# handles errors generated by scorer
#  Copyright (C) 1992-2000 Michigan State University
#
#  The CAPA system is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  The CAPA system is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with the CAPA system; see the file COPYING.  If not,
#  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
#  As a special exception, you have permission to link this program
#  with the TtH/TtM library and distribute executables, as long as you
#  follow the requirements of the GNU GPL in regard to all of the
#  software in the executable aside from TtH/TtM.

###########################################################
# handleErrorsScorer
###########################################################
###########################################################
###########################################################
proc handleErrorsScorer { num } {
    global gScorer

    if { [catch {set length [llength $gScorer(errors.$num)]}]} {
	displayMessage "There are no errors to save."
    }

    if { "" == [set file [tk_getSaveFile]] } { return }
    if { [catch {set fileId [open $file "w"]}] } {
	displayError "Unable to write to $file"
    }

    for { set i 0 } { $i < $length } { incr i } {
	puts $fileId "#[lindex $gScorer(errortype.$num) $i]"
	puts $fileId "#[lindex $gScorer(errors.$num) $i]"
    }
    close $fileId
}

proc handleErrorsScorer2 { num } {
    global gScorer

    if {[winfo exists .scorerError$num]} { 
	capaRaise .scorerError$num
	return 
    } 
    set errorWin [toplevel .scorerError$num] 
    
    set generalInfoFrame
    set studentInfoFrame
    
}
