;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     The data in this file contains enhancments.                    ;;;;;
;;;                                                                    ;;;;;
;;;  Copyright (c) 1984,1987 by William Schelter,University of Texas   ;;;;;
;;;     All rights reserved                                            ;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     (c) Copyright 1982 Massachusetts Institute of Technology         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "MAXIMA")
(macsyma-module risch)

(LOAD-MACSYMA-MACROS RZMAC RATMAC)

(DECLARE-TOP(SPECIAL PROB ROOTFAC PARNUMER PARDENOM LOGPTDX WHOLEPART $RATALGDENOM
		  EXPEXPFLAG $LOGSIMP SWITCH1 DEGREE CARY $RATFAC $LOGEXPAND
		  RATFORM GENVAR *VAR VAR ROOTFACTOR EXPINT $KEEPFLOAT
		  TRIGINT OPERATOR $EXPONENTIALIZE $GCD $LOGARC CHANGEVP
		  KLTH R S BETA GAMMA B MAINVAR EXPFLAG EXPSTUFF LIFLAG
		  INTVAR SWITCH VARLIST NOGOOD GENVAR $ERFFLAG $LIFLAG
		  RISCHP $FACTORFLAG ALPHAR M SIMP GENPAIRS HYPERTRIGINT
		  *MOSESFLAG YYY *EXP Y $ALGEBRAIC IMPLICIT-REAL
		  ERRRJFFLAG $%E/_TO/_NUMLOG GENERATE-ATAN2 CONTEXT
		  BIGFLOATZERO RP-POLYLOGP)
	 (*EXPR $EXPONENTIALIZE SUBFUNSUBS SUBFUNNAME SRATSIMP PARTFRAC MQAPPLYP)
	 (*LEXPR CONTEXT POLYLOGP)
	 (GENPREFIX RISCH))

(DEFMVAR $LIFLAG T "Controls whether RISCH generates polylogs") 

(DEFMVAR $ERFFLAG T "Controls whether RISCH generates ERFS") 

(DEFVAR CHANGEVP T #-LISPM "When nil prevents changevar hack")

(DEFMACRO PAIR (AL BL) `(MAPCAR (FUNCTION CONS) ,AL ,BL))

(DEFMACRO RISCHZERO () ''((0 . 1) 0))

(DEFUN RISCHNOUN (EXP1 &OPTIONAL (EXP2 EXP1 EXP2P))
  (UNLESS EXP2P (SETQ EXP1 (RZERO)))
  `(,EXP1 ((%INTEGRATE) ,(DISREP EXP2) ,INTVAR)))

(DEFUN GETRISCHVAR ()
       (DO ((VL VARLIST (CDR VL))
	    (GL GENVAR (CDR GL)))
	   ((NULL (CDR VL)) (CAR GL))))

(DEFUN RISCH-PCONSTP (P)
       (OR (PCOEFP P) (POINTERGP MAINVAR (CAR P))))

(DEFUN RISCH-CONSTP (R)
       (SETQ R (RATFIX R))
       (AND (RISCH-PCONSTP (CAR R)) (RISCH-PCONSTP (CDR R))))

(DEFUN RISCHADD (X Y)
       (LET (((A . B) X) ((C . D) Y))
	    (CONS (R+ A C) (APPEND B D))))

(DEFMFUN $RISCH (EXP VAR)
       ;; Get RATINT from SININT
       (FIND-FUNCTION 'RATINT)
       (WITH-NEW-CONTEXT (CONTEXT)
	 (RISCHINT EXP VAR)))


(DEFUN SPDERIVATIVE (P VAR) 
	 (COND ((PCOEFP P) '(0 . 1))
	       ((NULL (CDR P)) '(0 . 1))
	       ((OR (NOT (ATOM (CAR P))) (NUMBERP (CAR P)))	;P IS A RATFORM
		(LET ((DENPRIME (SPDERIVATIVE (CDR P) VAR)))
		     (COND ((RZEROP DENPRIME)
			    (RATQU (SPDERIVATIVE (CAR P) VAR) (CDR P)))
			   (T (RATQU (R- (R* (SPDERIVATIVE (CAR P) VAR)
					     (CDR P))
					 (R* (CAR P) DENPRIME))
				     (R* (CDR P) (CDR P)))))))
	       (T (R+ (SPDERIVATIVE1 (CAR P)
				     (CADR P)
				     (CADDR P)
				     VAR)
		      (SPDERIVATIVE (CONS (CAR P) (CDDDR P))
				    VAR)))))

(DEFUN SPDERIVATIVE1 (VAR1 DEG COEFF VAR) 
  (COND ((EQ VAR1 VAR)
	 (R* (RATEXPT (CONS (LIST VAR 1 1) 1) (SUB1 DEG))
	     (PCTIMES DEG COEFF)))
	((POINTERGP VAR VAR1) '(0 . 1))
	((EQUAL DEG 0) (SPDERIVATIVE COEFF VAR))
	(T (R+ (R* (RATEXPT (CONS (LIST VAR1 1 1) 1) DEG)
		   (SPDERIVATIVE COEFF VAR))
	       (R* (COND ((EQUAL DEG 1) COEFF)
			 (T (R* DEG
				COEFF
				(RATEXPT (CONS (LIST VAR1 1 1) 1)
					 (SUB1 DEG)))))
		   (GET VAR1 'RISCHDIFF) )))))

(DEFUN POLYLOGP (EXP &OPTIONAL SUB)
       (AND (MQAPPLYP EXP) (EQ (SUBFUNNAME EXP) '$LI)
	    (OR (NULL SUB) (EQUAL SUB (CAR (SUBFUNSUBS EXP))))))


(DEFUN RISCHINT (EXP INTVAR &AUX ($LOGARC NIL) ($EXPONENTIALIZE NIL)
		                 ($GCD '$ALGEBRAIC) ($ALGEBRAIC T) (IMPLICIT-REAL T))
  (PROG ($%E/_TO/_NUMLOG $LOGSIMP TRIGINT OPERATOR Y Z VAR RATFORM LIFLAG
	MAINVAR VARLIST GENVAR HYPERTRIGINT $RATFAC $RATALGDENOM )
       (IF (SPECREPP EXP) (SETQ EXP (SPECDISREP EXP)))
       (IF (SPECREPP INTVAR) (SETQ INTVAR (SPECDISREP INTVAR)))
       (IF (MNUMP INTVAR)
	   (MERROR "Attempt to integrate wrt a number: ~:M" INTVAR))
       (IF (AND (ATOM INTVAR) (ISINOP EXP INTVAR)) (GO NOUN))
       (RISCHFORM EXP)
       (COND (TRIGINT (RETURN (TRIGIN1 EXP INTVAR)))
	     (HYPERTRIGINT (RETURN (HYPERTRIGINT1 EXP INTVAR T)))
	     (OPERATOR (GO NOUN)))
       (SETQ Y (INTSETUP EXP INTVAR))
       (IF OPERATOR (GO NOUN))
       (SETQ RATFORM (CAR Y))
       (SETQ VARLIST (CADDR RATFORM))
       (SETQ MAINVAR (CAADR (RATF INTVAR)))
       (SETQ GENVAR (CADDDR RATFORM))
       (UNLESS (ORMAPC (FUNCTION ALGPGET) VARLIST) 
	       (SETQ $ALGEBRAIC NIL)
	       (SETQ $GCD (CAR *GCDL*)))
       (SETQ VAR (GETRISCHVAR))
       (SETQ Z (TRYRISCH (CDR Y) MAINVAR))
       (SETF (CADDR RATFORM) VARLIST)
       (SETF (CADDDR RATFORM) GENVAR)
       (RETURN (COND ((ATOM (CDR Z)) (DISREP (CAR Z)))
		     (T (LET (($LOGSIMP T) ($%E/_TO/_NUMLOG T))
			     (SIMPLIFY (LIST* '(MPLUS)
					      (DISREP (CAR Z))
					      (CDR Z)))))))
  NOUN (RETURN (LIST '(%INTEGRATE) EXP INTVAR))))
 
(DEFUN RISCHFORM (L) 
       (COND ((OR (ATOM L) (ALIKE1 INTVAR L) (FREEOF INTVAR L)) NIL)
	     ((POLYLOGP L)
	      (IF (AND (INTEGERP (CAR (SUBFUNSUBS L)))
		       (SIGNP G (CAR (SUBFUNSUBS L))))
		  (RISCHFORM (CAR (SUBFUNARGS L)))
		  (SETQ OPERATOR T)))
	     ((ATOM (CAAR L))
	      (CASE (CAAR L)
		((%SIN %COS %TAN %COT %SEC %CSC)
		 (SETQ TRIGINT T $EXPONENTIALIZE T)
		 (RISCHFORM (CADR L)))
		((%ASIN %ACOS %ATAN %ACOT %ASEC %ACSC)
		 (SETQ TRIGINT T $LOGARC T)
		 (RISCHFORM (CADR L)))
		((%SINH %COSH %TANH %COTH %SECH %CSCH)
		 (SETQ HYPERTRIGINT T $EXPONENTIALIZE T)
		 (RISCHFORM (CADR L)))
		((%ASINH %ACOSH %ATANH %ACOTH %ASECH %ACSCH)
		 (SETQ HYPERTRIGINT T $LOGARC T)
		 (RISCHFORM (CADR L)))
		((MTIMES MPLUS MEXPT RAT %ERF %LOG)
		 (MAPC #'RISCHFORM (CDR L)))
		(T (SETQ OPERATOR (CAAR L)))))
	     (T (SETQ OPERATOR (CAAR L)))))		

(DEFUN HYPERTRIGINT1 (EXP VAR HYPERFUNC)
  (IF HYPERFUNC (INTEGRATOR (RESIMPLIFY EXP) VAR)
		(RISCHINT (RESIMPLIFY EXP) VAR)))

(DEFUN TRIGIN1 (*EXP VAR) 
  (LET ((YYY (HYPERTRIGINT1 *EXP VAR NIL)))
    (SETQ YYY (DIV ($EXPAND ($NUM YYY))
		   ($EXPAND ($DENOM YYY))))
    (LET ((RISCHP VAR) (RP-POLYLOGP T) $LOGARC $EXPONENTIALIZE)
      (SRATSIMP (IF (AND (FREEOF '$%I *EXP) (FREEOF '$LI YYY))
		    ($REALPART YYY)
		    ($RECTFORM YYY))))))


(DEFUN TRYRISCH (EXP MAINVAR) 
       (PROG (WHOLEPART ROOTFACTOR PARNUMER PARDENOM
	      SWITCH1 LOGPTDX EXPFLAG EXPSTUFF EXPINT Y) 
	     (SETQ EXPSTUFF '(0 . 1))
	     (COND ((EQ MAINVAR VAR)
		    (RETURN (RISCHFPROG EXP)))
		   ((EQ (GET VAR 'LEADOP)
			'MEXPT)
		    (SETQ EXPFLAG T)))
             (SETQ Y (RISCHLOGDPROG EXP))
	     (DOLIST (RAT LOGPTDX)
		     (SETQ Y (RISCHADD (RISCHLOGEPROG RAT) Y)))
	     (SETQ Y (RISCHADD (TRYRISCH1 EXPSTUFF MAINVAR) Y))
	     (RETURN (IF EXPINT (RISCHADD (RISCHEXPPOLY EXPINT VAR) Y)
			 Y))))

(DEFUN TRYRISCH1 (EXP MAINVAR)
       (LET* ((VARLIST (REVERSE (CDR (REVERSE VARLIST))))
	      (VAR (GETRISCHVAR)))
	     (TRYRISCH EXP MAINVAR)))

(DEFUN RISCHFPROG (RAT)
       (LET (ROOTFACTOR PARDENOM PARNUMER LOGPTDX WHOLEPART SWITCH1) 
	    (CONS (CDR (RATREP* (DPROG RAT)))
		  (LET ((VARLIST VARLIST)
			(GENVAR (FIRSTN (LENGTH VARLIST) GENVAR)))
		       (MAPCAR 'EPROG LOGPTDX)))))

(DEFUN RISCHLOGDPROG (RATARG) 
  (PROG (KLTH AROOTF DERIV THEBPG THETOP THEBOT PROD1 PROD2 ANS) 
	(SETQ ANS '(0 . 1))
	(COND ((OR (PCOEFP (CDR RATARG))
		   (POINTERGP VAR (CADR RATARG)))
	       (RETURN (RISCHLOGPOLY RATARG))))
	(APROG (RATDENOMINATOR RATARG))
	(CPROG (RATNUMERATOR RATARG) (RATDENOMINATOR RATARG))
	(DO ((ROOTFACTOR (REVERSE ROOTFACTOR) (CDR ROOTFACTOR))
	     (PARNUMER (REVERSE PARNUMER) (CDR PARNUMER))
	     (KLTH (LENGTH ROOTFACTOR) (f1- KLTH)))
	    ((= KLTH 1))
	    (SETQ AROOTF (CAR ROOTFACTOR))
	    (COND
	     ((PCOEFP AROOTF))
	     ((AND (EQ (GET (CAR AROOTF) 'LEADOP) 'MEXPT)
		   (NULL (CDDDR AROOTF)))
	      (SETQ 
	       EXPINT
	       (APPEND
		(COND ((AND (NOT (ATOM (CAR PARNUMER)))
			    (NOT (ATOM (CAAR PARNUMER)))
			    (EQ (CAAAR PARNUMER) (CAR AROOTF)))
		       (GENNEGS AROOTF (CDAAR PARNUMER) (CDAR PARNUMER)))
		      (T (LIST
			  (LIST 'NEG (CAR PARNUMER)
				(CAR AROOTF) KLTH (CADR AROOTF)))))
		EXPINT)))
	     ((NOT (ZEROP (PDEGREE AROOTF VAR))) 
	      (SETQ DERIV (SPDERIVATIVE AROOTF MAINVAR))
	      (SETQ THEBPG (BPROG AROOTF (RATNUMERATOR DERIV)))
	      (SETQ THETOP (CAR PARNUMER))
	      (DO ((KX (f1- KLTH) (f1- KX))) ((= KX 0))
		  (SETQ PROD1 (R* THETOP (CAR THEBPG)))
		  (SETQ PROD2 (R* THETOP (CDR THEBPG) (RATDENOMINATOR DERIV)))
		  (SETQ THEBOT (PEXPT AROOTF KX))
		  (SETQ ANS (R+ ANS (RATQU (R- PROD2) (R* KX THEBOT))))
		  (SETQ THETOP
			(R+ PROD1 (RATQU (SPDERIVATIVE PROD2 MAINVAR) KX)))
		  (SETQ THETOP (CDR (RATDIVIDE THETOP THEBOT))))
	      (PUSH (RATQU THETOP AROOTF) LOGPTDX))))
	(PUSH (RATQU (CAR PARNUMER) (CAR ROOTFACTOR)) LOGPTDX)
	(COND ((OR (PZEROP ANS) (PZEROP (CAR ANS)))
	       (RETURN (RISCHLOGPOLY WHOLEPART))))
	(SETQ THETOP (CADR (PDIVIDE (RATNUMERATOR ANS)
				    (RATDENOMINATOR ANS))))
	(RETURN (RISCHADD (NCONS (RATQU THETOP (RATDENOMINATOR ANS)))
			  (RISCHLOGPOLY WHOLEPART)))))
 
(DEFUN GENNEGS (DENOM NUM NUMDENOM) 
	 (COND ((NULL NUM) NIL)
	       (T (CONS (LIST 'NEG (CADR NUM)
			      (CAR DENOM)
			      (DIFFERENCE KLTH (CAR NUM))
			      (R* NUMDENOM (CADDR DENOM) ))
			(GENNEGS DENOM (CDDR NUM) NUMDENOM)))))

(DEFUN RISCHLOGEPROG (P) 
  (PROG (P1E P2E P2DERIV LOGCOEF NCC DCC ALLCC EXPCOEF) 
	(IF (OR (PZEROP P) (PZEROP (CAR P))) (RETURN (RISCHZERO)))
	(SETQ P1E (RATNUMERATOR P))
	(DESETQ (DCC P2E) (OLDCONTENT (RATDENOMINATOR P)))
	(COND ((AND (NOT SWITCH1)
		    (CDR (SETQ PARDENOM (INTFACTOR P2E))))
	       (SETQ PARNUMER NIL)
	       (SETQ SWITCH1 T)
	       (DESETQ (NCC P1E) (OLDCONTENT P1E))
	       (CPROG P1E P2E)
	       (SETQ ALLCC (RATQU NCC DCC))
	       (RETURN (DO ((PNUM PARNUMER (CDR PNUM))
			    (PDEN PARDENOM (CDR PDEN))
			    (ANS (RISCHZERO)))
			   ((OR (NULL PNUM) (NULL PDEN))
			    (SETQ SWITCH1 NIL) ANS)
			   (SETQ ANS (RISCHADD
				      (RISCHLOGEPROG
				       (R* ALLCC (RATQU (CAR PNUM) (CAR PDEN))))
				      ANS))))))
	(WHEN (AND EXPFLAG (NULL (P-RED P2E)))
	      (PUSH (CONS 'NEG P) EXPINT)
	      (RETURN (RISCHZERO)))
	(IF EXPFLAG (SETQ EXPCOEF (R* (P-LE P2E) (RATQU (GET VAR 'RISCHDIFF)
							(MAKE-POLY VAR)))))
	(SETQ P1E (RATQU P1E (PTIMES DCC (P-LC P2E)))
	      P2E (RATQU P2E (P-LC P2E)))		;MAKE DENOM MONIC
	(SETQ P2DERIV (SPDERIVATIVE P2E MAINVAR))
	(SETQ LOGCOEF (RATQU P1E
			     (IF EXPFLAG (R- P2DERIV (R* P2E EXPCOEF))
				 P2DERIV)))
	(WHEN (RISCH-CONSTP LOGCOEF)
	      (IF EXPFLAG
		  (SETQ EXPSTUFF (R- EXPSTUFF (R* EXPCOEF LOGCOEF))))
	      (RETURN
	       (LIST
		'(0 . 1)
		(LIST '(MTIMES)
		      (DISREP LOGCOEF)
		      (LOGMABS (DISREP P2E))))))
	(if (and expflag $liflag changevp)
	    (let* ((newvar (gensym))
		   (new-int ($changevar
			     `((%integrate) ,(simplify (disrep p)) ,intvar)
			     (sub newvar (get var 'rischexpr))
			     newvar intvar))
		   (changevp nil))		  ;prevents recursive changevar
	      (if (and (freeof intvar new-int)
		       (freeof '%integrate
			       (setq new-int (rischint (sdiff new-int newvar)
						       newvar))))
		  (return
		   (list (rzero)
			 (MAXIMA-SUBSTITUTE (get var 'rischexpr) newvar new-int))))))
	(RETURN (RISCHNOUN P))))
	 

(DEFUN FINDINT (EXP) (COND ((ATOM EXP) NIL)
			   ((ATOM (CAR EXP)) (FINDINT (CDR EXP)))
			   ((EQ (CAAAR EXP) '%INTEGRATE) T)
			   (T (FINDINT (CDR EXP)))))

(DEFUN LOGEQUIV (FN1 FN2)
  (FREEOF INTVAR ($RATSIMP (DIV* (REMABS (LEADARG FN1))
				 (REMABS (LEADARG FN2))))))

(DEFUN REMABS (EXP)
       (COND ((ATOM EXP) EXP)
	     ((EQ (CAAR EXP) 'MABS) (CADR EXP))
	     (T EXP)))

(DECLARE-TOP(SPECIAL VLIST LIANS DEGREE))

(DEFUN GETFNSPLIT (L &AUX COEF FN)
  (MAPC #'(LAMBDA (X) (IF (FREE X INTVAR) (PUSH X COEF) (PUSH X FN))) L)
  (CONS (MULN COEF NIL) (MULN FN NIL)))

(DEFUN GETFNCOEFF (A FORM) 
  (COND ((NULL A) 0)
	((EQUAL (CAR A) 0) (GETFNCOEFF (CDR A) FORM))
	((EQ (CAAAR A) 'MPLUS) (RATPL (GETFNCOEFF (CDAR A) FORM)
				      (GETFNCOEFF (CDR A) FORM)))
	((EQ (CAAAR A) 'MTIMES)
	 (LET (((COEF . NEWFN) (GETFNSPLIT (CDAR A))))
	   (SETF (CDAR A) (LIST COEF NEWFN))
	   (COND ((ZEROP1 COEF) (GETFNCOEFF (CDR A) FORM))
		 ((AND (MATANP NEWFN) (MEMQ '$%I VARLIST))
		  (LET (($LOGARC T) ($LOGEXPAND '$ALL))
		    (RPLACA A ($EXPAND (RESIMPLIFY (CAR A)))))
		  (GETFNCOEFF A FORM))
		 ((AND (ALIKE1 (LEADOP NEWFN) (LEADOP FORM))
		       (OR (ALIKE1 (LEADARG NEWFN) (LEADARG FORM))
			   (AND (MLOGP NEWFN)
				(LOGEQUIV FORM NEWFN))))
		  (RATPL (RFORM COEF)
			 (PROG2 (RPLACA A 0)
				(GETFNCOEFF (CDR A) FORM))))
		 ((DO ((VL VARLIST (CDR VL))) ((NULL VL))
		      (AND (NOT (ATOM (CAR VL)))
			   (ALIKE1 (LEADOP (CAR VL)) (LEADOP NEWFN))
			   (IF (MLOGP NEWFN)
			       (LOGEQUIV (CAR VL) NEWFN)
			       (ALIKE1 (CAR VL) NEWFN))
			   (RPLACA (CDDAR A) (CAR VL))
			   (RETURN NIL))))
		 ((LET (VLIST) (NEWVAR1 (CAR A)) (NULL VLIST))
		  (SETQ CARY
			(RATPL (CDR (RATREP* (CAR A)))
			       CARY))
		  (RPLACA A 0)
		  (GETFNCOEFF (CDR A) FORM))
		 ((AND LIFLAG
		       (MLOGP FORM)
		       (MLOGP NEWFN))
		  (PUSH (DILOG (CONS (CAR A) FORM)) LIANS)
		  (RPLACA A 0)
		  (GETFNCOEFF (CDR A) FORM))
		 ((AND LIFLAG
		       (POLYLOGP FORM)
		       (MLOGP NEWFN)
		       (LOGEQUIV FORM NEWFN))
		  (PUSH (MUL* (CADAR A) (MAKE-LI (f1+ (CAR (SUBFUNSUBS FORM)))
						 (LEADARG FORM)))
			LIANS)
		  (RPLACA A 0)
		  (GETFNCOEFF (CDR A) FORM))
		 (T (SETQ NOGOOD T) 0))))
	(T (RPLACA A (LIST '(MTIMES) 1 (CAR A)))
	   (GETFNCOEFF A FORM))))


(DEFUN RISCHLOGPOLY (EXP) 
   (COND ((EQUAL EXP '(0 . 1)) (RISCHZERO))
	 (EXPFLAG (PUSH (CONS 'POLY EXP) EXPINT)
		  (RISCHZERO))
	 ((NOT (AMONG VAR EXP)) (TRYRISCH1 EXP MAINVAR))
	 (T (DO ((DEGREE (PDEGREE (CAR EXP) VAR) (f1- DEGREE))
		 (P (CAR EXP))
		 (DEN (CDR EXP))
		 (LIANS ())
		 (SUM (RZERO))
		 (CARY (RZERO))
		 (Y) (Z) (AK) (NOGOOD) (LBKPL1))
		((MINUSP DEGREE) (CONS SUM (APPEND LIANS (CDR Y))))
		(SETQ AK (R- (RATQU (POLCOEF P DEGREE) DEN)
			     (R* (CONS (ADD1 DEGREE) 1)
				 CARY
				 (GET VAR 'RISCHDIFF))))
		(IF (NOT (PZEROP (POLCOEF P DEGREE)))
		    (SETQ P (IF (PCOEFP P) (PZERO) (PSIMP VAR (P-RED P)))))
		(SETQ Y (TRYRISCH1 AK MAINVAR))
		(SETQ CARY (CAR Y))
		(AND (> DEGREE 0) (SETQ LIFLAG $LIFLAG))
		(SETQ Z (GETFNCOEFF (CDR Y) (GET VAR 'RISCHEXPR)))
		(SETQ LIFLAG NIL)
		(COND ((AND (GREATERP DEGREE 0)
			    (OR NOGOOD (FINDINT (CDR Y))))
		       (RETURN (RISCHNOUN SUM (R+ (R* AK
						      (MAKE-POLY VAR DEGREE 1))
						  (RATQU P DEN))))))
		(SETQ LBKPL1 (RATQU Z (CONS (f1+ DEGREE) 1)))
		(SETQ SUM (R+ (R* LBKPL1 (MAKE-POLY VAR (ADD1 DEGREE) 1))
			      (R* CARY (IF (ZEROP DEGREE) 1
					   (MAKE-POLY VAR DEGREE 1)))
			      SUM))))))

(DEFUN MAKE-LI (SUB ARG)
  (SUBFUNMAKE '$LI (NCONS SUB) (NCONS ARG)))

;integrates log(ro)^degree*log(rn)' in terms of polylogs
;finds constants c,d and integers j,k such that
;c*ro^j+d=rn^k  If ro and rn are poly's then can assume either j=1 or k=1
(DEFUN DILOG (L)
 (LET* ((((nil COEF NLOG) . OLOG) L)
	(NARG (REMABS (CADR NLOG)))
	(VARLIST VARLIST)
	(GENVAR GENVAR)				
	(RN (RFORM NARG))
	(RO (RFORM (CADR OLOG)))
	(VAR (CAAR RO))
	((J . K) (RATREDUCE (PDEGREE (CAR RN) VAR) (PDEGREE (CAR RO) VAR)))
	(IDX (GENSYM))
	(RC) (RD))
   (COND ((AND (= J 1) (> K 1))
	  (SETQ RN (RATEXPT RN K)
		COEF (DIV COEF K)
		NARG (RDIS RN)))
	 ((AND (= K 1) (> J 1))
	  (SETQ RO (RATEXPT RO J)
	        COEF (DIV COEF (f* J DEGREE))
		OLOG (MUL J OLOG))))
   (DESETQ (RC . RD) (RATDIVIDE RN RO))
   (COND ((AND (RISCH-CONSTP RC)
	       (RISCH-CONSTP RD))
	  (SETQ NARG ($RATSIMP (SUB 1 (DIV NARG (RDIS RD)))))
	  (MUL* COEF (POWER -1 (f1+ DEGREE))
		`((MFACTORIAL) ,DEGREE)
		(DOSUM (MUL* (POWER -1 IDX)
			     (DIV* (POWER OLOG IDX)
				   `((MFACTORIAL) ,IDX))
			     (MAKE-LI (ADD DEGREE (NEG IDX) 1) NARG))
		       IDX 0 DEGREE T)))
	 (T (SETQ NOGOOD T) 0))))

(DEFUN EXPPOLYCONTROL (FLAG F A EXPG N) 
       (LET (Y L VAR (VARLIST VARLIST) (GENVAR GENVAR)) 
	    (SETQ VARLIST (REVERSE (CDR (REVERSE VARLIST))))
	    (SETQ VAR (GETRISCHVAR))
	    (SETQ Y (GET VAR 'LEADOP))
	    (COND ((AND (NOT (PZEROP (RATNUMERATOR F)))
			(RISCH-CONSTP (SETQ L (RATQU A F))))
		   (COND (FLAG
			  (LIST (R* L (CONS (LIST EXPG N 1) 1)) 0))
			 (T L)))
		  ((EQ Y INTVAR)
		   (RISCHEXPVAR NIL FLAG (LIST F A EXPG N)))
		  (T (RISCHEXPLOG (EQ Y 'MEXPT) FLAG F A
				  (LIST EXPG N (GET VAR 'RISCHARG)
					VAR (GET VAR 'RISCHDIFF)))))))

(DEFUN RISCHEXPPOLY (EXPINT VAR) 
  (LET (Y W NUM DENOM TYPE (ANS (RISCHZERO))
	  (EXPDIFF (RATQU (GET VAR 'RISCHDIFF) (LIST VAR 1 1)))) 
       (DO ((EXPINT EXPINT (CDR EXPINT)))
	   ((NULL EXPINT) ANS)
	   (DESETQ (TYPE . Y) (CAR EXPINT))
	   (DESETQ (NUM . DENOM) (RATFIX Y))
	   (COND ((EQ TYPE 'NEG)
		  (SETQ W (EXPPOLYCONTROL T
					  (R* (MINUS (CADR DENOM))
					      EXPDIFF)
					  (RATQU NUM (CADDR DENOM))
					  VAR
					  (MINUS (CADR DENOM)))))
		 ((OR (NUMBERP NUM) (NOT (EQ (CAR NUM) VAR)))
		  (SETQ W (TRYRISCH1 Y MAINVAR)))
		 (T (SETQ W (RISCHZERO))
		    (DO ((NUM (CDR NUM) (CDDR NUM))) ((NULL NUM))
			(COND ((EQUAL (CAR NUM) 0)
			       (SETQ W (RISCHADD
					(TRYRISCH1 (RATQU (CADR NUM) DENOM) MAINVAR)
					W)))
			      (T (SETQ W (RISCHADD (EXPPOLYCONTROL
						     T
						     (R* (CAR NUM) EXPDIFF)
						     (RATQU (CADR NUM) DENOM)
						     VAR
						     (CAR NUM))
						   W)))))))
	   (SETQ ANS (RISCHADD W ANS)))))

(DEFUN RISCHEXPVAR (EXPEXPFLAG FLAG L) 
  (PROG (LCM Y M P ALPHAR BETA GAMMA DELTA R S
	 TT DENOM K WL WV I YTEMP TTEMP YALPHA F A EXPG N YN YD) 
	(DESETQ (F A EXPG N) L)
	(COND ((OR (PZEROP A) (PZEROP (CAR A)))
	       (RETURN (COND ((NULL FLAG) (RZERO))
			     (T (RISCHZERO))))))
	(SETQ DENOM (RATDENOMINATOR F))
	(SETQ P (FINDPR (CDR (PARTFRAC A MAINVAR))
			(CDR (PARTFRAC F MAINVAR))))
	(SETQ LCM (PLCM (RATDENOMINATOR A) P))
	(SETQ Y (RATPL (SPDERIVATIVE (CONS 1 P) MAINVAR)
		       (RATQU F P)))
	(SETQ LCM (PLCM LCM (RATDENOMINATOR Y)))
	(SETQ R (CAR (RATQU LCM P)))
	(SETQ S (CAR (R* LCM Y)))
	(SETQ TT (CAR (R* A LCM)))
	(SETQ BETA (PDEGREE R MAINVAR))
	(SETQ GAMMA (PDEGREE S MAINVAR))
	(SETQ DELTA (PDEGREE TT MAINVAR))
	(SETQ ALPHAR (MAX (DIFFERENCE (ADD1 DELTA) BETA)
			  (DIFFERENCE DELTA GAMMA)))
	(SETQ M 0)
	(COND ((EQUAL (SUB1 BETA) GAMMA)
	       (SETQ Y (R* -1
			   (RATQU (POLCOEF S GAMMA)
				  (POLCOEF R BETA))))
	       (AND (EQUAL (CDR Y) 1)
		    (NUMBERP (CAR Y))
		    (SETQ M (CAR Y)))))
	(SETQ ALPHAR (MAX ALPHAR M))
	(IF (MINUSP ALPHAR)
	    (RETURN (IF FLAG (CXERFARG (RZERO) EXPG N A) NIL)))
	(COND ((NOT (AND (EQUAL ALPHAR M) (NOT (ZEROP M))))
	       (GO DOWN2)))
	(SETQ K (PLUS ALPHAR BETA -2))
	(SETQ WL NIL)
   L2   (SETQ WV (LIST (CONS (POLCOEF TT K) 1)))
	(SETQ I ALPHAR)
   L1   (SETQ WV
	      (CONS (R+ (R* (CONS I 1)
			    (POLCOEF R (PLUS K 1 (MINUS I))))
			(CONS (POLCOEF S (PLUS K (MINUS I))) 1))
		    WV))
	(SETQ I (SUB1 I))
	(COND ((GREATERP I -1) (GO L1)))
	(SETQ WL (CONS WV WL))
	(SETQ K (SUB1 K))
	(COND ((GREATERP K -1) (GO L2)))
	(SETQ Y (LSA WL))
	(IF (OR (EQ Y 'SINGULAR) (EQ Y 'INCONSISTENT))
	    (COND ((NULL FLAG) (RETURN NIL))
		  (T (RETURN (CXERFARG (RZERO) EXPG N A)))))
	(SETQ K 0)
	(SETQ LCM 0)
	(SETQ Y (CDR Y))
   L3   (SETQ LCM
	      (R+ (R* (CAR Y) (PEXPT (LIST MAINVAR 1 1) K))
		  LCM))
	(SETQ K (ADD1 K))
	(SETQ Y (CDR Y))
	(COND ((NULL Y)
	       (RETURN (COND ((NULL FLAG) (RATQU LCM P))
			     (T (LIST (R* (RATQU LCM P)
					  (CONS (LIST EXPG N 1) 1))
				      0))))))
	(GO L3)
   DOWN2(COND ((GREATERP (SUB1 BETA) GAMMA)
	       (SETQ K (PLUS ALPHAR (SUB1 BETA)))
	       (SETQ DENOM '(RATTI ALPHAR (POLCOEF R BETA) T)))
	      ((LESSP (SUB1 BETA) GAMMA)
	       (SETQ K (PLUS ALPHAR GAMMA))
	       (SETQ DENOM '(POLCOEF S GAMMA)))
	      (T (SETQ K (PLUS ALPHAR GAMMA))
		 (SETQ DENOM
		       '(RATPL (RATTI ALPHAR (POLCOEF R BETA) T)
			       (POLCOEF S GAMMA)))))
	(SETQ Y 0)
   LOOP (SETQ YN (POLCOEF (RATNUMERATOR TT) K)
	      YD (R* (RATDENOMINATOR TT)		;DENOM MAY BE 0
		     (COND ((ZEROP ALPHAR) (POLCOEF S GAMMA))
			   (T (EVAL DENOM))) ))
        (COND ((RZEROP YD)
	       (COND ((PZEROP YN) (SETQ K (f1- K) ALPHAR (f1- ALPHAR))
				  (GO LOOP))		;need more constraints?
		     (T (COND
			 ((NULL FLAG) (RETURN NIL))
			 (T (RETURN (CXERFARG (RZERO) EXPG N A)))))))
	      (T (SETQ YALPHA (RATQU YN YD))))
        (SETQ YTEMP (R+ Y (R* YALPHA
			      (CONS (LIST MAINVAR ALPHAR 1) 1) )))
	(SETQ TTEMP (R- TT (R* YALPHA
			       (R+ (R* S (CONS (LIST MAINVAR ALPHAR 1) 1))
				   (R* R ALPHAR
				       (LIST MAINVAR (SUB1 ALPHAR) 1))))))
	(SETQ K (SUB1 K))
	(SETQ ALPHAR (SUB1 ALPHAR))
	(COND
	 ((LESSP ALPHAR 0)
	  (COND
	   ((RZEROP TTEMP)
	    (COND
	     ((NULL FLAG) (RETURN (RATQU YTEMP P)))
	     (T (RETURN (LIST (RATQU (R* YTEMP (CONS (LIST EXPG N 1) 1))
				     P)
			      0)))))
	   ((NULL FLAG) (RETURN NIL))
	   ((AND (RISCH-CONSTP (SETQ TTEMP (RATQU TTEMP LCM)))
		 $ERFFLAG
		 (EQUAL (PDEGREE (CAR (GET EXPG 'RISCHARG)) MAINVAR) 2)
		 (EQUAL (PDEGREE (CDR (GET EXPG 'RISCHARG)) MAINVAR) 0))
	    (RETURN (LIST (RATQU (R* YTEMP (CONS (LIST EXPG N 1) 1)) P)
			  (ERFARG2 (R* N (GET EXPG 'RISCHARG)) TTEMP))))
	   (T (RETURN
	       (CXERFARG
		(RATQU (R* Y (CONS (LIST EXPG N 1) 1)) P)
		EXPG
		N
		(RATQU TT LCM)))))))
	(SETQ Y YTEMP)
	(SETQ TT TTEMP)
	(GO LOOP)))
 

;; *JM should be declared as an array, although it is not created
;; by this file. -- cwh

(DEFUN LSA (MM)

       (PROG (D *MOSESFLAG M M2)
	     (SETQ D (LENGTH (CAR MM)))
	     ;; MTOA stands for MATRIX-TO-ARRAY.  An array is created and
	     ;; associated functionally with the symbol *JM.  The elements
	     ;; of the array are initialized from the matrix MM.
	     (MTOA '*JM* (LENGTH MM) D MM)
	     (SETQ M (TFGELI '*JM*  (LENGTH MM) D))
	     (COND ((OR (AND (NULL (CAR M)) (NULL (CADR M)))
			(AND (CAR M)
			     (> (LENGTH (CAR M)) (f- (LENGTH MM) (f1- D)))))
		    (RETURN 'SINGULAR))
		   ((CADR M) (RETURN 'INCONSISTENT)))
	     (SETQ *MOSESFLAG T)
	     (PTORAT '*JM* (f1- D) D)
	     (SETQ M2 (XRUTOUT '*JM* (f1- D) D NIL NIL))
	     (SETQ M2 (LSAFIX (CDR M2) (CADDR M)))
	     (*REARRAY '*JM*)
	     (RETURN M2)))

(DEFUN LSAFIX (L N)
  (declare (special *jm*))
       (DO ((N N (CDR N))
	    (L L (CDR L)))
	   ((NULL L))
	   ;(STORE (*JM 1 (CAR N)) (CAR L))
	   (STORE (aref *JM* 1 (CAR N)) (CAR L))
	   )
       (DO ((S (LENGTH L) (f1- S))
	    (ANS))
	   ((= S 0) (CONS '(LIST) ANS))
	   (SETQ ANS (CONS (aref *JM* 1 S) ANS))))


(DEFUN FINDPR (ALIST FLIST &AUX (P 1) ALPHAR FTERM)
    (DO ((ALIST ALIST (CDR ALIST))) ((NULL ALIST))
	(SETQ FTERM (FINDFLIST (CADAR ALIST) FLIST))
	(IF FTERM (SETQ FLIST (REMQ Y FLIST 1)))
	(SETQ ALPHAR
	      (COND ((NULL FTERM) (CADDAR ALIST))
		    ((EQUAL (CADDR FTERM) 1)
		     (FPR-DIF (CAR FLIST) (CADDAR ALIST)))
		    (T (MAX (f- (CADDAR ALIST) (CADDR FTERM)) 0))))
	(IF (NOT (ZEROP ALPHAR))
	    (SETQ P (PTIMES P (PEXPT (CADAR ALIST) ALPHAR)))))
    (DO ((FLIST FLIST (CDR FLIST))) ((NULL FLIST))
	(WHEN (EQUAL (CADDAR FLIST) 1)
	      (SETQ ALPHAR (FPR-DIF (CAR FLIST) 0))
	      (SETQ P (PTIMES P (PEXPT (CADAR FLIST) ALPHAR)))))
    P)
	 
(DEFUN FPR-DIF (FTERM ALPHA)
  (LET* (((NUM DEN MULT) FTERM)
	 (M (SPDERIVATIVE DEN MAINVAR))
	 (N))
	(COND ((RZEROP M) ALPHA)
	      (T (SETQ N (RATQU (CDR (RATDIVIDE NUM DEN))
				M))
		 (IF (AND (EQUAL (CDR N) 1) (NUMBERP (CAR N)))
		     (MAX (CAR N) ALPHA)
		     ALPHA)))))

(DEFUN FINDFLIST (A LLIST) (COND ((NULL LLIST) NIL)
				((EQUAL (CADAR LLIST) A) (CAR LLIST))
				(T (FINDFLIST A (CDR LLIST)))))
	 

(DEFUN RISCHEXPLOG (EXPEXPFLAG FLAG F A L)
  (declare (special var))
  (PROG (LCM Y YY M P ALPHAR BETA GAMMA DELTA
	 MU R S TT DENOM YMU RBETA EXPG N ETA LOGETA LOGDIFF
     TEMP CARY NOGOOD VECTOR AARRAY RMU RRMU RARRAY) 
	(DESETQ (EXPG N ETA LOGETA LOGDIFF) L) 
	(COND ((OR (PZEROP A) (PZEROP (CAR A)))
	       (RETURN (COND ((NULL FLAG) (RZERO))
			     (T (RISCHZERO))))))
	(SETQ P (FINDPR (CDR (PARTFRAC A VAR)) (CDR (PARTFRAC F VAR))))
	(SETQ LCM (PLCM (RATDENOMINATOR A) P))
	(SETQ Y (RATPL (SPDERIVATIVE (CONS 1 P) MAINVAR)
		       (RATQU F P)))
	(SETQ LCM (PLCM LCM (RATDENOMINATOR Y)))
	(SETQ R (CAR (RATQU LCM P)))
	(SETQ S (CAR (R* LCM Y)))
	(SETQ TT (CAR (R* A LCM)))
	(SETQ BETA (PDEGREE R VAR))
	(SETQ GAMMA (PDEGREE S VAR))
	(SETQ DELTA (PDEGREE TT VAR))
	(COND (EXPEXPFLAG (SETQ MU (MAX (f- DELTA BETA)
					(f- DELTA GAMMA)))
			  (GO EXPCASE)))
	(SETQ MU (MAX (f- (f1+ DELTA) BETA)
		      (f- (f1+ DELTA) GAMMA)))
	(COND ((< BETA GAMMA) (GO BACK))
	      ((= (SUB1 BETA) GAMMA) (GO DOWN1)))
	(SETQ Y (TRYRISCH1 (RATQU (R- (R* (POLCOEF R (f1- BETA))
					  (POLCOEF S GAMMA))
				      (R* (POLCOEF R BETA)
					  (POLCOEF S (f1- GAMMA))))
				  (R* (POLCOEF R BETA)
				      (POLCOEF R BETA) ))
			   MAINVAR))
	(SETQ CARY (CAR Y))
	(SETQ YY (GETFNCOEFF (CDR Y) (GET VAR 'RISCHEXPR)))
	(COND ((AND (NOT (FINDINT (CDR Y)))
		    (NOT NOGOOD)
		    (NOT (ATOM YY))
		    (EQUAL (CDR YY) 1)
		    (NUMBERP (CAR YY))
		    (GREATERP (CAR YY) MU))
	       (SETQ MU (CAR YY))))
	(GO BACK)
   EXPCASE
	(COND ((NOT (EQUAL BETA GAMMA)) (GO BACK)))
	(SETQ Y (TRYRISCH1 (RATQU (POLCOEF S GAMMA) (POLCOEF R BETA))
			   MAINVAR))
	(COND ((FINDINT (CDR Y)) (GO BACK)))
	(SETQ YY (RATQU (R* -1 (CAR Y)) ETA))
	(COND ((AND (EQUAL (CDR YY) 1)
		    (NUMBERP (CAR YY))
		    (GREATERP (CAR YY) MU))
	       (SETQ MU (CAR YY))))
	(GO BACK)
   DOWN1(SETQ Y (TRYRISCH1 (RATQU (POLCOEF S GAMMA) (POLCOEF R BETA))
			   MAINVAR))
        (SETQ CARY (CAR Y))
	(SETQ YY (GETFNCOEFF (CDR Y) (GET VAR 'RISCHEXPR)))
	(COND ((AND (NOT (FINDINT (CDR Y)))
		    (NOT NOGOOD)
		    (EQUAL (CDR YY) 1)
		    (NUMBERP (CAR YY))
		    (GREATERP (MINUS (CAR YY)) MU))
	       (SETQ MU (MINUS (CAR YY)))))
   BACK (IF (MINUSP MU)
	    (RETURN (IF FLAG (CXERFARG (RZERO) EXPG N A) NIL)))
        (COND ((> BETA GAMMA)(GO LSACALL))
	      ((= BETA GAMMA)
	       (GO RECURSE)))
	(SETQ DENOM (POLCOEF S GAMMA))
	(SETQ Y '(0 . 1))
   LINEARLOOP
	(SETQ YMU (RATQU (POLCOEF (RATNUMERATOR TT) (f+ MU GAMMA))
			 (R* (RATDENOMINATOR TT) DENOM)))
	(SETQ Y (R+ Y (SETQ YMU (R* YMU (PEXPT (LIST LOGETA 1 1) MU) ))))
	(SETQ TT (R- TT
		     (R* S YMU)
		     (R* R (SPDERIVATIVE YMU MAINVAR))))
	(SETQ MU (f1- MU))
	(COND
	 ((NOT (< MU 0)) (GO LINEARLOOP))
	 ((NOT FLAG) (RETURN (COND ((RZEROP TT) (RATQU Y P)) (T NIL))))
	 ((RZEROP TT)
	  (RETURN (CONS (RATQU (R* Y (CONS (LIST EXPG N 1) 1)) P) '(0))))
	 (T (RETURN (CXERFARG (RATQU (R* Y (CONS (LIST EXPG N 1) 1)) P)
			      EXPG
			      N
			      (RATQU TT LCM)))))
   RECURSE
	(SETQ RBETA (POLCOEF R BETA))
	(SETQ Y '(0 . 1))
   RECURSELOOP
        (SETQ F (R+ (RATQU (POLCOEF S GAMMA) RBETA)
		    (COND (EXPEXPFLAG (R* MU (SPDERIVATIVE ETA MAINVAR)))
			  (T 0))))
	(SETQ YMU (EXPPOLYCONTROL NIL
				  F
				  (RATQU (POLCOEF (RATNUMERATOR TT)
						  (f+ BETA MU))
					 (R* (RATDENOMINATOR TT) RBETA))
				  EXPG N))
	(COND
	 ((NULL YMU)
	  (RETURN
	   (COND
	    ((NULL FLAG) NIL)
	    (T (RETURN (CXERFARG (RATQU (R* Y (CONS (LIST EXPG N 1) 1)) P)
				 EXPG N (RATQU TT LCM))))))))
	(SETQ Y (R+ Y (SETQ YMU (R* YMU (PEXPT (LIST LOGETA 1 1) MU)))))
	(SETQ TT (R- TT
		     (R* S YMU)
		     (R* R (SPDERIVATIVE YMU MAINVAR))))
	(SETQ MU (f1- MU))
	(COND
	 ((NOT (< MU 0)) (GO RECURSELOOP))
	 ((NOT FLAG)
	  (RETURN (COND ((RZEROP TT) (RATQU Y P)) (T NIL))))
	 ((RZEROP TT)
	  (RETURN (CONS (RATQU (R* Y (CONS (LIST EXPG N 1) 1)) P) '(0))))
	 (T (RETURN (CXERFARG (RATQU (R* Y (CONS (LIST EXPG N 1) 1)) P)
			      EXPG
			      N
			      (RATQU TT LCM)))))
   LSACALL
        (SETQ RRMU MU)
   MULOOP
        (SETQ TEMP (R* (RATEXPT (CONS (LIST LOGETA 1 1) 1) (f1- MU))
		       (R+ (R* S (CONS (LIST LOGETA 1 1) 1))
			   (R* MU R LOGDIFF ))))
   MU1  (SETQ VECTOR NIL)
        (SETQ RMU (f+ RRMU BETA))
   RMULOOP
        (SETQ VECTOR (CONS (RATQU (POLCOEF (RATNUMERATOR TEMP) RMU)
				  (RATDENOMINATOR TEMP)) VECTOR))
	(SETQ RMU (f1- RMU))
	(COND ((NOT (< RMU 0)) (GO RMULOOP)))
	(SETQ MU (f1- MU))
	(SETQ AARRAY (APPEND AARRAY (LIST (REVERSE VECTOR))))
	(COND ((NOT (< MU 0)) (GO MULOOP))
	      ((EQUAL MU -2) (GO SKIPMU)))
	(SETQ TEMP TT)
	(GO MU1)
   SKIPMU
        (SETQ RARRAY NIL)
   ARRAYLOOP
        (SETQ VECTOR NIL)
	(SETQ VECTOR (MAPCAR 'CAR AARRAY))
	(SETQ AARRAY (MAPCAR 'CDR AARRAY))
	(SETQ RARRAY (APPEND RARRAY (LIST VECTOR)))
	(COND ((NOT (NULL (CAR AARRAY))) (GO ARRAYLOOP)))
	(SETQ RMU (f1+ RRMU))
	(SETQ VECTOR NIL)
   ARRAY1LOOP
        (SETQ VECTOR (CONS '(0 . 1) VECTOR))
	(SETQ RMU (f1- RMU))
	(COND ((NOT (< RMU 0)) (GO ARRAY1LOOP)))
	(SETQ AARRAY NIL)
   ARRAY2LOOP
        (COND ((EQUAL (CAR RARRAY) VECTOR) NIL)
	      (T (SETQ AARRAY (CONS (CAR RARRAY) AARRAY))))
	(SETQ RARRAY (CDR RARRAY))
	(COND (RARRAY (GO ARRAY2LOOP)))
	(SETQ RARRAY (REVERSE AARRAY))
	(SETQ TEMP (LSA RARRAY))
	(COND ((OR (EQ TEMP 'SINGULAR) (EQ TEMP 'INCONSISTENT))
	       (RETURN
		(COND ((NULL FLAG) NIL)
		      (T (CXERFARG (RZERO) EXPG N A))))))
	(SETQ TEMP (reverse  (CDR TEMP)))
	(SETQ RMU 0)
	(SETQ Y 0)
   L3   (SETQ Y (R+ Y (R* (CAR TEMP) (PEXPT (LIST LOGETA 1 1) RMU))))
        (SETQ TEMP (CDR TEMP))
	(SETQ RMU (f1+ RMU))
	(COND ((NOT (> RMU RRMU)) (GO L3)))
	(RETURN (COND ((NULL FLAG) (RATQU Y P))
		      (T (CONS (R* (LIST EXPG N 1) (RATQU Y P)) '(0)))))))


(DEFUN ERFARG (EXPARG COEF)
   (PROG (NUM DENOM ERFARG)
	 (SETQ EXPARG (R- EXPARG))
	 (UNLESS (AND (SETQ NUM (PNTHROOTP (RATNUMERATOR EXPARG) 2))
		      (SETQ DENOM (PNTHROOTP (RATDENOMINATOR EXPARG) 2)))
		 (RETURN NIL))
	 (SETQ ERFARG (CONS NUM DENOM))
	 (IF (RISCH-CONSTP
	      (SETQ COEF (RATQU COEF (SPDERIVATIVE ERFARG MAINVAR))))
	     (RETURN (SIMPLIFY `((MTIMES) ((RAT) 1 2)
					  ((MEXPT) $%PI ((RAT) 1 2))
					  ,(DISREP COEF)
					  ((%ERF) ,(DISREP ERFARG))))))))

(DEFUN ERFARG2 (EXPARG COEFF &AUX (VAR MAINVAR) A B C D) 
  (WHEN (AND (= (PDEGREE (CAR EXPARG) VAR) 2)
	     (EQ (CAAR EXPARG) VAR)
	     (RISCH-PCONSTP (CDR EXPARG))
	     (RISCH-CONSTP COEFF))
	(SETQ A (RATQU (R* -1 (CADDAR EXPARG))
		       (CDR EXPARG)))
	(SETQ B (DISREP (RATQU (R* -1 (POLCOEF (CAR EXPARG) 1))
			       (CDR EXPARG))))
	(SETQ C (DISREP (RATQU (R* (POLCOEF (CAR EXPARG) 0))
			       (CDR EXPARG))))
	(SETQ D (RATSQRT A))
	(SETQ A (DISREP A))
	(SIMPLIFY `((MTIMES)
		    ((MTIMES)
		     ((MEXPT) $%E ((MPLUS) ,C
					   ((MQUOTIENT) ((MEXPT) ,B 2)
							((MTIMES) 4 ,A))))
		     ((RAT) 1 2)
		     ,(DISREP COEFF)
		     ((MEXPT) ,D -1)
		     ((MEXPT) $%PI ((RAT) 1 2)))
		    ((%ERF) ((MPLUS)
			     ((MTIMES) ,D ,INTVAR)
			     ((MTIMES) ,B ((RAT) 1 2) ((MEXPT) ,D -1))))))))


(DEFUN CXERFARG (ANS EXPG N NUMDENOM &AUX (ARG (R* N (GET EXPG 'RISCHARG)))
		                          (FAILS 0))
  (PROG (DENOM ERFANS NUM NERF)
	(DESETQ (NUM . DENOM) NUMDENOM)
	(UNLESS $ERFFLAG (SETQ FAILS NUM) (GO LOSE))
	(IF (SETQ ERFANS (ERFARG ARG NUMDENOM))
	    (RETURN (LIST ANS ERFANS)))
  AGAIN	(WHEN (AND (NOT (PCOEFP DENOM))
		   (NULL (P-RED DENOM))
		   (EQ (GET (CAR DENOM) 'LEADOP) 'MEXPT))
	      (SETQ ARG (R+ ARG (R* (f- (P-LE DENOM))
				    (GET (P-VAR DENOM) 'RISCHARG)))
		    DENOM (P-LC DENOM))
	      (GO AGAIN))
        (SLOOP FOR (COEF EXPARG EXPPOLY) IN (EXPLIST NUM ARG 1)
	      DO (SETQ COEF (RATQU COEF DENOM)
		       NERF (OR (ERFARG2 EXPARG COEF) (ERFARG EXPARG COEF)))
	         (IF NERF (PUSH NERF ERFANS) (SETQ FAILS
						   (PPLUS FAILS EXPPOLY))))
   LOSE (RETURN
	 (IF (PZEROP FAILS) (CONS ANS ERFANS)
	     (RISCHADD (CONS ANS ERFANS)
		       (RISCHNOUN (R* (RATEXPT (CONS (MAKE-POLY EXPG) 1) N)
				      (RATQU FAILS (CDR NUMDENOM)))))))))

(DEFUN EXPLIST (P OARG EXPS)
       (COND ((OR (PCOEFP P) (NOT (EQ 'MEXPT (GET (P-VAR P) 'LEADOP))))
	      (LIST (LIST P OARG (PTIMES P EXPS))))
	     (T (SLOOP WITH NARG = (GET (P-VAR P) 'RISCHARG)
		      FOR (EXP COEF) ON (P-TERMS P) BY 'PT-RED
		      NCONC (EXPLIST COEF
				     (R+ OARG (R* EXP NARG))
				     (PTIMES EXPS
					     (MAKE-POLY (P-VAR P) EXP 1)))))))


(declare-top (SPECIAL *FNEWVARSW))
	
(DEFUN INTSETUP (EXP *VAR) 
  (PROG (VARLIST CLIST $FACTORFLAG DLIST GENPAIRS OLD Y Z $RATFAC $KEEPFLOAT
		 *FNEWVARSW)
   Y    (SETQ EXP (RADCAN1 EXP))
	(FNEWVAR EXP)
	(SETQ *FNEWVARSW T)
   A    (SETQ CLIST NIL)
	(SETQ DLIST NIL)
	(SETQ Z VARLIST)
   UP   (setq y (POP Z))
        (COND ((FREEOF *VAR Y) (PUSH Y CLIST))
	      ((EQ Y *VAR) NIL)
	      ((AND (MEXPTP Y)
		    (NOT (EQ (CADR Y) '$%E)))
	       (COND ((NOT (FREEOF *VAR (CADDR Y)))
		      (SETQ DLIST `((MEXPT SIMP)
				    $%E
				    ,(MUL2* (CADDR Y)
					    `((%LOG) ,(CADR Y)))))
		      (SETQ EXP (MAXIMA-SUBSTITUTE DLIST Y EXP))
		      (SETQ VARLIST NIL)  (GO Y))
		     ((ATOM (CADDR Y))
		      (COND ((NUMBERP (CADDR Y)) (PUSH Y DLIST))
			    (T (SETQ OPERATOR T)(RETURN NIL))))
		     (T (PUSH Y DLIST))))
	      (T (PUSH Y DLIST)))
	(IF Z (GO UP))
	(IF (MEMQ '$%I CLIST) (SETQ CLIST (CONS '$%I (zl-DELETE '$%I CLIST))))
	(SETQ VARLIST (APPEND CLIST
			      (CONS *VAR
				    (NREVERSE (SORT (APPEND DLIST NIL) 'INTGREAT)))))
	(ORDERPOINTER VARLIST)
	(SETQ OLD VARLIST)
	(MAPC (FUNCTION INTSET1) (CONS *VAR DLIST))
	(COND ((ALIKE OLD VARLIST) (RETURN (RATREP* EXP)))
	      (T (GO A)))))
 

(DEFUN LEADOP (EXP)
       (COND ((ATOM EXP) EXP)
	     ((MQAPPLYP EXP) (CADR EXP))
	     (T (CAAR EXP))))

(DEFUN LEADARG (EXP)
  (COND ((ATOM EXP) 0)
	((AND (MEXPTP EXP) (EQ (CADR EXP) '$%E)) (CADDR EXP))
	((MQAPPLYP EXP) (CAR (SUBFUNARGS EXP)))
	(T (CADR EXP))))

(DEFUN INTSET1 (B)
       (LET (E C D) 
	 (FNEWVAR
	  (SETQ D (IF (MEXPTP B)			;needed for radicals
		      `((MTIMES SIMP)
			,B
			,(RADCAN1 (SDIFF (SIMPLIFY (CADDR B)) *VAR)))	      
		      (RADCAN1 (SDIFF (SIMPLIFY B) *VAR)))))
	 (SETQ D (RATREP* D))
	 (SETQ C (RATREP* (LEADARG B)))
	 (SETQ E (CDR (zl-ASSOC B (PAIR VARLIST GENVAR))))
	 (PUTPROP E (LEADOP B) 'LEADOP)
	 (PUTPROP E B 'RISCHEXPR)
	 (PUTPROP E (CDR D) 'RISCHDIFF)
	 (PUTPROP E (CDR C) 'RISCHARG)))

(DEFUN INTGREAT (A B)
       (COND ((AND (NOT (ATOM A)) (NOT (ATOM B)))
	      (COND ((AND (NOT (FREEOF '%ERF A)) (FREEOF '%ERF B)) T)
		    ((AND (NOT (FREEOF '$LI A)) (FREEOF '$LI B)) T)
		    ((AND (FREEOF '$LI A) (NOT (FREEOF '$LI B))) NIL)
		    ((AND (FREEOF '%ERF A) (NOT (FREEOF '%ERF B))) NIL)
		    ((NOT (FREE B A)) NIL)
		    ((NOT (FREE A B)) T)
		    (T (GREAT (RESIMPLIFY (FIXINTGREAT A))
				   (RESIMPLIFY (FIXINTGREAT B))))))
		  (T (GREAT (RESIMPLIFY (FIXINTGREAT A))
			    (RESIMPLIFY (FIXINTGREAT B))))))

(DEFUN FIXINTGREAT (A) (SUBST '/_101X *VAR A))

#-Nil
(DECLARE-TOP(UNSPECIAL B BETA CARY CONTEXT *EXP DEGREE GAMMA
		    KLTH LIFLAG M NOGOOD OPERATOR PROB
		    R S SIMP SWITCH SWITCH1 *VAR VAR  Y YYY))
