/* myproxy.c wrappers used to connect to target via myproxy.r
 * Copyright (C) 2005-2006 Jia Wang <skyroam@gmail.com>
 *
 *
 *
 * This file is part of GNU Proxyknife.
 * GNU Proxyknife is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * GNU Proxyknife is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Proxyknife; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* all functions are declared in proxyknife.h */
#include <proxyknife.h>

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>

/* Connect SOCKFD to HOST:PORT. via myproxy or not. 
 *   
 */

void
MY_CONNECT (int sockfd, char *host, char *port)
{
  struct hostent *h;
  struct sockaddr_in addr;
  int n;

  h = gethostbyname (host);

  if (h == NULL)
    {
      herror ("gethostbyname");
      xexit (EXIT_FAILURE);
    }

  memset (&addr.sin_zero, 0, sizeof (addr.sin_zero));
  addr.sin_family = AF_INET;
  addr.sin_port = htons (atoi (port));
  addr.sin_addr = *(struct in_addr *) h->h_addr;


  if (my.mytype == DIRECT)
    {
      n =
	connect (sockfd, (struct sockaddr *) &addr, sizeof (struct sockaddr));
      if (n == -1)
	{
	  perror (__FILE__ "connect");
	  xexit (EXIT_FAILURE);
	}
    }
  else if ((my.mytype == HTTP_CONNECT) || (my.mytype == HTTP_CONNECT_AUTH))
    {

      n = CONVIAHTTP_MAIN (sockfd, host, port);
      if (n == -1)
	{
	  fprintf (stderr, "%s %s: CONNVIAHTTP_MAIN\n", progname, __FILE__);
	  xexit (EXIT_FAILURE);
	}
    }
  else if ((my.mytype == SOCKS5_CONNECT)
	   || (my.mytype == SOCKS5_CONNECT_AUTH))
    {
      n = CONVIASOCKS5_MAIN (sockfd, (struct sockaddr *) (&addr));
      if (n == -1)
	{
	  fprintf (stderr, "%s %s: CONVIASOCKS5_MAIN\n", progname, __FILE__);
	  xexit (EXIT_FAILURE);
	}
    }
  else if (my.mytype == SOCKS4_CONNECT)
    {
      n = CONVIASOCKS4_MAIN (sockfd, (struct sockaddr *) (&addr));
      if (n == -1)
	{
	  fprintf (stderr, "%s %s: CONVIASOCKS4_MAIN\n", progname, __FILE__);
	  xexit (EXIT_FAILURE);
	}
    }
  else
    {
      fprintf (stderr,
	       "%s %s: mytype=%d is not supported!\n",
	       progname, __FILE__, my.mytype);
      xexit (EXIT_FAILURE);
    }
}
