"======================================================================
|
|   Smalltalk Gtk+ bindings (hand-written methods).
|
 ======================================================================"


"======================================================================
|
| Copyright 2001, 2003 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

!GtkMessageDialog class methodsFor: 'instance creation'!

new: parent flags: flags type: type buttons: buttons message: message
    ^self
        new: parent
        flags: flags
        type: type
        buttons: buttons
        messageFormat: '%s'
        varargs: { message }! !

!GtkRequisition class methodsFor: 'instance creation'!

fromPoint: point
    | ba |
    ba := (CShortType arrayType: 2) new.
    ba at: 0 put: point x.
    ba at: 1 put: point y.
    ^(ba castTo: self type) addToBeFinalized; yourself! !

!GtkRequisition methodsFor: 'accessing'!

x
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 0!

y
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 1! !

!GtkRequisition methodsFor: 'conversion'!

asPoint
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 0) @ (ba at: 1)!

!GdkRectangle class methodsFor: 'instance creation'!

fromRectangle: rect
    | ba |
    ba := (CShortType arrayType: 4) new.
    ba at: 0 put: rect left.
    ba at: 1 put: rect top.
    ba at: 2 put: rect width.
    ba at: 3 put: rect height.
    ^(ba castTo: self type) addToBeFinalized; yourself! !

!GdkRectangle methodsFor: 'accessing'!

left
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 0!

top
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 1!

right
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 0) + (ba at: 2)!

bottom
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 1) + (ba at: 3)!

width
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 2!

height
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 3!

origin
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 0) @ (ba at: 1)!

extent
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 2) @ (ba at: 3)!

corner
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^((ba at: 0) + (ba at: 2)) @ ((ba at: 1) + (ba at: 3))! !

!GdkRectangle methodsFor: 'conversion'!

asRectangle
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 0) @ (ba at: 1) extent:
        (ba at: 2) @ (ba at: 3)! !
