.TH sourceinstall 1 "2005-06-09" "Claudio Fontana"
.SH NAME
.B sourceinstall
\- install, remove, manage source packages in a graphical environment

.SH SYNOPSIS

.B sourceinstall
[
.I "-hV"
]
[
.I PACKAGE_NAME ...
]

.SH DESCRIPTION
GNU Source Installer (sourceinstall) is a graphical tool that can be used to install, remove and query information about installed source packages.
It also provides package consistency checks, and uninstallation crosschecks using an internal trace of all files pertaining to each source package.
It works best with source packages prepared with the autotools, and which honour the classic targets and environment variables.
For more information, see the texinfo manual by issuing:
.I
info sourceinstall

.SH OPTIONS

.TP 
.B "-h, --help"
show a brief command line help and exit successfully
.TP 
.B "-V, --version"
show version information and exit successfully
.TP
.I "PACKAGE_NAME" ...
If one or more PACKAGE_NAME arguments are specified, they are assumed to be referring to valid source packages to add (honouring the current preferences about package adding).

Packages are added in the same order as specified on the command line,
but the first failure in the installations breaks the chain.

You can change the preferences from within the program under Edit->Preferences, or you can directly edit the configuration file

.I "~/.sourceinstall/sourceinstallrc"

.SH BUGS
Report bugs to bug-sourceinstall@gnu.org

.SH AUTHOR
Claudio Fontana

.SH HOME PAGE
.I http://www.gnu.org/software/sourceinstall

.SH FILES

.I ~/.sourceinstall/
\- user specific data directory

.I ~/.sourceinstall/sourceinstallrc
\- user preferences

.I ~/.sourceinstall/build
\- temporary build directory

.I ~/.sourceinstall/install-destdir
\- test install destination directory

.I ~/.sourceinstall/packages
\- installed packages directory

.I ~/.sourceinstall/src
\- user source repository directory

.I ~/.sourceinstall/.sourceinstall_lock
\- lock file. Each user should run only one instance of sourceinstall.

