#include <config.h>

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <srcinst/srcinst.h>
#include "options.h"

struct option_data action_list[] = {
  { 'h', "help", { 0 }, { 0 }, 0, ". show brief command line help" },
  { 'V', "version", { 0 }, { 0 }, 0, ". show program version" },
  { 'l', "list", { 0 }, { 0 }, 0, ". list all existing packages; if PACKAGE_NAME is specified, it is treated as a regular expression string, and only matching package names are listed" },
  { 'a', "add", { "FILENAME", 0 }, { 0, 0 }, 0, ". add new source package from FILENAME; the package name will be taken from the top source directory by default, or from PACKAGE_NAME if specified" },
  { 'r', "remove", { 0 }, { 0 }, 0, ". remove package PACKAGE_NAME completely" },
  { 'c', "check", { 0 }, { 0 }, 0, ". show and validate package PACKAGE_NAME information" },
  { 'v', "update", { "OLD_PACK", "FILENAME", 0 }, { 0, 0, 0 }, 0, ". remove package OLD_PACKAGE completely, then add FILENAME. The new package name will be taken from the top source directory by default, or from PACKAGE_NAME if specified" },
  { 'i', "install", { 0 }, { 0 }, 0, ". install known package PACKAGE_NAME from stored source code" },
  { 'u', "uninstall", { 0 }, { 0 }, 0, ". uninstall package PACKAGE_NAME, but do not delete source if available" },
  { 'd', "description", { "STRING", 0 }, { 0, 0 }, 0, ". associate first line of STRING to PACKAGE_NAME short description, and the remaining lines to the long description. If STRING is empty, remove descriptions from the package. Use your shell quotation characters to submit a STRING containing newlines" },
  { 'n', "rename", { "NEW_NAME", 0 }, { 0, 0 }, 0, ". rename existing package PACKAGE_NAME to NEW_NAME" },
  { 'x', "export", { "FORMAT", "FILENAME", 0 }, { 0, 0, 0 }, 0, ". export package PACKAGE_NAME information to FILENAME. FORMAT can be xml, txt, lst" },
  { 'k', "pack", { "FILENAME", 0 }, { 0, 0 }, 0, ". build binary tarball from the installed package PACKAGE_NAME, and save it as FILENAME" },
  { '1', "detect-build", { "FILENAME", 0 }, { 0, 0 }, 0, ". scan FILENAME, reporting configure scripts in all subdirectories, and which autoconf version generated them. This can be useful to choose a build subdir, and to run on a new, unknown package to decide whether to install it" },
  { '2', "detect-feats", { "FILENAME", 0 }, { 0, 0 }, 0, ". scan FILENAME, reporting and testing the configure script that will be used (if present), and get the features supported by the generated Makefile. This detection action is useful to run after '-1', coupled with '-D' to choose a particular build subdirectory (and thus configure script/Makefile)" },
  { '3', "detect-opts", { "FILENAME", 0 }, { 0, 0 }, 0, ". scan FILENAME for configure options" },
  { 0, 0, { 0 }, { 0 }, 0, 0 }
};

struct option_data option_list[] = {
  { 'S', "no-source", { 0 }, { 0 }, 0, ". do not keep source code during installation (not recommended)" },
  { 't', "strip", { 0 }, { 0 }, 0, ". strip binaries during installation if possible (not recommended)" },
  { 'z', "compression", { "FORMAT", 0 }, { 0, 0 }, 0,	". use FORMAT as compression. Can assume values gz, bz2, Z" },
  { 'C', "configure", { "STRING", 0 }, { 0, 0 }, 2, ". (multiple option) force (re)configure of the package, and add STRING to the configure flags; do not use for specifying installation prefix, or it will be ignored: see --prefix below for that." },
  { 'D', "subdir", { "STRING", 0 }, { 0, 0 }, 0, ". use STRING as build subdirectory for the package" },
  { 'p', "prefix", { "STRING", 0 }, { 0, 0 }, 0, ". specify installation prefix for the package. For other configure-time options see --configure above" },
  { 'f', "force", { 0 }, { 0 }, 0, ". force execution of the action even when not recommended" },
  { 'U', "user", { "STRING", 0 }, { 0, 0 }, 0, ". privileged user login to revert to if required [default=] NIY" },
  { 'P', "pass", { "STRING", 0 }, { 0, 0 }, 0, ". privileged user password to revert to if required [default=] NIY" },
  { 'Q', "verbose", { 0 }, { 0 }, 0, ". send verbose info to standard output" },
  { 0, 0, { 0 }, { 0 }, 0, 0 }
};

void init_options(struct options* o) {
  o->package = 0;
  o->source = srcinst_get_pref_keep_source();
  o->strip = srcinst_get_pref_strip();
  o->install = srcinst_get_pref_install();
  o->force = 0;
  o->quiet = 1;
  o->src_compress = srcinst_get_pref_src_compress();
  srcinst_init_string_list(&(o->configure_strings));
  srcinst_add_string_list(&o->configure_strings, "./configure");
  option_list[3].values[0] = (char*)(&(o->configure_strings));
  o->subdir = 0;
  o->prefix = srcinst_get_pref_prefix();
  o->user = o->pass = 0;
}
