#ifndef OPTIONS_H
#define OPTIONS_H

struct option_data {
  char short_option; char* long_option;
  char* params[5]; char* values[5];
  
  /* 0: not yet chosen, 1: already, chosen, 2: multiple choice!
     the case 2 is special, in that values[0] becomes a pointer to a
     srcinst_string_list that contains the values */
  char chosen;
 
  char* help;  
};

struct options {
  char* package;		/* the package name on which to act */

  char install;			/* whether to install during add */
  char source;		        /* whether to keep source */
  char strip;			/* install-strip? */
  char force;			/* NOP and NIY */
  char quiet;			/* suppress non-error, non-requested msgs */
  char src_compress;		/* source compression format to use */

  /* params to pass to ./configure script */
  struct srcinst_string_list configure_strings;

  char* subdir;			/* build subdirectory from the top_srcdir */
  char* prefix;			/* passed to configure as last param */
  char* user, *pass;		/* login information */
};

void init_options(struct options* o);

extern struct option_data action_list[];
extern struct option_data option_list[];

#endif /* OPTIONS_H */
