/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 edit.c - information edit

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "gui.h"
#include "dialog.h"
#include "package_list.h"
#include "package_info.h"
#include "greeting.h"
#include "edit.h"

GtkWidget *w_edit[W_EDIT_N];

void edit_create(void)
{
    w_edit[W_EDIT] = gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(w_edit[W_EDIT]),
			      GTK_BUTTONBOX_SPREAD);
    w_edit[W_EDIT_APPLY] = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    w_edit[W_EDIT_CANCEL] = gtk_button_new_from_stock(GTK_STOCK_CANCEL);

    gtk_container_add(GTK_CONTAINER(w_edit[W_EDIT]), w_edit[W_EDIT_APPLY]);
    gtk_container_add(GTK_CONTAINER(w_edit[W_EDIT]),
		      w_edit[W_EDIT_CANCEL]);
}

void edit_apply(GtkWidget * unused_w, gpointer unused_data)
{
    char *oldvalue, *newvalue, *newname;
    GtkTextBuffer *txt;
    GtkTextIter start;
    GtkTextIter end;
    int success = 1;
    char *title = _("Apply changes");

    oldvalue = srcinst_get_name(state.package);
    txt =
	gtk_text_view_get_buffer(GTK_TEXT_VIEW
				 (w_package_info[W_PACKAGE_INFO_NAME]));
    gtk_text_buffer_get_start_iter(txt, &start);
    gtk_text_buffer_get_end_iter(txt, &end);
    newvalue = gtk_text_buffer_get_text(txt, &start, &end, FALSE);
    newname = srcinst_strdup(newvalue);

    if (value_updated(oldvalue, newvalue)) {
	if (srcinst_rename_package(state.package, newvalue) !=
	    SRCINST_ERR_OK) {
	    success = 0;
	}
    }

    free(newvalue);

    oldvalue = srcinst_get_descr(state.package);
    txt =
	gtk_text_view_get_buffer(GTK_TEXT_VIEW
				 (w_package_info[W_PACKAGE_INFO_DESC]));
    gtk_text_buffer_get_start_iter(txt, &start);
    gtk_text_buffer_get_end_iter(txt, &end);
    newvalue = gtk_text_buffer_get_text(txt, &start, &end, FALSE);

    if (value_updated(oldvalue, newvalue)) {
	if (!srcinst_set_descr(state.package, newvalue)) {
	    success = 0;
	}
    }

    free(newvalue);

    oldvalue = srcinst_get_descr_long(state.package);
    txt =
	gtk_text_view_get_buffer(GTK_TEXT_VIEW
				 (w_package_info
				  [W_PACKAGE_INFO_DESC_LONG]));
    gtk_text_buffer_get_start_iter(txt, &start);
    gtk_text_buffer_get_end_iter(txt, &end);
    newvalue = gtk_text_buffer_get_text(txt, &start, &end, FALSE);

    if (value_updated(oldvalue, newvalue)) {
	if (!srcinst_set_descr_long(state.package, newvalue)) {
	    success = 0;
	}
    }

    free(newvalue);

    if (!srcinst_close_package(state.package))
	success = 0;

    state.package = 0;
    package_list_fill();

    if (success) {
	int idx;
	GtkTreePath *path;
	if ((idx = srcinst_lsearch(package_list.strings,
				   package_list.count, newname)) != -1) {
	    path = gtk_tree_path_new_from_indices(idx, -1);
	    gtk_tree_view_set_cursor(GTK_TREE_VIEW
				     (w_package_list[W_PACKAGE_LIST]),
				     path, NULL, FALSE);
	    gtk_tree_path_free(path);
	} else
	    success = 0;
    }

    if (!success) {
	dialog_warning(title, _("Failed to apply some changes"),
		       _("Could not apply all the changes. "
			 "Original values will be restored where necessary."),
		       0);
	greeting_show();
    }

    free(newname);
}

void edit_cancel(GtkWidget * unused_w, gpointer unused_data)
{
    package_info_show();
}
