<?php /* Copyright (C) 2008 David Englund.

This file is part of GNU Sovix.

GNU Sovix is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

GNU Sovix is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with GNU Sovix.  If not, see <http://www.gnu.org/licenses/>.

The text in $sovix__page__copyright doesn't apply to this file, but
rather to the pages it generates. */

$sovix__page__copyright="Copyright (C) 2008 David Englund.
Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or any
later version published by the Free Software Foundation; with no Invariant
Sections, with no Front-Cover Texts, and with no Back-Cover Texts.";
$sovix__directory__src=$_SERVER['DOCUMENT_ROOT']."/sovix/src";
$sovix__directory__dotsovix=$_SERVER['DOCUMENT_ROOT']."/sovix/dotsovix";
$sovix__topic="";
require_once "$sovix__directory__src/header.inc"; ?>

<?php
$sovix__positive="#80ff80";
$sovix__neutral="#fff880";
$sovix__negative="#ff8080";
?>

<table<?php if ($sovix__xhtml_basic!=true && $sovix__xhtml_print!=true) echo ' cellpadding="1" cellspacing="0"'; ?> border="1">
  <tr>
  <td colspan="4" style="font-type: bold; font-size: 16pt; color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;"><abbr title="Gnu's Not Unix">GNU</abbr> Sovix <?php echo $sovix__version; ?> Specification</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Build date
      <span title="The date this version was build."><sup>[?]</sup></span></td>
    <td><?php echo $sovix__build_date; ?></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Website
      <span title="."><sup>[?]</sup></span></td>
  <td><a href="http://sovix.org/">sovix.org</a></td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Free software verification</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Free software
      <span title="The free software license that the source code of this WRS is distributed under."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;"><acronym title="GNU's Not Unix">GNU</acronym> <abbr title="Affero General Public License">AGPL</abbr><abbr title="version">v</abbr>3 or later</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Free documentation
      <span title="The free documentation license that the documentation of this WRS is distributed under."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;"><acronym title="GNU's Not Unix">GNU</acronym> <abbr title="Free Documentation License">FDL</abbr><abbr title="version">v</abbr>1.3 or later</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Free artwork
      <span title="The free license that the art of this WRS is distributed under."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;"><acronym title="GNU's Not Unix">GNU</acronym> <abbr title="General Public License">GPL</abbr><abbr title="version">v</abbr>3 or later</td>
  </tr>
  <tr>
    <td colspan="2" style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;"><strong>System requirements</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Application framework
      <span title="The framework required to run this WRS"><sup>[?]</sup></span></td>
    <td>None</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Application server
      <span title="The application server or application environment required to run this WRS."><sup>[?]</sup></span></td>
    <td><abbr title="PHP: Hypertext Preprocessor">PHP</abbr> 4.3.0 or later</td>
  </tr>
  <tr>
  <td style="background-color:<?php echo $sovix__hover__text; ?>">Database
      <span title="The database engine this WRS uses to store content and settings."><sup>[?]</sup></span></td>
  <td>Not required but supported</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="OS">Operating system</abbr>
      <span title="The operating systems this WRS is compatible with."><sup>[?]</sup></span></td>
    <td>Any</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Superuser
      <span title="Is root (or administrator) access required to install this application?"><sup>[?]</sup></span></td>
    <td>No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Shell access
      <span title="Is shell access required to install this application? In other words, do you need to be able to log in to the machine (other than through FTP) in order to install this application?"><sup>[?]</sup></span></td>
    <td>No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Web server
      <span title="The web servers this WRS is compatible with."><sup>[?]</sup></span></td>
    <td>Any that support <abbr title="PHP: Hypertext Preprocessor">PHP</abbr></td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Programming languages</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Server-side scripting language
      <span title=""><sup>[?]</sup></span></td>
    <td><abbr title="PHP: Hypertext Preprocessor">PHP</abbr> 4</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Client-side scripting language
      <span title=""><sup>[?]</sup></span></td>
    <td><abbr title="JS">JavaScript</abbr></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Database computer language
      <span title=""><sup>[?]</sup></span></td>
    <td><abbr title="Structured Query Language">SQL</abbr></td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Security</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Audit trail
      <span title="Does the system keep track of who made additions, updates, or deletions?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">re<abbr title="Completely Automated Public Turing test to tell Computers and Humans Apart">CAPTCHA</abbr>
      <span title="A challenge-response system designed to defeat bots from being able to use user-only features of a system. See http://en.wikipedia.org/wiki/Captcha for more information."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Content approval
      <span title="Does the system provide for some level of system-wide content approval?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Email verification
      <span title="Does the system send an activation key to users to make sure they've entered a valid email address?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Granular privileges
      <span title="Does the system allow read and write privileges on a per page or per content item basis, as well as separate privileges for other system functions?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Kerberos authentication
      <span title="Does the system support authentication via Kerberos?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Lightweight Directory Access Protocol">LDAP</abbr> authentication
      <span title="Does the system allow for LDAP-based authentication?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Login history
      <span title="Does the system keep track of who logged in and when? Such systems also usually keep track of things like what browser the user was using and what IP address they came from, as well as unsuccessful attempts."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Network File System">NFS</abbr> authentication
      <span title="Does the system allow for NFS authentication?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Network Information Service">NIS</abbr> authentication
      <span title="Does the system support authentication via NIS?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Pluggable authentication
      <span title="Does the system allow an administrator to plug in additional authentication schemes (from a vendor or homegrown) beyond the default proprietary authentication scheme and an LDAP authentication mechanism?  "><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Problem notification
      <span title="Does the system provide a mechanism for alerting administrators (email, instant messenger, cell phone, etc) when it detects a problem? (Logging does not count.)"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Sandbox
      <span title="Does the system allow for a private area for webmasters to try new content ideas without the worry of affecting the rest of the site?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Session management
      <span title="Does the system provide some facility for an administrator to see who is logged in, what they are doing, and log them out if necessary?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Secure Sockets Layer">SSL</abbr> compatible
      <span title="Can this system be used with an SSL certificate on the web server?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Secure Sockets Layer">SSL</abbr> logins
      <span title="Can this system be configured to switch to SSL mode (HTTPS) for logins, and then back to normal HTTP after the login? This kind of functionality protects user login information from being sniffed."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Secure Sockets Layer">SSL</abbr> pages
      <span title="Can this system be configured to switch to SSL mode for certain pages (or sections), and then back to straight HTTP for other pages (or sections)? You may want this if the system is used partially for regular site content and partially to distribute confidential data such as customer invoices or medical records."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Versioning
      <span title="Does the system provide for some level of system-wide content versioning?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Agnostical <abbr title="Relational Database Management System">RDBMS</abbr> support</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">My<abbr title="Structured Query Language">SQL</abbr>
      <span title="Does the WRS support MySQL?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Version 4.1.x or later</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Postgre<abbr title="Structured Query Language">SQL</abbr>
      <span title="Does the WRS support PostgreSQL?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Version 7.4.x or later</td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Web Accessibility</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><a href="http:/www.w3.org/QA/2006/02/content_negotiation.html">Content negotiation</a>
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Best Viewed with Any Browser
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Web Content Accessibility Guidelines">WCAG</abbr> 2.0
      <span title="WCAG is a set of guidelines on making content accessible, primarily for disabled users, but also for all user agents, including highly limited devices, such as cell phones."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;"><acronym title="Web Accessibility Initiative">WAI</acronym>-AA</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><acronym title="Authoring Tool Accessibility Guidelines">ATAG</acronym> 2.0
      <span title="Is the WRS a authoring tool used for creating Web content?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Text-to-speech friendly
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Section 508
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><acronym title="Attention Interest Desire Action Satisfaction">AIDAS</acronym>
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="JS">JavaScript</abbr> independent
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr>-<abbr title="Recommendation">REC</abbr> <abbr title="Cascading Style Sheets">CSS</abbr>
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>In-built support</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Code skeletons
      <span title="Does the system provide code skeletons or code templates to make it easy for new developers to write plugins for it?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Pluggable <abbr title="Application Programming Interface">API</abbr>
      <span title="Can the system be extended through an open and documented application programming interface (API)?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No?</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Test framework
      <span title="Does the system have an automated test framework that can be used to test the codebase to ensure that it is functioning properly? This sort of framework is sometimes called Unit Tests or Smoke Tests."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Manual
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Tutorial
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Frequently Asked Question">FAQ</abbr>
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Ease of Use</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Drag-N-Drop content
      <span title="Does the product allow the user to position content in a drag and drop fashion?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Email to discussion
      <span title="Can messages be emailed to the system so that they automatically appear in community discussions (forums/message boards)?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Friendly <abbr title="Uniform Resource Locator">URL</abbr>s
      <span title="Does the system have human-readable and search engine friendly URLs? (The alternative is that there are a bunch of symbols and numbers in the URL and the URLs are typically quite long.) "><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Image resizing
      <span title="Is the system capable of allowing users to resize uploaded images so they need not mess around with an external image editor?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Macro language
      <span title="Is there a macro language that allows webmasters to place powerful functionality (like auto-generated navigation systems) without any programming knowledge?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Mass upload
      <span title="Does the system have a way of uploading/importing many images and other files all at once to save time?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Prototyping
      <span title="Does the system allow the user to create custom default settings for the different kinds of content objects to save them extra clicks when creating those object types. For instance, if there is a particular template they like to use, can they set it as a default?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Server page language
      <span title="Is there a server page language available like PHP or JSP for easy one-off functionality?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Site setup wizard
      <span title="Does the system give the user the option to create default content areas, styles, and other settings during setup of the site or installation?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Spell checker
      <span title="Does the system have an integrated spell checker?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Style wizard
      <span title="Does the system have a wizard for generating styles/themes/templates or whatever else a look and feel might be called in the system? These wizards would allow the user to step by step choose colors, layouts, logos, etc to create their own look and feel without knowing anything about HTML/CSS."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Subscriptions
      <span title="Can the user subscribe to various sections of the site and receive notifications on new/updated content? These types of functions are typically found in the news feeds, forums, and blogs."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Template language
      <span title="Is there a templating language for powerful layout controls? (Note that templating languages are different from server page languages in that they are not capable of full programmatic functions, and are fully HTML compliant.)"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="User Interface">UI</abbr> levels
      <span title="Is there a means of &ldquo;dumbing down&rdquo; the publishing interface for less sophisticated publishers while keeping a more sophisticated interface for power users?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Undo
      <span title="Does the system allow users to &ldquo;undo&rdquo; operations if they make a mistake?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="What You See Is What You Get">WYSIWYG</abbr> editor
      <span title="Is there a web-based rich text editor to allow publishers to create formatted content without knowing HTML, CSS, XML, or XSL?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Zip archives
      <span title="Does the system allow a user to upload a zip (or other compressed file) full of static content, which is then published to the site? This sort of feature is used to do web-based mass uploads of static content."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Performance</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Advanced caching
      <span title="Does the system have advanced caching mechanisms that go beyond simple page caching? For instance, navigation, template, or content object caching?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Database replication
      <span title="Can the system take advantage of database replication for better scalability? The system would need to be able to perform reads from slaves and writes to the database master."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Load balancing
      <span title="Does the system allow you to put a load balancer in front of it to split the load between multiple servers? This would require that user sessions can be passed beween all the nodes transparently."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Page caching
      <span title="Does the system have a mechanism for caching the contents of a page so that if it's requested again it can skip most of the work to create the page?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Static content export
      <span title="Does the system have the ability to export it's content as static HTML so it may be served up from regional cache servers, or from static HTML web servers?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Management</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Advertising management
      <span title="Does the WRS have a banner or other management system?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Asset management
      <span title="Is there a central repository for uploading images and other files so they can be reused through-out the site?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Clipboard
      <span title="Is there a clipboard system that allows publishers to easily cut and paste content from one area of the site to another?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Content scheduling
      <span title="Does the system allow for content to be automatically added or removed from a site based upon date?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Content staging
      <span title="Can content be created on one server and easily &ldquo;pushed&rdquo; to another server?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Inline Administration
      <span title="Is content edited directly in the page that it will be placed? (The alternative is that there is a wholly separate interface for managing content.) "><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Online administration
      <span title="Can the system be completely managed through a web browser? (The alternative is that there is some sort of offline client software that must be used to manage at least some components.) "><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Package deployment
      <span title="Can content and applications be packaged so that tedious repeditive publishing functions can be easily deployed time and time again without the repetition?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Sub-sites / roots
      <span title="Does the system allow for sub-sites within a site that are self-contained with their own navigation and content hierarchy?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Themes / skins
      <span title="Does the system have a mechanism to transport styles, templates, etc between sites so that you can create a theme on one site and then reuse it on many others?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Trash
      <span title="Is there a trash system to allow administrators or publishers to recover content that has been removed from the site? Note that this is not the same as recovering items from a versioning archive."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Web statistics
      <span title="Does the system have built in web site statistics reporting for things such as pages/content items viewed, number of users per time period, etc?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Web-based style / template management
      <span title="Is there a web-based interface for adding styles and templates to the system for design and layout control?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Web-based translation management
      <span title="Can language translations be managed through and easy web-based interface?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Workflow engine
      <span title="Is there a full-fledged workflow system integrated into the WRS that can be used for business process management (or other duties beyond just content approval)?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Interoperability</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Content syndication (<abbr title="Really Simple Syndication">RSS</abbr>)
      <span title="Can the system export RSS/XML feeds so that the content can be republished on other sites? Note that if it can only syndicate content from one function, such a &ldquo;news&rdquo; then it should be labeled as only limited support."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="File Transfer Protocol">FTP</abbr> support
      <span title="Does the system allow users to upload internal content and/or files via FTP?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No?</td>
  </tr>
  <tr>
  <td style="background-color:<?php echo $sovix__hover__text; ?>">iCalendar (RFC 2445)
      <span title="If the system implements calendars, does it allow for the import and export of the iCalendar standard?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Unicode Transformation Format">UTF</abbr>-8 support
      <span title="Does the system support UTF-8 character encoding to enable multi-lingual sites without the use of seperate code pages for each language?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">WAI compliant
      <span title="Does the system follow the W3C specification for WAI compliance?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Web-based Distributed Authoring and Versioning">WebDAV</abbr> support
      <span title="Does the system allow users to upload internal content and/or files via WebDAV?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Semantically valid markup</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="HyperText Markup Language">HTML</abbr> 4.01 Transitional
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="HyperText Markup Language">HTML</abbr> 4.01 Strict
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="HyperText Markup Language">HTML</abbr> 5
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__neutral; ?>;">Semi</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="Extensible HyperText Markup Language">XHTML</abbr> Basic 1.1
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="Extensible HyperText Markup Language">XHTML</abbr> Print 1.0
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="Extensible HyperText Markup Language">XHTML</abbr> 1.0 Strict
      <span title="Does the system follow the W3C specification for XHTML compliance?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="Extensible HyperText Markup Language">XHTML</abbr> 1.0 Transitional
      <span title="Does the system follow the W3C specification for XHTML compliance?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="Extensible HyperText Markup Language">XHTML</abbr> 1.1
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="Extensible HyperText Markup Language">XHTML</abbr> 1.1 plus <abbr title="Mathematical Markup Language">MathML</abbr> 2.0
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="Extensible HyperText Markup Language">XHTML</abbr> 1.1 plus <abbr title="Mathematical Markup Language">MathML</abbr> 2.0 plus <abbr title="Scalable Vector Graphics">SVG</abbr> 1.1
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="Extensible HyperText Markup Language">XHTML</abbr>+<abbr title="Resource Description Framework in attributes">RDFa</abbr> 1.0
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="Extensible HyperText Markup Language">XHTML</abbr> 2.0
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__neutral; ?>;">Semi</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="World Wide Web Consortium">W3C</abbr> <abbr title="Extensible HyperText Markup Language">XHTML</abbr> 5
      <span title=""><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Flexibility</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Common Gateway Interface">CGI</abbr>-mode support
      <span title="Can the system run in CGI mode for development purposes or on low-end systems?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No?</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Content reuse
      <span title="Does the system allow content to be mirrored (not copied, but reused) from one location to another on a site?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Extensible user profiles
      <span title="Does the system provide a user profiling that can be extended with new profile properties through an administrative interface?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Interface localization
      <span title="Is the system localized/internationalized so it can be translated into other languages and take locale preferences like date/time preferences into account?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Metadata
      <span title="Does the system support the adding of arbitrary metadata properties to all the content objects? The metadata is typically then used for profiling, indexing, or even auxillary display functions."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Multi-lingual content
      <span title="Does the system support the creation of sites with multiple languages?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Multi-lingual content integration
      <span title="Does the system support a multi-lingual version of each content object without republishing the content object. For example, if you create an FAQ in English, then all that needs to be done to display the FAQ in Spanish or another language is to translate the content, not create another page with another FAQ content object. Then depending upon user preferences it either shows one version or the other."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Multi-site deployment
      <span title="Is the system capable of hosting multiple sites from one software deployment? This means you can install the software once and host as many sites as you want. It also means that when it comes time to upgrade you only need to upgrade the software in one place, not for each seperate site."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Uniform Resource Locator">URL</abbr> rewriting
      <span title="Is the system capable of rewriting URL or working with some other URL rewriting mechanism to provide shorter or friendlier URLs?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Built-in Applications</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Blog
      <span title="Does the systemm have a blog or web log? (See slashdot.org for an example.) "><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Chat
      <span title="Does the system have an application for real-time online chat?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Classifieds
      <span title="Does the system have a classifieds application?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Contact management
      <span title="Does the system have a contact management or rolodex type of application?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Data entry
      <span title="Does the system have an application for creating arbitrary data entry applications?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Database reports
      <span title="Does the system have an application for creating database reports?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Discussion / forum
      <span title="Does the system have a message board?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Document management
      <span title="Does the system have an application for managing offline document storage and versioning?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Events calendar
      <span title="Does the system have an application for tracking events and displaying events calendars?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Events management
      <span title="Does the system have a way to create events and allow users to sign up for those events."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Expense reports
      <span title="Does the system have an application for tracking employee expense reports?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Frequently Asked Question">FAQ</abbr> management
      <span title="Does the system have an application to organize frequently asked questions?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">File distribution
      <span title="Does the system have an application for distributing files including privileges for who is allowed to view/download those files?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Graphs and charts
      <span title="Does the system have an application that will allow the user to generate graphs and charts based upon some data set (SQL, text file, xml file, etc)?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Groupware
      <span title="Does the system have email and calendaring (group scheduling) applications?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Guest book
      <span title="Does the system have a guest book or graffiti application?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Help desk / bug reporting
      <span title="Does the system have an application for trouble ticketing or bug reporting?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>"><abbr title="Hypertext Transfer Protocol">HTTP</abbr> proxy
      <span title="Does the system have a mechanism to proxy or mirror HTML and other content and applications from other web servers?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">In/out board
      <span title="An intranet application that allows staff to post their status. In the building. Out for the day, be back tommorrow. Etc."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Job postings
      <span title="Does the system have a mechanism for posting job listings?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Link management
      <span title="Does the system have an application to manage links?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Mail form
      <span title="Does the WRS have an application for creating customizable &ldquo;contact us&rdquo; type forms?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Matrix
      <span title="Does the system have a matrix application similar to what you see here on WRS Matrix?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">My page / dashboard
      <span title="Does the WRS have a dashboard application (sometimes called a portal)? (See my.yahoo.com for an example.) "><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Newsletter
      <span title="Does the system have the ability to allow users to add/delete themselves to/from a list so that they can be sent email from the system on various topics?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Photo gallery
      <span title="Does the system have an application for displaying a thumbnail / image repository?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Polls
      <span title="Does the system have an application for conducting simple single question polls?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Product management
      <span title="Does the system have an application for displaying organized product information?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Project tracking
      <span title="Does the system have an application for managing project tasks?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Search engine
      <span title="Does the system have an integrated search engine that can index the managed content and allow the user to search the indexed content?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Site map
      <span title="Can the system generate a tree showing all of the pages in the system dynamically so it doesn't have to be maintained seperately by the webmasters?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Stock quotes
      <span title="Does the system have an application for displaying stock ticker information?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Surveys
      <span title="Does the WRS have an application for conducting complex multi-question surveys?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Syndicated content (<abbr title="Really Simple Syndication">RSS</abbr>)
      <span title="Does the WRS have an application for retrieving and displaying RDF/RSS/XML syndicated content?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Tests / quizzes
      <span title="Does the system have an application for administering tests and quizzes?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Time tracking
      <span title="Does the system have an application for tracking employee time for payroll or billing purposes?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">User contributions
      <span title="Does the WRS have a system for allowing a user community to contribute stories and other content to the site?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Weather
      <span title="Does the system have a weather information system?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Web services front end
      <span title="Does the system have an application for directly interfacing with arbitrary web services such as the Google API and the various available methods from X-Methods, and then creating a templated user interface without coding?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Wiki
      <span title="Does the system support wiki or wiki-like functionality? Wiki provides online collaboration functionality as well as a simple text formatting language."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr style="color:<?php echo $sovix__theme__window_border_text_color; ?>; background-color:<?php echo $sovix__basecolor; ?>;">
    <td colspan="2"><strong>Commerce</strong></td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Affiliate tracking
      <span title="Does the system have an affiliate tracking or referrals system for tracking partner sites that link in to the site?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Inventory management
      <span title="Does the system provide the site owner a way to manage inventory levels (quantities of product on hand)?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Pluggable payments
      <span title="Does the system allow the site owner to plug in new payment gateways so they may use whatever payment processing mechanism (PayPal, PayFlowPro, 2checkout, iTransact, Authorize.net, etc) they choose?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Pluggable shipping
      <span title="Does the system allow the site owner to plug in their own shipping calculator so that they can charge based upon their needs (weight, price, UPS, USPS, FedEx, etc)?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Pluggable tax
      <span title="Does the system allow the site owner to plug in new tax calculators?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Point of sale
      <span title="Does the system tie into (or have built in) a point of sale system to enable site owners to run a brick and mortar store from the same inventory?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Shopping cart
      <span title="Does the system have a mechanism for allowing the user to create a list of adhoc items to purchase, and then purchase all of them at once?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Subscriptions
      <span title="Does the system have a way manage timed subscriptions that are tied into the commerce function? This requires recurring billing, billing cancellation, etc."><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__negative; ?>;">No</td>
  </tr>
  <tr>
    <td style="background-color:<?php echo $sovix__hover__text; ?>">Wish lists
      <span title="Does the system allow users to create wish lists?"><sup>[?]</sup></span></td>
    <td style="background-color:<?php echo $sovix__positive; ?>;">Yes. We register it at the Savannah Task Manager.</td>
  </tr>
</table>

<?php require_once "$sovix__directory__src/footer.inc"; ?>
