<?php /* Copyright (C) 2008 David Englund.

This file is part of GNU Sovix.

GNU Sovix is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

GNU Sovix is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with GNU Sovix.  If not, see <http://www.gnu.org/licenses/>.

The text in $sovix__page__copyright doesn't apply to this file, but
rather to the pages it generates. */

$sovix__page__copyright="Copyright (C) 2008 David Englund.
Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or any
later version published by the Free Software Foundation; with no Invariant
Sections, with no Front-Cover Texts, and with no Back-Cover Texts.";
$sovix__directory__src=$_SERVER['DOCUMENT_ROOT']."/sovix/src";
$sovix__directory__dotsovix=$_SERVER['DOCUMENT_ROOT']."/sovix/dotsovix";
require_once "$sovix__directory__src/header.inc"; ?>

<?php
$sovix__array__toc_index = array(
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "Set up a website with Sovix",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "Basic setup",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Copy a template",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Decide copyright for the web page",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Set configuration",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Description of setting files",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Secure Sovix",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "3",
                    'sovix__array__toc_index__array__section' => "Enable SSL login",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "3",
                    'sovix__array__toc_index__array__section' => "Granular previlegies",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Share files with Sovix",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Distribute software code under GNU AGPL or as private software",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "User Interface",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "3",
                    'sovix__array__toc_index__array__section' => "Customize UI",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "3",
                    'sovix__array__toc_index__array__section' => "Translate filenames in the select menu",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Page index",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Links",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Web template engine",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "Learn how to use Sovix",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "Write and validate",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Write semantically valid HTML and XHTML",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Validate a webpage with different DTDs",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "Revise website",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Log in and log out",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Update files",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "View load time for page",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "",
                    ),
          );
require_once "$sovix__directory__src/toc-index.inc";
?>

<?php sovix__toc_index__base($sovix__toc_index__base="Set up a website with Sovix", $sovix__section_ending_special_chars=""); ?>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Basic setup", $sovix__section_ending_special_chars=""); ?>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Copy a template", $sovix__section_ending_special_chars=""); ?>

<p>
Copy <?php echo "$sovix__directory__sovix/Templates/Default/"; ?> to DocumentRoot (<?php echo $_SERVER['DOCUMENT_ROOT']."/ in your current configuration"; ?>) or to some other place. We will use DocumentRoot as example in this Tutorial since that is default.
</p>

<p>Set proper base path that is used by different settings in <?php echo $_SERVER['DOCUMENT_ROOT']."/Default/include/dotsovix/files.inc"; ?>;<br<?php echo $sovix__close_tag; ?>> Change <span style="color:#0000BB">$sovix__directory__base</span><span style="color:#007700">=</span><span style="color:#DD0000">"$sovix__url__sovix/Templates/Default"</span><span style="color:#007700">;<br<?php echo $sovix__close_tag; ?>></span> to <span style="color:#0000BB">$sovix__directory__base</span><span style="color:#007700">=</span><span style="color:#DD0000">"$sovix__directory__document_root/Default"</span><span style="color:#007700">;</span></p>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Decide copyright for the web page", $sovix__section_ending_special_chars=""); ?>

  <p>Go to <a href="<?php echo "http://" . $_SERVER["SERVER_NAME"]."/Default/"; ?>"><?php echo "http://" . $_SERVER["SERVER_NAME"]."/Default/"; ?></a> in a web browser.</p>
  <p>Do as the text in the page suggest. Verbatim copying and distribution is preferred to personal text while the GNU Free Documentation License is preferred to distribute text who anyone can copy, modify and redistribute. The GNU FDL is recommended for software manuals. We publish personal web documents that are not part of Sovix under verbatim copying but we use free documentation for documents that are part of Sovix as you can see at the footer of this page.</p>

<p>Open <?php echo "$sovix__directory__document_root/Default/Main_page.php"; ?> in your favorite text editor</p>

<p>
Modify &lt;year&gt; &lt;name of author&gt; in the <span style="color:#0000BB">$sovix__copyright</span> variable but do not remove any text about GNU Affero General Public License and do not remove <span style="color:#0000BB">$sovix__copyright_pointer</span> until you have read &ldquo;<a href="#Distribute_software_code_under_GNU_AGPL_or_as_private_software">Distribute software code under GNU AGPL or as private software</a>&rdquo;.
</p>

<p>Reload <?php echo "http://" . $_SERVER["SERVER_NAME"]."/Default/Main_page"; ?>.<br<?php echo $sovix__close_tag; ?>>
Your &ldquo;copyright&rdquo; appears at the beginning of the file, at the bottom (called footer) of the web page and at the page source (view page source with your web browser).</p>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Set configuration", $sovix__section_ending_special_chars=""); ?>

<p>
Modify the variable that points to the configuration directory in Main_page.php;<br<?php echo $sovix__close_tag; ?>>
Change <span style="color:#0000BB">$sovix__directory__dotsovix</span><span style="color:#007700">=</span><span style="color:#DD0000">""</span><span style="color:#007700">;</span>
<br<?php echo $sovix__close_tag; ?>>to&nbsp;&nbsp;&nbsp;&nbsp; <span style="color:#0000BB">$sovix__directory__dotsovix</span><span style="color:#007700">=</span><span style="color:#0000BB">$_SERVER</span><span style="color:#007700">[</span><span style="color:#DD0000">'DOCUMENT_ROOT'</span><span style="color:#007700">].</span><span style="color:#DD0000">"/Default/include/dotsovix"</span><span style="color:#007700">;</span>
</p>

<p>
Copy sovix/dotsovix/public.inc to your dotsovix directory and modify any settings that you wish not to be global and remove rest of the settings to let Sovix take care of them. For example, copy the line with sovix__array__public_variables__array__variable to your public.inc file and set it to a ISO-8859-1 if you wish to show Swedish characters with Sovix.
</p>

<p>
Set any variable before the header to override a variable set by the configuration files. The header line look like this:

<span style="color:#007700">require_once&nbsp;</span><span style="color:#DD0000">"$sovix__directory__src/header.inc"</span><span style="color:#007700">;&nbsp;</span><span style="color:#0000BB">?&gt;</span>
</p>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Description of setting files", $sovix__section_ending_special_chars=""); ?>

dotsovix/files.inc:
<ul>
  <li><span style="color: rgb(0, 0, 187);">$sovix__directory__base</span>: Base directory used by the configuration.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__directory__document_root</span>: Sovix uses this instead of PHP's predefined variable DOCUMENT_ROOT since the web server might not allow it. <span style="color: rgb(0, 0, 187);">$sovix__directory__document_root</span>: can be set to DOCUMENT_ROOT however.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__directory__include</span>: Intended&nbsp;directory for special files</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__directory__private</span>: Private directory. All private setting files for Sovix should be located here.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__directory__sovix</span>: Sovix directory. Its the &ldquo;internal Sovix site&rdquo; to describe the program. It has tutorial, sandbox and more.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__copyright_mod</span>: Execute given file. The file is intended to give a link to the license in <span style="color: rgb(0, 0, 187);">$sovix__page__copyright</span> that can be seen at the web page.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__footer_body</span>: File to be included at the bottom of the web page above the copyright notice.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__header</span>: File to be included in the top of the header. It may be useful to point to a file with personal variables.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__header_before_dtd</span>: File to be included before the DTD tag.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__header_body</span>: File to be included at the header below the top bar.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__header_bodytag_end</span>: File to be included at the end of the body tag</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__header_dtd_end</span>: File to be included at the end of&nbsp;the DTD tag</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__header_head</span>: File to be included within &lt;head&gt; and &lt;/head&gt; for custom purpose</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__header_html_end</span>: File to be included at the end of the &lt;html </li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__icon</span>: The icon file that represent the website that is typically showed in graphical web browsers.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__personal</span>: File with personal information related to the website.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__public</span>: File for settings</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__public__global</span>: File for global settings</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__read_file</span>: File that accepts which files should be readable and downloadable by the public.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__select_menu_data</span>: File that defines which directories and files types should be listed in the select menu.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__select_menu_translate</span>: File to translate filenames in the select menu.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__translations</span>: File that list available translations of the web page.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__url__etc</span>: URL to Sovix etc directory that contains images and relevant text files</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__url__sovix</span>: URL to Sovix.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__url__websrc</span>: URL to Sovix directory that contains special files.</li>
</ul>

<p></p>

dotsovix/private/files.inc.php:
<ul>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__ip_block</span>: File that lists blocked IP addresses</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__auth_sovix</span>: File with authentication data</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__select_menu_ignore</span>: File that defines which directories should not be listed in the select menu.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__hits_unique</span>: File that list unique hits. You can show the number of hits with the command &ldquo;server-hits-uniqe&rdquo;</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__log</span>: Login history</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__private</span>: Private settings that cannot be modified by public</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__rdbms</span>: File with variables to connect to a PostgreSQL or MySQL. This file is used by the web template engine.</li>
  <li><span style="color: rgb(0, 0, 187);">$sovix__file__read_file_ignore</span>: File that defines which files should not be readable and downloadable by the public</li>
</ul>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Secure Sovix", $sovix__section_ending_special_chars=""); ?>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Enable SSL login", $sovix__section_ending_special_chars=""); ?>

<p>
Set sovix__ssl_login to true in dotsovix/private/private.inc.php to execute a https request for logins with the command &ldquo;login&rdquo; or &ldquo;Tools > Log in&rdquo; from the menu bar. You need to configure Apache and PHP to use a SSL certificate in order to make this work.
</p>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Granular previlegies", $sovix__section_ending_special_chars=""); ?>

<p>
Set usernames and passwords in the commented text in dotsovix/private/auth_sovix.inc.php and uncomment it.<br<?php echo $sovix__close_tag; ?>>. Regular users (other then root) can only update the system while root can do anything. Avoid to log in as root if you don't have to.
</p>

<p>It is recommend to copy dotsovix/private/auth_sovix.inc.php to any location outside DOCUMENT_ROOT and set <span style="color:#0000BB">$sovix__file__auth_sovix</span> to that location in dotsovix/private/files.inc.php by security.</p>

When you click at &ldquo;Tools > Login&rdquo; in the menu bar or run &ldquo;login&rdquo; in the command line Sovix will use the configuration files set in the file you execute it from. So the username and password might be different when you log in from Sovix files then from the Default template since Sovix will read its configuration from sovix/dotsovix/ and Default from Default/dotsovix/.


<h4>Password</h4>

I suggest that you base $sovix__password on a algorithm based on the system date and time since this will update the password as often as you want.<br<?php echo $sovix__close_tag; ?>>

<p>
Example: <span style="color:#0000BB">$sovix__password</span><span style="color:#007700">=</span><span style="color:#DD0000">"x"</span><span style="color:#007700">.</span><span style="color:#0000BB">date</span><span style="color:#007700">(</span><span style="color:#DD0000">"ymdHi"</span><span style="color:#007700">);<br<?php echo $sovix__close_tag; ?>></span>

NOTE! Do not use the example above since it does not contain a capital, special character or is not long enough to be secure enough. Use at least a 8 characters long password and create your own algoritm.
</p>

<p>
Allways use the command 'server-time' to get the the system date and time from the server that host Sovix.
</p>

<h4>Username</h4>

Nothing special to mention about the username. Just keep the it static so as not to confuse it with a (eventually) dynamic password.

<h4>IP</h4>

<span style="color:#0000BB">$sovix__ip_address</span> can be on of follow: 'Allow from all', 'Deny from all' or any IP number.<br<?php echo $sovix__close_tag; ?>>
Allow from all allow any IP number to login to Sovix. Deny from all denies any IP from logging in. If you set it to a specific IP number only that address is allowd to login. If you want to be able to update your website with Sovix from anywhere in the world, set it to 'Allow from all'.


<?php sovix__toc_index__sub($sovix__toc_index__sub="Share files with Sovix", $sovix__section_ending_special_chars=""); ?>

<p>
Sovix has a mechanism to read files as plain text and another to download them. This is very useful when you want to share a file that is otherwise parsed by the HTTP sever such as file with a .php extension.
</p>

<p>
The file <?php echo $_SERVER['DOCUMENT_ROOT']."/Default/include/dotsovix/read-file.inc"; ?> is configured by default to instruct Sovix to read or download any file from <span style="color:#0000BB">$sovix__directory__base/</span> is you uncomment the array in the file. subdirectories that is listed in <?php echo $_SERVER['DOCUMENT_ROOT']."/Default/include/dotsovix/private/read-file-ignore.inc"; ?> is used to exclude desired subdirectories.
</p>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Distribute software code under GNU AGPL or as private software", $sovix__section_ending_special_chars=""); ?>

<p>
User who is in charge of a website typically keep the software code that generates the website as private software. That user keeps it and uses it, and does not release it to the public either as source code or as binaries. This makes it impossible for the visitors to contribute to the software code and learn. We distribute files at Sovix website under GNU AGPL; Anyone can read the software code as plain text by downloading it or view it direct from the web browser. Both you and us have been benefited with this many a time. We can for example read how Sovix is configured with the current release if there is something we need to do backward-compatible in our development version. And you can learn how to configure Sovix when you are in trouble.
</p>

<p>
Files in <span style="color:#0000BB">$sovix__directory__sovix</span> are readable over network by default since Sovix is distributed under GNU Affero General Public License. You can for example read sovix/Sovix.php by execute 'read-file <?php echo "$sovix__directory__sovix"; ?>/Sovix.php' in the command line. Files in subdirectories of <span style="color:#0000BB">$sovix__directory__sovix</span> named 'private' are not readable by default since they contain sensitive data such as passwords etc.
</p>

<p>
We are convinced that we can push the web to adapt this concept by demonstrating the usability from Sovix. You can help us doing this by adopting this mechanism for your website. The PHP Group advocates this at php.net, see the footer of any page at php.net where you can view the software code.
</p>

<h3>Distribute software code under GNU AGPL</h3>

GNU Affero General Public License ensures that anyone who makes copies of the software redistribute it under same license and that the software code is readable over a network.

<ol>
  <li>Make sure Sovix shares the files, see &ldquo;<a href="#Share_files_with_Sovix">Share files with Sovix</a>&rdquo; for how to do that.</li>
  <li>Leave the commented GNU AGPL notice that appears at the top of Main_page.php.</li>
</ol>

<h3>Distribute software code as private software</h3>
<ol>
  <li>Remove the GNU AGPL notice that appears at the top of Main_page.php.</li>
</ol>

<?php sovix__toc_index__sub($sovix__toc_index__sub="User Interface", $sovix__section_ending_special_chars=""); ?>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Customize UI", $sovix__section_ending_special_chars=""); ?>

<p>Sovix has all elements visible by default to make it as user friendly as possible so change these settings to suit your needs.<br<?php echo $sovix__close_tag; ?>>
You can find the settings in dotsovix/public.inc.
</p>

<ul>
  <li>Screen mode: <span style="color:#0000BB">$sovix__screen_mode</span>. This is set to &ldquo;normal&rdquo; by default which means that these user interfaces are configured, they are also visible by default:
    <ul>
      <li>&ldquo;Window&rdquo; border: <span style="color:#0000BB">$sovix__window_border_mode</span></li>
      <li>Menu bar: <span style="color:#0000BB">$sovix__menu_bar_mode</span></li>
      <li>Tool bar: <span style="color:#0000BB">$sovix__tool_bar_mode</span></li>
      <li>Top select menu: <span style="color:#0000BB">$sovix__select_menu_header_mode</span></li>
      <li>Side pane: <span style="color:#0000BB">$sovix__menu__side_pane_mode</span></li>
      <li>Bottom select menu: <span style="color:#0000BB">$sovix__select_menu_footer_mode</span></li>
      <li>Command line: <span style="color:#0000BB">$sovix__command_line_mode</span></li>
    </ul>
  </li>
</ul>

<p>
Note that you need the command line to perform commands with Sovix. So if you hide it you wont be able to update your configuration files from Sovix.
</p>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Translate filenames in the select menu", $sovix__section_ending_special_chars=""); ?>

Filenames should only include the letters A-Z and a-z since some web servers translate special characters which make the URL for the file wrong. The select menu uses the filename as item where underscore is replaced with space. So if you want to use different names for the represented files in the select menu you have to translate them.

<ol>
  <li>Copy <?php echo "$sovix__url__sovix/copy/select-menu-translate.inc"; ?> to your dotsovix directory</li>
  <li>Change <span style="color:#0000BB">$sovix__file__select_menu_translate</span><span style="color:#007700">=</span><span style="color:#DD0000">""</span><span style="color:#007700">;</span>
to <span style="color:#0000BB">$sovix__file__select_menu_translate</span><span style="color:#007700">=</span><span style="color:#DD0000">"$sovix__directory__dotsovix/select-menu-translate.inc"</span><span style="color:#007700">;</span></li>
  <li>Modify the search and replace arrays in <?php echo $_SERVER['DOCUMENT_ROOT']."/Default/include/dotsovix/select-menu-translate.inc"; ?>.</li>
</ol>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Page index", $sovix__section_ending_special_chars=""); ?>

Copy the code from sovix/copy/Page-index.php to an existing file and customize it.

<p>Page index can be showed in different modes</p>

<ol>
<li>In normal mode the page index links to a section at the page and that section links back to the page index. This is presented in (X)HTML.</li>
<li>The link sections placed at the page can be text without a link to the page index. This is useful when you do not use the page index since you can convert it to be a link that points to the page index any time by removing the <span style="color:#0000BB">$sovix__toc_index__hide_link</span>. Example: <span style="color:#0000BB">&lt;?php&nbsp;sovix__toc_index__base</span><span style="color:#007700">(</span><span style="color:#0000BB">$sovix__toc_index__base</span><span style="color:#007700">=</span><span style="color:#DD0000">"Name of topic or headline"</span><span style="color:#007700">,&nbsp;</span><span style="color:#0000BB">$sovix__toc_index__hide_link</span><span style="color:#007700">=</span><span style="color:#DD0000">"y"</span><span style="color:#007700">);&nbsp;</span><span style="color:#0000BB">?&gt;</span></li>
<li>&ldquo;File > Format as text&rdquo; at the menu bar or &ldquo;format-txt&rdquo; presents the whole page index and its links as plain text</li>
</ol>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Links", $sovix__section_ending_special_chars=""); ?>

The function sovix__local_link shows the link in red color and asks people to send the broken link to the webmaster of the site if the file does not exist. This is useful for a couple of reasons; 1) If the link is not discovered as broken by any software. 2) If there is no &ldquo;Missing&rdquo; page that provide the same feature.

<p>This is how it looks</p>

<span style="color:#0000BB">&lt;?php&nbsp;sovix__local_link</span><span style="color:#007700">(</span><span style="color:#0000BB">$sovix__local_link__link</span><span style="color:#007700">=</span><span style="color:#DD0000">"Link.php"</span><span style="color:#007700">,</span><span style="color:#0000BB">$sovix__local_link__text</span><span style="color:#007700">=</span><span style="color:#DD0000">"some&nbsp;link"</span><span style="color:#007700">);&nbsp;</span><span style="color:#0000BB">?&gt;</span>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Web template engine", $sovix__section_ending_special_chars=""); ?>

<ul>
  <li>Modify database, username and password in <?php echo $_SERVER['DOCUMENT_ROOT']."/Default/include/dotsovix/private/rdbms.inc.php"; ?> to be able to connect to the database</li>
  <li>Copy the text in <?php echo "$sovix__url__sovix/copy/RDBMS.inc"; ?> to an existing file used by Sovix such as Main_page.php.</li>
  <li>Modify <?php echo "$sovix__url__sovix/copy/RDBMS.inc"; ?></li>
</ul>

<ul>
  <li><span style="color:#0000BB">$sovix__wte__rdbms</span>: The name of the database. Possible values = PostgreSQL, MySQL.</li>
  <li><span style="color:#0000BB">$sovix__wte__rdbms__rdbms__host_address</span>: The host address of the specified RDBMS. Use 127.0.0.1 for localhost.</li>
  <li><span style="color:#0000BB">$sovix__wte__rdbms__port</span>: The port of the RDBMS. This is usally 5432 for PostgreSQL 8.1 and 3306 for MySQL 4.1.</li>
  <li><span style="color:#0000BB">$sovix__wte__rdbms__username</span>: The username for the RDBMS</li>
  <li><span style="color:#0000BB">$sovix__wte__rdbms__password</span>: The password for the RDBMS</li>
  <li><span style="color:#0000BB">$sovix__wte__rdbms__database</span>: The database name used by the RDBMS</li>
  <li><span style="color:#0000BB">$sovix__wte__rdbms__table</span>: The database table used by the RDBMS</li>
  <li><span style="color:#0000BB">$sovix__wte__query_free</span>: Extra query used to define conditions for example</li>
  <li><span style="color:#0000BB">$sovix__wte__order_by</span>: Defines which row that should be sorted</li>
  <li><span style="color:#0000BB">$sovix__wte__main_table</span>: Set to file if you want custom layout</li>
  <li><span style="color:#0000BB">$sovix__wte__highlight_boolean</span>: Shows green color for 'Yes' and red color for 'No'. Possible values = y, n</li>
</ul>

<p>Lets decribe how the arrays used by the web template engine work</p>

<ul>
  <li><span style="color:#0000BB">sovix__array__wte__column'</span>: The name of the column selected from the database table</li>
  <li><span style="color:#0000BB">sovix__array__wte__topic'</span>: The topic that you want to show for the column at the web page</li>
  <li><span style="color:#0000BB">sovix__array__wte__dbtype'</span>: Defines the data  type the column is. This is needed to be able to update the column to the database when you are logged in. Possible values = date, time, id, varchar, char, integer, text, boolean</li>
  <li><span style="color:#0000BB">sovix__array__wte__value'</span>: Used for booleans to set a default value if they have no values. Possible values = 't' (PosgreSQL) or '1' (MySQL)</li>
  <li><span style="color:#0000BB">sovix__array__wte__private'</span>: Only display the data if you are logged in. Possible values = y, n</li>
  <li><span style="color:#0000BB">sovix__array__wte__give_topic'</span>: Enable topic. Note that private must be set to n if you want to make it public. Possible values = y, n</li>
  <li><span style="color:#0000BB">sovix__array__wte__showcontent'</span>: Show what showcontent is set at instead of the text provided by the column. Value "y" is the same as leaving it empty</li>
  <li><span style="color:#0000BB">sovix__array__wte__require_value'</span>: Require a value when you want to update the column when you are logged in</li>
  <li><span style="color:#0000BB">sovix__array__wte__beg'</span>: Start a text before the text in the column. This is used to customize the layout</li>
  <li><span style="color:#0000BB">sovix__array__wte__beg_link'</span>: Set what the 'link' should start with </li>
  <li><span style="color:#0000BB">sovix__array__wte__link'</span>: Set the value provided by the column in a link</li>
  <li><span style="color:#0000BB">sovix__array__wte__end_link'</span>: Set what the 'link' should start with </li>
  <li><span style="color:#0000BB">sovix__array__wte__end'</span>: End with this text after the text in the column. This is used to customize the layout</li>
</ul>

<?php sovix__toc_index__base($sovix__toc_index__base="Learn how to use Sovix", $sovix__section_ending_special_chars=""); ?>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Write and validate", $sovix__section_ending_special_chars=""); ?>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Write semantical valid HTML and XHTML", $sovix__section_ending_special_chars=""); ?>

Visit <a href="Content_negotiation<?php echo "$sovix__dotphp"; ?>">'Content negotiation'</a> to see the syntax that should be used.

<?php sovix__toc_index__sub($sovix__toc_index__sub="Validate a webpage with different DTDs", $sovix__section_ending_special_chars=""); ?>

Go to &ldquo;Edit > Markup validate web document&rdquo; in the menu bar or run &ldquo;validate-markup*&rdquo; in the command line.

<?php sovix__toc_index__base($sovix__toc_index__base="Revise website", $sovix__section_ending_special_chars=""); ?>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Log in and log out", $sovix__section_ending_special_chars=""); ?>

To begin with, a username, password and more need to be set in <span style="color:#0000BB">$sovix__file__auth_sovix</span>, this is auth_sovix.inc.php by default. Refer to <a href="#TOCConfigure_users">Configure users</a> for how to do that.

<p>You need to log in to perform operator activities like updating text in files. Such actities are gray in the menu bar and begin with two lines (--) in the completion list (execute &ldquo;?&rdquo; in the command line to see them).</p>

<h4>Log in</h4>

Click at &ldquo;Tools > Login&rdquo; or run &ldquo;login&rdquo; in the command line to get redirected to the login page. Enter your username and password.

<h4>Log out</h4>

Click at &ldquo;Tools > Log out&rdquo; (&ldquo;Log in&rdquo; converts to &ldquo;Log out&rdquo; when you are logged in) or run &ldquo;logout&rdquo; in the command line. This will log out you directly.

<?php sovix__toc_index__sub($sovix__toc_index__sub="Update files", $sovix__section_ending_special_chars=""); ?>

Click at &ldquo;File > Open file...&rdquo; in the select menu or run command &ldquo;open-file&rdquo; in the command line. Define any file with the absolute filename (eg open-file /var/www/Default/Main_page.php) and click enter or &ldquo;Run&rdquo;.

<?php sovix__toc_index__sub($sovix__toc_index__sub="View load time for page", $sovix__section_ending_special_chars=""); ?>

At the bottom of the page source you see a line that begins with &ldquo;Page loaded in&rdquo;.

<?php require_once "$sovix__directory__src/footer.inc"; ?>
