/*
 *   Copyright (C) 2000 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _server_h
#define _server_h

#include <crawl.h>
#include <webbase_hook.h>

/*
 * Register hook 
 */
int server_hook(webbase_hook_params_t* hook_arg);
/*
 * Map server string to server id
 */
int server_id(webbase_t* base, const char* url);
/*
 * Add a server to the list of known servers
 */
int server_add(webbase_t* base, const char* url);
/*
 * Remove a server from the list of known servers
 */
int server_remove(webbase_t* base, const char* url);

#endif /* _server_h */
