/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifndef _http_h
#define _http_h

#include <crawl_private.h>
#include <webbase_url.h>
#include <cookies.h>

typedef struct http_context {
  crawl_context_t* crawl;
  webbase_url_t* webbase_url;
  cookies_t* cookies;
} http_context_t;

/*
 * Called once by I/O function (as a callback) with header string in <buffer>
 */
int http_header(char* arg, int sd, char* buffer, int buffer_size, int flag);
/*
 * Called for each chunck read by I/O function (as a callback)
 */
int http_body(char* arg, int sd, char* buffer, int buffer_size, int flag);
void http_verbose(int level);

#endif /* _http_h */
