/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifndef _robots_parser_h
#define _robots_parser_h

/*
 * Parse the content of a robots.txt file in file <path>
 * and return the list of Allow strings in <allowp> and the 
 * list of Disallow strings in <disallowp>.
 */
#ifdef WEBBASE_CONTENT_BASE
int robots_parse(char* content, int content_length, char** allowp, char** disallowp);
#else /* WEBBASE_CONTENT_BASE */
int robots_parse(char* path, char** allowp, char** disallowp);
#endif /* WEBBASE_CONTENT_BASE */

#endif /* _robots_parser_h */
