/*
 *
 * Copyright (C) 1997, 1998, 1999, 2000, 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <string.h>

#include <md5lib.h>
#include <md5str.h>

unsigned char* str2md5_simple(const char* string, int string_length)
{
  static char md5[MD5_SIZE];
  str2md5(string, string_length, md5);
  return md5;
}

unsigned char* str2md5ascii_simple(const char* string, int string_length)
{
  static char md5[MD5_ASCII_SIZE];
  str2md5ascii(string, string_length, md5);
  return md5;
}

void str2md5ascii(const char* string, int string_length, unsigned char* md5)
{
  unsigned char tmp[MD5_SIZE];
  str2md5(string, string_length, tmp);
  md52ascii(tmp, md5);
}

void str2md5(const char* string, int string_length, unsigned char* md5)
{
  struct md5_ctx ctx;
  MD5NS(init_ctx) (&ctx);
  MD5NS(process_bytes)((unsigned char*)string, (unsigned long)string_length, &ctx);
  MD5NS(finish_ctx)(&ctx, md5);
}

void ascii2md5(const char* str, unsigned char* md5)
{
  static char hextable[128] = {
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 1, 2, 3, 4, 5, 6, 7, 
    8, 9, 0, 0, 0, 0, 0, 0, 
    0, 10, 11, 12, 13, 14, 15, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 10, 11, 12, 13, 14, 15, 0, 
  };

  int i;
  for(i = 0; i < 16; i++) {
    const char* p = str + (i * 2);
    md5[i] = ((hextable[(int)p[0]] << 4) | (hextable[(int)p[1]]));
  }
}

void md52ascii(const unsigned char* md5, char* str)
{
  static char num2hex[] = "0123456789abcdef";

  int i;
  for(i = 0; i < 16; i++) {
    *str++ = num2hex[(md5[i] >> 4) & 0xf];
    *str++ = num2hex[md5[i] & 0xf];
  }
}
