/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#if HAVE_STRING_H
# include <string.h>
# include <memory.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif

#include <mkdirp.h>
#include <salloc.h>
#include <split.h>
#include <file_exists.h>

void mkdirp(char* dirname, int dirname_length)
{
  char** splitted;
  int count;
  static char* path = 0;
  static int path_size = 0;
  int i;

  if(dirname_length == 0)
    return;
  /*
   * + 2 is for null AND trailing / 
   */
  static_alloc(&path, &path_size, dirname_length + 2);

  split(dirname, dirname_length, &splitted, &count, '/', SPLIT_TRIM);

  path[0] = '\0';
  if(dirname[0] == '/') {
    strcpy(path, "/");
  }
  for(i = 0; i < count; i++) {
    /*
     * If the path is not empty and not root, add trailing /
     */
    if(path[0] != '\0' && strcmp(path, "/")) {
      strcat(path, "/");
    }
    strcat(path, splitted[i]);
    if(!file_exists(path)) {
      if(mkdir(path, 0777) < 0) {
	fprintf(stderr, "could not create directory %s\n", path);
	perror("");
	exit(1);
      }
    }
  }
}
