/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _dirsel_h
#define _dirsel_h

#ifdef __cplusplus
extern "C" {
#endif

#define DIRSEL_LOAD	0x01
#define DIRSEL_RELOAD	0x02

void dirsel_init();
void dirsel_end();
void dirsel_allow(char* url, char* dirs, int flag);
void dirsel_disallow(char* url, char* dirs, int flag);
void dirsel_robots_allow(char* netloc, char* dirs, int flag);
void dirsel_robots_disallow(char* netloc, char* dirs, int flag);
int dirsel_allowed(char* netpath, char* url);
char* dirsel_key(char* url);
void dirsel_verbose(int level);

#ifdef __cplusplus
}
#endif

#endif /* _dirsel_h */
