/*
 * zlibc.h
 *
 * Copyright (C) 1993 Alain Knaff
 */

#ifndef ZLIBC_H
#define ZLIBC_H

#define FA_ALL	    0

#define FA_DIR      1
#define FA_SUBDIR   2
/* FA_DIR and FA_SUBDIR should be specified with their trailing slash */

#define FA_BASENAME 3
#define FA_SUFFIX   4
#define FA_FILENAME 5
#define FA_ALL2     6
#define FA_FS	    7

#define PM_NONE    0

#define PM_USE_TMP_FILE 1
#define PM_HIDE_PIPE	2
#define PM_SHOW_PIPE	3
#define PM_DIR_LEAVE_COMPR	4
#define PM_LEAVE_COMPR 	5
#define PM_READ_MASK    7

#define PM_CREATE_COMPR 0x8
#define PM_NOCREATE_COMPR 0x10
#define PM_CREATE_MASK 0x18

#define PM_APPEND_COMPR 0x20
#define PM_NOAPPEND_COMPR 0x40
#define PM_APPEND_MASK 0x60

#define PM_UNCOMPR_BEFORE_WRITE 0x80
#define PM_NO_UNCOMPR_BEFORE_WRITE 0x100
#define PM_UNCOMPR_MASK 0x180

#define PM_SIZE_COMPR 0x200
#define PM_SIZE_UNCOMPR 0x400
#define PM_SIZE_COMPR_MASK 0x600

typedef struct FilenameActions {
  int fa_type;
  char *name;
  dev_t dev;
  ino_t ino;
  int is_initialized;
  int namelength;
  int pipe_mode;
} FilenameActions;

/* the file actions have been read */
#define CM_HAVE_FA 0x1

/* disable package altogether */
#define CM_DISAB 0x2

/* readdir lists compressed files */
#define CM_READDIR_COMPR 0x4

/* print comments for each intercepted syscall */
#define CM_VERBOSE 0x8

/* unlinks compressed files when user programs asks to unlink 
 * uncompressed file */
#define CM_UNLINK 0x10

/* doesn't read run time configuration file */
#define CM_NORTCONF 0x20

/* all available file-settable modes or'ed together */
#define CM_ALL_MODES 0x1f

/* none of these flags */
#define CM_NONE 0

typedef struct CommandActions {
  char *name;
  int cm_type;  
  FilenameActions *actions;
} CommandActions;


extern CommandActions zlib_commandActions[];

#define FREC(a,b,c) { a, b, sizeof(b) - 1, c }

#if 0

#ifdef HAVE___ACCESS
#define access __access
#endif

#ifdef HAVE___CHMOD
#define chmod __chmod
#endif

#ifdef HAVE___CHOWN
#define chown __chown
#endif

#ifdef HAVE___LSTAT
#define lstat __lstat
#endif

#ifdef HAVE___STAT
#define lstat __stat
#endif

#if 0
#ifdef HAVE___OPEN
#define open __open
#endif

#ifdef HAVE___READLINK
#define readlink __readlink
#endif

#ifdef HAVE___UNLINK
#define unlink __unlink
#endif

#ifdef HAVE___LINK
#define link __link
#endif

#ifdef HAVE___SYMLINK
#define symlink __symlink
#endif
#endif

#endif

#ifndef __STDC__
#define signed /**/
int fprintf();
int printf();
int _flsbuf();
int syscall();
int wait4();
int fclose();
int perror();
int getdents();
#endif


void zlib_initialise(void);
int zlib_getfiletype(__const char *name, int fd);
void zlib_getuserconf(char *progname, 
		      FilenameActions **filenameActions, 
		      int *mode, int *modemask);

extern char *zlib_ext;
extern int zlib_extlen;
extern int zlib_mode;
extern char *zlib_tmp;
extern char **zlib_uncompressor;




#ifdef CONFIG_COMPILER
extern char *err_strings[];
extern int generation;

/* configuration file compiler */
typedef struct commands_line {
  char *name;
  int mode, modemask;
  struct commands_line *globalnext, *localnext;
  int generation;
  char class[16];
  int defined;
} commands_line;

int add_prog(commands_line **cmd, char *name);
int add_default(commands_line **cmd);

void print_class(FilenameActions *fa, char *name, int line);
int parse_file(char *progname, 
	       FILE *f,
	       int *line,
	       int *mode,
	       int *modemask,
	       char *classname);
#endif

int ___zlibc_lstat(const char *file_name, struct stat *buf);
int ___zlibc_stat(const char *file_name, struct stat *buf);

#endif
