#!/bin/csh -f

#	S. Kremer, Sep 1989.

#	texbib - make .tex file from .ref file for annotated bibliography 
#	and TeX it (like roffbib, but with tib&TeX instead of refer&nroff).

# path names of commands:
set tiblist=AAAAA/tiblist
set tex=BBBBB

set tibinputs=CCCCC

# init:
set tibopt=(-d $tibinputs -s texbib -i quote.ttx -i abstract.ttx)
#	quote.ttx uses `` and '' instead of german quotes
#	abstract.ttx prints the %X and %W fields

set V=0	tib_verbose='-z'	# do not be verbose as default
set K=0				# do not keep tmp files

alias announce 'if ($V == 1) echo'

if ($#argv == 0) then
	echo 'Usage:' $0 '[-vk] [tib options] file[.ref]'
	echo '-v: be verbose'
	echo "-k: keep intermediate files and don't run TeX"
	exit 
endif

set infile=$argv[$#argv]	# last arg is filename
set argv[$#argv]=''		# delete it form arg list

foreach i ($*)
 	switch("$i")
	case '-v': 
		set V=1 tib_verbose='' 
		breaksw
	case '-k':
		set K=1
		breaksw
	case '-vk':
	case '-kv':
		set V=1 tib_verbose='' K=1
		breaksw
	default:
		set tibopt=($tibopt $i)
	endsw
end

set in=$infile	# the original input file name
# make a suitable tex file name
switch ($infile:e)
	case 'ref': 
		# strip extension .ref and give it .tex instead
		set out=$infile:r.tex
		breaksw
	case '':
		set out=$infile.tex
		# If specified input file does not exist, user 
		# probably forgot .ref.
		# We fix it for him:
		if (! -f $infile && -f $infile.ref) set in=$infile.ref
		# If we would not fix it, tib will look for $in.tex,
		# which may very well exist from a previous run.
		breaksw
	default:
		set out=$infile.tex	# just add .tex for a strange file name
		# But beware of the processing tex does with its input file 
		# name,
		# e.g., `mkannbib bib.ref~' will call `tex bib.ref~.tex',
		# but tex inputs file `bib.ref', which is not what you want!
endsw

$tiblist $tib_verbose $tibopt $in -x > $out	|| exit 1

if ($K == 1) then	# do no tex and do not clean up
	announce Tiblist output is in $out
	exit
endif

if ($V == 0) then
	$tex $out	> /dev/null		|| exit 1
else
	$tex $out				|| exit 1
endif

if ($K == 0) then
	announce Removing $out $out:r.log
	/bin/rm -f $out $out:r.log
endif		
