/* unixio.h - Unix terminal and signal handling
   $Id: unixio.h,v 0.2 1997/03/28 03:17:40 tjchol01 Exp $
   Authors: Andrew Trevorrow, Ian Dall, Geoffrey Tobin, Tomasz J. Cholewo
 */

#ifndef UNIXIO_H
#define UNIXIO_H

#include "dvgt.h"

typedef struct
  {
    unsigned int intr, tstop:1;
  }
sig_flags_t;
typedef struct
  {
    unsigned int cbreak, raw, echo:1;
  }
cmode_flags_t;

extern sig_flags_t sig_flags;
extern cmode_flags_t cmode_flags;

/* Alex Dickinson                                                         */
/* Definitions for some unix ioctl calls. These external procedures       */
/* refer to the C functions contained in unixio.c.                        */

extern void save_init_tty ();
extern void restore_init_tty ();
extern void save_temp_tty ();
extern void restore_temp_tty ();
extern void singlecharon ();
extern void singlecharoff ();
extern void echoon ();
extern void echooff ();
extern void rawouton ();
extern void rawoutoff ();
extern int buffercount ();
extern void suspend ();

#endif /* UNIXIO_H */

/* end unixio.h */
