#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include "dvi.h"

#ifdef IBMPC
#include <alloc.h>
#else
#define farmalloc malloc
#define farfree free
#endif


static long mem_used = 0l;

void huge *mem_alloc(long n, char *comment)
{
    void *ptr;

    while(op.maxmem && mem_used+n>op.maxmem)
    {
	fnt_t *f = fnt_find(dvi_info.fonts);
	if (f==NULL) 
	    halt("Error: Maximum memory size too small for %s",comment);
	fnt_free(f,0);
    }


    ptr = (void*)farmalloc(n);

    while(ptr==NULL)
    {
	fnt_t *f = fnt_find(dvi_info.fonts);
	if (f==NULL) 
	    halt("Error: Cannot allocate memory for %s",comment);
	fnt_free(f,0);

	ptr = (void*)farmalloc(n);
    }

    mem_used += n;
    return ptr;
}

void mem_free(void huge *ptr, long n)
{
    if (ptr!=NULL)
    {
	farfree((void*)ptr);
	mem_used -= n;
    }
}

char *mem_strdup(char *string)
{
    char *s = (char*)mem_alloc(strlen(string)+1,"String");
    strcpy(s,string);
    return s;
}

void mem_strfree(char *string)
{
    mem_free(string,strlen(string)+1);
}

void mem_test(void)
{
    if (mem_used) print("%ld Bytes of memory in use",mem_used);
}


