# -*- python -*-
# $Id: gnomegoods.py,v 1.3 2000/12/09 14:29:23 yotam Exp $
import GTK;
import gtk;
import gnome.ui;
import GdkImlib;
import osgoods;
import gtkgoods;


class WarnDlg(gnome.ui.GnomeDialog):
   def __init__(self):
      gnome.ui.GnomeDialog.__init__(self, "Warning", 
                                    gnome.uiconsts.STOCK_BUTTON_OK);
      self.hbox = gtk.GtkHBox();
      self.hbox.show();
      self.vbox.pack_start(self.hbox);
      self.text = gtk.GtkText();
      self.text.set_line_wrap(0);
      self.text.show();
      self.connect('clicked', self.callback);
      gnomeroot = osgoods.cmdOutput("gnome-config --prefix");
      png = gnomeroot + "/share/pixmaps/gnome-warning.png";
      # print "png='%s'" % png;
      try:
         im = GdkImlib.Image(png)
      except RuntimeError: 
         print "load image failed";
         im = None;
      # print "im=$im";
      if im != None:
         # print "Adding warning image";
         im.render();
         pix = im.make_pixmap();
         pix.show();
         self.hbox.pack_start(pix);
      self.hbox.pack_start(self.text);

   def setText(self, text):
      rect = gtkgoods.getTextRect(self.text.get_style().font, text);
      # print "rect=", rect;
      self.text.delete_text(0, -1);
      self.text.insert_defaults(text);
      self.text.set_usize(rect[0] + 3, rect[1] + 1);
      self.text.set_position(0);
      self.text.thaw();
      gtk.grab_add(self);

   def callback(self, button, no):
      # print "WarnDlg callback no:", no;
      if no == 0:
         self.hide();
         gtk.grab_remove(self);



# How to write singleton?
_warnDlg = None;
def warn(text):
   global _warnDlg;
   if _warnDlg == None:
      # print "_warnDlg created";
      _warnDlg = WarnDlg();
   _warnDlg.setText(text);
   _warnDlg.set_position(GTK.WIN_POS_MOUSE);
   _warnDlg.show();





