---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, références, 
              protéger, accolades, crochets, référence bibliographique, 
              citation, arguments optionnels
---

# Comment utiliser la commande `\cite` dans une commande `\item` ?

Un problème peut survenir en "emboîtant" deux commandes 
ayant un argument optionnel. Par exemple :

```{noedit}
\item[\cite[section 1]{observ}] ...
```

Dans ce cas, le crochet fermant après `section 1` sera considéré 
comme la fin de l'argument optionnel de la commande `\item`. 
Pour éviter la confusion, il faudra ajouter un niveau d'accolades :

```
% Un fichier BIB créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{\jobname.bib}
  @book{observ,
    author = {Lancaster, Albert},
    title = {Liste générale des observatoires et des astronomes, 
             des sociétés et des revues astronomiques},
    publisher = {F. Hayez},
    year = {1890},
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Au cas où vous en auriez besoin, plusieurs ressources existent sur 
des listes d'observatoires astronomiques :
\begin{itemize}
\item[Wikipédia] maintient une telle liste sur son site ;
\item[{\cite[section 1]{observ}}] donne une liste datant de 1890.
\end{itemize}
\bibliographystyle{plain}
\bibliography{\jobname}
\end{document}
```