import three;
settings.render=0;
settings.prc=false; 

import Header;

unitsize(x=1.25cm);
currentprojection=orthographic(0.5, 1.0, 0.25);

thinpen;
currentpen += roundcap;
currentpen += roundjoin;

real r  = 5.0;
real re = 0.3*r;
real ra = 0.25*r;

triple vA  =   dir(35, 25);
transform3 Rr =  rotate(130,vA);

triple vV  = r*dir(50, 10);
triple vVr =   Rr*vV;

triple vRo = dot(vA,vV) * vA;
triple vR  = vV-vRo;
real   rr  = length(vR);

draw(O--vRo, dashed);
draw(Label("$\aS{a}$",1,UnFill(1)),
     O--re*vA, uvecpen, Arrow3(HookHead3, size=Asize));
draw(O--vV,    uvecpen, Arrow3(HookHead3, size=Asize));
draw(O--vVr,   uvecpen, Arrow3(HookHead3, size=Asize));


draw(Label("$\aS{x}$",  1), vRo--vV);
draw(Label("$\aS{x}_R$",1), vRo--vVr);

draw(circle(vRo, rr, vA));
dot(vRo);
dot(vV);
dot(vVr);

draw(Label("$\vartheta$",align=O,UnFill(1)), 
     arc(vRo, 0.75*(vV-vRo)+vRo, 0.75*(vVr-vRo)+vRo), Arrow3(HookHead3, size=Asize));

draw(Label("$s_1$",1), O--2.0*ra*X);
draw(Label("$s_2$",1), O--1.0*ra*Y);
draw(Label("$s_3$",1), O--1.5*ra*Z);

