{ CONVERT.PAS
  Oliver Kirchkamp / 25.3.92,
  This module is included by WP2LATEX (the WP5.1-version)}

PROCEDURE math_fifo;
VAR i:INTEGER;
BEGIN
   typeout(texcommand[TEX_MAX_STACK]);
   FOR i:=TEX_MAX_STACK DOWNTO 2 DO
      texcommand[i]:=texcommand[i-1];
   texcommand[1]:='';
END;

PROCEDURE start_tex_math;
VAR i:INTEGER;
BEGIN
   FOR i:=1 TO TEX_MAX_STACK DO texcommand[i]:='';
   hbox:=FALSE;
END;

FUNCTION math_inspect(i:INTEGER):STRING;
BEGIN
   IF (i>0) AND (i<=TEX_MAX_STACK) THEN math_inspect:=texcommand[i]
   ELSE math_inspect:='';
END;

FUNCTION math_pop(i:INTEGER):STRING;
BEGIN
   IF (i>0) AND (i<=TEX_MAX_STACK) THEN BEGIN
      math_pop:=texcommand[i];
      texcommand[i]:='';
   END ELSE math_pop:='';
END;

PROCEDURE lowercase(VAR s:STRING);
  { this translates ALPHA into alpha }
  VAR i:INTEGER;
  BEGIN
  FOR i:=1 TO length(s) DO
     IF ((ORD(s[i]) >= ORD('A')) AND
         (ORD(s[i]) <= ORD('Z'))) THEN
         s[i]:=Chr(ORD(s[i])+ORD('a')-ORD('A'));
  END; {proc lowercase}

FUNCTION is_accent(s2:STRING):BOOLEAN;
   BEGIN
      lowercase(s2);
      IF (s2='hat') OR (s2='breve') OR (s2='grave') OR (s2='bar') OR (s2='dot')
      OR (s2='check') OR (s2='acute') OR (s2='tilde') OR (s2='vec')
      OR (s2='ddot') THEN is_accent:=TRUE
      ELSE is_accent:=FALSE;
   END;

FUNCTION accents(VAR s:STRING):BOOLEAN;
  {This makes xBAR become \bar x }
  VAR s1,
      s2:STRING;
  BEGIN
    IF length(s)<2 THEN accents:=FALSE ELSE
    BEGIN
      s1 := COPY(s,1,1); { s1 is the `x' from xBAR }
      s2 := s;
      DELETE(s2,1,1);    { s2 is the `BAR' }
      IF is_accent(s2) THEN BEGIN
        s := CONCAT('\',s2,'{',s1,'}'); { if bar is found to be an accent,
                                          then we build \bar x }
        accents := TRUE;
      END ELSE
         accents:=FALSE;                { else we leave xBAR as it is }
    END; {if length}
  END;

PROCEDURE clear_texcommand;
   { here we 'translate' WP-Commands word by word into TeX commands,
     we start with a small list, thereafter *accents* are treated more
     systematically }
   VAR command2 : STRING;
   BEGIN
      IF texcommand[1]='}'THEN hbox:=FALSE;
      IF NOT hbox THEN BEGIN
         command2 := texcommand[1];
         lowercase(command2); {WP-commands are assumed to be case-invariant}
         IF command2='sup' THEN texcommand[1]:='^'
         ELSE IF command2='to' THEN texcommand[1]:='^'
         ELSE IF command2='sub' THEN texcommand[1]:='_'
         ELSE IF command2='from' THEN texcommand[1]:='_'
         ELSE IF command2='~' THEN texcommand[1]:=''
         ELSE IF command2='`' THEN texcommand[1]:=''
         ELSE IF command2='#' THEN texcommand[1]:='\cr '
         ELSE IF command2='func'THEN BEGIN
            texcommand[1]:='\hbox';
            hbox:=TRUE;
         END ELSE IF is_accent(command2) AND
                 (math_inspect(2)=' ') THEN BEGIN { accent-command}
            texcommand[1]:=concat('\',command2,'{',math_pop(3),'} ');
         END {accent-command}
         ELSE IF NOT accents(texcommand[1])
         THEN IF length(command2)>1 THEN
           texcommand[1]:=concat('\',command2,' ');
      END; {if not hbox}
      math_fifo;
   END; {Procedure clear_texcommand}

PROCEDURE add_texcommand(by:BYTE);
  {This adds a character to the current 'command'.
   If the character is a non-letter, the current word is
   shipped to the output (clear_texcommand), and the
   non-letter becomes the beginning of a new word}
   
  BEGIN
  IF NOT(((ORD('A')<=by) AND (by<=ORD('Z')))
     OR (ORD('a')<=by) AND (by<=ORD('z'))) THEN BEGIN {non-letter}
     clear_texcommand;
     texcommand[1] := Chr(by);
     clear_texcommand;
     END
  ELSE {letter}
     IF (by<>Ord(' ')) OR (texcommand[1]<>' ') THEN
        texcommand[1]:=Concat(texcommand[1],Chr(by));
        { This prevents multiple blanks }
END; {procedure add_texcommand}

PROCEDURE end_tex_math;
VAR i:INTEGER;
BEGIN
   FOR i:=TEX_MAX_STACK DOWNTO 1 DO clear_texcommand;
END;

