/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.0 or 5.1 files into LaTeX               *
 * modul:       wp2latex.h                                                    *
 * description: Contains global definitions and prototypes                    *
 ******************************************************************************/
#define LineLength   80     /* Split lines after more than LineLength charcters */
#define MAXCHARNUM   0xff   /* Maximum number of special WP characters */
#define MaxParLength 0x7fff /* hope, that no paragraph contains more characters
                             * than this */

#define versionname "2.4"
#define versiondate "09 Apr 1996"  /* exactly 2 digits, 3 letters, 4 digits */

#define _IncludeFormulaParsing /* formula parsing added by Dirk Lellinger */

#define  false          0
#define  true           1
typedef  unsigned char  uchar;
typedef  unsigned char  boolean;

extern FILE *wpd, *tabel, *strip, *latex;
extern unsigned short num_of_lines_stripfile;
extern char *open_com[0x11], *close_com[0x11];

#define IsLegalCharacter(by) ( (by >= 0x20 && by <= 0x7f) ||  \
                                by == 0xa9                ||  \
                                by == 0xaa                ||  \
                                by == 0xc0 || by == 0xc4 )
                               /* 0xa9 = '-'                */
                               /* 0xaa = '-' at end of line */

/* functions of wp2lfuti.c */
FILE *CheckOpen(char *name, char *type);
int  ReadAndSplitLine(FILE *fp, char *regel);
#ifdef __EMX__
#define Rd_word(f,w)  fread(w, sizeof(unsigned short), 1, f);
#define Wr_word(f,w)  fwrite(&w, sizeof(unsigned short), 1, f);
#else
void Rd_word(FILE *f, unsigned short *w);
void Wr_word(FILE *f, unsigned short w);
#endif

/* Variables for Convert_first_pass: */
struct LOC_Convert_first_pass {
  uchar    by;
  unsigned short regelnum;

  char     *lat[0x60];
  short    char_set[MAXCHARNUM];
  short    char_code[MAXCHARNUM];
  char     *ext_lat[MAXCHARNUM];

  short    leegptr[2], openptr[2];
  uchar    attr_rij[2][17];
  boolean  open_attr_rij[2];
  short    depth;

  char     envir, line_term;

  boolean  char_on_line, nomore_valid_tabs, indenting, indent_end, ind_text1,
           ind_text2;

  unsigned short ind_leftmargin, ind_rightmargin;

  short    num_of_tabs, latex_tabpos;
  unsigned short tabpos[40];
  boolean  right_tab, align_tab, center_tab;

  short    WP_sidemargin;
} ;

/* Variables for Convert_second_pass: */
struct LOC_Convert_second_pass {
  boolean just_envir_closed;

  short num_of_tabs;
  unsigned short tabpos[40];

  short tabent_num_of_tabs[3];
  unsigned short tabent_tabpos[3][40];

  unsigned short ind_leftmargin[3], ind_rightmargin[3];
  uchar ind_label[3];

  short pre, cur, next;

  char envir[3], line_term[3];
  boolean new_tabset[3];
  boolean new_rightjust;
  boolean new_tabent_rightjust[3], tabent_rightjust[3];

  short num_of_attr[3];
  uchar attr_BOL[3][0x11];
  boolean attr_closed;
} ;

/* global functions of wp2linit.c */
int  Wpd_check(void);
void Init_commando(void);
void WP_Default(struct LOC_Convert_first_pass *LINK);
void Table_Init(struct LOC_Convert_first_pass *LINK);
void Ext_chr_init(struct LOC_Convert_first_pass *LINK);

/* global functions of wp2lfir.c */
void Convert_first_pass(void);
void Return_Page(struct LOC_Convert_first_pass *LINK);

/* global functions of wp2lsec.c */
void Convert_second_pass(char *wpd_fn);

/* global functions of formpars.c */
#ifdef _IncludeFormulaParsing
void ExtractMathematicalFormula(struct LOC_Convert_first_pass *LINK);
#endif

