/****************************************************************/
/* 						TeX Syntax Highlight					*/
/****************************************************************/
/* 			Andre Hentz (andre@lcmi.ufsc.br) 		Apr 14, 1995
* 
* This file implements syntax highlight for LaTeX files. It is base on
* LaTex  - A Document Preparation System by Leslie Lamport. There's 
* also a internal version of this that is much faster. 
*	Features:	- \Something is a command
*				- $Something$ is a formula
*				- comments: % Something 
*				- punctuation characters
*				- special characters
*				- special character are recognized inside formulas
*	Bugs:		- \( and \) are not recognized as formula delimeters
*				- it gets confused with formulas that don't fit in one line
*				- it gets confused with line pannings (because of $)
*				- iso-latin characters are accepted in commands 
*					( ... to be continued ... )
*/

#include <stdio.h>
#include "buffer.h"
#include "screen.h"


int tex_is_one_of(char *set, char elem);
#define TEXDELIM_COLOR JOP_COLOR
#define TEXOP_COLOR JDELIM_COLOR

static unsigned char Symbol_Colors[128] = 
{
   JNORMAL_COLOR,	/* 0 */
   JNORMAL_COLOR,	/* 1 */
   JNORMAL_COLOR,	/* 2 */
   JNORMAL_COLOR,	/* 3 */
   JNORMAL_COLOR,	/* 4 */
   JNORMAL_COLOR,	/* 5 */
   JNORMAL_COLOR,	/* 6 */
   JNORMAL_COLOR,	/* 7 */
   JNORMAL_COLOR,	/* 8 */
   JNORMAL_COLOR,	/* 9 */
   JNORMAL_COLOR,	/* 10 */
   JNORMAL_COLOR,	/* 11 */
   JNORMAL_COLOR,	/* 12 */
   JNORMAL_COLOR,	/* 13 */
   JNORMAL_COLOR,	/* 14 */
   JNORMAL_COLOR,	/* 15 */
   JNORMAL_COLOR,	/* 16 */
   JNORMAL_COLOR,	/* 17 */
   JNORMAL_COLOR,	/* 18 */
   JNORMAL_COLOR,	/* 19 */
   JNORMAL_COLOR,	/* 20 */
   JNORMAL_COLOR,	/* 21 */
   JNORMAL_COLOR,	/* 22 */
   JNORMAL_COLOR,	/* 23 */
   JNORMAL_COLOR,	/* 24 */
   JNORMAL_COLOR,	/* 25 */
   JNORMAL_COLOR,	/* 26 */
   JNORMAL_COLOR,	/* 27 */
   JNORMAL_COLOR,	/* 28 */
   JNORMAL_COLOR,	/* 29 */
   JNORMAL_COLOR,	/* 30 */
   JNORMAL_COLOR,	/* 31 */
   JNORMAL_COLOR,	/* 32 */
   TEXDELIM_COLOR,	/* ! */
   JNORMAL_COLOR,	/* " */ 
   TEXOP_COLOR,		/* # */
   TEXOP_COLOR,		/* $ */ 
   TEXOP_COLOR,		/* % */
   TEXOP_COLOR,		/* & */
   TEXDELIM_COLOR,	/* ' */ 
   TEXDELIM_COLOR,	/* ( */
   TEXDELIM_COLOR,	/* ) */
   TEXDELIM_COLOR,	/* * */
   JNORMAL_COLOR,	/* + */
   TEXDELIM_COLOR,	/* , */
   TEXDELIM_COLOR,	/* - */
   TEXDELIM_COLOR,	/* . */
   TEXDELIM_COLOR,	/* / */
   JKEY_COLOR,	/* 0 */
   JKEY_COLOR,	/* 1 */
   JKEY_COLOR,	/* 2 */
   JKEY_COLOR,	/* 3 */
   JKEY_COLOR,	/* 4 */
   JKEY_COLOR,	/* 5 */
   JKEY_COLOR,	/* 6 */
   JKEY_COLOR,	/* 7 */
   JKEY_COLOR,	/* 8 */
   JKEY_COLOR,	/* 9 */
   TEXDELIM_COLOR,	/* : */
   TEXDELIM_COLOR,	/* ; */
   TEXOP_COLOR,		/* < */
   JNORMAL_COLOR,	/* = */
   TEXOP_COLOR,		/* > */
   TEXDELIM_COLOR,	/* ? */
   TEXDELIM_COLOR,	/* @ */
   JKEY_COLOR,	/* A */
   JKEY_COLOR,	/* B */
   JKEY_COLOR,	/* C */
   JKEY_COLOR,	/* D */
   JKEY_COLOR,	/* E */
   JKEY_COLOR,	/* F */
   JKEY_COLOR,	/* G */
   JKEY_COLOR,	/* H */
   JKEY_COLOR,	/* I */
   JKEY_COLOR,	/* J */
   JKEY_COLOR,	/* K */
   JKEY_COLOR,	/* L */
   JKEY_COLOR,	/* M */
   JKEY_COLOR,	/* N */
   JKEY_COLOR,	/* O */
   JKEY_COLOR,	/* P */
   JKEY_COLOR,	/* Q */
   JKEY_COLOR,	/* R */
   JKEY_COLOR,	/* S */
   JKEY_COLOR,	/* T */
   JKEY_COLOR,	/* U */
   JKEY_COLOR,	/* V */
   JKEY_COLOR,	/* W */
   JKEY_COLOR,	/* X */
   JKEY_COLOR,	/* Y */
   JKEY_COLOR,	/* Z */
   TEXDELIM_COLOR,	/* [ */
   TEXOP_COLOR,		/* \ */  
   TEXDELIM_COLOR,	/* ] */
   TEXOP_COLOR,		/* ^ */
   TEXOP_COLOR,		/* _ */  
   TEXDELIM_COLOR,	/* ` */
   JKEY_COLOR,	/* a */
   JKEY_COLOR,	/* b */
   JKEY_COLOR,	/* c */
   JKEY_COLOR,	/* d */
   JKEY_COLOR,	/* e */
   JKEY_COLOR,	/* f */
   JKEY_COLOR,	/* g */
   JKEY_COLOR,	/* h */
   JKEY_COLOR,	/* i */
   JKEY_COLOR,	/* j */
   JKEY_COLOR,	/* k */
   JKEY_COLOR,	/* l */
   JKEY_COLOR,	/* m */
   JKEY_COLOR,	/* n */
   JKEY_COLOR,	/* o */
   JKEY_COLOR,	/* p */
   JKEY_COLOR,	/* q */
   JKEY_COLOR,	/* r */
   JKEY_COLOR,	/* s */
   JKEY_COLOR,	/* t */
   JKEY_COLOR,	/* u */
   JKEY_COLOR,	/* v */
   JKEY_COLOR,	/* w */
   JKEY_COLOR,	/* x */
   JKEY_COLOR,	/* y */
   JKEY_COLOR,	/* z */
   TEXOP_COLOR,	/* { */
   TEXOP_COLOR,	/* | */
   TEXOP_COLOR,	/* } */
   TEXOP_COLOR,	/* ~ */
   JNORMAL_COLOR,
};

unsigned short *tex_highlight_command(register unsigned short *p, unsigned short *pmax)
{
	unsigned char ch;

	*p++ |= JKEY_COLOR << 8;
	ch = (unsigned char) *p & 0x7F;
	if (tex_is_one_of("#$%&_{}, @!\"'`+-./:;<=>[]\\^|~()", ch))
		*p++ |= JKEY_COLOR << 8;
	else
		while( p<pmax && !tex_is_one_of("0123456789.:;,?!`'()[]-/*@#$%&~_^\\{} ", ch) )
		{  
			*p++ |= JKEY_COLOR << 8;
		    ch = (unsigned char) *p & 0x7F;
		}
	return p;
}
	
unsigned short *tex_highlight_formula(unsigned short *p, unsigned short *pmax)
{
	unsigned char ch;

	*p++ |= JSTR_COLOR << 8;
	while (p < pmax)
	{
		ch = (unsigned char) *p;

		if (ch == '$') 
		{
	    	*p++ |= JSTR_COLOR << 8;
			break;
		}	
		if ((ch == '\\') && (p < pmax))
		{
	    	p = tex_highlight_command(p, pmax);
		}
		else 
		{
	    	int color = Symbol_Colors[ch];
			if ((color==TEXOP_COLOR)||(color==TEXDELIM_COLOR))
	        	*p++ |= color << 8;
			else 
				*p++ |= JSTR_COLOR << 8;
		}		
	}
	return p;
}

int tex_is_one_of(char *set, char elem)
{
	if (strchr(set, elem))
		return 1;
	return 0;
}


void tex_syntax_highlight (register unsigned short *p, register unsigned short *pmax)
{
	register unsigned char ch;
	register unsigned int color;
   
	while (p < pmax)
    {	
		ch = (unsigned char) *p;
		if (ch>127) 
			color = JKEY_COLOR;
		else 
			color = (unsigned int) Symbol_Colors[ch];

	    if (color == JKEY_COLOR) *p++ |= JNORMAL_COLOR;
		else if (ch == '\\') p = tex_highlight_command(p, pmax);
	    else if (ch == '$') p = tex_highlight_formula(p, pmax);
	    else if ((ch == '%'))
	    { 
			while (p<pmax)
		  		*p++ |= JCOM_COLOR << 8;
		}
	    else if (color == TEXDELIM_COLOR) *p++ |= color << 8; 
	    else if (color == TEXOP_COLOR) *p++ |= color << 8; 
	    else *p++ |= JNORMAL_COLOR; 
	}
}
