#include <forms.h>
#include "load_data.h"
#include "main_window.h"
#include "preset_window.h"


extern FD_main_window *main_window;
extern FD_preset_window *preset_window;

extern char field_name_list[][32];

extern BS_data_list data;


void
set_field()
{
  int irun;
  FL_OBJECT *ob;

  fl_deactivate_form(main_window->main_window);

  /*******************************/

  /* prepare field names */

  fl_clear_choice(preset_window->preset_choice);

  irun=0;
  while(irun++<MAXFIELDS &&
	strlen(&field_name_list[irun][0])!=0)
    fl_addto_choice(preset_window->preset_choice,&field_name_list[irun][0]);

  fl_activate_form(preset_window->preset_window);

  fl_show_form(preset_window->preset_window,FL_PLACE_MOUSE,FL_FULLBORDER,"BibOrg Preset");

}

void
cb_preset_cancel(FL_OBJECT *ob, long button)
{
  fl_hide_form(preset_window->preset_window);
  list_data(fl_get_browser_maxline(main_window->list));
  fl_activate_form(main_window->main_window);
}

void
cb_preset(FL_OBJECT *ob, long button)
{
  BS_data_list present_entry,first_entry;
  
  int choice,irun;
  
  first_entry=data;

  choice=fl_get_choice(preset_window->preset_choice);
  irun=1;
  do
    {
      data->field_text[choice]=(char *)
	realloc(data->field_text[choice],
		strlen(fl_get_input(preset_window->preset_text))+1);
      memmove(data->field_text[choice],
	      fl_get_input(preset_window->preset_text),
	      strlen(fl_get_input(preset_window->preset_text))+1);
      data=data->next_entry;
    }while(irun++ < fl_get_browser_maxline(main_window->list));
    
  data=first_entry;
  fl_hide_form(preset_window->preset_window);
  list_data(fl_get_browser_maxline(main_window->list));
  fl_activate_form(main_window->main_window);
}







