{$N-,V-,W-,G+}

Unit wbibbrws;

Interface

Uses
  Wobjects, WinTypes, WinProcs, strings, ddeml, shellapi, windos, commdlg,
  print, win31, ole,
  bibvars, bibstrg, bibsave, bibutil, bibmain, bibfile, streams, bibsrtpt,
  bib8bit, bibreach, bibreadb, bibfilch, bibflch2, bibPchec, bibstrm, bibtmplt,
  rc_id, rc_strng, wc_help, bibcache, bibgoto, bibinout, bibmisc,
  wbibdisp, wbibshow, wbibupdt, wbibgui, wbibdlg, wbibeden, wbib3d, wbibtbar,
  wbibpatt, wbibstat, wbibinit, bib_help, wbibabv1, wbibabv2, wbibslct, wbibole,
  wbibedhy, wbibsfrm, lfnunit, smapi, wbibmhlp;

Const
  ENameHightAdd = 3;

Type

  PBrowseWindow = ^TBrowseWindow;
  TBrowseWindow = object(TWindow)
    EntryNameShiftTop: integer;
    DisplayShiftBottom: integer;
    DisplayArea: PDisplayArea;
    EntryName:   PEntryName;
    OldSortRec : SortRecType;
    OrigName   : string;
    MenuHelp,PopupHelp: TCollection;
    HFloatingHeader,HFloatingField,HFloatingSName,HFloatingSVal: HMenu;
    HelpBibTeX : HMenu;
    IsHelpBibTeX,FirstTime: boolean;
    ModifyFieldInd,HyperInd,ObjectInd,HelpBibTeXPos: integer;
    HelpBibTeXStr: array[0..32] of char;
    EditFieldStr,CopyNameStr: PString;
    FollowHyperStr,CopyHyperStr,EditHyperStr: PChar;
    EditObjectStr,EditImageStr,ActivateObjectStr: PChar;
    CopyObjectStr,CopyImageStr: PChar;

    Inst       : Longint;
    CallBack   : TCallback;
    ServiceHSz : HSz;
    TopicHSz   : HSz;
    SystemHsz  : HSz;
    BeginProgressHsz{,OpenURLHsz,MakingProgressHsz,EndProgressHsz}: HSz;
    ConvHdl    : HConv;
    DdeItems,DdePokes,DdeMacros,DdeSysItems: Tcollection;

    constructor  Init(AParent: PWindowsObject; Atitle: Pchar);
    procedure    SetupWindow; virtual;
    procedure    CalcSizes(W,H: integer);
    procedure    KeepPositions;
    procedure    UpdateEntry;
    procedure    Update;
    procedure    bibUpdate(var Msg: TMessage); virtual wm_first+bib_Update;

    function     GetClassName: PChar; virtual;
    function     WmGetMinMaxInfo(var Msg: TMessage): bool; virtual
                                           wm_first+wm_GetMinMaxInfo;
    procedure    GetWindowClass(var Class: TWndClass); virtual;
    procedure    WmSize(var Msg: TMessage); virtual wm_first+wm_Size;
    procedure    WMSysColorChange(var Msg : TMessage);
                              virtual wm_first + wm_SysColorChange;  { 3-D controls }
    procedure    WmNCHitTest(var Msg: TMessage);
                              virtual wm_first+wm_NCHitTest;
    procedure    wmEnterIdle(var Msg: TMessage); virtual wm_first+wm_EnterIdle;
    procedure    wmActivate(var Msg: TMessage);  virtual wm_first+wm_activate;
    procedure    wmSetCursor(var Msg: TMessage); virtual wm_first+wm_SetCursor;
    function     CanClose: boolean; virtual;

    { Menu help, included from wbibmhlp.inc }
    procedure    wmInitMenu(var Msg: TMessage);   virtual wm_first+wm_InitMenu;
    procedure    wmMenuSelect(var Msg: TMessage); virtual wm_first+wm_MenuSelect;

    procedure    BibGetInstNum(var Msg: TMessage); virtual wm_first+bib_GetInstNumber;
    { DDE related methods, included from wbibdde.inc }
    procedure    InitDDE;   { Called from Init }
    procedure    SetupDDE;  { Called from SetupWindow, needs a valid main window }
    function     Connect(Service,Topic: PChar;
                   var ServHsz, TopHsz: Hsz;
                   var ConverHdl: HConv): boolean;    { Establish a client connection }
    procedure    Disconnect(var ServHsz, TopHsz: Hsz;
                   var ConverHdl: HConv); {Close a client connection }
    function     MatchTopicAndService(Topic, Service: HSz): Boolean;
    function     MatchTopic (Topic: HSz) : Boolean;
    function     MatchSystem(Topic: HSz) : Boolean;
    function     MatchWWWVerb(Topic: HSz): Boolean;
    function     WildConnect(Topic, Service: HSz; ClipFmt: Word): HDDEData;
    function     FindDDEItem(var T: TCollection; ItemReq: string): integer;
    function     RequestSysData(ItemHsz: Hsz): HDDEData;
    function     RequestData   (ItemHsz: Hsz): HDDEData;
    procedure    CompressEntry;
    function     ExecMacro       (Data: HDDEData): HDDEData;
    function     PokeData        (ItemHsz: Hsz; Data: HDDEData): HDDEData;
    function     WWWVerb(Topic,ItemHsz: Hsz): HDDEData;
    procedure    CloseDDE;

    procedure ProcessToolbar(var Msg: TMessage);
                 virtual wm_first+bib_TbButtonPressed;
    procedure ProcessStatusBar(var Msg: TMessage);
                 virtual wm_first+bib_StatusBoxClick;
    procedure wmDropFiles(var Msg: Tmessage); virtual wm_first+wm_DropFiles;

    procedure EditAHeader(var Msg: TMessage);  virtual cm_First+mi_MainFEdit;
    procedure EditSName(var Msg: TMessage);    virtual cm_first+mi_BrSNEdit;
    procedure CopyHeader(var Msg: TMessage);   virtual cm_First+mi_MainFCopy;
    procedure CopySName(var Msg: TMessage);    virtual cm_first+mi_BrSNCopy;
    procedure CopyHeaderEx(var Msg: TMessage); virtual cm_First+mi_MainFECopy;
    procedure CopySNameEx(var Msg: TMessage);  virtual cm_first+mi_BrSNCopyEx;
    procedure MenuStringCopy(var Msg: TMessage);
                             virtual cm_first+mi_MainFString;
    procedure PopupTaggedEnt(var Msg: TMessage);virtual cm_first+mi_BrFTag;
    procedure PopupTaggedStr(var Msg: TMessage);virtual cm_first+mi_BrSNTag;

    procedure EditSomething(fld,H,O: integer);
    procedure EditAField(var Msg: TMessage);   virtual cm_First+mi_BrFFEdit;
    procedure EditAHyper(var Msg: TMessage);   virtual cm_First+mi_BrFFEditHyper;
    procedure EditAnObject(var Msg: TMessage); virtual cm_First+mi_BrFFEditObject;
    procedure ActivateObject(var Msg: TMessage);virtual cm_first+mi_BrFFActObj;
    procedure CopyObject(var Msg: TMessage);   virtual cm_first+mi_BrFFCopyObject;
    procedure EditSValue(var Msg: TMessage);   virtual cm_first+mi_BrSValEdit;
    procedure CopyField(var Msg: TMessage);    virtual cm_First+mi_BrFFCopy;
    procedure CopyHyper(var Msg: TMessage);    virtual cm_first+mi_BrFFCopyHyper;

    function  UploadRemoteFile(URL: string; var fname: string; Wait: boolean): boolean;

    procedure FollowHyper(var Msg: TMessage);  virtual cm_first+mi_BrFFFollowHyper;
    procedure CopySValue(var Msg: TMessage);   virtual cm_first+mi_BrSValCopy;
    procedure CopyFieldEx(var Msg: TMessage);  virtual cm_First+mi_BrFFCopyExt;
    procedure CopySValueEx(var Msg: TMessage); virtual cm_first+mi_BrSValCopyEx;
    procedure TagField(var Msg: TMessage);     virtual cm_first+mi_BrFFTag;
    procedure TagSVal(var Msg: TMessage);      virtual cm_first+mi_BrSValTag;

    procedure ClickedOnField(var Msg: TMessage);
                             virtual wm_First+bib_ClickedOnField;

    procedure wmCommand(var Msg: TMessage);   virtual wm_first+wm_Command;

    procedure SendToFileRoutine(select1,select2: integer);
    procedure FileOpen(var Msg: TMessage);    virtual cm_first+mi_BrFileOpen;
    procedure FileClose(var Msg: TMessage);   virtual cm_first+mi_BrFileClose;
{--------------------------------------------------------------------------}
    procedure Count(var Msg: TMessage);       virtual cm_first+mi_BrFileCount;
    procedure DupEntries(All: boolean);
    procedure DupNamesCur(var Msg: TMessage); virtual cm_first+mi_BrFileDupsCurrent;
    procedure DupNamesAll(var Msg: TMessage); virtual cm_first+mi_BrFileDupsAll;
    procedure Sort(var Msg: TMessage);        virtual cm_first+mi_BrFileSort;
    procedure Reformat(var Msg: TMessage);    virtual cm_first+mi_BrFileReformat;
    procedure Index(var Msg: TMessage);       virtual cm_first+mi_BrFileIndex;
    procedure FTranslate(var Msg: TMessage);  virtual cm_First+mi_BrFileTranslate;
    procedure PrintFile(var Msg: TMessage);   virtual cm_first+mi_BrFilePrint;
    procedure PrintSetup(var Msg: TMessage);  virtual cm_first+mi_BrFilePrintSetup;
    procedure PageSetup(var Msg: TMessage);   virtual cm_first+mi_BrFilePageSetup;
{--------------------------------------------------------------------------}

    procedure EditEntry(var Msg: TMessage);    virtual cm_First+mi_BrEditEdit;
    procedure EditStrings(var Msg: TMessage);  virtual cm_first+mi_BrEditStrings;
    {---}
    procedure CopyEName(var Msg: TMessage);    virtual cm_first+mi_BrEditHeaderCopy;
    procedure CopyENameEx(var Msg: TMessage);  virtual cm_First+mi_BrEditHeaderCopyEx;
    procedure CopyEnameStr(var Msg: TMessage); virtual cm_First+mi_BrEditHeaderString;
    {---}
    procedure CopyEField(var Msg: TMessage);   virtual cm_First+mi_BrEditCopyField;
    procedure CopyEntry(var Msg: TMessage);    virtual cm_first+mi_BrEditCopy;
    procedure CutEntry(var Msg: TMessage);     virtual cm_first+mi_BrEditCut;
    {---}
    procedure PasteEntry(var Msg: TMessage);   virtual cm_first+mi_BrEditPaste;
    procedure PasteClip(var Msg: TMessage);    virtual cm_first+mi_BrEditPasteClip;
    {---}
    procedure ReplaceEntry(var Msg: TMessage); virtual cm_first+mi_BrEditReplace;
    procedure ReplaceClip(var Msg: TMessage);  virtual cm_first+mi_BrEditRepClip;
    {---}
    procedure PutBookmark(var Msg: TMessage);  virtual cm_first+mi_BrEditBookmark;
    procedure ToggleTag(var Msg: TMessage);    virtual cm_first+mi_brEditTag;
    procedure TagAll(var Msg: TMessage);       virtual cm_first+mi_BrEditTagAll;
    procedure TagTeX(var Msg: TMessage);       virtual cm_first+mi_BrEditTagTeX;
    procedure UntagAll(var Msg: TMessage);     virtual cm_first+mi_BrEditUntagAll;
    {---}
    procedure ClearEntry(var Msg: TMessage);   virtual cm_first+mi_BrEditClear;
    procedure DelAll(var Msg: TMessage);       virtual cm_first+mi_BrEditDelAll;
    procedure DelTagged(var Msg: TMessage);    virtual cm_first+mi_BrEditDelTagged;

    { Goto menu }
    procedure GotoThere(id: integer);
    procedure Next(var Msg: TMessage);           virtual cm_first+mi_BrGotoNext;
    procedure Back(var Msg: TMessage);           virtual cm_first+mi_BrGotoBack;
    procedure Last(var Msg: TMessage);           virtual cm_first+mi_BrGotoLast;
    procedure First(var Msg: TMessage);          virtual cm_first+mi_BrGotoFirst;
    procedure GotoList(var Msg: TMessage);       virtual cm_first+mi_BrGotoEntryList;
    procedure GotoOverview(var Msg: TMessage);   virtual cm_first+mi_BrGotoOverview;
    procedure GotoNum(var Msg: TMessage);        virtual cm_first+mi_BrGotoNumber;
    procedure GotoLabel(var Msg: TMessage);      virtual cm_first+mi_BrGotoLabel;
    procedure GotoLabelNext(var Msg: TMessage);  virtual cm_first+mi_BrGotoLabelNext;
    procedure GotoSearch(var Msg: TMessage);     virtual cm_first+mi_BrGotoSearch;
    procedure GotoSearchNext(var Msg: TMessage); virtual cm_first+mi_BrGotoSearchNext;
    procedure GotoTag(var Msg: TMessage);        virtual cm_First+mi_BrGotoTag;
    procedure GotoBookmark(var Msg: Tmessage);   virtual cm_first+mi_BrGotoBookmark;

    { Add menu }

    procedure Adding(where: integer);
    procedure AddSorted(var Msg: TMessage);      virtual cm_first+mi_BrAddSorted;
    procedure AddEOF(var Msg: TMessage);         virtual cm_first+mi_BrAddEOF;
    procedure AddCurrent(var Msg: TMessage);     virtual cm_first+mi_BrAddCurrent;
    procedure AddAfterCurrent(var Msg: TMessage);virtual cm_first+mi_BrAddAfterCurrent;
    procedure AddNumber(var Msg: TMessage);      virtual cm_first+mi_BrAddNumber;
    procedure AddBeforeEntry(var Msg: TMessage); virtual cm_first+mi_BrAddBeforeEntry;
    procedure AddFirst(var Msg: TMessage);       virtual cm_first+mi_BrAddFirst;

    { Import menu}

    procedure Import(var Msg: TMessage); virtual cm_first+mi_BrImport;

    { Export menu }

    procedure Exp(var Msg: TMessage);    virtual cm_first+mi_BrExp;

    { Pattern menu }

    procedure EditPattern(var Msg: TMessage);   virtual cm_first+mi_BrPatternEdit;
    procedure PattTagged(var Msg: TMessage);    virtual cm_first+mi_BrPatternTagged;
    procedure PattAllFields(var Msg: TMessage); virtual cm_first+mi_BrPattAllFields;
    procedure TogglePattern(var Msg: TMessage); virtual cm_first+mi_BrPatternOn;
    procedure PattAssociate(var Msg: TMessage); virtual cm_first+mi_BrPattHeirAssoc;
    procedure PattHeirList(var Msg: TMessage);  virtual cm_first+mi_BrPattPattListList;
    procedure PattFromMenu(id: word);

    { Options menu }

    procedure ViewMode(var Msg: TMessage);
                               virtual cm_first+mi_BrMiscView;
    procedure StringsMode(var Msg: TMessage);
                               virtual cm_first+mi_BrMiscStrings;
    procedure ToggleLink(var Msg: TMessage);     virtual cm_first+mi_BrMiscLinked;
    procedure ToggleReadOnly(var Msg: TMessage); virtual cm_first+mi_BrMiscReadOnly;
    procedure ToggleTagNew(var Msg: TMessage);   virtual cm_first+mi_BrMiscTagNew;
    procedure PrefOpts(var Msg: TMessage);       virtual cm_first+mi_BrMiscPreferences;
    procedure GUIOpts(var Msg: TMessage);        virtual cm_first+mi_BrOptGUI;
    procedure FieldsList(var Msg: TMessage);     virtual cm_first+mi_BrOptFields;
    procedure ShowFormat(var Msg: TMessage);     virtual cm_first+mi_BrOptShowFormat;
    procedure HyperOpts(var Msg: TMessage);      virtual cm_first+mi_BrOptHyper;
    procedure ObjectOpts(var Msg: TMessage);     virtual cm_first+mi_BrOptObjImg;
    procedure EdAbbrevs;
    {---}
    procedure SortOpts(which: integer);
    procedure DefSortOpt(var Msg: TMessage);
                               virtual cm_first+mi_BrMiscSortDefault;
    procedure CurSortOpt(var Msg: TMessage);
                               virtual cm_first+mi_BrMiscSortCurrent;
    procedure ExpSortOpt(var Msg: TMessage);
                               virtual cm_first+mi_BrMiscSortExport;
    {---}
    procedure FileFormOpts(var Msg: TMessage); virtual cm_first+mi_BrMiscFormat;
    procedure ModifyFonts(var Msg: TMessage);  virtual cm_first+mi_BrOptModifyFonts;
    {
    procedure FontEncodings(var Msg: TMessage); virtual cm_First+mi_BrMiscFontEnc;
    }
    {----}
    procedure SaveTheCache(var Msg: TMessage);  virtual cm_first+mi_BrMiscSaveCache;
    procedure ClearTheCache(var Msg: TMessage); virtual cm_first+mi_BrMiscClearCache;
    procedure SaveAnOption(which: integer);
    procedure SavePrefs(var Msg: TMessage);   virtual cm_first+mi_BrMiscSavePrefs;
    procedure SaveRegs(var Msg: TMessage);    virtual cm_first+mi_BrMiscSaveRegisters;
    procedure SaveSort(var Msg: TMessage);    virtual cm_first+mi_BrMiscSaveSort;
    procedure SaveFForm(var Msg: TMessage);   virtual cm_first+mi_BrMiscSaveFormats;
    procedure SavePos(var Msg: TMessage);     virtual cm_first+mi_BrMiscSavePos;
    procedure SaveAll(var Msg: TMessage);     virtual cm_first+mi_BrMiscSaveAll;
    procedure SaveOnExit(var Msg: TMessage);  virtual cm_first+mi_BrMiscSaveOnExit;
    procedure SaveWOnExit(var Msg: TMessage); virtual cm_first+mi_BrMiscSaveWOnExit;

    { Help menu }

    procedure HelpContents(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpContents;
    procedure HelpSearch(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpSearch;
    procedure HelpHow(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpHow;
    procedure HelpMouse(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpMouse;
    procedure HelpMenus(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpMenus;
    procedure HelpConfig(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpConfig;
    { BibTeX submenu }
      procedure HelpBibContents(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpBibContents;
      procedure HelpBibSearch(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpBibSearch;
      procedure HelpBibWhat(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpBibWhat;
      procedure HelpBibFormat(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpBibFormat;
      procedure HelpBibType(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpBibTypes;
      procedure HelpBibFields(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpBibFields;
      procedure HelpBibNames(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpBibNames;
      procedure HelpBibStyles(var Msg: TMessage);
                           virtual cm_first+mi_BrHelpBibStyles;
    {------}
    procedure About(var Msg: TMessage); virtual cm_first+mi_BrHelpAbout;

    {------}
    procedure AccScrollDn(var Msg: TMessage); virtual cm_first+acc_ScrollDn;
    procedure AccScrollUp(var Msg: TMessage); virtual cm_first+acc_ScrollUp;
    procedure AccPgDn(var Msg: TMessage);     virtual cm_first+acc_PgDn;
    procedure AccPgUp(var Msg: TMessage);     virtual cm_first+acc_PgUp;
    procedure AccHome(var Msg: TMessage);     virtual cm_first+acc_Home;
    procedure AccEnd(var Msg: TMessage);      virtual cm_first+acc_End;

    procedure  KillW(var Msg: TMessage);      virtual cm_first+mi_QuitProg;
    procedure  wmDestroy(var Msg: TMessage);  virtual wm_First+wm_Destroy;
    destructor done; virtual;
  end;


Implementation


{$I wbibdde.inc}         { DDE support routines       }
{$I wbibprnt.inc}        { Printing routines          }


{ TBrowseWindow methods }

constructor TBrowseWindow.Init(AParent: PWindowsObject; Atitle: Pchar);
var
  i: integer;
  F: array[0..63] of char;
begin
  TWindow.Init(AParent,Atitle);
  with Attr do
  begin
    Style:=Style or ws_ClipChildren or ws_ClipSiblings;
    Menu:=LoadMenu(Hinstance,PChar(rc_MainMenu));
    if MainWinSize.H>0 then
    begin
      X:=MainWinSize.X; Y:=MainWinSize.Y;
      W:=MainWinSize.W; H:=MainWinSize.H;
      if X+W>ScreenRect.right  then X:=ScreenRect.right-W;
      if X<0                   then X:=0;
      if X+W>ScreenRect.right  then W:=ScreenRect.right-X;
      if Y+H>ScreenRect.bottom then Y:=ScreenRect.bottom-H;
      if Y<0                   then Y:=0;
      if Y+H>ScreenRect.bottom then H:=ScreenRect.bottom-Y;
    end;
  end;

{  RegisterBibDBClasses;}

  New(StatusBar,init(@Self));
  New(EntryName,init(@Self,true,true,false,true,StatusBar));
  New(Toolbar,Init(@Self,PChar(rc_ToolbarDlg)));
  New(DisplayArea,init(@Self,Nil,StatusBar,false));

  InitDDE;
  HelpBibTeX:=0; HelpBibTeXPos:=-1; IsHelpBibTeX:=false;
  StrPCopy(HelpBibTeXStr,'');
  FirstTime:=true;
  EditFieldStr:=Nil;  CopyNameStr:=Nil;
  HFloatingHeader:=0; HFloatingField:=0;
  HFloatingSName:=0;  HFloatingSVal:=0;

  StrAbbrevsList.init(50,50,true,false);
  IniAbbrevsList.init(50,50,true,false);
  BibAbbrevsList.init(50,50,true,false);
  BSTAbbrevsList.init(50,50,true,false);

  RetrievingURLDlg:=Nil;
  EdShowFormat:=Nil;
end;                              { TBrowseWindow.Init }

procedure TBrowseWindow.SetupWindow;
var
  Rect: TRect;
  i,j: integer;
  H,H1: HMenu;
  S: string;
  mchars: string[32];
  F: array[0..64] of char;
begin
  TWindow.SetupWindow;
{  if UseCtl3d then Load3dDll; }

  InitMainMenuHelp(@Self,MenuHelp,PopupHelp);

  { Extract system menu names }
  H:=GetSystemMenu(HWindow,false);
  GetMenuString(H,sc_size,F,64,mf_ByCommand);
  MenuSizeString:=StrNew(F);

  with Attr do                    { Extract the popup menus }
  begin
    HFloatingHeader:=GetSubmenu(Menu,0);
    RemoveMenu(Menu,0,mf_ByPosition);
    GetMenuString(HFloatingHeader,mi_MainFString,F,64,mf_ByCommand);
    CopyNameStr:=NewStr(StrPas(F));

    HFloatingField:=GetSubmenu(Menu,0);
    RemoveMenu(Menu,0,mf_ByPosition);
    GetMenuString(HFloatingField,0,F,64,mf_ByPosition);
    EditFieldStr:=NewStr(StrPas(F));
    GetMenuString(HFloatingField,mi_BrFFFollowHyper,F,64,mf_ByCommand);
    FollowHyperStr:=StrNew(F);
    GetMenuString(HFloatingField,mi_BrFFCopyHyper,F,64,mf_ByCommand);
    CopyHyperStr:=StrNew(F);
    GetMenuString(HFloatingField,mi_BrFFEditHyper,F,64,mf_ByCommand);
    EditHyperStr:=StrNew(F);
    GetMenuString(HFloatingField,mi_BrFFEditObject,F,64,mf_ByCommand);
    EditObjectStr:=StrNew(F);
    S:=StrPas(F);
    StrRepl(S,'Object','Image',1,255,255); StrPCopy(F,S);
    EditImageStr:=StrNew(F);
    GetMenuString(HFloatingField,mi_BrFFActObj,F,64,mf_ByCommand);
    ActivateObjectStr:=StrNew(F);
    GetMenuString(HFloatingField,mi_BrFFCopyObject,F,64,mf_ByCommand);
    CopyObjectStr:=StrNew(F);
    S:=StrPas(F);
    StrRepl(S,'o&bject','i&mage',1,255,255); StrPCopy(F,S);
    CopyImageStr:=StrNew(F);

    HFloatingSName:=GetSubmenu(Menu,0);
    RemoveMenu(Menu,0,mf_ByPosition);

    HFloatingSVal:=GetSubmenu(Menu,0);
    RemoveMenu(Menu,0,mf_ByPosition);
  end;

  H:=SearchForMenuItem(Attr.Menu,'help'); HelpBibTeX:=0;
  HelpBibTeXPos:=-1;
  for i:=0 to GetMenuItemCount(H)-1 do
  begin
    GetMenuString(H,i,F,32,mf_ByPosition);
    S:=StrPas(F); StrLwr(S); ChrDel(S,'&');
    if S='bibtex' then HelpBibTeXPos:=i;
  end;
  if HelpBibTeXPos>-1 then
  begin
    IsHelpBibTeX:=true;
    GetMenuString(H,HelpBibTeXPos,HelpBibTeXStr,32,mf_ByPosition);
    HelpBibTeX:=GetSubmenu(H,HelpBibTeXPos);
    if BibTeXHelpMode=0 then
    begin
      IsHelpBibTeX:=false;
      RemoveMenu(H,HelpBibTeXPos,mf_ByPosition);
    end;
  end;

    { Adjust menu }
  UsingSortedMenu:=false;

  AddPopup:=0;
  AddSortItem.id:=mi_BrAddSorted;
  AddSortItem.Name:=StrNew('&Add');
  RemoveMenu(Attr.Menu,mi_BrAddSorted,  mf_ByCommand);

  H:=SearchForMenuItem(Attr.Menu,'Pattern');
  if PMenuNum>0 then
  begin
    mchars:='';
    for i:=1 to PMenuNum do
    begin
      S:=PMenuStr[i]^;
      {
      j:=Pos(PMenuChars[i],S);
      if (j>0) and (Pos(UpCase(S[j]),mchars)=0) then
      begin
        Insert('&',S,j);
        mchars:=mchars+UpCase(S[j]);
      end;
      }
      StrPCopy(F,S);
      InsertMenu(H,i+2,mf_ByPosition+mf_String,cm_FirstUserPattField+i-1,F);
    end;
  end;

  { Pattern heirarchy stuff }
  if (bibname^=' ') or (GetPattHeirarchy(PattHeirarchy,0,bibname,true)<0) then
      GetPattHeirarchy(PattHeirarchy,0,Nil,false);
  InsertPattHeirarchyMenu(H,PattHeirarchy);

  DragAcceptFiles(HWindow,true);

  SysFontHeight:=LoWord(GetDialogBaseUnits);
  SysFontWidth:=HiWord(GetDialogBaseUnits);

  if Application^.MakeWindow(Toolbar)=Nil then
    FatalErrorRC(Str_ToolbarError,'');
  with Toolbar^ do
  begin
    MoveWindow(HWindow,0,0,Width,Height,bool(1));
    Show(sw_Hide);
  end;

  if Application^.MakeWindow(Statusbar)=Nil then
    FatalErrorRC(Str_StatusbarError,'');
  CurrentHelpBar:=StatusBar;

  GetClientRect(HWindow,Rect);
  EntryNameShiftTop:=Toolbar^.Height+1;
  EntryNameHeight:=(6*SysFontHeight) div 2;
  with EntryName^.Attr do
  begin
    X:=0; W:=Rect.right-X;
    Y:=EntryNameShiftTop; H:=EntryNameHeight;
  end;
  if Application^.MakeWindow(EntryName)=Nil then
    FatalErrorRC(Str_CantCreateChild,'');
  EntryName^.Show(sw_Hide);

  if (Application^.MakeWindow(DisplayArea)=Nil)
        then FatalErrorRC(Str_CantCreateChild,'');
  DisplayArea^.Show(sw_hide);

  CurrentWindow:=@Self; MessageParent:=HWindow;

  SetupDDE;
  Toolbar^.IsEnabled := true;
end;                             { TBrowseWindow.SetupWindow }

function TBrowseWindow.WmGetMinMaxInfo(var Msg: TMessage): bool;
             { Determines the minimum size of the window }
begin
  with PMinMaxInfo(Msg.lparam)^ do
  begin
    ptMinTrackSize.X:= 300; ptMinTrackSize.Y:=250;
  end;
  WmGetMinMaxInfo:=bool(0);
end;

procedure TBrowseWindow.KeepPositions;
var
  Placement: TWindowPlacement;
begin
  FillChar(Placement,sizeof(TWindowPlacement),0);
  Placement.length:=sizeof(TWindowPlacement);
  if GetWindowPlacement(HWindow,@Placement)<>bool(0) then
  with MainWinSize, Placement.rcNormalPosition do
    if (X<>left) or (Y<>top) or (W<>(right-left)) or (H<>(bottom-top)) then
    begin
      X:=left; Y:=top; W:=right-left; H:=bottom-top;
      OptionsModified.WindowsParams:=true;
    end;
end;                               { TBrowseWindow.KeepPositions }

procedure TBrowseWindow.CalcSizes(W,H: integer);
var
  Rect: TRect;
  ENameShift: integer;
  DC: HDC;
  Metrics: TTextMetric;
  OldFont: HFont;
begin
  if (W=0) and (H=0) then
  begin
    GetClientRect(HWindow,Rect);
    W:=Rect.right-Rect.left; H:=rect.Bottom-Rect.Top;
  end;
  if UseToolbar then
  begin
    GetWindowRect(Toolbar^.HWindow,Rect);
    SetWindowPos(Toolbar^.HWindow,0,0,0,W,Rect.bottom-Rect.top,
                 swp_NoMove or swp_NoZOrder);
    Toolbar^.show(sw_Show); EnameShift:=EntryNameShiftTop;
  end else
  begin
    Toolbar^.show(sw_Hide); ENameShift:=0;
  end;
  if not Fonts^[LabelFont].Initialized then
  begin
    DC:=GetDC(GetDesktopWindow);
    with Fonts^[LabelFont] do
    begin
      Font:=CreateFontIndirect(Logfont);
      OldFont:=SelectObject(DC,Font);
      GetTextMetrics(DC,Metrics);
      SelectObject(DC,OldFont);
      Height:=Metrics.tmHeight+Metrics.tmExternalLeading;
      Ascent:=Metrics.tmAscent;
      Descent:=Metrics.tmDescent;
      Initialized:=true;
    end;
    ReleaseDC(GetDesktopWindow,DC);
  end;
  EntryNameHeight:=Fonts^[LabelFont].Height+ENameHightAdd;
  with EntryName^ do
  begin
    MoveWindow(Hwindow,0,ENameShift,
               W,
               EntryNameHeight,bool(1));
    if FirstTime then Show(sw_Show);
    FirstTime:=false;
  end;
  with DisplayArea^ do
  begin
    MoveWindow(Hwindow,-1,
                       ENameShift+EntryNameHeight,
                       W+2,
                       H-(ENameShift+EntryNameHeight+StatusBar^.height),
                       bool(1));
    if FirstTime then Show(sw_show); 
    FirstTime:=false;
  end;
  StatusBar^.MoveBarTo(W,H);
  if FirstTime then
  begin
    FirstTime:=false;
    if StartupMinimized then
    begin
      ShowWindow(HWindow,sw_ShowMinimized);
    end else if StartupMaximized then ShowWindow(HWindow,sw_ShowMaximized);
  end;
end;                          { TBrowseWindow.CalcSizes }

procedure TBrowseWindow.WmSize(var Msg: TMessage);
begin
  CalcSizes(Msg.lparamlo,Msg.lparamhi);
  SetBrowseWindowCaption(HWindow);
  TWindow.WmSize(Msg);
end;

function TBrowseWindow.GetClassName: PChar;
begin
  GetClassName:=BibDBMainWinClass;
end;

procedure TBrowseWindow.GetWindowClass(var Class: TWndClass);
begin
  TWindow.GetWindowClass(Class);
  Class.hicon:=MainIcon;
{  Class.hBrBackground:=HBrush(Color_BtnFace+1);}
{  Class.hcursor:=CrossCursor;}
end;

procedure TBrowseWindow.WMSysColorChange(var Msg : TMessage);
begin
  if Ctl3Dv2Active then Ctl3dColorChange;
end;

procedure TBrowseWindow.wmNCHitTest(var Msg: TMessage);
begin
  if (not AmWaiting) and (CurrentHelpBar<>Nil) then CurrentHelpBar^.ClearHelpText;
  DefWndProc(Msg);
end;

procedure TBrowseWindow.wmSetCursor(var Msg: TMessage);
begin
  if AmWaiting then
  begin
    SetCursor(WaitingCursor); Msg.Result:=1;
  end else DefWndProc(Msg);
end;

procedure TBrowseWindow.wmInitMenu(var Msg: TMessage);
begin
  MainMenuActive:=true;
  if IsClipboardFormatAvailable(cf_text) then
  begin
    EnableMenuItem(HMenu(Msg.wParam),mi_BrEditPasteClip,mf_ByCommand or mf_Enabled);
    EnableMenuItem(HMenu(Msg.wParam),mi_BrEditRepClip,  mf_ByCommand or mf_Enabled);
  end else
  begin
    EnableMenuItem(HMenu(Msg.wParam),mi_BrEditPasteClip,mf_ByCommand or mf_Grayed);
    EnableMenuItem(HMenu(Msg.wParam),mi_BrEditRepClip,  mf_ByCommand or mf_Grayed);
  end;
end;                  { TBrowseWindow.wmInitMenu }

procedure TBrowseWindow.wmMenuSelect(var Msg: TMessage);
var
  MM: PMenuHelpObj;
  id: word;

function Matches(P: Pointer): boolean; far;
begin
  Matches:=PMenuHelpObj(P)^.m=id;
end;

begin
  id:=Msg.wParam;
  if (Msg.lParamLo=word(-1)) and (Msg.lParamHi=0) then
  begin
    if not AmWaiting then CurrentHelpBar^.ClearHelpText;
{    InvalidateRect(CurrentHelpBar^.HWindow,Nil,true);
    UpdateWindow(CurrentHelpBar^.HWindow);}
    MainMenuActive:=false;
  end else if Msg.lParamLo and mf_Separator=0 then
  begin
    if (id>cm_FirstPattHeirarchy) and (id<cm_FirstPattHeirarchy+PattHeirCount)
      then id:=cm_FirstPattHeirarchy;
    if Msg.lParamLo and mf_Popup<>0 then MM:=PopupHelp.FirstThat(@Matches)
    else MM:=MenuHelp.FirstThat(@Matches);
    if MM=Nil then CurrentHelpBar^.HideHelpText(false,true)
    else begin
      CurrentHelpBar^.PutHelpText(MM^.s);
    end;
  end else if not AmWaiting then CurrentHelpBar^.ClearHelpText;
end;                        { TBrowseWindow.wmMenuSelect }

function TBrowseWindow.CanClose: boolean;
var
  o_k: boolean;
begin
  o_k:=(not AmWaiting) and
    ((CurrentWindow=@Self) or
     ((EdShowFormat<>Nil) and (CurrentWindow=EdShowFormat)));
  if o_k then CanClose:=TWindow.CanClose
  else begin
    Show(sw_Show); MessageRC(Str_ImBusy,''); CanClose:=false;
  end;
end;                  { TBrowseWindow.CanClose }

procedure TBrowseWindow.UpdateEntry;
var
  H: HMenu;
  tmp: string[64];
  F: array[0..64] of char;
begin
  EntryName^.Update; UpdateWindow(EntryName^.HWindow);
  DisplayArea^.Update;
  H:=SearchForMenuItem(SearchForMenuItem(Attr.Menu,'edit'),'copy name');
  if (entry^.nentry>0) then
  begin
    tmp:=CopyNameStr^;
    if not EditOnlyStrings then
    begin
      StrRepl(tmp,'%s',NameClickMenuString^,1,1,64);
      StrRepl(tmp,'#1',Entry^.name,1,255,255);
      if length(tmp)>60 then tmp:=Copy(tmp,1,56)+'..."';
    end;
    StrPCopy(F,tmp);
    ModifyMenu(H,mi_BrEditHeaderString,mf_ByCommand or mf_String,
               mi_BrEditHeaderString,F);
  end;
  SetBrowseWindowCaption(HWindow);
  GrayMainMenu(@Self);
  Toolbar^.Update;
end;                          { TBrowseWindow.UpdateEntry }

procedure TBrowseWindow.Update;
begin
  SelectBrowseMenu(@Self);
  UpdateFileList(@Self);
  CheckMainMenu(@Self);
  UpdateEntry;
  StatusBar^.Update;
  DrawMenuBar(HWindow);        
end;                           { TBrowseWindow.Update }

procedure TBrowseWindow.bibUpdate(var Msg: TMessage);
begin Update; end;

procedure TBrowseWindow.wmEnterIdle(var Msg: TMessage);
begin
  if (Msg.wparam=msgf_DialogBox) then
  begin
    if GetKeyState(vk_F1)<0 then
      SendMessage(Msg.lparamLo,bib_DlgHelp,0,0)
    else SendMessage(Msg.lParamLo,bib_EnterIdle,0,0);
  end else StatusBar^.CheckHelpPos(true);
end;                            { TBrowseWindow.wmEnterIdle }

procedure TBrowseWindow.wmActivate(var Msg: TMessage);
begin
  MainWinActive:=(Msg.wParam<>wa_InActive);
  TWindow.wmActivate(Msg);
  if MainWinActive then
  begin
    CurrentWindow:=@Self;
    MessageParent:=HWindow;
  end;
end;                   { TBrowseWindow.wmActivate }

procedure TBrowseWindow.wmDropFiles(var Msg: TMessage);
var
  nfiles: word;
  F: array[0..255] of char;
  selection: SelectionType;
begin
  if DialogDepth=0 then
  begin
    NFiles:=DragQueryFile(Msg.wParam,word(-1),Nil,0);
    if NFiles>1 then ErrorMessageRC(Str_DropOnlyOne,'')
    else begin
      DragQueryFile(Msg.wParam,0,F,256);
      InputStr^:=StrPas(F);
      if (GetKeyState(vk_Shift)<0) or (GetKeyState(vk_Control)<0) then
      begin
        Selection[1]:=CFile_Change; Selection[2]:=CurrentBibFile;
      end else Selection[1]:=CFile_Open;
      MacroCommand:=true;
      DealWithFiles(Entry,Pattern,Selection); Update;
      MacroCommand:=false;
      if IsWindow(HWindow) then
      begin
        if IsIconic(HWindow) then ShowWindow(HWindow,sw_restore);
        SetFocus(HWindow);
      end;
    end;
  end;
  DragFinish(THandle(Msg.wParam));
end;                              { TBrowseWindow.wmDropFiles }

procedure TBrowseWindow.BibGetInstNum(var Msg: TMessage);
begin
  Msg.Result:=InstNumber;
end;

    { Work methods }

{ Responses to internally generated messages }

procedure TBrowseWindow.ProcessToolbar(var Msg: TMessage);
begin
  Case Msg.wParam of
    dl_TBarOpenBtn:       FileOpen(Msg);
    dl_TbarRightBtn:
      if Msg.lParam=0 then Next(Msg) else Last(Msg);
    dl_TbarLeftBtn:
      if Msg.lParam=0 then Back(Msg) else First(Msg);
    dl_TbarLastBtn:       Last(Msg);
    dl_TbarFirstBtn:      First(Msg);
    dl_TbarEntryListBtn:  GotoList(Msg);
    dl_TbarOverviewBtn:   GotoOverview(Msg);
    dl_TbarNumberBtn:     GotoNum(Msg);
    dl_TbarNameBtn:
      if Msg.lParam=0 then GotoLabel(Msg) else GotoLabelNext(Msg);
    dl_TbarSearchBtn:
      if Msg.lParam=0 then GotoSearch(Msg) else GotoSearchNext(Msg);
    dl_TbarSearchNextBtn: GotoSearchNext(Msg);
    dl_TbarTagBtn:
      if Msg.lParam=0 then ToggleTag(Msg) else GotoTag(Msg);
    dl_TbarStringsBtn:
      if Msg.lParam=0 then EditStrings(Msg) else EdAbbrevs;
    dl_TbarEditBtn:       EditEntry(Msg);
    dl_TBarDelBtn:
      if Msg.lParam=0 then ClearEntry(Msg) else CutEntry(Msg);
    dl_TBarPattBtn:
      if Msg.lParam=0 then EditPattern(Msg) else TogglePattern(Msg); 
    dl_TBarPrintBtn:
      if Msg.lParam=0 then PrintFile(Msg) else PrintSetup(Msg);
  end;
end;                            { TBrowseWindow.ProcessToolbar }

procedure TBrowseWindow.ProcessStatusBar(var Msg: TMessage);
begin
  case Msg.wParam of
    stat_EntriesClick: StringsMode(Msg);
    stat_LinkClick:    ToggleLink(Msg);
    stat_SortClick:    CurSortOpt(Msg);
    stat_PattClick:    TogglePattern(Msg);
    stat_ReadOnly:     ToggleReadOnly(Msg);
  end;
end;                             { TBrowseWindow.ProcessStatusBar }

procedure TBrowseWindow.EditAHeader(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false,CEdit_Entry);
  Update;
end;

procedure TBrowseWindow.EditSName(var Msg: TMessage);
begin EditAHeader(Msg); end;

procedure TBrowseWindow.CopyHeader(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,0,false,false,Nil);
end;

procedure TBrowseWindow.CopySName(var Msg: TMessage);
begin CopyHeader(Msg); end;

procedure TBrowseWindow.CopyHeaderEx(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PCopyToClipDlg,init(@Self,Entry,0)));
end;

procedure TBrowseWindow.CopySNameEx(var Msg: TMessage);
begin CopyHeaderEx(Msg); end;

procedure TBrowseWindow.MenuStringCopy(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,0,false,false,NameClickMenuString);
end;

procedure TBrowseWindow.PopupTaggedEnt(var Msg: TMessage);
begin ToggleTag(Msg); end;

procedure TBrowseWindow.PopupTaggedStr(var Msg: TMessage);
begin ToggleTag(Msg); end;

procedure TBrowseWindow.EditSomething(fld,H,O: integer);
var
  W: WhichFieldPtr;
begin
  New(W); W^.fld:=fld; W^.Hyper:=H; W^.Obj:=O;
  DealWithEdit(Entry,Pattern,longint(W),false,CEdit_Entry);
  Dispose(W);
  Update;
end;                 { TBrowseWindow.EditSomething }

procedure TBrowseWindow.EditAField(var Msg: TMessage);
begin EditSomething(ModifyFieldInd,-1,-1); end;

procedure TBrowseWindow.EditAHyper(var Msg: TMessage);
begin EditSomething(ModifyFieldInd,HyperInd,-1); end;

procedure TBrowseWindow.EditAnObject(var Msg: TMessage);
begin EditSomething(ModifyFieldInd,-1,ObjectInd); end;

procedure TBrowseWindow.ActivateObject(var Msg: TMessage);
var
  OleStatus: TOleStatus;
  M: TMSG;
  OleObject: POleObj;
  R: TRect;
  F: array[0..255] of char;
begin
  if ObjectInd=-1 then Exit;
  OleObject:=POleObj(DisplayArea^.Objects.at(ObjectInd));
  OleStatus:=Ole_OK;
  if OleObject^.O<>Nil then
  repeat
    OleStatus:=OleQueryReleaseStatus(OleObject^.O);
    if OleStatus = ole_Busy then
    begin
      if GetMessage(M, 0, 0, 0) and not
        ((M.Message>=wm_KeyFirst) and (M.Message<=wm_KeyLast)) and not
        ((M.Message>=wm_MouseFirst) and (M.Message<=wm_MouseLast)) then
      begin
        TranslateMessage(M);
        DispatchMessage(M);
      end;
    end;
  until (OleStatus<>Ole_Busy);
  if OleStatus=Ole_Error_Object then Exit;
  with DisplayArea^ do
  begin
    R:=PObjRect(ObjRects.at(ObjectInd))^.R;
    OffsetRect(R,-Scroller^.Xpos*Scroller^.Xunit,
                 -Scroller^.Ypos*Scroller^.Yunit);
  end;
  OleObject^.Activate(DisplayArea,@R);
end;                   { TBrowseWindow.ActivateObject }

procedure TBrowseWindow.CopyObject(var Msg: TMessage);
begin
  if ObjectInd=-1 then Exit;
  POleObj(DisplayArea^.Objects.at(ObjectInd))^.CopyToClip(HWindow);
end;

procedure TBrowseWindow.EditSValue(var Msg: TMessage);
begin EditSomething(ModifyFieldInd,-1,-1); end;

procedure TBrowseWindow.CopyField(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,ModifyFieldInd,false,false,Nil);
end;

{$I wbibhypr.inc}

procedure TBrowseWindow.CopySValue(var Msg: TMessage);
begin CopyField(Msg); end;

procedure TBrowseWindow.CopyFieldEx(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PCopyToClipDlg,init(@Self,Entry,ModifyFieldInd)));
end;

procedure TBrowseWindow.CopySValueEx(var Msg: TMessage);
begin CopyFieldEx(Msg); end;

procedure TBrowseWindow.TagField(var Msg: TMessage); 
begin ToggleTag(Msg); end;

procedure TBrowseWindow.TagSVal(var Msg: TMessage);
begin ToggleTag(Msg); end;

procedure TBrowseWindow.ClickedOnField(var Msg: TMessage);
var
  MP: longint;
  Ctrl,Shift,CanEdit,IsHyper: boolean;
  F: array[0..255] of char;
  l: integer;
  tmp: string;
  FldRgn: PFieldRegion;
begin
  if RetrievingURLDlg<>Nil then Exit;
  HyperInd:=-1; ObjectInd:=-1; IsHyper:=false;
  if Msg.wParam=$FFFF then ModifyFieldInd:=0
  else begin
    FldRgn:=PFieldRegion(DisplayArea^.ShownList.at(Msg.wParam));
    ModifyFieldInd:=FldRgn^.fld;
    HyperInd:=FldRgn^.Hyperlink;
    IsHyper:=(HyperInd<>-1);
    { 
    if (HyperInd<>-1) and
       (not PHyperLinkObj(DisplayArea^.HyperLinks.at(HyperInd))^.Active)
          then HyperInd:=-1;
    }
    ObjectInd:=FldRgn^.Obj;
  end;
  Msg.Result:=1;
  Shift:=(Msg.lParamHi and mk_Shift   <> 0);
  Ctrl :=(Msg.lParamHi and mk_Control <> 0);
  CanEdit:=BibFileExists and (not Linked) and (not BibReadOnly);
  if Msg.lParamLo=mk_RButton then
  begin
    MP:=GetMessagePos;
    if (ModifyFieldInd=0) and (Entry^.Entrynum>0) then
    begin
      if EditOnlyStrings then
      begin
        CheckMenu(HFloatingSName,mi_BrSNTag,IsTagged(Entry^.realnum,Tags));
        ChangeMenuState(HFloatingSName,mi_BrSNEdit,CanEdit);
        TrackPopupMenu(HFloatingSName,tpm_LeftAlign or tpm_RightButton,
                   LoWord(MP), HiWord(MP), 0, HWindow, Nil)
      end else
      begin
        tmp:=CopyNameStr^;
        StrRepl(tmp,'%s',NameClickMenuString^,1,1,64);
        StrRepl(tmp,'#1',Entry^.name,1,255,255);
        if length(tmp)>60 then tmp:=Copy(tmp,1,56)+'..."';
        StrPCopy(F,tmp);
        ModifyMenu(HFloatingHeader,mi_MainFString,mf_ByCommand or mf_String,
                 mi_MainFString,F);
        CheckMenu(HFloatingHeader,mi_BrFTag,IsTagged(Entry^.realnum,Tags));
        ChangeMenuState(HFloatingHeader,mi_MainFEdit,CanEdit);
        TrackPopupMenu(HFloatingHeader,tpm_LeftAlign or tpm_RightButton,
                   LoWord(MP), HiWord(MP), 0, HWindow, Nil);
      end;
    end else if ModifyFieldInd<>0 then
    begin
      if EditOnlyStrings then
      begin
        CheckMenu(HFloatingSVal,mi_BrSValTag,IsTagged(Entry^.realnum,Tags));
        ChangeMenuState(HFloatingSVal,mi_BrSValEdit,CanEdit);
        TrackPopupMenu(HFloatingSVal,tpm_LeftAlign or tpm_RightButton,
                   LoWord(MP), HiWord(MP), 0, HWindow, Nil)
      end else
      begin
        tmp:=EditFieldStr^;
        StrRepl(tmp,'%s',TypeField^[ModifyFieldInd],1,255,255);
        if length(tmp)>60 then tmp:=Copy(tmp,1,56)+'..."';
        StrPCopy(F,tmp);
        ModifyMenu(HFloatingField,mi_BrFFEdit,mf_ByCommand or mf_String,
                 mi_BrFFEdit,F);
        CheckMenu(HFloatingField,mi_BrFFTag,IsTagged(Entry^.realnum,Tags));
        ChangeMenuState(HFloatingField,mi_BrFFEdit,CanEdit);
        DeleteMenu(HFloatingField,mi_BrFFFollowHyper,mf_ByCommand);
        DeleteMenu(HFloatingField,mi_BrFFCopyHyper,  mf_ByCommand);
        DeleteMenu(HFloatingField,mi_BrFFEditHyper,  mf_ByCommand);
        DeleteMenu(HFloatingField,mi_BrFFEditObject, mf_ByCommand);
        DeleteMenu(HFloatingField,mi_BrFFActObj,     mf_ByCommand);
        DeleteMenu(HFloatingField,mi_BrFFCopyObject, mf_ByCommand);
        if IsHyper then
        begin
          InsertMenu(HFloatingField,4,mf_ByPosition or mf_String,mi_BrFFFollowHyper,
                     FollowHyperStr);
          InsertMenu(HFloatingField,5,mf_ByPosition or mf_String,mi_BrFFCopyHyper,
                     CopyHyperStr);
          InsertMenu(HFloatingField,1,mf_ByPosition or mf_String,mi_BrFFEditHyper,
                     EditHyperStr);
        end;
        if ObjectInd<>-1 then
        begin
          if POleObj(DisplayArea^.Objects.at(ObjectInd))^.IsGraphic then
          begin
            InsertMenu(HFloatingField,1,mf_ByPosition or mf_String,mi_BrFFEditObject,
                       EditImageStr);
            InsertMenu(HFloatingField,2,mf_ByPosition or mf_String,mi_BrFFCopyObject,
                       CopyImageStr);
          end else
          begin
            InsertMenu(HFloatingField,1,mf_ByPosition or mf_String,mi_BrFFEditObject,
                       EditObjectStr);
            InsertMenu(HFloatingField,2,mf_ByPosition or mf_String,mi_BrFFCopyObject,
                       CopyObjectStr);
            InsertMenu(HFloatingField,3,mf_ByPosition or mf_String,mi_BrFFActObj,
                       ActivateObjectStr);
          end;
        end;
        TrackPopupMenu(HFloatingField,tpm_LeftAlign or tpm_RightButton,
                   LoWord(MP), HiWord(MP), 0, HWindow, Nil);
      end;
    end;
  end else if not (Shift or Ctrl) then
  begin
    if (ObjectInd>-1) and (HyperInd=-1) then ActivateObject(Msg)
    else if HyperInd=-1 then EditAField(Msg)
    else begin
      FollowHyper(Msg);
    end;
  end else if Shift or Ctrl then
  begin
    if ModifyFieldInd>0 then
      CopyFieldToClip(@Self,Entry,ModifyFieldInd,Shift and Ctrl,false,Nil)
    else
      CopyFieldToClip(@Self,Entry,0,Shift,Ctrl,Nil);
  end;
end;                            { TBrowseWindow.ClickedOnField }

{ Handler for sequential commands and command remappings }

procedure TBrowseWindow.wmCommand(var Msg: TMessage);
begin
  if AmWaiting then Exit;
  if (Msg.lparamLo<>0) or
      ((Msg.lParamHi<>0) and (Msg.lParamHi<>1)) then TWindow.wmCommand(Msg)
  else if (Msg.wParam>=cm_FirstPattHeirarchy) and
          (Msg.wParam<cm_FirstPattHeirarchy+PattHeirCount) then
            PattFromMenu(Msg.wParam)
  else
    case Msg.wParam of
      mi_BrFileChange1..mi_BrFileChange9:
        SendToFileRoutine(CFile_Change,Msg.wParam-mi_BrFileChange1+1);
      mi_BrFile1..mi_BrFile9:
        if (CurrentBibFile<>Msg.wParam-mi_BrFile1+1) or (bibname^='') then
          SendToFileRoutine(CFile_List+Msg.wParam-mi_BrFile1,0);
      cm_FirstUserPattField..cm_FirstUserPattField+MaxMenu-1:
        if DealWithPattern(Entry,Pattern,0,true,
                      CPatt_User+(Msg.wParam-cm_FirstUserPattField)) then
                                   Update;
      dl_EdSFFind    : GotoSearch(Msg);
      dl_EdSFFindNext: GotoSearchNext(Msg);
      else TWindow.wmCommand(Msg);
    end;
end;                       { TBrowseWindow.wmCommand }

{ Files menu }

procedure TBrowseWindow.SendToFileRoutine(select1,select2: integer);
var
  Selected: SelectionType;
  i: integer;
  OldBibFile: Pstring;
  OldLinked: boolean;
begin
  OldBibFile:=Nil; if BibName^<>'' then OldBibFile:=NewStr(BibName^);
  OldLinked:=Linked;
  for i:=0 to MaxMenuStack do Selected[i]:=0;
  Selected[0]:=CMainFile; Selected[1]:=Select1; Selected[2]:=Select2;
  DealWithFiles(Entry,Pattern,selected);
  if (OldBibFile=Nil) or (StrCmpI(OldBibFile^,BibName^,1,1,255)<>0)
      or (Linked<>OldLinked) then
         LoadStringAbbrevs(StrAbbrevsList,Entry);
  if Entry^.EntryNum=0 then Entry^.EntryType:='';
  Update;
  if (select1<>CFile_Change) and (select1<>CFile_Index) and
     (select1<>CFile_ReadOnly) then
    DisplayArea^.Scroller^.ScrollTo(0,0);
  if OldBibFile<>Nil then DisposeStr(OldBibFile);
end;                          { TBrowseWindow.SendToFileRoutine }

procedure TBrowseWindow.FileOpen(var Msg: TMessage);
begin SendToFileRoutine(CFile_Open,0); end;

procedure TBrowseWindow.FileClose(var Msg: TMessage);
begin SendToFileRoutine(CFile_Close,0); end;

{----------------------------------------------------}

procedure TBrowseWindow.Count(var Msg: TMessage);
var
  Selected: SelectionType;
begin
  Selected[1]:=CMisc_Count;
  DealWithMisc(Entry,Pattern,Selected);
  GrayMainMenu(@Self);
end;

procedure TBrowseWindow.DupEntries(all: boolean);
var
  Selected: SelectionType;
  ToGo: longint;
  ok,WasLinked: boolean;
  OEntry,OReal,OPlace: longint;
begin
  WasLinked:=Linked;
  if Linked then all:=false;
  Selected[0]:=CMainFile; Selected[1]:=CFile_Link; Selected[2]:=0;
  OReal:=Entry^.RealNum; OEntry:=Entry^.EntryNum; OPlace:=Entry^.Beginning;

  if all then   { Link up }
    DealWithFiles(Entry,Pattern,selected);

  ToGo:=LookForDups(@Self,Entry,Pattern);
  if ToGo>0 then
  begin
    SearchingMessage;
    ok:=true;
    GetEntry(Entry,Nil,ToGo,true,Pattern,ok);
    DisplayArea^.Scroller^.ScrollTo(0,0);
    WaitingOff;
  end;
  if All then  { Unlink }
    DealWithFiles(Entry,Pattern,selected);
  Update;
end;                { TBrowseWindow.DupEntries }

procedure TBrowseWindow.DupNamesCur(var Msg: TMessage);
begin DupEntries(false); end;

procedure TBrowseWindow.DupNamesAll(var Msg: TMessage);
begin DupEntries(true); end;

procedure TBrowseWindow.Sort(var Msg: TMessage);
begin SendToFileRoutine(CFile_Sort,0); end;

procedure TBrowseWindow.Reformat(var Msg: TMessage);
begin SendToFileRoutine(CFile_Reformat,0); end;

procedure TBrowseWindow.Index(var Msg: TMessage);
begin SendToFileRoutine(CFile_Index,0); end;

procedure TBrowseWindow.FTranslate(var Msg: TMessage);
begin SendToFileRoutine(CFile_Translate,0); end;

{ Edit menu }

procedure TBrowseWindow.EditEntry(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,-1,false,CEdit_Entry);
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

procedure TBrowseWindow.EditStrings(var Msg: TMessage);
var
  Oreal,Oentry,Obeginning,n: longint;
  WasStrings,o_k,Ascend,Descend,CacheOn,FoundStrings: boolean;
  StrList: PAbbrevList;
  OldTags: ^TagType;
begin
  Oentry:=Entry^.EntryNum; Oreal:=Entry^.RealNum;
  OBeginning:=Entry^.Beginning;
  WasStrings:=EditOnlyStrings;

  Ascend :=CurrentSortMode^.StringNameSort=StrSortAscend;
  Descend:=CurrentSortMode^.StringNameSort=StrSortDescend;
  New(StrList,Init(100,100,Ascend,Descend));
  EditOnlyStrings:=true;

  WaitingMessage('Reading...');
  IncludePreambles:=true;
  ResetBib(Entry);
  n:=1; FoundStrings:=false;
  GetEntry(Entry,Nil,1,true,Nil,o_k);
  if entry^.entrynum<1 then o_k:=false
  else FoundStrings:=true;
  while o_k do
  with Entry^ do
  begin
    inc(n);
    StrList^.Insert(New(POneStringObj,init(Entry)));
    GetEntry(Entry,Nil,n,true,Nil,o_k);
    if Entry^.EntryNum<>n then o_k:=false;
  end;
  IncludePreambles:=false;
  WaitingOff;
  if application^.ExecDialog(New(PEdStringsDlg,init(@Self,StrList)))=id_ok then
  begin
    UpdateWindow(HWindow);
    if (Ascend<>StrList^.SortUp) or (Descend<>StrList^.SortDown) then
    begin
      if StrList^.SortUp        then CurrentSortMode^.StringNameSort:=StrSortAscend
      else if StrList^.SortDown then CurrentSortMode^.StringNameSort:=StrSortDescend
      else CurrentSortMode^.StringNameSort:=StrSortOff;
    end;
    IncludePreambles:=true;
    OldTags:=Nil;
    if not WasStrings then
    begin
      New(OldTags); move(Tags,OldTags^,sizeof(TagType));
    end;
    EraseTags(Tags);
    ResetBib(Entry);
    if FoundStrings then DeleteEntries(Entry,Nil,true,false);
    IncludePreambles:=false;
    BibFileChange(Nil,Entry,'',Ac_Strings,false,'',0,2,0,StrList);
    ResetBib(Entry);
    EditOnlyStrings:=WasStrings;
    if OldTags<>Nil then
    begin
      move(OldTags^,Tags,sizeof(TagType)); Dispose(OldTags); OldTags:=Nil;
    end;
    LoadStringAbbrevs(StrAbbrevsList,Entry);
    if EditOnlyStrings and not FoundStrings then
    begin
      ResetBib(Entry);
      GetEntry(Entry,Nil,1,true,Nil,o_k);
    end else
    begin
      ReachNumber(Entry,Nil,Oreal,Oreal);
      Entry^.EntryNum:=Oentry;
    end;
    Update;
  end else
  begin
    EditOnlyStrings:=WasStrings;
    ReachEntry(Entry,oreal,oentry,Obeginning,false);
  end;
  Dispose(StrList,Done);
end;                                   { TBrowseWindow.EditStrings }

{ Copy header submenu }

procedure TBrowseWindow.CopyEName(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,0,false,false,Nil);
end;

procedure TBrowseWindow.CopyENameEx(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PCopyToClipDlg,init(@Self,Entry,0)));
end;

procedure TBrowseWindow.CopyENameStr(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,0,false,false,NameClickMenuString);
end;

procedure TBrowseWindow.CopyEField(var Msg: TMessage);
var
  Ind: integer;
  Extended: boolean;
begin
  if Entry^.nentry=0 then Exit;
  if Application^.ExecDialog(New(PCopyFieldDlg,
                    init(@Self,Entry,@Ind,@Extended)))=id_ok then
    CopyFieldToClip(@Self,Entry,Ind,Extended,false,Nil);
end;

procedure TBrowseWindow.CopyEntry(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false,CEdit_Copy); GrayMainMenu(@Self);
end;

procedure TBrowseWindow.CutEntry(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false,CEdit_Cut);
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

procedure TBrowseWindow.PasteEntry(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false,CEdit_Paste);
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

procedure TBrowseWindow.PasteClip(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false,CEdit_PasteClip);
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

procedure TBrowseWindow.ReplaceEntry(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false,CEdit_Replace);
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

procedure TBrowseWindow.ReplaceClip(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false,CEdit_RepClip);
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

procedure TBrowseWindow.ClearEntry(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false, CEdit_Clear);
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

procedure TBrowseWindow.PutBookmark(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false, CEdit_Bookmark);
  GrayMainMenu(MainW);
end;

procedure TBrowseWindow.ToggleTag(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false, CEdit_Tag);
  if ContainsTags(Pattern) then Update
  else begin
    EntryName^.Update; UpdateWindow(EntryName^.HWindow);
  end;
end;

procedure TBrowseWindow.TagAll(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false, CEdit_TagAll);
  if ContainsTags(Pattern) then Update
  else begin
    EntryName^.Update; UpdateWindow(EntryName^.HWindow);
  end;
end;

procedure TBrowseWindow.TagTeX(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false, CEdit_TagTeX);
  if ContainsTags(Pattern) then Update
  else begin
    EntryName^.Update; UpdateWindow(EntryName^.HWindow);
  end;
end;

procedure TBrowseWindow.UnTagAll(var Msg: TMessage);
begin
  DealWithEdit(Entry,Pattern,0,false, CEdit_UnTagAll); 
  if ContainsTags(Pattern) then Update
  else begin
    EntryName^.Update; UpdateWindow(EntryName^.HWindow);
  end;
end;

procedure TBrowseWindow.DelAll(var Msg: TMessage);
begin
  DeleteEntries(Entry,Pattern,true,true);
  if EditOnlyStrings then LoadStringAbbrevs(StrAbbrevsList,Entry);
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

procedure TBrowseWindow.DelTagged(var Msg: TMessage);
begin
  DeleteEntries(Entry,Pattern,false,true);
  if EditOnlyStrings then LoadStringAbbrevs(StrAbbrevsList,Entry);
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

{ Goto menu }

procedure TBrowseWindow.GotoThere(id: integer);
begin
  if DealWithGoto(Entry,Pattern,0,false,false,false,id) then
  begin
    UpdateEntry; DisplayArea^.Scroller^.ScrollTo(0,0);
  end;
end;

procedure TBrowseWindow.Next(var Msg: TMessage);
begin GotoThere(CGoto_Next); end;

procedure TBrowseWindow.Back(var Msg: TMessage);
begin GotoThere(CGoto_Back); end;

procedure TBrowseWindow.Last(var Msg: TMessage);
begin GotoThere(CGoto_Last); end;

procedure TBrowseWindow.First(var Msg: TMessage);
begin GotoThere(CGoto_First); end;

procedure TBrowseWindow.GotoTag(var Msg: TMessage);
begin GotoThere(CGoto_Tag); end;

procedure TBrowseWindow.GotoBookmark(var Msg: TMessage);
begin GotoThere(CGoto_Bookmark); end;

procedure TBrowseWindow.GotoList(var Msg: TMessage);
begin GotoThere(CGoto_List); end;

procedure TBrowseWindow.GotoOverview(var Msg: TMessage);
begin GotoThere(CGoto_Overview); end;

procedure TBrowseWindow.GotoNum(var Msg: TMessage);
begin GotoThere(CGoto_Number); end;

procedure TBrowseWindow.GotoLabel(var Msg: TMessage);
begin GotoThere(CGoto_Label); end;

procedure TBrowseWindow.GotoLabelNext(var Msg: TMessage);
begin GotoThere(CGoto_LabelNext); end;

procedure TBrowseWindow.GotoSearch(var Msg: TMessage);
begin
  if DealWithGoto(Entry,Pattern,0,false,true,false,CGoto_Search) then
  begin
    UpdateEntry; DisplayArea^.Scroller^.ScrollTo(0,0);
  end;
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

procedure TBrowseWindow.GotoSearchNext(var Msg: TMessage);
begin
  if DealWithGoto(Entry,Pattern,0,false,true,false,CGoto_SearchNext) then
  begin
    UpdateEntry; DisplayArea^.Scroller^.ScrollTo(0,0);
  end;
  UpdateEntry; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

{ Add menu }

procedure TBrowseWindow.Adding(where: integer);
var
  Selected: SelectionType;
begin
  Selected[1]:=where;
  DealWithAdd(Entry,Pattern,Selected);
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;

procedure TBrowseWindow.AddSorted(var Msg: TMessage);
begin Adding(0); end;

procedure TBrowseWindow.AddEOF(var Msg: TMessage);
begin Adding(CIns_EOF); end;

procedure TBrowseWindow.AddCurrent(var Msg: TMessage);
begin Adding(CIns_BeforeCurr); end;

procedure TBrowseWindow.AddAfterCurrent(var Msg: TMessage);
begin Adding(CIns_AfterCurr); end;

procedure TBrowseWindow.AddNumber(var Msg: TMessage);
begin Adding(CIns_Num); end;

procedure TBrowseWindow.AddBeforeEntry(var Msg: TMessage);
begin Adding(CIns_EntryList); end;

procedure TBrowseWindow.AddFirst(var Msg: TMessage);
begin Adding(CIns_FirstEntry); end;

{ Import menu }

procedure TBrowseWindow.Import(var Msg: TMessage);
var
  ans: integer;
  Selected: SelectionType;
begin
  ans:=Application^.ExecDialog(New(PImportDlg,init(@Self,InputStr)));
  if ans and (id_ok*100)<>0 then
  begin
    Selected[1]:=ans and not (id_ok*100);
    if Selected[1]=CIns_Sorted then Selected[1]:=0;
    DealWithImport(Entry,Pattern,Selected);
    Update; DisplayArea^.Scroller^.ScrollTo(0,0);
  end;
end;             { TBrowseWindow.Import }

{ Export }

procedure TBrowseWindow.Exp(var Msg: TMessage);
var
  IORec: TExportRec;
  Selected: SelectionType;
begin
  if Application^.ExecDialog(New(PExportDlg,init(@Self,Entry,@IORec)))=id_ok
      then
  begin
    Selected[1]:=CExp_Rec; Selected[2]:=0;
    InvalidateRect(HWindow,Nil,true); UpdateWindow(HWindow);
    DealWithExport(Entry,Pattern,Selected,@IORec);
    InvalidateRect(HWindow,Nil,true);
  end;
end;

{ Pattern menu }

procedure TBrowseWindow.EditPattern(var Msg: TMessage);
begin
  if DealWithPattern(Entry,Pattern,0,true,CPatt_Edit) then Update;
end;

procedure TBrowseWindow.PattTagged(var Msg: TMessage);
begin
  if DealWithPattern(Entry,Pattern,0,true,CPatt_Tagged) then Update;
end;

procedure TBrowseWindow.PattAllFields(var Msg: TMessage);
begin
  if DealWithPattern(Entry,Pattern,0,true,CPatt_AllFields) then Update;
end;

procedure TBrowseWindow.TogglePattern(var Msg: TMessage);
begin
  if (Pattern^.npatt<>0) and 
    DealWithPattern(Entry,Pattern,0,true,CPatt_OnOff) then Update;
end;

procedure TBrowseWindow.PattAssociate(var Msg: TMessage);
begin
  if Application^.ExecDialog(New(PAssocPattListDlg,init(@Self)))=id_ok then
  begin
    if GetPattHeirarchy(PattHeirarchy,0,bibname,true)<0 then
         GetPattHeirarchy(PattHeirarchy,0,Nil,false);
    InsertPattHeirarchyMenu(0,PattHeirarchy);
  end;
end;                   { TBrowseWindow.PattAssociate }

procedure TBrowseWindow.PattHeirList(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PPatMenuFilesDlg,init(@Self)));
  if GetPattHeirarchy(PattHeirarchy,0,bibname,true)<0 then
       GetPattHeirarchy(PattHeirarchy,0,Nil,false);
  InsertPattHeirarchyMenu(0,PattHeirarchy);
end;                  { TBrowseWindow.PattHeirList }

procedure TBrowseWindow.PattFromMenu(id: word);
begin
  if DealWithPattern(Entry,Pattern,0,true,id) then Update;
end;

{ Options menu }

procedure TBrowseWindow.ViewMode(var Msg: TMessage);
var
  Selected: SelectionType;
begin
  Selected[1]:=CMisc_View;
  DealWithMisc(Entry,Pattern,Selected);
  CheckMainMenu(MainW);
  DisplayArea^.Update;
end;

procedure TBrowseWindow.StringsMode(var Msg: TMessage);
var
  Selected: SelectionType;
begin
  Selected[1]:=CMisc_Strings;
  DealWithMisc(Entry,Pattern,Selected);
  Update;
end;

procedure TBrowseWindow.ToggleLink(var Msg: TMessage);
begin SendToFileRoutine(CFile_Link,0); end;

procedure TBrowseWindow.ToggleReadOnly(var Msg: TMessage);
begin SendToFileRoutine(CFile_ReadOnly,0); end;

procedure TBrowseWindow.ToggleTagNew(var Msg: TMessage);
var
  Selected: SelectionType;
begin
  Selected[1]:=CMisc_TagNew;
  DealWithMisc(Entry,Pattern,Selected);
  CheckMainMenu(@Self);
end;

procedure TBrowseWindow.SaveTheCache(var Msg: TMessage);
var
  Selected: SelectionType;
begin
  Selected[1]:=CMisc_CacheMenu;
  Selected[2]:=CMisc_SaveCache;
  DealWithMisc(Entry,Pattern,Selected);
end;

procedure TBrowseWindow.ClearTheCache(var Msg: TMessage);
var
  Selected: SelectionType;
begin
  Selected[1]:=CMisc_CacheMenu;
  Selected[2]:=CMisc_ClearCache;
  DealWithMisc(Entry,Pattern,Selected);
end;

procedure TBrowseWindow.PrefOpts(var Msg: TMessage);
begin
  if Preferences then Update;
end;

procedure TBrowseWindow.GUIOpts(var Msg: TMessage);
var
  OldExpStr,OldExpAbb,OldBraces: boolean;
  OldBibAbbrev,OldBSTAbbrev: string;
begin
  OldExpStr:=ExpandStrings; OldExpAbb:=ExpandIniAbbrevs;
  OldBibAbbrev:=BIBAbbrevsFile^; OldBSTAbbrev:=BSTAbbrevsFile^;
  OldBraces:=StripExtraBraces;
  if (Application^.ExecDialog(New(PGUIOptDlg,Init(@Self)))=id_ok) then
  begin
    OptionsModified.WindowsParams:=true;
    if StripExtraBraces<>OldBraces then
      OptionsModified.Preferences:=true;
    if UseToolbar then Toolbar^.Show(sw_show) else Toolbar^.Show(sw_hide);
    if UseCoffeeCup then WaitingCursor:=CoffeeCupCursor
    else WaitingCursor:=HourglassCursor;
    if UseCtl3d and not Ctl3dv2Active then Load3dDll
    else if (not UseCtl3d) and Ctl3dv2Active then Unload3dDll;

    if (BibTeXHelpMode=0) and IsHelpBibTeX then
    begin
      RemoveMenu(SearchForMenuItem(Attr.Menu,'help'),HelpBibTeXPos,mf_ByPosition);
      IsHelpBibTeX:=false;
    end else if (BibTeXHelpMode<>0) and not IsHelpBibTeX then
    begin
      InsertMenu(SearchForMenuItem(Attr.Menu,'help'),HelpBibTeXPos,
        mf_ByPosition or mf_Popup or mf_String,HelpBibTeX,HelpBibTeXStr);
      IsHelpBibTeX:=true;
    end;
    if OldExpStr<>ExpandStrings then LoadStringAbbrevs(StrAbbrevsList,Entry);
    LoadIniAbbrevs(IniAbbrevsList);
    if StrCmpI(BIBAbbrevsFile^,OldBIBAbbrev,1,1,255)<>0 then
      LoadBIBAbbrevs(BIBAbbrevsList,BIBAbbrevsFile^,Entry);
    if StrCmpI(BSTAbbrevsFile^,OldBSTAbbrev,1,1,255)<>0 then
      LoadBstAbbrevs(BstAbbrevsList,BstAbbrevsFile^);

    Toolbar^.ReorderBtns;
    EntryNameShiftTop:=Toolbar^.Height+1;
    CalcSizes(0,0);
    Update;
  end;
end;                        { TBrowseWindow.GUIOpts }

procedure TBrowseWindow.FieldsList(var Msg: TMessage);
begin
  if Application^.ExecDialog(New(PFieldsDlg,init(@Self)))=id_ok then
  begin
    if BibFileExists and (Entry^.RealNum<>0) then RefreshEntry(Entry);
    Update;
  end;
end;

procedure TBrowseWindow.ShowFormat(var Msg: TMessage);
begin
  if EdShowFormat=Nil then Application^.MakeWindow(
                      New(PEdShowFormatDlg,init(Nil)))
  else SetFocus(EdShowFormat^.HWindow);
end;

procedure TBrowseWindow.ObjectOpts(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PObjectImageOptions,init(@Self)));
  OptionsModified.WindowsParams:=true;
  Update;
end;

procedure TBrowseWindow.HyperOpts(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PHyperOptionsDlg,init(@Self)));
  if not LockOleServers then UnlockOleServers;
  OptionsModified.WindowsParams:=true;
  Update;
end;

procedure TBrowseWindow.EdAbbrevs;
var
  OldExpStr,OldExpAbb: boolean;
  OldBibAbbrev,OldBSTAbbrev: string;
  IniAbbrevs: TAbbrevList;
  F: array[0..255] of char;
  i: integer;
  Buf,BufRoot: PChar;
  SLen: word;
begin
  OldExpStr:=ExpandStrings; OldExpAbb:=ExpandIniAbbrevs;
  OldBibAbbrev:=BIBAbbrevsFile^; OldBSTAbbrev:=BSTAbbrevsFile^;

  IniAbbrevs.init(50,50,false,false);
  LoadIniAbbrevs(IniAbbrevs);

  if Application^.ExecDialog(New(PEdIniAbbrevsDlg,init(@Self,@IniAbbrevs)))=id_ok then
  begin
    GetMem(Buf,BufSize); BufRoot:=Buf;
    i:=GetPrivateProfileString(AbbrevSec,Nil,'',Buf,BufSize,IniFile);
    SLen:=StrLen(Buf);
    if i>=3 then
    begin
      while SLen>0 do
      begin
        WritePrivateProfileString(AbbrevSec,Buf,Nil,IniFile);
        Buf:=Buf+Slen+1;
        SLen:=StrLen(Buf);
      end;
    end;
    FreeMem(BufRoot,BufSize);
    for i:=0 to IniAbbrevs.Count-1 do
    with POneStringObj(IniAbbrevs.at(i))^ do
    begin
      StrPCopy(F,SName^);
      WritePrivateProfileString(AbbrevSec,F,SValue,IniFile);
    end;
    IniAbbrevs.Done;

    if OldExpStr<>ExpandStrings then LoadStringAbbrevs(StrAbbrevsList,Entry);
    LoadIniAbbrevs(IniAbbrevsList);
    if StrCmpI(BIBAbbrevsFile^,OldBIBAbbrev,1,1,255)<>0 then
      LoadBIBAbbrevs(BIBAbbrevsList,BIBAbbrevsFile^,Entry);
    if StrCmpI(BSTAbbrevsFile^,OldBSTAbbrev,1,1,255)<>0 then
      LoadBstAbbrevs(BstAbbrevsList,BstAbbrevsFile^);
  end else IniAbbrevs.Done;
end;                            { TBrowseWindow.EdAbbrevs }

{---}

procedure TBrowseWindow.SortOpts(which: integer);
var
  Selected: SelectionType;
begin
  Selected[1]:=CMisc_Soptions; Selected[2]:=which;
  DealWithMisc(Entry,Pattern,Selected);
  Update;
end;

procedure TBrowseWindow.DefSortOpt(var Msg: TMessage);
begin SortOpts(CSortMode_Default); end;

procedure TBrowseWindow.CurSortOpt(var Msg: TMessage);
begin SortOpts(CSortMode_Current); end;

procedure TBrowseWindow.ExpSortOpt(var Msg: TMessage);
begin SortOpts(CSortMode_Export);  end;

{---}

procedure TBrowseWindow.FileFormOpts(var Msg: TMessage);
begin
  FileFormatOptions;
end;

procedure TBrowseWindow.ModifyFonts(var Msg: TMessage);
var
  Res: integer;
  Updt: boolean;
begin
  Updt:=false;
  Res:=Application^.ExecDialog(New(PModifyFontsDlg,Init(@Self,true)));
  if Res and $10 <> 0 then  { Screen font change }
  begin
    InvalidateRect(Entryname^.HWindow,Nil,true);
    UpdateWindow(Entryname^.HWindow);
    EntryNameHeight:=Fonts^[LabelFont].Height+ENameHightAdd;
    StatusBar^.Resize;
    CalcSizes(0,0);
    Updt:=true;
  end else if Res and $40 <> 0 then Updt:=true;   { Tag color change }
  if Res and $80 <> 0 then
  begin
    HighBits(DispEncoding,FReadEncoding,-1);
    LoadIniAbbrevs(IniAbbrevsList);
    LoadBibAbbrevs(BIBAbbrevsList,BIBAbbrevsFile^,Entry);
    LoadBstAbbrevs(BSTAbbrevsList,BSTAbbrevsFile^);
    LoadStringAbbrevs(StrAbbrevsList,Entry);
    RefreshEntry(Entry);
    Updt:=true;
    OptionsModified.Preferences:=true;
  end;
  if ENameBackBrush=0 then InvalidateRect(EntryName^.HWindow,Nil,true);
  if Updt then UpdateEntry;
end;                         { TBrowseWindow.ModifyFonts }
{
procedure TBrowseWindow.FontEncodings(var Msg: TMessage);
begin
  if EncodingsList.Count<3 then
    ErrorMessageRC(Str_NoEncodingsFound,'')
  else if Application^.ExecDialog(New(PFontEncodingDlg,init(
    @Self,@Prog8bit,@Prog7Bit,@File8Bit,@File7Bit,
    @DispEncoding,@FReadEncoding)))=id_ok then
  begin
    HighBits(DispEncoding,FReadEncoding,-1);
    LoadIniAbbrevs(IniAbbrevsList);
    LoadBibAbbrevs(BIBAbbrevsList,BIBAbbrevsFile^,Entry);
    LoadBstAbbrevs(BSTAbbrevsList,BSTAbbrevsFile^);
    LoadStringAbbrevs(StrAbbrevsList,Entry);
    RefreshEntry(Entry); UpdateEntry;
    OptionsModified.Preferences:=true;
  end;
end; }                          { TBrowseWindow.FontEncodings }

procedure TBrowseWindow.SaveAnOption(which: integer);
var
  Selected: SelectionType;
begin
  Selected[1]:=CMisc_SaveOpts; Selected[2]:=which;
  DealWithMisc(Entry,Pattern,Selected);
  CheckMainMenu(@Self);
end;

procedure TBrowseWindow.SavePrefs(var Msg: TMessage);
begin SaveAnOption(CMiscSave_Prefs); end;

procedure TBrowseWindow.SaveRegs(var Msg: TMessage);
begin SaveAnOption(CMiscSave_Regs); end;

procedure TBrowseWindow.SaveSort(var Msg: TMessage);
begin SaveAnOption(CMiscSave_Sort); end;

procedure TBrowseWindow.SaveFForm(var Msg: TMessage);
begin SaveAnOption(CMiscSave_Formats); end;

procedure TBrowseWindow.SavePos(var Msg: TMessage);
begin
  SaveWinOptions;
end;

procedure TBrowseWindow.SaveAll(var Msg: TMessage);
begin SaveAnOption(CMiscSave_All); end;

procedure TBrowseWindow.SaveOnExit(var Msg: TMessage);
begin SaveAnOption(CMiscSave_Exit); end;

procedure TBrowseWindow.SaveWOnExit(var Msg: TMessage);
begin
  SaveWinOptsOnExit:=not SaveWinOptsOnExit;
  if SaveWinOptsOnExit then OptionsModified.WindowsParams:=true;
  CheckMainMenu(@Self);
end;


{ Help menu }

procedure TBrowseWindow.HelpContents(var Msg: TMessage);
begin
  WinHelp(HWindow,HelpFile,Help_Contents,0);
end;

procedure TBrowseWindow.HelpSearch(var Msg: TMessage);
var
  F: array[0..3] of char;
begin
  StrPCopy(F,'');
  WinHelp(HWindow,HelpFile,Help_PartialKey,LongInt(@F));
end;

procedure TBrowseWindow.HelpHow(var Msg: TMessage);
var
  HFile: array[0..255] of char;
begin
  GetWindowsDirectory(HFile,255);
  StrPCopy(HFile,StrPas(HFile)+'\winhelp.hlp');
  WinHelp(HWindow,HFile,Help_Contents,0);
end;

procedure TBrowseWindow.HelpMenus(var Msg: TMessage);
begin
  WinHelp(HWindow,HelpFile,Help_Context,hc_Menus);
end;

procedure TBrowseWindow.HelpMouse(var Msg: TMessage);
begin
  WinHelp(HWindow,HelpFile,Help_Context,hc_MouseAndKeys);
end;

procedure TBrowseWindow.HelpConfig(var Msg: TMessage);
begin
  WinHelp(HWindow,HelpFile,Help_Context,hc_Configuration);
end;

procedure TBrowseWindow.HelpBibContents(var Msg: TMessage);
begin
  WinHelp(HWindow,BibTeXHelpFile,Help_Contents,0);
end;

procedure TBrowseWindow.HelpBibSearch(var Msg: TMessage);
var
  F: array[0..3] of char;
begin
  StrPCopy(F,'');
  WinHelp(HWindow,BibTeXHelpFile,Help_PartialKey,LongInt(@F));
end;

procedure TBrowseWindow.HelpBibWhat(var Msg: TMessage);
begin
  WinHelp(HWindow,BibTeXHelpFile,Help_Context,hc_btx_WhatIsBibTeX);
end;

procedure TBrowseWindow.HelpBibFormat(var Msg: TMessage);
begin
  WinHelp(HWindow,BibTeXHelpFile,Help_Context,hc_Btx_BibFormat);
end;

procedure TBrowseWindow.HelpBibType(var Msg: TMessage);
begin
  WinHelp(HWindow,BibTeXHelpFile,Help_Context,hc_btx_EntryTypes);
end;

procedure TBrowseWindow.HelpBibFields(var Msg: TMessage);
begin
  WinHelp(HWindow,BibTeXHelpFile,Help_Context,hc_btx_Fields);
end;

procedure TBrowseWindow.HelpBibNames(var Msg: TMessage);
begin
  WinHelp(HWindow,BibTeXHelpFile,Help_Context,hc_btx_NameFields);
end;

procedure TBrowseWindow.HelpBibStyles(var Msg: TMessage);
begin
  WinHelp(HWindow,BibTeXHelpFile,Help_Context,hc_btx_Styles);
end;


procedure TBrowseWindow.About(var Msg: TMessage);
var
  Selected: SelectionType;
begin
  Selected[1]:=CMisc_About;
  DealWithMisc(Entry,Pattern,Selected);
end;

{ Accelerators }

procedure TBrowseWindow.AccScrollDn(var Msg: TMessage);
begin
  DisplayArea^.Scroller^.ScrollBy(0,1);
end;

procedure TBrowseWindow.AccScrollUp(var Msg: TMessage);
begin
  DisplayArea^.Scroller^.ScrollBy(0,-1);
end;

procedure TBrowseWindow.AccPgDn(var Msg: TMessage);
begin
  DisplayArea^.Scroller^.ScrollBy(0,DisplayArea^.Scroller^.YPage);
end;

procedure TBrowseWindow.AccPgUp(var Msg: TMessage);
begin
  DisplayArea^.Scroller^.ScrollBy(0,-DisplayArea^.Scroller^.YPage);
end;

procedure TBrowseWindow.AccHome(var Msg: TMessage);
begin
  DisplayArea^.Scroller^.ScrollTo(0,0);
end;

procedure TBrowseWindow.AccEnd(var Msg: TMessage);
begin
  DisplayArea^.Scroller^.ScrollTo(0,DisplayArea^.Scroller^.YRange);
end;

procedure TBrowseWindow.KillW(var Msg: TMessage);
begin
  if (not LeaveConfirm) or YesNoRC(Str_ReallyQuit,'') then
  begin
    AmWaiting:=false;
    CloseWindow;
  end;
end;

procedure TBrowseWindow.wmDestroy(var Msg: TMessage);
var
  i: integer;
begin
  KeepPositions;
  DragAcceptFiles(HWindow,false);
  WinHelp(HWindow,HelpFile,Help_Quit,0);
  if UsingSortedMenu then DestroyMenu(AddPopup);
  TWindow.wmDestroy(Msg);
end;                   { TBrowseWindow.wmDestroy }

destructor TBrowseWindow.Done;
begin
  MenuHelp.Done; PopupHelp.Done;
  StrAbbrevsList.Done; IniAbbrevsList.Done;
  BSTAbbrevsList.Done; BIBAbbrevsList.Done;
  if HfloatingHeader<>0  then DestroyMenu(HFloatingHeader);
  if HfloatingField<>0   then DestroyMenu(HFloatingField);
  if HfloatingSName<>0   then DestroyMenu(HFloatingSName);
  if HfloatingSVal<>0    then DestroyMenu(HFloatingSVal);
  if (not IsHelpBibTeX)  and (HelpBibTeX<>0) then DestroyMenu(HelpBibTeX);
  if EditFieldStr<>Nil   then DisposeStr(EditFieldStr);
  if CopyNameStr<>Nil    then DisposeStr(CopyNameStr);
  if MenuSizeString<>Nil then StrDispose(MenuSizeString);
  CloseDDE;
  Unload3dDll;
  TWindow.Done;
end;                    { TBrowseWindow.Done }

end.
