/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.jmakepdfx;

import com.dickimawbooks.jmakepdfx.FileField;
import com.dickimawbooks.jmakepdfx.Jmakepdfx;
import com.dickimawbooks.jmakepdfx.JpdfxResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class IccSelector
extends JDialog
implements ActionListener {
    private File selectedFile = null;
    private FileField fileField;
    private JFileChooser fileChooser;
    private Jmakepdfx app;

    public IccSelector(Jmakepdfx jmakepdfx) {
        super(jmakepdfx, Jmakepdfx.getLabel("iccselect.title"), true);
        JTextArea jTextArea = new JTextArea(Jmakepdfx.getLabel("properties.fetch_icc.info"));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        this.getContentPane().add((Component)jTextArea, "North");
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel(Jmakepdfx.getLabel("properties.path.icc"));
        jLabel.setDisplayedMnemonic(Jmakepdfx.getMnemonic("properties.path.icc"));
        box.add(jLabel);
        this.fileChooser = new JFileChooser();
        this.fileField = new FileField(this, this.fileChooser);
        box.add(this.fileField);
        JButton jButton = new JButton(Jmakepdfx.getLabel("properties.fetch_icc"));
        jButton.setMnemonic(Jmakepdfx.getMnemonic("properties.fetch_icc"));
        jButton.setActionCommand("fetchicc");
        jButton.addActionListener(this);
        box.add(jButton);
        this.getContentPane().add((Component)box, "Center");
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        jPanel.add(JpdfxResources.createOkayButton(this));
        jPanel.add(JpdfxResources.createCancelButton(this));
        this.pack();
        Dimension dimension = this.getSize();
        dimension.width += 50;
        dimension.height += 10;
        this.setSize(dimension);
        this.setLocationRelativeTo(jmakepdfx);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("choose")) {
            if (this.fileChooser.showOpenDialog(this) == 0) {
                this.fileField.setFileName(this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        } else if (string.equals("fetchicc")) {
            try {
                File file = this.app.fetchICCFile();
                if (file != null) {
                    this.fileField.setFileName(file.getAbsolutePath());
                }
            }
            catch (Exception exception) {
                this.app.error(exception);
            }
        } else if (string.equals("okay")) {
            this.selectedFile = this.fileField.getFile();
            if (this.selectedFile == null || this.selectedFile.equals("")) {
                JpdfxResources.error((Component)this, Jmakepdfx.getLabel("error.no_file"));
            } else {
                this.setVisible(false);
            }
        } else if (string.equals("cancel")) {
            this.setVisible(false);
        }
    }

    public File fetchPath() {
        this.setVisible(true);
        return this.selectedFile;
    }
}

