/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.Arrays;

public class IndexData {
    private final int count;
    private final int[] offset;
    private int[] data;

    public IndexData(int count) {
        this.count = count;
        this.offset = new int[count + 1];
    }

    public byte[] getBytes(int index) {
        int length = this.offset[index + 1] - this.offset[index];
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)this.data[this.offset[index] - 1 + i];
        }
        return bytes;
    }

    public String toString() {
        return this.getClass().getName() + "[count=" + this.count + ", offset=" + Arrays.toString(this.offset) + ", data=" + Arrays.toString(this.data) + "]";
    }

    public int getCount() {
        return this.count;
    }

    public void setOffset(int index, int value) {
        this.offset[index] = value;
    }

    public int getOffset(int index) {
        return this.offset[index];
    }

    public void initData(int dataSize) {
        this.data = new int[dataSize];
    }

    public void setData(int index, int value) {
        this.data[index] = value;
    }
}

