/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.mariadb.jdbc.internal.common.packet.buffer.ReadUtil;

public final class RawPacket {
    private final ByteBuffer byteBuffer;
    private final int packetSeq;

    static RawPacket nextPacket(InputStream is) throws IOException {
        byte[] lengthBuffer = new byte[4];
        ReadUtil.readFully(is, lengthBuffer);
        int length = (lengthBuffer[0] & 0xFF) + ((lengthBuffer[1] & 0xFF) << 8) + ((lengthBuffer[2] & 0xFF) << 16);
        byte packetSeq = lengthBuffer[3];
        byte[] rawBytes = new byte[length];
        ReadUtil.readFully(is, rawBytes);
        return new RawPacket(ByteBuffer.wrap(rawBytes).order(ByteOrder.LITTLE_ENDIAN), packetSeq);
    }

    public RawPacket(ByteBuffer byteBuffer, int packetSeq) {
        this.byteBuffer = byteBuffer;
        this.packetSeq = packetSeq;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int getPacketSeq() {
        return this.packetSeq;
    }
}

