#!/bin/awk -f 

#
#    REFERENCES -- bibliographic software
#    Copyright (C) 1995-2006  Volker Kiefel
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#    USA
#

#
#    txt2ltx.awk -- convert a list of references into a formatted LaTeX-file
#
#    Usage:
#
#       awk [-v output_file=NameOfOutputFile.txt] -f txt2ltx.awk textfile
#
#
#    Versions:
#    31.7.2005: name of `outfile' may be changed (for References v4.2)
#
#


BEGIN {
   if (!output_file)
   {
     outfile = "reflist.tex"
   } else
   {
     outfile=output_file
   }

}

{
   a = $0
   gsub(/&/,"\\\\\\&",a)                ## see (1)
   gsub(/</,"$<$",a)
   gsub(/>/,"$>$",a)
   gsub(/___open-it\(/,"\\textit{",a) 
   gsub(/\)close-it___/,"}",a) 
   gsub(/___open-ul\(/,"\\ul{",a)       ## see (2) 
   gsub(/\)close-ul___/,"}",a) 
   gsub(/___open-bf\(/,"\\textbf",a) 
   gsub(/\)close-bf___/,"}",a) 
   gsub(/___open-tt\(/,"\\texttt",a) 
   gsub(/\)close-tt___/,"}",a) 
   gsub(/___open-sc\(/,"\\textsc",a) 
   gsub(/\)close-sc___/,"}",a) 
   gsub(//,"\\\"a",a)
   gsub(//,"\\\"o",a)
   gsub(//,"\\\"u",a)
   gsub(//,"\\\"A",a)
   gsub(//,"\\\"O",a)
   gsub(//,"\\\"U",a)
   gsub(//,"{\\ss}",a)

   print a > outfile

}


END {
   close(outfile)
   print "\nFile " outfile " created\n"
}

# (1) incredible, but see: Robbins A, Effective AWK programming
# (2) for `underlined', loading of the soul-package is required

# vim:tw=2048
