/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   list_rfd.c: compile list of references, user defined
   v4.1
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "refs.h"
#include "list_rfd.h"
#include "ix01_fun.h"
#include "ix02_fun.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "interf.h"
#include "initial.h"
#include "fd.h"
#include "rfd_fun1.h"
#include "str_refs.h"

#define REFZAHL_LEN 7
#define TXTBUF_SIZE 15000
#define BBTBUF_SIZE 4000
#define ORDNUNGSZAHL_LEN 12
#define TEMP_FORMDEF_NAME "tfd.dat"


 extern config_set one_config_set;
 extern char wrtxtbu[WRTXTBU_LEN+1];

 extern journal_rec            one_journal_rec;
 extern buch_rec               one_buch_rec;
 extern quell_rec              one_quell_rec;
 extern refspix_rec            ix01rec;
 extern quellpix_rec           ix02rec;
 extern author_rec             one_aued_rec;
 static bbatchtable_rec        one_bbt_rec;
 static formdef_rec            fd;
 extern desc_rec               one_desc_rec;

 extern char journal_pix_name[PFAD_LEN+1];
 extern char journal_name[PFAD_LEN + 1];
 extern char book_name[PFAD_LEN + 1];
 extern char autorjl_name[PFAD_LEN + 1];
 extern char autorbu_name[PFAD_LEN + 1];
 extern char quell_pix_name[PFAD_LEN + 1];
 extern char quell_name[PFAD_LEN + 1];
 extern char desc_name[PFAD_LEN + 1];
 static char txt_name[PFAD_LEN + 1];
 extern char log_name[PFAD_LEN + 1];
 static char bbt_name[PFAD_LEN + 1];
 static char haupt_schluessel[KENNZIFFER_LEN + 1];
 static char quell_schluessel[QUELLKUERZEL_LEN + 1];
 static char txt_buf[TXTBUF_SIZE + 1];
 static char bbt_buf[BBTBUF_SIZE + 1];
 extern char formdef_name[PFAD_LEN + 1];
 
 char temp_formdef_name[PFAD_LEN + 1];

 static char ordnungszahl[ORDNUNGSZAHL_LEN+1];

 static char * au_zeile;
 static char * ed_zeile;
 static char * ex_au_zeile;
 static char * ausgabe_zeile;
 static char * desc_zeile;

 static int makromodus;
 static long formdef_datensatz;


 static int fdau_n_j1;
 static int fdau_n_b1;
 static int fdau_n_b2au;
 static int fdau_n_b2ed;
 static int fdau_n_m1;  /* new for v4.1*/
 static int fdau_m_j1;
 static int fdau_m_b1;
 static int fdau_m_b2au;
 static int fdau_m_b2ed;
 static int fdau_m_m1;  /* new for v4.1*/
 static int fdedmax;
  /* Die hoechste Ziffernkennung in der Herausgeberliste */

 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];

 extern FILE * ix01file;
 extern FILE * ix02file;
 extern FILE * fpjournal;
 extern FILE * fpdesc;
 extern FILE * fpbuch;
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;
 extern FILE * fpsource;
 static FILE * fpbbt;
 static FILE * fptxt;
//  static FILE * fplog;
 extern FILE * fpformdef;
 
 FILE * fptempformdef;

 static int getfilenames_list_rfd(int testmodus);
 static int list_rfd_initialize(void);
 static int list_rfd_aufraeumen(void);
 static int dateien_oeffnen_list_rfd(void);
 static void dateien_schliessen_list_rfd(void);
 static int formdef_datensatz_lesen(int testcode);
 int test_datensatz_lesen(long rec_zeiger, formdef_rec * one_fd, char * temp_formdef_datei_name);
 static void machlist_list_rfd(void);
 static void exarg01(char * zeile);
 static void compile_j1(void);
 static void compile_j2(void);
 static void compile_b1(void);
 static void compile_b2(void);
 static void compile_b3(void);
 static void compile_m1(void);
 static void compile_m2(void);
 static int fdautorenstr0(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  );



 static int fdautorenstr1(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  );

 static int fdautorenstr2(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  );


 static int fdautorenstr3(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  );

 static int kwdsstr(char * desc_zeile, long zeiger);
 static void j1_aut(void);
 static void j1_tit(void);
 static void j1_lok(void);
 static void j2_aut(void);
 static void j2_tit(void);
 static void j2_lok(void);
 static void b1_ed(void);
 static void b1_tit(void);
 static void b1_lok(void);
 static void b2_aut(void);
 static void b2_tit(void);
 static void b2_ed(void);
 static void b2_titb(void);
 static void b2_lok(void);
 static void b3_ed(void);
 static void b3_tit(void);
 static void b3_lok(void);
 static void m1_aut(void);
 static void m1_tit(void);
 static void m1_lok(void);
 static void m2_aut(void);
 static void m2_tit(void);
 static void m2_lok(void);



 
/* 
   testmodus==0 read format definition from database file, testmodus==1 
   read format definition from .fde file
 */
 
int list_rfd_main(char * mmodus, int testmodus)
{
  int rueckgabewert;

  rueckgabewert = 1;
  if (testmodus==1)
  {
    wrtxt("\n(Test an .fde-file, this makes a list with the format definition "
        "(*.fde))\n");
  }
  else
  {
    wrtxt("\n(Make a list/macro with a user defined format definition (database))\n");
  }

  if (!strcmp(mmodus,"-m"))
  {
     makromodus = 1;
  }
  else
  {
     makromodus = 0;
  }
  if (!getfilenames_list_rfd(testmodus))
  {
     rueckgabewert=0;
     return rueckgabewert;
  }
  list_rfd_initialize();
  if (dateien_oeffnen_list_rfd())
  {
       if (formdef_datensatz_lesen(testmodus)) 
       {
        machlist_list_rfd();
       }
      dateien_schliessen_list_rfd();
      load_file_yn(txt_name);
  }
  list_rfd_aufraeumen();
  return rueckgabewert;
}

static int getfilenames_list_rfd(int testmodus)
{
   int rueckgabewert;
   int taste;
   char datei[PFAD_LEN+1];
   static char ein[INPUT_BU_LEN+1];
   if (makromodus==0) /* normal list of references */
   {
     if (!dateivornamen_holen(datei,"Please enter name for text file "
        "(default `reflist')"))
     {
        strcpy(datei,"reflist");
     }
   }
   else /* macro */
   {
     if (!dateivornamen_holen(datei,"Please enter name for text file "
        "(default `macro')"))
     {
        strcpy(datei,"macro");
     }
   }
   strlimcpy(txt_name,textpfad,PFAD_LEN);
   strlimcat(txt_name,datei,PFAD_LEN);
   strlimcat(txt_name,".txt",PFAD_LEN);
   if (isfile(txt_name))
   {
     strcpy(ein,"menu");
     wrtxt("\nMenu: text file already exists, overwrite [y/n]?\n");
     taste = menu_wahl(ein,
                       "[y] yes, overwrite existing file\n"
                       "[n] no, do not overwrite existing file");
     if (taste==2)
     {
        rueckgabewert = 0;
        return rueckgabewert;
     }
   }

   /* begin new 28.11.2006 */
   if (testmodus==0)
   {
     wrtxt(LIST_RFD_EXPL1);
   }
   if (testmodus==1)
   {
     wrtxt(LIST_RFD_EXPL2);
   }
   /* end new 28.11.2006 */
   
   taste = datei_suchen_mit_pfad("*.bbt",rdbpfad,bbt_name);
   rueckgabewert = taste; 
   return rueckgabewert;   
}

static int list_rfd_initialize(void)
{
   strlimcpy(temp_formdef_name,rdbpfad,PFAD_LEN);
   strlimcat(temp_formdef_name,TEMP_FORMDEF_NAME,PFAD_LEN);
   if ((fptempformdef=fopen(temp_formdef_name,"wb"))==NULL)
   {
      fprintf(stderr,"\nERROR: Cannot create %s\n",temp_formdef_name);
      exit(1);
   }

   if ((au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR 'List' 'User defined Format' memory allocation\n");
      exit(1);
   }
   if ((ed_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR 'List' 'User defined Format' memory allocation\n");
      exit(1);
   }
   if ((ex_au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR 'List' 'User defined Format' memory allocation\n");
      exit(1);
   }
   if ((ausgabe_zeile =  (char *) malloc((AUSGABEZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR 'List' 'User defined Format' memory allocation\n");
      exit(1);
   }
   if ((desc_zeile =  (char *) malloc((DESC_ZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR 'List' 'User defined Format' memory allocation\n");
      exit(1);
   }
   return 1;
}


static int list_rfd_aufraeumen(void)
{
   free(au_zeile);
   free(ed_zeile);
   free(ex_au_zeile);
   free(ausgabe_zeile);
   free(desc_zeile);
   fclose(fptempformdef);
   if (isfile(temp_formdef_name))
   {
      remove(temp_formdef_name);
   }
   return 1;
}

static int dateien_oeffnen_list_rfd(void)
{
  if (filesize(journal_pix_name)==0)
  {
    wrtxt("ERROR: main index file is empty\n");
    return 0;
  }
  if (!read_ix01(journal_pix_name)) return 0;
  if (!read_ix02(quell_pix_name)) return 0;
  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",journal_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    return 0;
  }
  if ((fpdesc=fopen(desc_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",desc_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    return 0;
  }

  if ((fpbuch=fopen(book_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",book_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    return 0;
  }
  if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",autorjl_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    return 0;
  }
  if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",autorbu_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    return 0;
  }

  if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",bbt_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    return 0;
  }
  if (setvbuf(fpbbt,bbt_buf,_IOFBF,BBTBUF_SIZE)!=0)
  {
    wrtxt("\nERROR: Cannot allocate memory for fpbbt\n");
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    return 0;
  }

  if ((fpsource=fopen(quell_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",quell_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    return 0;
  }

  if ((fptxt=fopen(txt_name,"w"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: write read %s\n",txt_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    fclose(fpsource);
    return 0;
  }
  if (setvbuf(fptxt,txt_buf,_IOFBF,TXTBUF_SIZE)!=0)
  {
    wrtxt("\nERROR: Cannot allocate memory for fptxt\n");
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    fclose(fpsource);
    fclose(fptxt);
    return 0;
  }
  // if (logdatei_oeffnen()==0)
  // {
  //   sprintf(wrtxtbu,"\nERROR: write read %s\n",log_name);
  //   wrtxt(wrtxtbu);
  //   close_ix01();
  //   close_ix02();
  //   fclose(fpjournal);
  //   fclose(fpdesc);
  //   fclose(fpbuch);
  //   fclose(fpautorjl);
  //   fclose(fpautorbu);
  //   fclose(fpbbt);
  //   fclose(fpsource);
  //   fclose(fptxt);
  //   return 0;
  // }

  return 1;
}

static void dateien_schliessen_list_rfd(void)
{
   close_ix01();
   close_ix02();
   fclose(fpjournal);
   fclose(fpdesc);
   fclose(fpbuch);
   fclose(fpautorjl);
   fclose(fpautorbu);
   fclose(fpbbt);
   fclose(fpsource);
   fclose(fptxt);
   // logdatei_schliessen();
}

int test_datensatz_lesen(long rec_zeiger, formdef_rec * one_fd, char * temp_formdef_datei_name)
{
   FILE * fpformdef;
   long byte_zeiger;
   formdef_rec lies_fd;

   if ((fpformdef=fopen(temp_formdef_datei_name,"rb"))==0)
   {
     fprintf(stderr,"\nERROR: cannot read %s\n",formdef_name);
     exit(1);
   }
   byte_zeiger = rec_zeiger * sizeof(formdef_rec);

   fseek(fpformdef,byte_zeiger,SEEK_SET);
   // fread(one_fd,sizeof(formdef_rec),1,fpformdef);
   fread(&lies_fd,sizeof(formdef_rec),1,fpformdef);
   * one_fd = lies_fd;
   fclose(fpformdef);
   return 1;
}




static void machlist_list_rfd(void)
{
   long i, j, byte_zeiger, rec_zeiger, anzahl_records;
   static int taste, ok;
   char zahl[REFZAHL_LEN+1];
   int schleifeok;
   /* long verzoegerung; */
   static char ein[INPUT_BU_LEN+1];

   fseek(fpbbt,0L,SEEK_END);
   byte_zeiger = ftell(fpbbt);
   anzahl_records = byte_zeiger/sizeof(one_bbt_rec);
   anzahl_records--;
   strcpy(zahl,"1");
   if (anzahl_records==-1)
   {
      wrtxt("\nCurrent BBT-file is empty\n");
      return;
   }

   if (!makromodus)
   {
     strcpy(ein,"menu");
     wrtxt("\nMenu: Reference number format [1/2/3/4/q]\n");
     taste = menu_wahl(ein,
       "[1] number only: (n) ...\n"
       "[2] number and reference key: (n) <REFKEY> ...\n"
       "[3] reference key: <REFKEY> ...\n"
       "[4] no leading numbers\n"
       "[q] quit"
       );

   }
   else
   {
      taste = 4;
   }

   if (taste==5)
   {
      return;
   }
     /* folg. Zeile geaendert, wg. %n ist diese Abfrage stets erforderlich */
   if (taste==1 || taste==2 || taste==3 || taste==4)
   {
    schleifeok = 0;
    do
    {
      ein_zeile(zahl,"Number assigned to the first reference (default 1)",REFZAHL_LEN);
      if (strlen(zahl)==0)
      {
        j = 1;
        ok = 1;
      } else
      {
        string_in_long(zahl,&j,&ok);
      }
      if (ok) schleifeok=1; else schleifeok=0;
     }
     while (!schleifeok);
   }

  schleifeok = 0;
  strcpy(zahl,"0");
   /* eingefuegt 24.1.99 */
   sprintf(wrtxtbu,"\n(Compiling %li references)\n",anzahl_records+1);
   wrtxt(wrtxtbu);
   rewind(fpbbt);
   /* begin new 28.11.2006 */
   logdatei_oeffnen();
   /* end new 28.11.2006 */
   for (i=0;i<=anzahl_records;i++)
   {
        sprintf(ordnungszahl,"%li",j);

        if ((i % 100)==0)
        {
           if (i==100) wrtxt("\n");
           if (i>0)
           {
             sprintf(wrtxtbu,"[%li] ",i);
             wrtxt(wrtxtbu);
           }
        }

        fread(&one_bbt_rec, sizeof(one_bbt_rec),1,fpbbt);

        strlimcpy(haupt_schluessel,one_bbt_rec.kennziffer,KENNZIFFER_LEN);
        if (locate_ix01(haupt_schluessel,&ix01rec) > -1)
        {
           rec_zeiger = ix01rec.journal_rptr;
           byte_zeiger = rec_zeiger * sizeof(one_journal_rec);
           fseek(fpjournal,byte_zeiger,SEEK_SET);
           fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

           if (ix01rec.desc_rptr > -1)
           {
              kwdsstr(desc_zeile,ix01rec.desc_rptr);
           }

           if (taste==1) sprintf(ausgabe_zeile,"[%li] ",j);
           else if (taste==2) sprintf(ausgabe_zeile,"[%li] <%s> ",j,haupt_schluessel);
           else if (taste==3) sprintf(ausgabe_zeile,"<%s> ",haupt_schluessel);
           else strcpy(ausgabe_zeile,"");

           if (!strcmp(one_journal_rec.reftyp,"j1")) compile_j1();
           else if (!strcmp(one_journal_rec.reftyp,"j2")) compile_j2();
           else if (!strcmp(one_journal_rec.reftyp,"b1")) compile_b1();
           else if (!strcmp(one_journal_rec.reftyp,"b2")) compile_b2();
           else if (!strcmp(one_journal_rec.reftyp,"b3")) compile_b3();
           else if (!strcmp(one_journal_rec.reftyp,"m1")) compile_m1();
           else compile_m2();

           fprintf(fptxt,"%s\n",ausgabe_zeile);
           if (!makromodus)
           {
               fprintf(fptxt,"\n");
           }

        }
        else
        {
          /* begin new for version 4.1h */
          if (taste==1) sprintf(ausgabe_zeile,"[%li] ",j);
          else if (taste==2) sprintf(ausgabe_zeile,"[%li] <%s> ",j,haupt_schluessel);
          else if (taste==3) sprintf(ausgabe_zeile,"<%s> ",haupt_schluessel);
          else if (taste==4) strcpy(ausgabe_zeile,"");
          else if (taste==5) sprintf(ausgabe_zeile,"*%s*%06li* ",haupt_schluessel,j);
          else sprintf(ausgabe_zeile,"*%s* %s * ",haupt_schluessel,one_bbt_rec.sortierfeld);
          
          if (!makromodus)
          {
             fprintf(fptxt,"%s--%s--\n\n",ausgabe_zeile,one_bbt_rec.kennziffer);
          } else
          {
             fprintf(fptxt,"%s==%s==\n",ausgabe_zeile,one_bbt_rec.kennziffer);
          }
          /* end new for version 4.1h */
          sprintf(wrtxtbu,"# %s: not found",haupt_schluessel);
          logdatei_schreiben(wrtxtbu);
        }
        j++;
   }
   /* begin new 28.11.2006 */
   logdatei_schliessen();
   /* end new 28.11.2006 */
   if (i > 100) wrtxt("\n");
   
   sprintf(wrtxtbu,"\nFormat: %s\n",fd.formatbeschreibung);
   wrtxt(wrtxtbu);
   
   sprintf(wrtxtbu,"\n(Textfile %s written)\n",txt_name);
   wrtxt(wrtxtbu);
}

static int formdef_datensatz_lesen(int testcode)
{
   long mn;
   int ok;
   if (testcode==0)
   {
     formdef_datensatz = fd_datensatz_auswaehlen();
     if (formdef_datensatz < 0)
     {
       return 0;
     }
     datensatz_lesen(formdef_datensatz,&fd);
   } else
   {
      char fde_name[PFAD_LEN+1];
      if (!datei_suchen_mit_pfad("*.fde",textpfad,fde_name))
      {
       return 0;
      }
      if (!textdatei_in_fd(temp_formdef_name,
                           fde_name,
                           0,
                           1))
      {
       return 0;
      }
      test_datensatz_lesen(0,&fd,temp_formdef_name);
   }
   string_in_long(fd.fdau_n_j1,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_n_j1=999; else fdau_n_j1 = mn;
   string_in_long(fd.fdau_n_b1,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_n_b1=999; else fdau_n_b1 = mn;
   string_in_long(fd.fdau_n_b2au,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_n_b2au=999; else fdau_n_b2au = mn;
   string_in_long(fd.fdau_n_b2ed,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_n_b2ed=999; else fdau_n_b2ed = mn;
   string_in_long(fd.fdau_n_m1,&mn,&ok);  /* new for v4.1*/
   if (!ok || mn < 1 || mn > 999) fdau_n_m1=999; else fdau_n_m1 = mn;  /* new for v4.1*/

   string_in_long(fd.fdau_m_j1,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_m_j1=999; else fdau_m_j1 = mn;
   string_in_long(fd.fdau_m_b1,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_m_b1=999; else fdau_m_b1 = mn;
   string_in_long(fd.fdau_m_b2au,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_m_b2au=999; else fdau_m_b2au = mn;
   string_in_long(fd.fdau_m_b2ed,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_m_b2ed=999; else fdau_m_b2ed = mn;
   string_in_long(fd.fdau_m_m1,&mn,&ok);  /* new for v4.1*/
   if (!ok || mn < 1 || mn > 999) fdau_m_m1=999; else fdau_m_m1 = mn;  /* new for v4.1*/


   /* die folgenden 4 Zeilen eingefuegt am 12.07.1997 */
   if (fdau_n_j1 < fdau_m_j1) fdau_n_j1 = fdau_m_j1;
   if (fdau_n_b1 < fdau_m_b1) fdau_n_b1 = fdau_m_b1;
   if (fdau_n_b2au < fdau_m_b2au) fdau_n_b2au = fdau_m_b2au;
   if (fdau_n_b2ed < fdau_m_b2ed) fdau_n_b2ed = fdau_m_b2ed;
   if (fdau_n_m1 < fdau_m_m1) fdau_n_m1 = fdau_m_m1;  /* new for v4.1*/

   exarg01(fd.fdbetwau_j1);
   exarg01(fd.fdbetwau_b1);
   exarg01(fd.fdbetwau_b2au);
   exarg01(fd.fdbetwau_b2ed);
   exarg01(fd.fdbetwau_m1);

   exarg01(fd.fdbetwaulast_j1);
   exarg01(fd.fdbetwaulast_b1);
   exarg01(fd.fdbetwaulast_b2au);
   exarg01(fd.fdbetwaulast_b2ed);
   exarg01(fd.fdbetwaulast_m1);

   exarg01(fd.fdv_j1);
   exarg01(fd.fdv_b1);
   exarg01(fd.fdv_b2au);
   exarg01(fd.fdv_b2ed);
   exarg01(fd.fdv_m1);

   exarg01(fd.fdauvornach_j1);
   exarg01(fd.fdauvornach_b1);
   exarg01(fd.fdauvornach_b2au);
   exarg01(fd.fdauvornach_b2ed);
   exarg01(fd.fdauvornach_m1);

   exarg01(fd.fdaunachvor_j1);
   exarg01(fd.fdaunachvor_b1);
   exarg01(fd.fdaunachvor_b2au);
   exarg01(fd.fdaunachvor_b2ed);
   exarg01(fd.fdaunachvor_m1);

   exarg01(fd.fdafterlastau_j1);
   exarg01(fd.fdafterlastau_b1);
   exarg01(fd.fdafterlastau_b2au);
   exarg01(fd.fdafterlastau_b2ed);
   exarg01(fd.fdafterlastau_m1);

   exarg01(fd.fdweitereau_j1);
   exarg01(fd.fdweitereau_b1);
   exarg01(fd.fdweitereau_b2au);
   exarg01(fd.fdweitereau_b2ed);
   exarg01(fd.fdweitereau_m1);

   return 1;
}
static void exarg01(char * zeile)
{
   char hilfsvar[FD_FELD_LEN + 1];
   if (extractargument("%()", zeile, hilfsvar)==1)
       strcpy(zeile,hilfsvar);
}

static void compile_j1(void)
{
   if (!strcmp(fd.fdauttyp_j1,"3"))
   {
     fdautorenstr3(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_j1,
                  fd.fdbetwaulast_j1,
                  fd.fdv_j1,
                  fd.fdauvornach_j1,
                  fd.fdaunachvor_j1,
                  fd.fdafterlastau_j1,
                  fd.fdweitereau_j1,
                  fdau_n_j1,
                  fdau_m_j1
                 );
   }
   else if (!strcmp(fd.fdauttyp_j1,"2"))
   {
     fdautorenstr2(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_j1,
                  fd.fdbetwaulast_j1,
                  fd.fdv_j1,
                  fd.fdauvornach_j1,
                  fd.fdaunachvor_j1,
                  fd.fdafterlastau_j1,
                  fd.fdweitereau_j1,
                  fdau_n_j1,
                  fdau_m_j1
                 );
   }
   else if (!strcmp(fd.fdauttyp_j1,"1"))
   {
     fdautorenstr1(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_j1,
                  fd.fdbetwaulast_j1,
                  fd.fdv_j1,
                  fd.fdauvornach_j1,
                  fd.fdaunachvor_j1,
                  fd.fdafterlastau_j1,
                  fd.fdweitereau_j1,
                  fdau_n_j1,
                  fdau_m_j1
                  );
   }
   else
   {
     fdautorenstr0(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_j1,
                  fd.fdbetwaulast_j1,
                  fd.fdv_j1,
                  fd.fdauvornach_j1,
                  fd.fdaunachvor_j1,
                  fd.fdafterlastau_j1,
                  fd.fdweitereau_j1,
                  fdau_n_j1,
                  fdau_m_j1
                  );
   }




   strncpy(quell_schluessel,one_journal_rec.kuerzel,KUERZEL_LEN);
   if (locate_ix02(quell_schluessel,&ix02rec) > -1)
   {
       long byte_zeiger;
       byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
       fseek(fpsource,byte_zeiger,SEEK_SET);
       fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);
   }
   else
   {
      strcpy(one_quell_rec.quell_zeitschrift,"[");
      strcat(one_quell_rec.quell_zeitschrift,quell_schluessel);
      strcat(one_quell_rec.quell_zeitschrift,"]");
      strcpy(one_quell_rec.quell_kurzform,"");

      // fprintf(fplog,"# %s: JOURNAL name corresponding to [%s] not found\n",haupt_schluessel,quell_schluessel);
      sprintf(wrtxtbu,"# %s: JOURNAL name corresponding to [%s] not found",haupt_schluessel,quell_schluessel);
      logdatei_schreiben(wrtxtbu);
   }



   if (!strcmp(fd.fdj1_str1,"%au"))
   {
     j1_aut();
   }
   if (!strcmp(fd.fdj1_str1,"%ti"))
   {
     j1_tit();
   }
   if (!strcmp(fd.fdj1_str1,"%lo"))
   {
     j1_lok();
   }

   if (!strcmp(fd.fdj1_str2,"%au"))
   {
     j1_aut();
   }
   if (!strcmp(fd.fdj1_str2,"%ti"))
   {
     j1_tit();
   }
   if (!strcmp(fd.fdj1_str2,"%lo"))
   {
     j1_lok();
   }

   if (!strcmp(fd.fdj1_str3,"%au"))
   {
     j1_aut();
   }
   if (!strcmp(fd.fdj1_str3,"%ti"))
   {
     j1_tit();
   }
   if (!strcmp(fd.fdj1_str3,"%lo"))
   {
     j1_lok();
   }
}

static void compile_j2(void)
{

   strncpy(quell_schluessel,one_journal_rec.kuerzel,KUERZEL_LEN);
   if (locate_ix02(quell_schluessel,&ix02rec) > -1)
   {
       long byte_zeiger;
       byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
       fseek(fpsource,byte_zeiger,SEEK_SET);
       fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);
   }
   else
   {
      strcpy(one_quell_rec.quell_zeitschrift,"[");
      strcat(one_quell_rec.quell_zeitschrift,quell_schluessel);
      strcat(one_quell_rec.quell_zeitschrift,"]");
      strcpy(one_quell_rec.quell_kurzform,"");

      sprintf(wrtxtbu,"# %s: JOURNAL name corresponding to [%s] not found",haupt_schluessel,quell_schluessel);
      logdatei_schreiben(wrtxtbu);
   }


   if (!strcmp(fd.fdj2_str1,"%au"))
   {
     j2_aut();
   }
   if (!strcmp(fd.fdj2_str1,"%ti"))
   {
     j2_tit();
   }
   if (!strcmp(fd.fdj2_str1,"%lo"))
   {
     j2_lok();
   }

   if (!strcmp(fd.fdj2_str2,"%au"))
   {
     j2_aut();
   }
   if (!strcmp(fd.fdj2_str2,"%ti"))
   {
     j2_tit();
   }
   if (!strcmp(fd.fdj2_str2,"%lo"))
   {
     j2_lok();
   }

   if (!strcmp(fd.fdj2_str3,"%au"))
   {
     j2_aut();
   }
   if (!strcmp(fd.fdj2_str3,"%ti"))
   {
     j2_tit();
   }
   if (!strcmp(fd.fdj2_str3,"%lo"))
   {
     j2_lok();
   }
}



static void compile_b1(void)
{
   long byte_zeiger;

   if (!strcmp(fd.fdauttyp_b1,"3"))
   {
     fdedmax = fdautorenstr3(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b1,
                  fd.fdbetwaulast_b1,
                  fd.fdv_b1,
                  fd.fdauvornach_b1,
                  fd.fdaunachvor_b1,
                  fd.fdafterlastau_b1,
                  fd.fdweitereau_b1,
                  fdau_n_b1,
                  fdau_m_b1
                 );
   }
   else if (!strcmp(fd.fdauttyp_b1,"2"))
   {
     fdedmax = fdautorenstr2(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b1,
                  fd.fdbetwaulast_b1,
                  fd.fdv_b1,
                  fd.fdauvornach_b1,
                  fd.fdaunachvor_b1,
                  fd.fdafterlastau_b1,
                  fd.fdweitereau_b1,
                  fdau_n_b1,
                  fdau_m_b1
                 );
   }
   else if (!strcmp(fd.fdauttyp_b1,"1"))
   {
     fdedmax = fdautorenstr1(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b1,
                  fd.fdbetwaulast_b1,
                  fd.fdv_b1,
                  fd.fdauvornach_b1,
                  fd.fdaunachvor_b1,
                  fd.fdafterlastau_b1,
                  fd.fdweitereau_b1,
                  fdau_n_b1,
                  fdau_m_b1
                  );
   }
   else
   {
     fdedmax = fdautorenstr0(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b1,
                  fd.fdbetwaulast_b1,
                  fd.fdv_b1,
                  fd.fdauvornach_b1,
                  fd.fdaunachvor_b1,
                  fd.fdafterlastau_b1,
                  fd.fdweitereau_b1,
                  fdau_n_b1,
                  fdau_m_b1
                  );
   }

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

   if (!strcmp(fd.fdb1_str1,"%ed"))
   {
     b1_ed();
   }
   if (!strcmp(fd.fdb1_str1,"%bo"))
   {
     b1_tit();
   }
   if (!strcmp(fd.fdb1_str1,"%lo"))
   {
     b1_lok();
   }

   if (!strcmp(fd.fdb1_str2,"%ed"))
   {
     b1_ed();
   }
   if (!strcmp(fd.fdb1_str2,"%bo"))
   {
     b1_tit();
   }
   if (!strcmp(fd.fdb1_str2,"%lo"))
   {
     b1_lok();
   }

   if (!strcmp(fd.fdb1_str3,"%ed"))
   {
     b1_ed();
   }
   if (!strcmp(fd.fdb1_str3,"%bo"))
   {
     b1_tit();
   }
   if (!strcmp(fd.fdb1_str3,"%lo"))
   {
     b1_lok();
   }

   return;
}



static void compile_b2(void)
{
   long byte_zeiger;

   if (!strcmp(fd.fdauttyp_b2au,"3"))
   {
     fdautorenstr3(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_b2au,
                  fd.fdbetwaulast_b2au,
                  fd.fdv_b2au,
                  fd.fdauvornach_b2au,
                  fd.fdaunachvor_b2au,
                  fd.fdafterlastau_b2au,
                  fd.fdweitereau_b2au,
                  fdau_n_b2au,
                  fdau_m_b2au
                 );
   }
   else if (!strcmp(fd.fdauttyp_b2au,"2"))
   {
     fdautorenstr2(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_b2au,
                  fd.fdbetwaulast_b2au,
                  fd.fdv_b2au,
                  fd.fdauvornach_b2au,
                  fd.fdaunachvor_b2au,
                  fd.fdafterlastau_b2au,
                  fd.fdweitereau_b2au,
                  fdau_n_b2au,
                  fdau_m_b2au
                 );
   }
   else if (!strcmp(fd.fdauttyp_b2au,"1"))
   {
     fdautorenstr1(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_b2au,
                  fd.fdbetwaulast_b2au,
                  fd.fdv_b2au,
                  fd.fdauvornach_b2au,
                  fd.fdaunachvor_b2au,
                  fd.fdafterlastau_b2au,
                  fd.fdweitereau_b2au,
                  fdau_n_b2au,
                  fdau_m_b2au
                  );
   }
   else
   {
     fdautorenstr0(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_b2au,
                  fd.fdbetwaulast_b2au,
                  fd.fdv_b2au,
                  fd.fdauvornach_b2au,
                  fd.fdaunachvor_b2au,
                  fd.fdafterlastau_b2au,
                  fd.fdweitereau_b2au,
                  fdau_n_b2au,
                  fdau_m_b2au
                  );
   }



   if (!strcmp(fd.fdauttyp_b2ed,"3"))
   {
     fdedmax = fdautorenstr3(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b2ed,
                  fd.fdbetwaulast_b2ed,
                  fd.fdv_b2ed,
                  fd.fdauvornach_b2ed,
                  fd.fdaunachvor_b2ed,
                  fd.fdafterlastau_b2ed,
                  fd.fdweitereau_b2ed,
                  fdau_n_b2ed,
                  fdau_m_b2ed
                 );
   }
   else if (!strcmp(fd.fdauttyp_b2ed,"2"))
   {
     fdedmax = fdautorenstr2(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b2ed,
                  fd.fdbetwaulast_b2ed,
                  fd.fdv_b2ed,
                  fd.fdauvornach_b2ed,
                  fd.fdaunachvor_b2ed,
                  fd.fdafterlastau_b2ed,
                  fd.fdweitereau_b2ed,
                  fdau_n_b2ed,
                  fdau_m_b2ed
                 );
   }
   else if (!strcmp(fd.fdauttyp_b2ed,"1"))
   {
     fdedmax = fdautorenstr1(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b2ed,
                  fd.fdbetwaulast_b2ed,
                  fd.fdv_b2ed,
                  fd.fdauvornach_b2ed,
                  fd.fdaunachvor_b2ed,
                  fd.fdafterlastau_b2ed,
                  fd.fdweitereau_b2ed,
                  fdau_n_b2ed,
                  fdau_m_b2ed
                  );
   }
   else
   {
     fdedmax = fdautorenstr0(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b2ed,
                  fd.fdbetwaulast_b2ed,
                  fd.fdv_b2ed,
                  fd.fdauvornach_b2ed,
                  fd.fdaunachvor_b2ed,
                  fd.fdafterlastau_b2ed,
                  fd.fdweitereau_b2ed,
                  fdau_n_b2ed,
                  fdau_m_b2ed
                  );
   }


   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);


   if (!strcmp(fd.fdb2_str1,"%ed"))
   {
     b2_ed();
   }
   if (!strcmp(fd.fdb2_str1,"%au"))
   {
     b2_aut();
   }
   if (!strcmp(fd.fdb2_str1,"%ti"))
   {
     b2_tit();
   }
   if (!strcmp(fd.fdb2_str1,"%bo"))
   {
     b2_titb();
   }
   if (!strcmp(fd.fdb2_str1,"%lo"))
   {
     b2_lok();
   }


   if (!strcmp(fd.fdb2_str2,"%ed"))
   {
     b2_ed();
   }
   if (!strcmp(fd.fdb2_str2,"%au"))
   {
     b2_aut();
   }
   if (!strcmp(fd.fdb2_str2,"%ti"))
   {
     b2_tit();
   }
   if (!strcmp(fd.fdb2_str2,"%bo"))
   {
     b2_titb();
   }
   if (!strcmp(fd.fdb2_str2,"%lo"))
   {
     b2_lok();
   }



   if (!strcmp(fd.fdb2_str3,"%ed"))
   {
     b2_ed();
   }
   if (!strcmp(fd.fdb2_str3,"%au"))
   {
     b2_aut();
   }
   if (!strcmp(fd.fdb2_str3,"%ti"))
   {
     b2_tit();
   }
   if (!strcmp(fd.fdb2_str3,"%bo"))
   {
     b2_titb();
   }
   if (!strcmp(fd.fdb2_str3,"%lo"))
   {
     b2_lok();
   }

   if (!strcmp(fd.fdb2_str4,"%ed"))
   {
     b2_ed();
   }
   if (!strcmp(fd.fdb2_str4,"%au"))
   {
     b2_aut();
   }
   if (!strcmp(fd.fdb2_str4,"%ti"))
   {
     b2_tit();
   }
   if (!strcmp(fd.fdb2_str4,"%bo"))
   {
     b2_titb();
   }
   if (!strcmp(fd.fdb2_str4,"%lo"))
   {
     b2_lok();
   }


   if (!strcmp(fd.fdb2_str5,"%ed"))
   {
     b2_ed();
   }
   if (!strcmp(fd.fdb2_str5,"%au"))
   {
     b2_aut();
   }
   if (!strcmp(fd.fdb2_str5,"%ti"))
   {
     b2_tit();
   }
   if (!strcmp(fd.fdb2_str5,"%bo"))
   {
     b2_titb();
   }
   if (!strcmp(fd.fdb2_str5,"%lo"))
   {
     b2_lok();
   }
   return;
}

static void compile_b3(void)
{
   long byte_zeiger;

   // if (!strcmp(fd.fdauttyp_b1,"3"))
   // {
   //   fdedmax = fdautorenstr3(fpautorbu,
   //                ed_zeile,
   //                ix01rec.autorbu_rptr,
   //                fd.fdbetwau_b1,
   //                fd.fdbetwaulast_b1,
   //                fd.fdv_b1,
   //                fd.fdauvornach_b1,
   //                fd.fdaunachvor_b1,
   //                fd.fdafterlastau_b1,
   //                fd.fdweitereau_b1,
   //                fdau_n_b1,
   //                fdau_m_b1
   //               );
   // }
   // else if (!strcmp(fd.fdauttyp_b1,"2"))
   // {
   //   fdedmax = fdautorenstr2(fpautorbu,
   //                ed_zeile,
   //                ix01rec.autorbu_rptr,
   //                fd.fdbetwau_b1,
   //                fd.fdbetwaulast_b1,
   //                fd.fdv_b1,
   //                fd.fdauvornach_b1,
   //                fd.fdaunachvor_b1,
   //                fd.fdafterlastau_b1,
   //                fd.fdweitereau_b1,
   //                fdau_n_b1,
   //                fdau_m_b1
   //               );
   // }
   // else if (!strcmp(fd.fdauttyp_b1,"1"))
   // {
   //   fdedmax = fdautorenstr1(fpautorbu,
   //                ed_zeile,
   //                ix01rec.autorbu_rptr,
   //                fd.fdbetwau_b1,
   //                fd.fdbetwaulast_b1,
   //                fd.fdv_b1,
   //                fd.fdauvornach_b1,
   //                fd.fdaunachvor_b1,
   //                fd.fdafterlastau_b1,
   //                fd.fdweitereau_b1,
   //                fdau_n_b1,
   //                fdau_m_b1
   //                );
   // }
   // else
   // {
   //   fdedmax = fdautorenstr0(fpautorbu,
   //                ed_zeile,
   //                ix01rec.autorbu_rptr,
   //                fd.fdbetwau_b1,
   //                fd.fdbetwaulast_b1,
   //                fd.fdv_b1,
   //                fd.fdauvornach_b1,
   //                fd.fdaunachvor_b1,
   //                fd.fdafterlastau_b1,
   //                fd.fdweitereau_b1,
   //                fdau_n_b1,
   //                fdau_m_b1
   //                );
   // }

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

   if (!strcmp(fd.fdb3_str1,"%ed"))
   {
     b3_ed();
   }
   if (!strcmp(fd.fdb3_str1,"%bo"))
   {
     b3_tit();
   }
   if (!strcmp(fd.fdb3_str1,"%lo"))
   {
     b3_lok();
   }

   if (!strcmp(fd.fdb3_str2,"%ed"))
   {
     b3_ed();
   }
   if (!strcmp(fd.fdb3_str2,"%bo"))
   {
     b3_tit();
   }
   if (!strcmp(fd.fdb3_str2,"%lo"))
   {
     b3_lok();
   }

   if (!strcmp(fd.fdb3_str3,"%ed"))
   {
     b3_ed();
   }
   if (!strcmp(fd.fdb3_str3,"%bo"))
   {
     b3_tit();
   }
   if (!strcmp(fd.fdb3_str3,"%lo"))
   {
     b3_lok();
   }

   return;
}

static void compile_m1(void)
{
   if (!strcmp(fd.fdauttyp_m1,"3"))
   {
     fdautorenstr3(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_m1,
                  fd.fdbetwaulast_m1,
                  fd.fdv_m1,
                  fd.fdauvornach_m1,
                  fd.fdaunachvor_m1,
                  fd.fdafterlastau_m1,
                  fd.fdweitereau_m1,
                  fdau_n_m1,
                  fdau_m_m1
                 );
   }
   else if (!strcmp(fd.fdauttyp_m1,"2"))
   {
     fdautorenstr2(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_m1,
                  fd.fdbetwaulast_m1,
                  fd.fdv_m1,
                  fd.fdauvornach_m1,
                  fd.fdaunachvor_m1,
                  fd.fdafterlastau_m1,
                  fd.fdweitereau_m1,
                  fdau_n_m1,
                  fdau_m_m1
                 );
   }
   else if (!strcmp(fd.fdauttyp_m1,"1"))
   {
     fdautorenstr1(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_m1,
                  fd.fdbetwaulast_m1,
                  fd.fdv_m1,
                  fd.fdauvornach_m1,
                  fd.fdaunachvor_m1,
                  fd.fdafterlastau_m1,
                  fd.fdweitereau_m1,
                  fdau_n_m1,
                  fdau_m_m1
                  );
   }
   else
   {
     fdautorenstr0(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_m1,
                  fd.fdbetwaulast_m1,
                  fd.fdv_m1,
                  fd.fdauvornach_m1,
                  fd.fdaunachvor_m1,
                  fd.fdafterlastau_m1,
                  fd.fdweitereau_m1,
                  fdau_n_m1,
                  fdau_m_m1
                  );
   }



   /* this and the if ..else construct should be removed for v4.1  */

   // strncpy(quell_schluessel,one_journal_rec.kuerzel,KUERZEL_LEN);
   // if (locate_ix02(quell_schluessel,&ix02rec) > -1)
   // {
   //     long byte_zeiger;
   //     byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
   //     fseek(fpsource,byte_zeiger,SEEK_SET);
   //     fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);
   // }
   // else
   // {
   //    strcpy(one_quell_rec.quell_zeitschrift,"[");
   //    strcat(one_quell_rec.quell_zeitschrift,quell_schluessel);
   //    strcat(one_quell_rec.quell_zeitschrift,"]");
   //    strcpy(one_quell_rec.quell_kurzform,"");

   //    // fprintf(fplog,"# %s: JOURNAL name corresponding to [%s] not found\n",haupt_schluessel,quell_schluessel);
   //    sprintf(wrtxtbu,"# %s: JOURNAL name corresponding to [%s] not found",haupt_schluessel,quell_schluessel);
   //    logdatei_schreiben(wrtxtbu);
   // }



   if (!strcmp(fd.fdm1_str1,"%au"))
   {
     m1_aut();
   }
   if (!strcmp(fd.fdm1_str1,"%ti"))
   {
     m1_tit();
   }
   if (!strcmp(fd.fdm1_str1,"%lo"))
   {
     m1_lok();
   }

   if (!strcmp(fd.fdm1_str2,"%au"))
   {
     m1_aut();
   }
   if (!strcmp(fd.fdm1_str2,"%ti"))
   {
     m1_tit();
   }
   if (!strcmp(fd.fdm1_str2,"%lo"))
   {
     m1_lok();
   }

   if (!strcmp(fd.fdm1_str3,"%au"))
   {
     m1_aut();
   }
   if (!strcmp(fd.fdm1_str3,"%ti"))
   {
     m1_tit();
   }
   if (!strcmp(fd.fdm1_str3,"%lo"))
   {
     m1_lok();
   }
}

static void compile_m2(void)
{


   /* this and the if ..else construct should be removed for v4.1  */
   // strncpy(quell_schluessel,one_journal_rec.kuerzel,KUERZEL_LEN);
   // if (locate_ix02(quell_schluessel,&ix02rec) > -1)
   // {
   //     long byte_zeiger;
   //     byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
   //     fseek(fpsource,byte_zeiger,SEEK_SET);
   //     fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);
   // }
   // else
   // {
   //    strcpy(one_quell_rec.quell_zeitschrift,"[");
   //    strcat(one_quell_rec.quell_zeitschrift,quell_schluessel);
   //    strcat(one_quell_rec.quell_zeitschrift,"]");
   //    strcpy(one_quell_rec.quell_kurzform,"");

   //    sprintf(wrtxtbu,"# %s: JOURNAL name corresponding to [%s] not found",haupt_schluessel,quell_schluessel);
   //    logdatei_schreiben(wrtxtbu);
   // }


   if (!strcmp(fd.fdm2_str1,"%au"))
   {
     m2_aut();
   }
   if (!strcmp(fd.fdm2_str1,"%ti"))
   {
     m2_tit();
   }
   if (!strcmp(fd.fdm2_str1,"%lo"))
   {
     m2_lok();
   }

   if (!strcmp(fd.fdm2_str2,"%au"))
   {
     m2_aut();
   }
   if (!strcmp(fd.fdm2_str2,"%ti"))
   {
     m2_tit();
   }
   if (!strcmp(fd.fdm2_str2,"%lo"))
   {
     m2_lok();
   }

   if (!strcmp(fd.fdm2_str3,"%au"))
   {
     m2_aut();
   }
   if (!strcmp(fd.fdm2_str3,"%ti"))
   {
     m2_tit();
   }
   if (!strcmp(fd.fdm2_str3,"%lo"))
   {
     m2_lok();
   }
}



static int fdautorenstr0(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  )
{
   int anzahl_n, i, etalzufuegen;
   long byte_zeiger;
   char fdzwiau[FD_FELD_LEN+1];
   strcpy(auedstring,"");
   etalzufuegen = 0;
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);

   strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
   anzahl_n = one_aued_rec.au_n;
   for (i=2;i<=anzahl_n;i++)
   {
        /* die if-Bedingung eingefuegt am 12.7.1997 */
        if (fdau_m==1 && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }

        if (i < anzahl_n) strcpy(fdzwiau,fdbetwau); else strcpy(fdzwiau,fdbetwaulast);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
        strlimcat(auedstring,fdzwiau,AUTORZEILE_LEN);
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
        if (i==fdau_m && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }
   }
   if (etalzufuegen) strlimcat(auedstring,fdweitereau,AUTORZEILE_LEN);
         else strlimcat(auedstring,fdafterlastau,AUTORZEILE_LEN);
   return anzahl_n;
}




static int fdautorenstr1(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  )
{
   int anzahl_n, i, etalzufuegen;
   long byte_zeiger;
   char fdzwiau[FD_FELD_LEN+1];
   char vn[2];

   int n_vornamen, k;
   strcpy(auedstring,"");
   etalzufuegen = 0;
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);

   strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
   strlimcat(auedstring,fdaunachvor,AUTORZEILE_LEN);
   n_vornamen=strlen(one_aued_rec.au_vornamen);
   for (k=0;k<=n_vornamen-1;k++)
   {
      vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
      strlimcat(auedstring,vn,AUTORZEILE_LEN);
      strlimcat(auedstring,fdv,AUTORZEILE_LEN);
   }
   rtrim(auedstring,' ');

   anzahl_n = one_aued_rec.au_n;
   for (i=2;i<=anzahl_n;i++)
   {
        /* die if-Bedingung eingefuegt am 12.7.1997 */
        if (fdau_m==1 && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }

        if (i < anzahl_n) strcpy(fdzwiau,fdbetwau); else strcpy(fdzwiau,fdbetwaulast);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
        strlimcat(auedstring,fdzwiau,AUTORZEILE_LEN);
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
        strlimcat(auedstring,fdaunachvor,AUTORZEILE_LEN);

        n_vornamen=strlen(one_aued_rec.au_vornamen);
        for (k=0;k<=n_vornamen-1;k++)
        {
           vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
           strlimcat(auedstring,vn,AUTORZEILE_LEN);
           strlimcat(auedstring,fdv,AUTORZEILE_LEN);
        }
        rtrim(auedstring,' ');
        if (i==fdau_m && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }
   }
   if (etalzufuegen) strlimcat(auedstring,fdweitereau,AUTORZEILE_LEN);
         else strlimcat(auedstring,fdafterlastau,AUTORZEILE_LEN);
   return anzahl_n;
}


static int fdautorenstr2(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  )
{
   int anzahl_n, i, etalzufuegen;
   long byte_zeiger;
   char fdzwiau[FD_FELD_LEN+1];
   char vn[2];

   int n_vornamen, k;
   strcpy(auedstring,"");
   etalzufuegen = 0;
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);


   n_vornamen=strlen(one_aued_rec.au_vornamen);
   for (k=0;k<=n_vornamen-1;k++)
   {
      vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
      strlimcat(auedstring,vn,AUTORZEILE_LEN);
      strlimcat(auedstring,fdv,AUTORZEILE_LEN);
   }
   rtrim(auedstring,' ');
   strlimcat(auedstring,fdauvornach,AUTORZEILE_LEN);
   strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);


   anzahl_n = one_aued_rec.au_n;
   for (i=2;i<=anzahl_n;i++)
   {

        /* die if-Bedingung eingefuegt am 12.7.1997 */
        if (fdau_m==1 && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }

        if (i < anzahl_n) strcpy(fdzwiau,fdbetwau); else strcpy(fdzwiau,fdbetwaulast);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);

        strlimcat(auedstring,fdzwiau,AUTORZEILE_LEN);
        n_vornamen=strlen(one_aued_rec.au_vornamen);
        for (k=0;k<=n_vornamen-1;k++)
        {
           vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
           strlimcat(auedstring,vn,AUTORZEILE_LEN);
           strlimcat(auedstring,fdv,AUTORZEILE_LEN);
        }

        rtrim(auedstring,' ');
        strlimcat(auedstring,fdauvornach,AUTORZEILE_LEN);
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
        if (i==fdau_m && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }
   }
   if (etalzufuegen) strlimcat(auedstring,fdweitereau,AUTORZEILE_LEN);
         else strlimcat(auedstring,fdafterlastau,AUTORZEILE_LEN);
   return anzahl_n;
}


static int fdautorenstr3(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  )
{
   int anzahl_n, i, etalzufuegen;
   long byte_zeiger;
   char fdzwiau[FD_FELD_LEN+1];
   char vn[2];

   int n_vornamen, k;
   strcpy(auedstring,"");
   etalzufuegen = 0;
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);

   strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
   strlimcat(auedstring,fdaunachvor,AUTORZEILE_LEN);
   n_vornamen=strlen(one_aued_rec.au_vornamen);
   for (k=0;k<=n_vornamen-1;k++)
   {
      vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
      strlimcat(auedstring,vn,AUTORZEILE_LEN);
      strlimcat(auedstring,fdv,AUTORZEILE_LEN);
   }

   rtrim(auedstring,' ');

   anzahl_n = one_aued_rec.au_n;
   for (i=2;i<=anzahl_n;i++)
   {

        /* die if-Bedingung eingefuegt am 12.7.1997 */
        if (fdau_m==1 && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }

        if (i < anzahl_n) strcpy(fdzwiau,fdbetwau); else strcpy(fdzwiau,fdbetwaulast);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);

        strlimcat(auedstring,fdzwiau,AUTORZEILE_LEN);
        n_vornamen=strlen(one_aued_rec.au_vornamen);
        for (k=0;k<=n_vornamen-1;k++)
        {
           vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
           strlimcat(auedstring,vn,AUTORZEILE_LEN);
           strlimcat(auedstring,fdv,AUTORZEILE_LEN);
        }

        rtrim(auedstring,' ');
        strlimcat(auedstring,fdauvornach,AUTORZEILE_LEN);
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);

        if (i==fdau_m && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }
   }
   if (etalzufuegen) strlimcat(auedstring,fdweitereau,AUTORZEILE_LEN);
         else strlimcat(auedstring,fdafterlastau,AUTORZEILE_LEN);
   return anzahl_n;
}


static int kwdsstr(char * desc_zeile, long zeiger)
{
   int n_desc, i;
   long byte_zeiger;

   strcpy(desc_zeile,"");
   byte_zeiger = zeiger * sizeof(one_desc_rec);
   fseek(fpdesc,byte_zeiger,SEEK_SET);
   fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
   n_desc = one_desc_rec.desc_n;
   fseek(fpdesc,byte_zeiger,SEEK_SET);
   for (i=1;i<=n_desc;i++)
   {
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      strlimcat(desc_zeile,one_desc_rec.keywordsfield,DESC_ZEILE_LEN);
      if (i < n_desc)
      {
         strlimcat(desc_zeile,", ",DESC_ZEILE_LEN);
      }
   }
   return 1;
}


static void j1_aut(void)
{
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   int i;
   for (i=0;i<J1_AUT_N;i++)
   {
     if (!strcmp(fd.j1_aut[i],"%auth"))
     {
        strlimcat(ausgabe_zeile,au_zeile,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.j1_aut[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.j1_aut[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.j1_aut[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.j1_aut[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.j1_aut[i],AUSGABEZEILE_LEN);
   }
}


static void j1_tit(void)
{
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   int i;
   for (i=0;i<J1_TIT_N;i++)
   {
     if (!strcmp(fd.j1_tit[i],"%title"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.j1_tit[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.j1_tit[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.j1_tit[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_tit[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_tit[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_tit[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_tit[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }

     else if  (!strcmp(fd.j1_tit[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.j1_tit[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.j1_tit[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.j1_tit[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.j1_tit[i],AUSGABEZEILE_LEN);
   }
}



static void j1_lok(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   char quell_kurz_del[2*KURZFORM_LEN + 1];
   for (i=0;i<J1_LOK_N;i++)
   {
     if (!strcmp(fd.j1_lok[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%month"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.monat,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%m()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.monat) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%day"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.tag,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%d()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.tag) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.j1_lok[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.j1_lok[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%journ"))
     {
        strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%journsh"))
     {
        if (strlen(one_quell_rec.quell_kurzform) > 0)
          strlimcat(ausgabe_zeile,one_quell_rec.quell_kurzform,AUSGABEZEILE_LEN);
        else
        strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%issn"))
     {
        strlimcat(ausgabe_zeile,one_quell_rec.quell_issn,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%isn()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_quell_rec.quell_issn) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     // else if (!strcmp(fd.j1_lok[i],"%journ4l"))
     else if (!strcmp(fd.j1_lok[i],"%journ4l") || !strcmp(fd.j1_lok[i],"%journkey"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.kuerzel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%status"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.status,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%js()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_quell_rec.quell_kurzform) > 0)
        {
          fdjsdelimiter(one_quell_rec.quell_kurzform, quell_kurz_del, argument1, 2*KURZFORM_LEN);
          strlimcat(ausgabe_zeile,quell_kurz_del,AUSGABEZEILE_LEN);
        }
        else
        strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%volume"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%v()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%issuenum"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.issue_nummer,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%inu()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.issue_nummer) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%pagefrom"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%pageto"))
     {
        if (strlen(one_journal_rec.seite_bis)==0 || strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0)
        {
          strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile, one_journal_rec.seite_bis, AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.j1_lok[i],"%pagetosh"))
     {
        seitenziffern(one_journal_rec.seite_von, one_journal_rec.seite_bis);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%pgs()",fd.j1_lok[i],argument1))
     {
        if (strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0
           || strlen(one_journal_rec.seite_bis)==0)
        {
           strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.j1_lok[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%kwds"))
     {
        strlimcat(ausgabe_zeile,desc_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%p()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.seite_von) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }

     else strlimcat(ausgabe_zeile,fd.j1_lok[i],AUSGABEZEILE_LEN);
   }
}

static void j2_aut(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<J2_AUT_N;i++)
   {
     if (!strcmp(fd.j2_aut[i],"%auth"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.instau,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%ina()",fd.j2_aut[i],argument1))
     {
        if (strlen(one_journal_rec.instau) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.j2_aut[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.j2_aut[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.j2_aut[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_aut[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_aut[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_aut[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_aut[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_aut[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_aut[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_aut[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.j2_aut[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.j2_aut[i],AUSGABEZEILE_LEN);
   }
}


static void j2_tit(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<J2_TIT_N;i++)
   {
     if (!strcmp(fd.j2_tit[i],"%title"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.j2_tit[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.j2_tit[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.j2_tit[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_tit[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_tit[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_tit[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_tit[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }

     else if  (!strcmp(fd.j2_tit[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.j2_tit[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.j2_tit[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.j2_tit[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.j2_tit[i],AUSGABEZEILE_LEN);
   }
}



static void j2_lok(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   char quell_kurz_del[2*KURZFORM_LEN + 1];
   for (i=0;i<J2_LOK_N;i++)
   {
     if (!strcmp(fd.j2_lok[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%month"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.monat,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%m()",fd.j2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.monat) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%day"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.tag,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%d()",fd.j2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.tag) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.j2_lok[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.j2_lok[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.j2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%journ"))
     {
        strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%journsh"))
     {
        if (strlen(one_quell_rec.quell_kurzform) > 0)
          strlimcat(ausgabe_zeile,one_quell_rec.quell_kurzform,AUSGABEZEILE_LEN);
        else
        strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%issn"))
     {
        strlimcat(ausgabe_zeile,one_quell_rec.quell_issn,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%isn()",fd.j2_lok[i],argument1))
     {
        if (strlen(one_quell_rec.quell_issn) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     // else if (!strcmp(fd.j2_lok[i],"%journ4l"))
     else if (!strcmp(fd.j2_lok[i],"%journ4l") || !strcmp(fd.j2_lok[i],"%journkey"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.kuerzel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%status"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.status,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%js()",fd.j2_lok[i],argument1))
     {
        if (strlen(one_quell_rec.quell_kurzform) > 0)
        {
          fdjsdelimiter(one_quell_rec.quell_kurzform, quell_kurz_del, argument1, 2*KURZFORM_LEN);
          strlimcat(ausgabe_zeile,quell_kurz_del,AUSGABEZEILE_LEN);
        }
        else
        strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%volume"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%v()",fd.j2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%issuenum"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.issue_nummer,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%inu()",fd.j2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.issue_nummer) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%pagefrom"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%pageto"))
     {
        if (strlen(one_journal_rec.seite_bis)==0 || strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0)
        {
          strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile, one_journal_rec.seite_bis, AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.j2_lok[i],"%pagetosh"))
     {
        seitenziffern(one_journal_rec.seite_von, one_journal_rec.seite_bis);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%pgs()",fd.j2_lok[i],argument1))
     {
        if (strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0
           || strlen(one_journal_rec.seite_bis)==0)
        {
           strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.j2_lok[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%kwds"))
     {
        strlimcat(ausgabe_zeile,desc_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j2_lok[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%p()",fd.j2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.seite_von) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }

     else strlimcat(ausgabe_zeile,fd.j2_lok[i],AUSGABEZEILE_LEN);
   }
}



static void b1_ed(void)
{
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   int i;
   for (i=0;i<B1_ED_N;i++)
   {
      if (!strcmp(fd.b1_ed[i],"%edits"))
      {
         strlimcat(ausgabe_zeile,ed_zeile,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%refnr"))
      {
         strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
      }
     else if (extractargument_square_round("%i[]()",fd.b1_ed[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.b1_ed[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.b1_ed[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_ed[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
      else if (!strcmp(fd.b1_ed[i],"%n"))
      {
         strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%year"))
      {
         strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%space"))
      {
         strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%endline"))
      {
         strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%tab"))
      {
         strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%fullstop"))
      {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%EdEds"))
      {
         if (fdedmax <= 1)
            strlimcat(ausgabe_zeile,"Editor",AUSGABEZEILE_LEN);
         else
            strlimcat(ausgabe_zeile,"Editors",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%ededs"))
      {
         if (fdedmax <= 1)
            strlimcat(ausgabe_zeile,"editor",AUSGABEZEILE_LEN);
         else
            strlimcat(ausgabe_zeile,"editors",AUSGABEZEILE_LEN);
      }
      else strlimcat(ausgabe_zeile,fd.b1_ed[i],AUSGABEZEILE_LEN);
   }
}

static void b1_tit(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];

   for (i=0;i<B1_TIT_N;i++)
   {
     if (!strcmp(fd.b1_tit[i],"%titlebo"))
     {
        strlimcat(ausgabe_zeile,one_buch_rec.titel_bu, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.b1_tit[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.b1_tit[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.b1_tit[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.b1_tit[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%edno"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%Edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%Auflage"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Auflage",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%e()",fd.b1_tit[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.b1_tit[i], AUSGABEZEILE_LEN);
   }
}

static void b1_lok(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   char ort_ex[PUBLORT_LEN+1];
   for (i=0;i<B1_LOK_N;i++)
   {
     if (!strcmp(fd.b1_lok[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.b1_lok[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.b1_lok[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.b1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%kwds"))
     {
        strlimcat(ausgabe_zeile,desc_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%edno"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%Edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%Auflage"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Auflage",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%e()",fd.b1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%place"))
     {
         extractitem(1,one_buch_rec.publ_ort,",",ort_ex);
         trim(ort_ex,' ');
         strlimcat(ausgabe_zeile,ort_ex,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%places"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.publ_ort, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%publisher"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.verlag, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%isbn"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.isbn, AUSGABEZEILE_LEN);
     }
     else if (extractargument("%ibn()",fd.b1_lok[i],argument1))
     {
        if (strlen(one_buch_rec.isbn) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%status"))
     {
         strlimcat(ausgabe_zeile, one_journal_rec.status, AUSGABEZEILE_LEN);
     }

     else if (!strcmp(fd.b1_lok[i],"%pagefrom"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%pageto"))
     {
        if (strlen(one_journal_rec.seite_bis)==0 || strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0)
        {
          strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile, one_journal_rec.seite_bis, AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.b1_lok[i],"%pagetosh"))
     {
        seitenziffern(one_journal_rec.seite_von, one_journal_rec.seite_bis);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%pgs()",fd.b1_lok[i],argument1))
     {
        if (strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0
           || strlen(one_journal_rec.seite_bis)==0)
        {
           strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%p()",fd.b1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.seite_von) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile, fd.b1_lok[i],AUSGABEZEILE_LEN);
   }

}


static void b3_ed(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<B3_ED_N;i++)
   {
      if (!strcmp(fd.b3_ed[i],"%edits"))
      {
         strlimcat(ausgabe_zeile,one_buch_rec.insted,AUSGABEZEILE_LEN);
      }
      else if (extractargument("%ine()",fd.b3_ed[i],argument1))
      {
         if (strlen(one_buch_rec.insted) > 0)
            strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b3_ed[i],"%refnr"))
      {
         strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
      }
     else if (extractargument_square_round("%i[]()",fd.b3_ed[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.b3_ed[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.b3_ed[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_ed[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
      else if (!strcmp(fd.b3_ed[i],"%n"))
      {
         strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b3_ed[i],"%year"))
      {
         strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b3_ed[i],"%space"))
      {
         strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b3_ed[i],"%endline"))
      {
         strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b3_ed[i],"%tab"))
      {
         strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b3_ed[i],"%fullstop"))
      {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b3_ed[i],"%EdEds"))
      {
         if (fdedmax <= 1)
            strlimcat(ausgabe_zeile,"Editor",AUSGABEZEILE_LEN);
         else
            strlimcat(ausgabe_zeile,"Editors",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b3_ed[i],"%ededs"))
      {
         if (fdedmax <= 1)
            strlimcat(ausgabe_zeile,"editor",AUSGABEZEILE_LEN);
         else
            strlimcat(ausgabe_zeile,"editors",AUSGABEZEILE_LEN);
      }
      else strlimcat(ausgabe_zeile,fd.b3_ed[i],AUSGABEZEILE_LEN);
   }
}

static void b3_tit(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];

   for (i=0;i<B3_TIT_N;i++)
   {
     if (!strcmp(fd.b3_tit[i],"%titlebo"))
     {
        strlimcat(ausgabe_zeile,one_buch_rec.titel_bu, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_tit[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.b3_tit[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.b3_tit[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.b3_tit[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_tit[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_tit[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_tit[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_tit[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_tit[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_tit[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.b3_tit[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_tit[i],"%edno"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_tit[i],"%edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_tit[i],"%Edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_tit[i],"%Auflage"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Auflage",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%e()",fd.b3_tit[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.b3_tit[i], AUSGABEZEILE_LEN);
   }
}

static void b3_lok(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   char ort_ex[PUBLORT_LEN+1];
   for (i=0;i<B3_LOK_N;i++)
   {
     if (!strcmp(fd.b3_lok[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.b3_lok[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.b3_lok[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.b3_lok[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%kwds"))
     {
        strlimcat(ausgabe_zeile,desc_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%edno"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%Edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%Auflage"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Auflage",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%e()",fd.b3_lok[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%place"))
     {
         extractitem(1,one_buch_rec.publ_ort,",",ort_ex);
         trim(ort_ex,' ');
         strlimcat(ausgabe_zeile,ort_ex,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%places"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.publ_ort, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%publisher"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.verlag, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%isbn"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.isbn, AUSGABEZEILE_LEN);
     }
     else if (extractargument("%ibn()",fd.b3_lok[i],argument1))
     {
        if (strlen(one_buch_rec.isbn) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%status"))
     {
         strlimcat(ausgabe_zeile, one_journal_rec.status, AUSGABEZEILE_LEN);
     }

     else if (!strcmp(fd.b3_lok[i],"%pagefrom"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b3_lok[i],"%pageto"))
     {
        if (strlen(one_journal_rec.seite_bis)==0 || strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0)
        {
          strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile, one_journal_rec.seite_bis, AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.b3_lok[i],"%pagetosh"))
     {
        seitenziffern(one_journal_rec.seite_von, one_journal_rec.seite_bis);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%pgs()",fd.b3_lok[i],argument1))
     {
        if (strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0
           || strlen(one_journal_rec.seite_bis)==0)
        {
           strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%p()",fd.b3_lok[i],argument1))
     {
        if (strlen(one_journal_rec.seite_von) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile, fd.b3_lok[i],AUSGABEZEILE_LEN);
   }

}



static void b2_aut(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<B2_AUT_N;i++)
   {
     if (!strcmp(fd.b2_aut[i],"%auth"))
     {
        strlimcat(ausgabe_zeile,au_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.b2_aut[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.b2_aut[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.b2_aut[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.b2_aut[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.b2_aut[i],AUSGABEZEILE_LEN);
   }
}

static void b2_tit(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<B2_TIT_N;i++)
   {
     if (!strcmp(fd.b2_tit[i],"%title"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.b2_tit[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.b2_tit[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.b2_tit[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }

     else if (!strcmp(fd.b2_tit[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.b2_tit[i],AUSGABEZEILE_LEN);
   }
}

static void b2_ed(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<B2_ED_N;i++)
   {
      if (!strcmp(fd.b2_ed[i],"%edits"))
      {
         strlimcat(ausgabe_zeile,ed_zeile,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%refnr"))
      {
         strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
      }
      else if (extractargument_square_round("%i[]()",fd.b2_ed[i],argument1,argument2))
      {
         char outstr[IDNR_LEN+1];
         if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
         {
            strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
         }
      }
      else if (extractargument_square("%id[]",fd.b2_ed[i],argument1))
      {
         char outstr[IDNR_LEN+1];
         if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
         {
            strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
         }
      }
      else if (extractargument("%idn()",fd.b2_ed[i],argument1))
      {
         if (strlen(one_journal_rec.idnr) > 0)
            strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%idnr"))
      {
         strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%n"))
      {
         strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%year"))
      {
         strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%space"))
      {
         strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%endline"))
      {
         strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%tab"))
      {
         strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%fullstop"))
      {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%EdEds"))
      {
         if (fdedmax <= 1)
            strlimcat(ausgabe_zeile,"Editor",AUSGABEZEILE_LEN);
         else
            strlimcat(ausgabe_zeile,"Editors",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%ededs"))
      {
         if (fdedmax <= 1)
            strlimcat(ausgabe_zeile,"editor",AUSGABEZEILE_LEN);
         else
            strlimcat(ausgabe_zeile,"editors",AUSGABEZEILE_LEN);
      }
      else strlimcat(ausgabe_zeile,fd.b2_ed[i],AUSGABEZEILE_LEN);
   }
}

static void b2_titb(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];

   for (i=0;i<B2_TITB_N;i++)
   {
     if (!strcmp(fd.b2_titb[i],"%titlebo"))
     {
        strlimcat(ausgabe_zeile,one_buch_rec.titel_bu, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.b2_titb[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.b2_titb[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.b2_titb[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.b2_titb[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%edno"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%Edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%Auflage"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Auflage",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%e()",fd.b2_titb[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.b2_titb[i], AUSGABEZEILE_LEN);
   }
}

static void b2_lok(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   char ort_ex[PUBLORT_LEN+1];
   for (i=0;i<B2_LOK_N;i++)
   {
     if (!strcmp(fd.b2_lok[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.b2_lok[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.b2_lok[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.b2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%kwds"))
     {
        strlimcat(ausgabe_zeile,desc_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%edno"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%Edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%Auflage"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Auflage",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%e()",fd.b2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%place"))
     {
         extractitem(1,one_buch_rec.publ_ort,",",ort_ex);
         trim(ort_ex,' ');
         strlimcat(ausgabe_zeile,ort_ex,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%places"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.publ_ort, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%publisher"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.verlag, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%isbn"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.isbn, AUSGABEZEILE_LEN);
     }
     else if (extractargument("%ibn()",fd.b2_lok[i],argument1))
     {
        if (strlen(one_buch_rec.isbn) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%status"))
     {
         strlimcat(ausgabe_zeile, one_journal_rec.status, AUSGABEZEILE_LEN);
     }

     else if (!strcmp(fd.b2_lok[i],"%pagefrom"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%pageto"))
     {
        if (strlen(one_journal_rec.seite_bis)==0 || strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0)
        {
          strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile, one_journal_rec.seite_bis, AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.b2_lok[i],"%pagetosh"))
     {
        seitenziffern(one_journal_rec.seite_von, one_journal_rec.seite_bis);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%pgs()",fd.b2_lok[i],argument1))
     {
        if (strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0
           || strlen(one_journal_rec.seite_bis)==0)
        {
           strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%p()",fd.b2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.seite_von) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.b2_lok[i],AUSGABEZEILE_LEN);
   }
}

static void m1_aut(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<M1_AUT_N;i++)
   {
     if (!strcmp(fd.m1_aut[i],"%auth"))
     {
        strlimcat(ausgabe_zeile,au_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_tit[i],"%howpub"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.howpublished,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%hp()",fd.m1_tit[i],argument1))
     {
        if (strlen(one_journal_rec.howpublished) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_aut[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.m1_aut[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.m1_aut[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.m1_aut[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_aut[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_aut[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_aut[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_aut[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_aut[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_aut[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.m1_aut[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.m1_aut[i],AUSGABEZEILE_LEN);
   }
}


static void m1_tit(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<M1_TIT_N;i++)
   {
     if (!strcmp(fd.m1_tit[i],"%title"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_tit[i],"%howpub"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.howpublished,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%hp()",fd.m1_tit[i],argument1))
     {
        if (strlen(one_journal_rec.howpublished) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_tit[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.m1_tit[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.m1_tit[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.m1_tit[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_tit[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_tit[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_tit[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }

     else if  (!strcmp(fd.m1_tit[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.m1_tit[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.m1_tit[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.m1_tit[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.m1_tit[i],AUSGABEZEILE_LEN);
   }
}



static void m1_lok(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<M1_LOK_N;i++)
   {
     if (!strcmp(fd.m1_lok[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_lok[i],"%month"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.monat,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%m()",fd.m1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.monat) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_lok[i],"%day"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.tag,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%d()",fd.m1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.tag) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_lok[i],"%howpub"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.howpublished,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%hp()",fd.m1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.howpublished) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_lok[i],"%status"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.status,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_lok[i],"%pagefrom"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_lok[i],"%pageto"))
     {
        if (strlen(one_journal_rec.seite_bis)==0 || strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0)
        {
          strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile, one_journal_rec.seite_bis, AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.m1_lok[i],"%pagetosh"))
     {
        seitenziffern(one_journal_rec.seite_von, one_journal_rec.seite_bis);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%pgs()",fd.m1_lok[i],argument1))
     {
        if (strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0
           || strlen(one_journal_rec.seite_bis)==0)
        {
           strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.m1_lok[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_lok[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_lok[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.m1_lok[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.m1_lok[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.m1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_lok[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_lok[i],"%kwds"))
     {
        strlimcat(ausgabe_zeile,desc_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m1_lok[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }

     else if (extractargument("%p()",fd.m1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.seite_von) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.m1_lok[i],AUSGABEZEILE_LEN);
   }
}


static void m2_aut(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<M2_AUT_N;i++)
   {
     if (!strcmp(fd.m2_aut[i],"%auth"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.instau,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%ina()",fd.m2_aut[i],argument1))
     {
        if (strlen(one_journal_rec.instau) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_tit[i],"%howpub"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.howpublished,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%hp()",fd.m2_tit[i],argument1))
     {
        if (strlen(one_journal_rec.howpublished) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_aut[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.m2_aut[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.m2_aut[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.m2_aut[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_aut[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_aut[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_aut[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_aut[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_aut[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_aut[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.m2_aut[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.m2_aut[i],AUSGABEZEILE_LEN);
   }
}


static void m2_tit(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<M2_TIT_N;i++)
   {
     if (!strcmp(fd.m2_tit[i],"%title"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_tit[i],"%howpub"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.howpublished,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%hp()",fd.m2_tit[i],argument1))
     {
        if (strlen(one_journal_rec.howpublished) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_tit[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.m2_tit[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.m2_tit[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.m2_tit[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_tit[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_tit[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_tit[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }

     else if  (!strcmp(fd.m2_tit[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.m2_tit[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.m2_tit[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.m2_tit[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.m2_tit[i],AUSGABEZEILE_LEN);
   }
}



static void m2_lok(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char argument2[FD_FELD_LEN + 1];
   for (i=0;i<M2_LOK_N;i++)
   {
     if (!strcmp(fd.m2_lok[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_lok[i],"%month"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.monat,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%m()",fd.m2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.monat) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_lok[i],"%day"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.tag,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%d()",fd.m2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.tag) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_lok[i],"%howpub"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.howpublished,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%hp()",fd.m2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.howpublished) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_lok[i],"%status"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.status,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_lok[i],"%pagefrom"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_lok[i],"%pageto"))
     {
        if (strlen(one_journal_rec.seite_bis)==0 || strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0)
        {
          strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile, one_journal_rec.seite_bis, AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.m2_lok[i],"%pagetosh"))
     {
        seitenziffern(one_journal_rec.seite_von, one_journal_rec.seite_bis);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%pgs()",fd.m2_lok[i],argument1))
     {
        if (strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0
           || strlen(one_journal_rec.seite_bis)==0)
        {
           strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.m2_lok[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_lok[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_lok[i],"%tab"))
     {
        strlimcat(ausgabe_zeile,"\t",AUSGABEZEILE_LEN);
     }
     else if (extractargument_square_round("%i[]()",fd.m2_lok[i],argument1,argument2))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,argument2,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument_square("%id[]",fd.m2_lok[i],argument1))
     {
        char outstr[IDNR_LEN+1];
        if (extract_idnr(one_journal_rec.idnr,argument1,outstr))
        {
           strlimcat(ausgabe_zeile,outstr,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%idn()",fd.m2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.idnr) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_lok[i],"%idnr"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.idnr,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_lok[i],"%kwds"))
     {
        strlimcat(ausgabe_zeile,desc_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.m2_lok[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%p()",fd.m2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.seite_von) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }

     else strlimcat(ausgabe_zeile,fd.m2_lok[i],AUSGABEZEILE_LEN);
   }
}



#undef REFZAHL_LEN

