[INHERIT('UTILITYOPS','ARGOPS','FLAGOPS',
'TREEANDLISTOPS','LATEXOPS'), environment('conversion')]

MODULE CONVERSION;

CONST
    maxlists = 8;     
    maxheaderlevels = 6;
    maxlongpckstrchars = 75;
TYPE

longpckstr = VARYING[maxlongpckstrchars] of char;

pagesizetype = record
	            length : integer;
	            width  : integer
	         end;

paragraphdeftype = record
    	                indent : integer;
	                vertskip : integer;
	                testpage : integer
	             end;

numberlisttype = record
	              listlevel   : integer;
	              valuetoset : integer
	           end;

displayelementstype = record
	                  leftchar : char;
	                  style : styletype;
	                  rightchar : char
	                end;

leveltype = record
	   value : integer;                                                    
	   display : styletype
	end;

headerleveltype = array[1..maxheaderlevels] of leveltype;


VAR


inputcontainstexcommands : [GLOBAL] boolean;

totallines, totalchars : [EXTERNAL] integer;

pagesize : [GLOBAL] pagesizetype;

numberpage : [GLOBAL] integer;

numberrunning : [GLOBAL] integer;

displaynumber : [GLOBAL] styletype;

capitalizetext, lowercasetext : [GLOBAL] boolean;

leftmargin : [GLOBAL] integer;

rightmargin : [GLOBAL] integer;

fill : [GLOBAL] boolean;

startnofillagain : [GLOBAL] boolean;

justify : [GLOBAL] boolean;

spacing : [GLOBAL] integer;
                              
indent  : [GLOBAL] integer;

centering : [GLOBAL] boolean;

flushright : [GLOBAL] boolean;

minipageactive : [GLOBAL] boolean;

inmarginpar  : [GLOBAL] boolean;

infootnote : [GLOBAL] boolean;

paragraphdef : [GLOBAL] paragraphdeftype;

numberlist : [GLOBAL] numberlisttype;

displayelements : [GLOBAL] displayelementstype;

numberchapter : [GLOBAL] integer;

displaychapter : [GLOBAL] styletype;

headerlevel : [GLOBAL] headerleveltype;

nestlevel : [GLOBAL] integer;

numberappendix : [GLOBAL] integer;

displayappendix : [GLOBAL] styletype;

writetexcommands : [GLOBAL] boolean;

flagtable : [GLOBAL] flagtabletype;

inliteral : [GLOBAL] boolean;

title, subtitle : [GLOBAL] argarray;

datestring : [GLOBAL] pckstr;

pagestyle : [GLOBAL] pagestyletype;
                                                   
liststate : [GLOBAL] array[1..maxlists] of liststatetype;

numberofelements : [GLOBAL] array[1..maxlists] of integer;

outputfirstitem : [GLOBAL] array[1..maxlists] of boolean;

listnestlevel : [GLOBAL] integer;

nofillbeforelist : [GLOBAL] boolean;

LOG : [EXTERNAL] text;

underlineactive : [GLOBAL] enhancmentstates;

boldactive : [GLOBAL] enhancmentstates;



[GLOBAL] FUNCTION quotedcharacter( arg : argument ) : char;
var
  s : pckstr;
begin
   s := argliteral( arg, true );
   if length(s) = 1 then
      quotedcharacter := s[1]
   else
      if length(s) = 3 then
	quotedcharacter := s[2]
      else
	quotedcharacter := blank
end;                                           
                          


[HIDDEN] PROCEDURE noconversion; EXTERN;






                              
[GLOBAL] PROCEDURE blankifypckstr( var s : pckstr );
begin
  s.body := blank;
  s.length := 0
end;



[GLOBAL] PROCEDURE initglobalvars;
var
  i : integer;
begin
   pagesize.length := 58;
   pagesize.width := 60;
   numberpage := 1;
   numberrunning := 1;
   displaynumber := decimal;
   capitalizetext := false;
   lowercasetext := false;
   leftmargin := 0;
   rightmargin := 60;
   fill := true;
   startnofillagain := false;
   justify := true;              
   centering := false;
   flushright := false;
   minipageactive := false;
   indent := 5;
   spacing := 1;
   paragraphdef.indent := 5;
   paragraphdef.vertskip := 2;
   paragraphdef.testpage := 5;
   numberlist.listlevel := 1;
   numberlist.valuetoset := 0;
   nofillbeforelist := false;
   displayelements.leftchar := blank;
   displayelements.style := decimal;
   displayelements.rightchar := blank;
   numberchapter := 0;
   numberappendix := 0;
   displaychapter := decimal;
   for i := 1 to maxheaderlevels do
   begin
     headerlevel[i].value := 0;   
     headerlevel[i].display := decimal
   end;                       
   nestlevel := 1;
   inliteral := false;
   makenullarray( title );
   makenullarray( subtitle ); 
   pagestyle := myheadings;
   blankifypckstr( datestring );
   for i := 1 to maxlists do
   begin
      liststate[i] := nostate;
      numberofelements[i] := 0;
      outputfirstitem[i] := false
   end;
   listnestlevel := 0;
   underlineactive := notenhanced;
   boldactive := notenhanced
end;
                        



[GLOBAL] PROCEDURE loglist( list : arglist; index : integer);
var                                    
  l : arglist;
begin
  writeln(log);
  writeln(log,'INDEX >',index:1,' LENGTH >',arglistlength(list):1);
  l := list;  
  write(log,'RUNOFF >');
  while l <> nulllist do
  begin
    write(log, argliteral(firstarg(l), false), blank);
    l := nextinlist(l)
  end;
  writeln(log);
  write(log,'TEX >') 
end;

                    


[GLOBAL] PROCEDURE dumpthelist( var outfile : text; list : arglist );
begin
   if list <> nulllist then
   begin
      texwritearg(outfile, firstarg(list));
      dumpthelist(outfile, nextinlist(list))
   end
end;




[GLOBAL] PROCEDURE newintvalue( arg : argument; var current : integer; 
       	                 var modified : parameterchangestates; 
	                 var intextracted : integer );
var  
  signed : boolean;                      
  successful : boolean;
begin                                        
  modified := nochange;
  extractintegerfromargument(arg, successful, intextracted, signed );
  if successful then
  begin                                               
    if signed then
    begin
      modified := altered;
      current := intextracted + current
    end
    else                        
    begin
      modified := assigned;
      current := intextracted
    end
  end
end;                      




[GLOBAL] PROCEDURE newcountparameter( arg : argument; var current : integer;
	                                var modified : parameterchangestates;
                                        var countervalueextracted : integer;
	                                var class : countparametertype);
begin
  modified := nochange
end;


[GLOBAL] PROCEDURE newstyleparameter( arg : argument; var current : styletype );
var
   s : styletype;
begin
  s := isastylespecifier( arg );
  if s <> undetermined then
      current := s
end;
                     

                                            
  
[LOCAL] FUNCTION  m( i : integer  ) : integer;
begin
  if i < 2 then
   m := 1
  else
   m := i - 1
end;                                        
                                                               

[LOCAL] PROCEDURE C( var f : text );
begin
   writeln(f,'}');
   writeln(log,'}')
end;




[GLOBAL] PROCEDURE flagchange( f : dsrflagclasses; arg : argument );
var
  ch : char;
begin
   turnflagon( f );
   ch := quotedcharacter( arg );
   if ch <> blank then 
     changeflagchar(f, ch)
end;



                   
[GLOBAL] PROCEDURE puttexcommand( var outfile : text; index : integer; 
	                   dsrlist : arglist; 
	                   var writeanothertexcommand : integer );

label 
   routineexit;                                                          
const                  
  charwidth = true;
  charheight = false;
var 
   arg : argarray;
   i, j, n : integer;
   modified : parameterchangestates; 
   extractedvalue, skip, startindex : integer;     
   class : countparametertype;
   f : dsrflagclasses;
   q : char;                            
   startedwithfill : boolean;
                   
begin                                

if (index < 1) or (index > 130) then goto routineexit;
                             
writeanothertexcommand := indexofunknowntexcommand;
loglist( dsrlist, index );
n := arglistlength( dsrlist );
listtoarray( dsrlist, index, arg, maxargsinarray);
startedwithfill := fill;     
stopunderline( outfile );
stopbold( outfile );

{
  n      - number of arguments supplied with the DSR command 
  m(n-1) - one less than that number, unless n < 2
  m(n-2) - two less than the number of arguments, unless < 3
  etc                                                         

  arg[i] - the ith input dsr argument; e.g. four args could be : 
 
      1    2   3   4
     PAGE SIZE 10, 20                                             }

 
                      
case index of
                                 
   {***** PAGE SIZE *****}      
  1 : begin                                                         
	newintvalue(arg[n], pagesize.width, modified, extractedvalue);
	newintvalue(arg[m(n)], pagesize.length, modified, extractedvalue);
        adjustlength(outfile, modified, pagesize.width, extractedvalue,charwidth,'textwidth');
	adjustlength(outfile, modified, pagesize.length, extractedvalue,charheight,'textheight')
      end;
              
   {***** HEADERS OFF *****} 
  2 : adjustpagestyle(outfile, plain);

   {***** HEADERS ON ***** }
  3 : adjustpagestyle(outfile, headings);

   {***** HEADERS UPPER ***** }
  4 : noconversion;              
                      
   {***** HEADERS LOWER ***** }
  5 : noconversion;

   {***** HEADERS MIXED ***** }
  6 : noconversion;
                           
   {***** ENABLE WRITING OF DATE *****} 
  7 : begin
        datestring := '\today';
        if pagestyle = myheadings then
          adjustpagestyle(outfile, myheadings)
        else
	  noconversion
      end;
          
  { ***** DISABLE WRITING OF DATE ***** }
  8 : begin
        blankifypckstr( datestring );
        if pagestyle = myheadings then
          adjustpagestyle(outfile, myheadings )
        else
          noconversion
      end;
	     
  { ***** LAYOUT ***** }
  9 : noconversion;
     
  { ***** NO NUMBER ***** }
 10 : adjustpagestyle(outfile, empty);

  { ***** NUMBER PAGE ***** }
 11 : begin                                                        
	newcountparameter(arg[n], numberpage, modified, extractedvalue,class);
        adjustcounter(outfile, modified, numberpage, extractedvalue, 'page')
      end;                        
           
  { ***** NUMBER RUNNING ***** }
 12 : begin                                         
        newintvalue(arg[n], numberrunning, modified, extractedvalue);
        adjustcounter(outfile, modified, numberrunning, extractedvalue,'page')
      end;
      
  { ***** DISPLAY NUMBER ***** }
 13 : begin
        newstyleparameter(arg[n], displaynumber);
	adjuststyle(outfile, displaynumber, 'page')
      end;
           
  { ***** NO PAGING ***** }
 14 : noconversion;

  { ***** PAGING ***** }
 15 : noconversion;

  { ***** BEGIN SUBPAGE ***** }
 16 : begin
        if not minipageactive then
	begin
	  minipageactive := true;
          if not startedwithfill then
	  begin
	    endnofill( outfile );
	    startnofillagain := true
	  end;
	  writeln(outfile,'\begin{minipage}');
          writeln(    log,'\begin{minipage}');
	  if not startedwithfill then
	    beginnofill( outfile )
        end
	else
	begin
	   writeln(outfile,'% RNOTOTEX - minipage already active');
	   writeln(    log,'% RNOTOTEX - minipage already active')
	end
      end;

  { ***** END SUBPAGE ***** }
 17 : begin                     
        if minipageactive then
	begin
          if not fill then
	    endnofill( outfile );
          writeln(outfile,'\end{minipage}');
          writeln(    log,'\end{minipage}');
          if startnofillagain then         
	  begin
	    startnofillagain := false;
	    beginnofill( outfile )     
          end
        end
        else
        begin
	   writeln(outfile,'% RNOTOTEX - minipage not active');
	   writeln(    log,'% RNOTOTEX - minipage not active')
     	end;
        minipageactive := false
      end;

  { ***** NUMBER SUBPAGE ***** }
 18 : noconversion;


  { ***** DISPLAY SUBPAGE ***** }
 19 : noconversion;

  { ***** FIRST TITLE ***** }
 20 : noconversion;

  { ***** TITLE ***** }
 21 : begin
         for i := 2 to maxargsinarray do
	   title[i-1] := arg[i];
         if pagestyle = myheadings then
           adjustpagestyle(outfile, myheadings)
         else
	   noconversion
      end;

  { ***** SUBTITLE ***** }
 22 : begin
         for i := 2 to maxargsinarray do
	    subtitle[i-1] := arg[i];
         if pagestyle = myheadings then
	   adjustpagestyle(outfile, myheadings)
         else
	   noconversion
      end;

  { ***** NO SUBTITLE ***** }
  23 : begin
          makenullarray( subtitle );
          if pagestyle = myheadings then
            adjustpagestyle(outfile, myheadings)
          else
	    noconversion
       end;

  { ***** NO AUTOSUBTITLE ***** }
  24 : begin
         makenullarray( subtitle );
         if pagestyle = myheadings then
           adjustpagestyle(outfile, plain)
         else
           noconversion
       end;

  { ***** AUTOSUBTITLE ***** }
  25 : adjustpagestyle(outfile, headings);


  { ***** UPPERCASE ***** }
  26 : begin
        capitalizetext := true;
        lowercasetext := false
       end;

  { ***** LOWERCASE ***** }
  27 : begin
	capitalizetext := false;
        lowercasetext := true
       end;

  { ***** LEFT MARGIN ***** }
  28 : begin
          newintvalue( arg[n], leftmargin, modified, extractedvalue);
	  noconversion
       end;
 
  { ***** RIGHT MARGIN ***** }
  29 : begin
          newintvalue( arg[n], rightmargin, modified, extractedvalue);
          noconversion
       end;

  { ***** NO FILL ***** }
  30 : beginnofill( outfile );

  { ***** FILL ***** }
  31 : endnofill( outfile );

  { ***** NO JUSTIFY ***** }
  32 : begin
          writeln(outfile,'\sloppy % - begin no justify');
          writeln(    log,'\sloppy % - begin no justify');
          justify := false
       end;

  { ***** JUSTIFY ***** }
  33 : begin
          writeln(outfile,'\fussy % - turn justification on');
          writeln(    log,'\fussy % - turn justification on');
          justify := true
       end;

  { ***** BREAK ***** }
  34 : begin                        
         if fill then
	 begin
	   writeln(outfile,'\hfil\linebreak');
	   writeln(    log,'\hfil\linebreak')
	 end
         else
	 begin
	   writeln(outfile,'% RNOTOTEX - forced break');
	   writeln(    log,'% RNOTOTEX - forced break')
	 end
       end;

  { ***** SPACING ***** }
  35 : begin
          newintvalue(arg[n], spacing, modified, extractedvalue );
          adjustlength(outfile, modified, spacing, extractedvalue, charheight,'baselineskip')
       end;

  { ***** SKIP ***** }
  36 : begin          
         if n = 1 then
	 begin
	    if (spacing > 0) and (spacing < 4) then
	    case spacing of
	        1 : begin
	              writeln(outfile,'\smallskip');
	              writeln(    log,'\smallskip')
	            end;
	        2 : begin
	              writeln(outfile,'\medskip');
	              writeln(    log,'\medskip')
	            end;
	        3 : begin
	               writeln(outfile,'\bigskip');
	               writeln(    log,'\bigskip')
	            end
	    end
	    else
	    begin
	       writeln(outfile,'\smallskip % - default skip amount');
	       writeln(    log,'\smallskip % - default skip amount')
	    end
         end
         else
	 begin
           skip := 1;
           newintvalue(arg[n], skip, modified, extractedvalue );
           extractedvalue := extractedvalue * spacing;
	   write(outfile,'\vspace{'); 
           write(    log,'\vspace{'); 
           writecharheight(outfile, extractedvalue);
           c(outfile)
         end
       end;

  { ***** BLANK ***** }
  37 : begin
         if n = 1 then
	 begin
	   writeln(outfile,'\smallskip');
           writeln(    log,'\smallskip')
         end
         else
         begin
	   skip := 1;
           newintvalue(arg[n], skip, modified, extractedvalue );
           write(outfile,'\vspace{');  
           write(    log,'\vspace{'); 
	   writecharheight(outfile, extractedvalue);
           c(outfile)
         end
       end;

  { ***** PAGE ***** }
  38 : begin
	 writeln(outfile,'\pagebreak[0] \typeout{runoff page break encountered, may be ignored}');
	 writeln(    log,'\pagebreak[0]')
       end;
 
  { ***** TEST PAGE ***** }
  39 : noconversion;

  { ***** CENTRE ***** }
  40 : begin
         if not centering then
	 begin
           centering := true;         
	   if not fill then
	   begin
	     startnofillagain := true;
	     endnofill( outfile )
           end;
	   writeln(outfile,'\begin{centering}');
	   writeln(    log,'\begin{centering}');
           writeanothertexcommand := 40
	 end
	 else
	 begin
	   writeln(outfile,'% RNOTOTEX - centering already active');
	   writeln(    log,'% RNOTOTEX - centering already active')
	 end
       end;

  { ***** TAB STOPS ***** }
  41 : noconversion;

  { ***** INDENT ***** }
  42 : begin
          indent := 5;
	  newintvalue(arg[n], indent, modified, extractedvalue);
          if modified = nochange then        
          begin
	     write(outfile,'\indent ');
	     write(    log,'\indent ')
          end
          else              
          begin
            write(outfile,'\hspace*{');
            write(    log,'\hspace*{');
            writecharwidth(outfile, indent);
            write(outfile,'} ');
            writeln(log,'}')
          end
       end;

   { ***** LEFT ***** }
  43 : begin
          indent := 5;
	  newintvalue(arg[n], indent, modified, extractedvalue);
          if (modified = nochange) or (n = 1) then
          begin
	     write(outfile,'\indent ');
	     write(    log,'\indent ')
	  end
          else
          begin                                                   
            write(outfile,'\hspace*{');
            write(    log,'\hspace*{');
            writecharwidth(outfile, indent);
            write(outfile,'} ');
	    writeln(log,'}')
          end
       end;
 
   { *****  RIGHT ***** }
  44 : begin
          if not flushright then
	  begin
            if not fill then
            begin
	      startnofillagain := true;
	      endnofill( outfile )
	    end;
	    flushright:= true;
	    writeln(outfile,'\begin{flushright}');
	    writeln(    log,'\begin{flushright}');
            writeanothertexcommand := 44
	  end
	  else
	  begin
	    writeln(outfile,'% RNOTOTEX - flush right already active');
	    writeln(    log,'% RNOTOTEX - flush right already active')
	  end
       end;

   { ***** NO PERIOD ***** }
  45 : begin 
         writeln(outfile,'\frenchspacing');
         writeln(    log,'\frenchspacing')
       end;

   { ***** PERIOD ***** }
  46 : begin 
	 writeln(outfile,'\nofrenchspacing');
	 writeln(    log,'\nofrenchspacing')
       end;

   { ***** NO SPACE ***** }
  47 : noconversion;

   { ***** PARAGRAPH ***** }
  48 : begin
	if n > 1 then
 	begin
	    newintvalue(arg[2], paragraphdef.indent, modified, extractedvalue);
 	    newintvalue(arg[3], paragraphdef.vertskip, modified, extractedvalue);
	    newintvalue(arg[4], paragraphdef.testpage, modified, extractedvalue)
        end;
	writeln(outfile,'\par');
	writeln(    log,'\par')
       end;

   { ***** SET PARAGRAPH ***** }
  49 : begin
	 newintvalue(arg[m(n-2)], paragraphdef.indent, modified, extractedvalue);
 	 adjustlength(outfile, modified, paragraphdef.indent, extractedvalue,charwidth,'parindent');
 	 newintvalue(arg[m(n-1)], paragraphdef.vertskip, modified, extractedvalue);
	 adjustlength(outfile, modified, paragraphdef.vertskip, extractedvalue,charheight,'parskip');
	 newintvalue(arg[m(n)], paragraphdef.testpage, modified, extractedvalue)
       end;

   { ***** AUTOPARAGRAPH ***** }
   50 : noconversion;

   { ***** NO AUTOPARAGRAPH ***** }
   51 : noconversion;

   { ***** AUTOTABLE ***** }
   52 :  noconversion;

   { ***** NO AUTOTABLE ***** }
   53 : noconversion;

   { ***** DISABLE UNDERLINING ***** }
   54 : turnflagoff( underline );

   { ***** ENABLE UNDERLINING ***** }                                                          
   55 : turnflagon( underline );

   { ***** NO HYNPHENATION ***** }
   56 : turnflagoff( hyphenate );

   { ***** HYPENATION ***** }
   57 : turnflagon( hyphenate );

   { ***** DISABLE BOLDING ***** }
   58 : turnflagoff( bold );

   { *****  ENABLE BOLDING ***** }
   59 : turnflagon( bold );

   { ***** DISABLE OVERSTRIKE ***** }
   60 : turnflagoff( overstrike );

   { ***** ENABLE OVERSTRIKE ***** }
   61 : turnflagon( overstrike );

   { ***** ENABLE BAR ***** }
   62 : noconversion;
                       
   { ***** BEGIN BAR  ***** }
   63 : noconversion;

   { ***** END BAR ***** }
   64 : noconversion;

   { ***** DISABLE BAR ***** }
   65 : noconversion;

   { ***** FIGURE ***** }
   66 : begin
	   skip := 1;
	   newintvalue(arg[n], skip, modified, extractedvalue);
	   writeln(outfile,'\begin{figure}');
           write(outfile,'\vspace{');
	   writeln(    log,'\begin{figure}');
           write(    log,'\vspace{');
           writecharheight(outfile, skip);
           c(outfile);
	   writeln(outfile,'\caption{Another Figure}');
           writeln(outfile,'\end{figure}');
	   writeln(    log,'\caption{Another Figure}');
           writeln(    log,'\end{figure}')
	end;

    { ***** FIGURE DEFFERED ***** }
   67 : begin
	   skip := 1;
	   newintvalue(arg[n], skip, modified, extractedvalue);
	   writeln(outfile,'\begin{figure}');
	   writeln(    log,'\begin{figure}');
           write(outfile,'\vspace{');
           write(    log,'\vspace{');
           writecharheight(outfile, skip);
           c(outfile);
	   writeln(outfile,'\caption{Another Figure}');
           writeln(outfile,'\end{figure}');
	   writeln(    log,'\caption{Another Figure}');
           writeln(    log,'\end{figure}')
	end;
    
    { ***** LITERAL ***** }
   68 : begin 
	   if not inliteral then
	   begin
	     if not fill then
	     begin
	       startnofillagain := true;
	       endnofill( outfile )
	     end;
	     inliteral := true;
	     writeln(outfile,'\begin{verbatim}');
             writeln(    log,'\begin{verbatim}')
	   end
	   else
	   begin
	     writeln(outfile,'% RNOTOTEX - literal already active');
	     writeln(    log,'% RNOTOTEX - literal already active')
	   end
	end;	

    { ***** END LITERAL ***** }
   69 : begin  
	   if inliteral then
	   begin
	     writeln(outfile,'\end{verbatim}');
	     writeln(    log,'\end{verbatim}');
	     inliteral := false;
	     if startnofillagain then
	     begin
	       startnofillagain := false;                           
	       beginnofill( outfile )
	     end
           end
	   else
	   begin
	      writeln(outfile,'% RNOTOTEX - end literal not after literal');
	      writeln(    log,'% RNOTOTEX - end literal not after literal')
	   end
	end;

    { ***** REPEAT ***** }
   70 : begin
          skip := 1;
	  newintvalue(arg[2], skip, modified, extractedvalue);
	  q := quotedcharacter( arg[3] );
          for i := 1 to skip do                  
	  begin
	    texwrite(outfile, q);
	    texwrite(    log, q)
	  end
        end;

    { ***** LIST ***** }
   71 : begin                         
	  if (not fill) and (listnestlevel = 0) then
	  begin
	    nofillbeforelist := true;
	    endnofill( outfile )
	  end;
          listnestlevel := listnestlevel + 1;
          numberofelements[listnestlevel] := 0;
	  if n = 3 then
	  begin
	    q := quotedcharacter( arg[3] );
	    writeln(outfile,'\begin{itemize} % list nest ',listnestlevel:1);
	    writeln(    log,'\begin{itemize}');
	    liststate[listnestlevel] := itemize;
	    write(outfile,'\item ');          
	    outputfirstitem[listnestlevel] := true
	  end
	  else
	  begin
	    writeln(outfile,'\begin{enumerate} % list nest ',listnestlevel:1);
	    writeln(    log,'\begin{enumerate}');
	    liststate[listnestlevel] := enumerate;
	    write(outfile,'\item ');          
	    outputfirstitem[listnestlevel] := true
	  end
	end;
      
     { ***** END LIST ***** }
    72 : begin                   
           if listnestlevel > 0 then 
           begin
	     case liststate[listnestlevel] of
	        nostate   : writeln(outfile,'% - RNOTOTEX - close on list not open');
	        itemize    : writeln(outfile,'\end{itemize} % - list nest ',listnestlevel:1);
	        enumerate  : writeln(outfile,'\end{enumerate} % - list nest ',listnestlevel:1)
	     end;
	     case liststate[listnestlevel] of          
	        nostate   : writeln(    log,'% - RNOTOTEX - close on list not open');
	        itemize    : writeln(    log,'\end{itemize}');
	        enumerate  : writeln(    log,'\end{enumerate}')
	     end;
             numberofelements[listnestlevel] := 0;
             liststate[listnestlevel] := nostate;
	     outputfirstitem[listnestlevel] := false;
   	     listnestlevel := listnestlevel - 1;
	     if (listnestlevel = 1) and (nofillbeforelist) then
	     begin
	        nofillbeforelist := false;
	        beginnofill( outfile )
	     end
           end
	   else
	   begin
	      writeln(outfile,'% - RNOTOTEX end list for none started');
	      writeln(    log,'% - RNOTOTEX end list for none started')
	   end
	 end;
                                         
     { ***** LIST ELEMENT ***** }
    73 : begin                           
           if listnestlevel > 0 then
	   begin
             if liststate[listnestlevel] = nostate then
             begin
	        writeln(outfile,'% - RNOTOTEX - list element for non-existant-list');
	        writeln(    log,'% - RNOTOTEX - list element for non-existant-list')
             end
	     else
             begin
	       if not outputfirstitem[listnestlevel] then
	       begin
	         write(outfile,'\item ');
    	         writeln(    log,'\item ')
	       end
	       else
	         outputfirstitem[listnestlevel] := false;
               numberofelements[listnestlevel] := numberofelements[listnestlevel] + 1
             end
           end                   
           else
           begin
	     writeln(outfile,'% - RNOTOTEX - list element for unopened-list');
	     writeln(    log,'% - RNOTOTEX - list element for unopened-list')
           end                                               
 	 end;
               
     { ***** NUMBER LIST ***** }
    74 : begin
	   newintvalue(arg[2], numberlist.listlevel, modified, extractedvalue);
	   newintvalue(arg[3], numberlist.valuetoset, modified, extractedvalue);
	   if (numberlist.listlevel > 0) and ( numberlist.listlevel < 5) then
	     case numberlist.valuetoset of
	        1 : adjustcounter(outfile, modified, numberlist.valuetoset,extractedvalue,'enumi');
	        2 : adjustcounter(outfile, modified, numberlist.valuetoset,extractedvalue,'enumii');
	        3 : adjustcounter(outfile, modified, numberlist.valuetoset,extractedvalue,'enumiii');
	        4 : adjustcounter(outfile, modified, numberlist.valuetoset,extractedvalue,'enumiv')
	     end                     
	 end;

      { ***** DISPLAY ELEMENTS ***** }
     75 : noconversion;

      { ***** NOTE ***** }
     76 : begin
            if not inmarginpar then
	    begin
	      writeln(outfile,'\marginpar{\em ');
	      writeln(    log,'\marginpar{\em ');
	      inmarginpar := true;
	      if n > 1 then
	      begin 
	        dumpthelist(outfile, dsrlist);
	        dumpthelist(    log, dsrlist);
	        inmarginpar := false;
	        c(outfile)
              end
            end
	    else
	    begin
	       writeln(outfile,'% RNOTOTEX - marginpar already active');
	       writeln(    log,'% RNOTOTEX - marginpar already active')
	    end
	  end;

      { ***** END NOTE ***** }
     77 : begin            
            if inmarginpar then
            begin
	      writeln(outfile,'} % - end of margin par ');
	      writeln(    log,'} % - end of margin par ')
            end
	    else
	    begin
	       writeln(outfile,'% RNOTOTEX - marginpar not active');
	       writeln(    log,'% RNOTOTEX - marginpar not active')
	    end;
	    inmarginpar := false
	  end;

      { ***** FOOTNOTE ***** }
     78 : begin
            if not infootnote then
	    begin
	      write(outfile,'\footnote{');
	      writeln(    log,'\footnote{');
     	      infootnote := true
            end
	    else
	    begin
	      writeln(outfile,'% RNOTOTEX - already in footnote');
	      writeln(    log,'% RNOTOTEX - already in footnote')
            end
	  end;

      { ***** END FOOTNOTE ***** }
     79 : begin 
     	    if infootnote then
            begin              
	       writeln(outfile,'} % - end of footnote');
	       writeln(    log,'} % - end of footnote')
	    end
            else
	    begin
	       writeln(outfile,'% RNOTOTEX - footnote not active');
	       writeln(    log,'% RNOTOTEX - footnote not active')
            end;
	    infootnote := false
	  end;

      { ***** CHAPTER ***** }
     80 : begin 
            if not startedwithfill then
	       endnofill(outfile);
	    write(outfile,'\chapter{');
	    write(    log,'\chapter{');
	    dumpthelist(outfile, nextinlist(dsrlist));
	    dumpthelist(    log, nextinlist(dsrlist));
	    c(outfile);
	    if not startedwithfill then
	      beginnofill(outfile);
	  end;

      { ***** NUMBER CHAPTER ***** }
     81 : begin
	     newcountparameter(arg[n], numberchapter, modified, extractedvalue, class);
	     adjustcounter(outfile, modified, numberchapter, extractedvalue,'chapter')
	  end;                             
                                 
      { ***** DISPLAY CHAPTER ***** }
     82 : begin
	    newstyleparameter(arg[n], displaychapter);
	    adjuststyle(outfile, displaychapter, 'chapter')
	  end;

       { ***** HEADER LEVEL ***** }
      83 : begin                             
	     newintvalue(arg[2], nestlevel, modified, extractedvalue);
	     if modified <> nochange then
	        startindex := 3
	     else
	     begin                         
	       newintvalue(arg[3], nestlevel, modified, extractedvalue);
	       startindex := 4
	     end;
	     if modified <> nochange then
	     begin
	        if (nestlevel > 0) and (nestlevel < 7) then
	        begin
	          case nestlevel of 
	            1 : write(outfile,'\section{');
	            2 : write(outfile,'\subsection{');
	            3 : write(outfile,'\subsubsection{');
	            4 : write(outfile,'\paragraph{');
	            5 : write(outfile,'\subparagraph{');
	            6 : write(outfile,'\P ')
	          end;
	          case nestlevel of 
	            1 : write(    log,'\section{');
	            2 : write(    log,'\subsection{');
	            3 : write(    log,'\subsubsection{');
	            4 : write(    log,'\paragraph{');
	            5 : write(    log,'\subparagraph{');
	            6 : write(    log,'\P ')
	          end;
	          for i := startindex to n do
                  begin
	            texwritearg(outfile, arg[i] );
	            texwritearg(    log, arg[i] )
                  end;
	          if nestlevel < 6 then
	            c(outfile);
           	  headerlevel[nestlevel].value := headerlevel[nestlevel].value + 1
	        end
             end
           end;
           
       { ***** NUMBER LEVEL ***** }
      84 : begin  
	     startindex := -1; 
	     if  n = 7 then startindex := 2;
	     if  n = 8 then startindex := 3;
	     if startindex <> -1 then
	     begin
     	       for i := startindex to (startindex + 5) do 
	       begin                      
	         j := i - startindex + 1;
	         newintvalue(arg[i], headerlevel[j].value, modified,extractedvalue);
	          case j of
	            1 : adjustcounter(outfile, modified, headerlevel[1].value,extractedvalue,'section');
	            2 : adjustcounter(outfile, modified, headerlevel[2].value,extractedvalue,'subsection');
	            3 : adjustcounter(outfile, modified, headerlevel[3].value,extractedvalue,'subsubsection');
	            4 : adjustcounter(outfile, modified, headerlevel[4].value,extractedvalue,'paragraph');
	            5 : adjustcounter(outfile, modified, headerlevel[5].value,extractedvalue,'subparagraph');
	            6 : noconversion
	          end   
	       end
             end
	   end;

        { ***** STYLE HEADERS ***** }
       85 : noconversion;

        { ***** DISPLAY LEVELS ***** }
       86 : begin  
	     startindex := -1; 
	     if  n = 7 then startindex := 2;
	     if  n = 8 then startindex := 3;
	     if startindex <> -1 then
	     begin
     	       for i := startindex to (startindex + 5) do 
	       begin                      
	         j := i - startindex + 1;
	         newstyleparameter(arg[i], headerlevel[j].display);
	          case j of                     
	            1 : adjuststyle(outfile, headerlevel[1].display, 'section');
	            2 : adjuststyle(outfile, headerlevel[2].display, 'subsection');
	            3 : adjuststyle(outfile, headerlevel[3].display, 'subsubsection');
	            4 : adjuststyle(outfile, headerlevel[4].display, 'paragraph');
	            5 : adjuststyle(outfile, headerlevel[5].display ,'subparagraph');
	            6 : noconversion
	          end
	       end      
             end
	    end;                     
    
       { ***** APPENDIX ***** }
      87 : begin
	     write(outfile,'\chapter{APPENDIX ');
	     write(    log,'\chapter{APPENDIX ');
	     if n >= 2 then
	     begin
	       write(outfile,': ');
	       write(    log,': ');
	       dumpthelist(outfile, nextinlist(dsrlist));
	       dumpthelist(    log, nextinlist(dsrlist))
	     end;
	     c(outfile)
	   end;

       { ***** NUMBER APPENDIX ***** }
      88 : begin
	     newcountparameter(arg[n], numberappendix, modified, extractedvalue,class);
	     adjustcounter(outfile, modified, numberappendix, extractedvalue, 'chapter')
	   end;

       { ***** DISPLAY APPENDIX ***** }
      89 : begin
	     newstyleparameter(arg[n], displayappendix);
	     adjuststyle(outfile, displayappendix, 'chapter')
	   end;
                             
       { ***** STANDARD ***** }
      90 : noconversion;

       { ***** COMMENT ***** }
      91 : begin
	      write(outfile,'% ');
	      dumpthelist(outfile, nextinlist(dsrlist));
	      write(    log,'% ');
	      dumpthelist(    log, nextinlist(dsrlist))
	   end;

       { ***** REQUIRE ***** }
      92 : begin
	     write(outfile,'%%%%%% REQUIRE WAS HERE %%%%% \input {');
	     dumpthelist(outfile, nextinlist(dsrlist));
	     write(    log,'\input {');
	     dumpthelist(    log, nextinlist(dsrlist));
	     c(outfile)
	   end;

       { ***** CONTROL CHARACTERS ***** }
      93 : noconversion;

       { ***** NO CONTROL CHARACTERS ***** }
      94 : noconversion;

       { ***** IF ***** }
      95 : noconversion;

       { ***** ELSE ***** }
      96 : noconversion;

       { ***** END IF ***** }
      97 : noconversion;

       { ***** IFNOT ***** }
      98 : noconversion;

       { ***** VARIABLE ***** }
      99 : noconversion;

       { ***** SET DATE ***** }
     100 : noconversion;

       { ***** SET TIME ***** }
     101 : noconversion;

       { ***** FLAGS ALL ***** }
     102 : begin
	     for f := control to substitute do
	        turnflagon( f )
	   end;
   
       { ***** NO FLAGS ALL ***** }
     103 : begin
	     for f := control to substitute do
	        turnflagoff( f );
	     turnflagon( control )
	   end;               
 
       { ***** NO FLAGS CONTROL ***** }
     104 : turnflagoff( control );

       { ***** FLAGS CONTROL ***** }
     105 : flagchange(control, arg[n]);

       { ***** NO FLAGS UPPERCASE ***** }
     106 : turnflagoff( uppercase );

       { ***** FLAGS UPPERCASE ***** }
     107 : flagchange( uppercase, arg[n]);

       { ***** NO FLAGS LOWERCASE ***** }
     108 : turnflagoff( lowercase );

       { ***** FLAGS LOWERCASE ***** }
     109 : flagchange( lowercase, arg[n]);

       { ***** NO FLAGS QUOTE ***** }
     110 : turnflagoff( quote );
	                          
       { ***** FLAGS QUOTE ***** }
     111 : flagchange( quote, arg[n] );

       { ***** NO FLAGS SPACE ***** }
     112 : turnflagoff( space );

       { ***** FLAGS SPACE ***** }
     113 : flagchange( space, arg[n] );

       { ***** NO FLAGS UNDERLINE ***** }
     114 : turnflagoff( underline );

       { ***** FLAGS UNDERLINE ***** }
     115 : flagchange( underline, arg[n] );
           
       { ***** NO FLAGS BOLD ***** }
     116 : turnflagoff( bold );

       { ***** FLAGS BOLD ***** }
     117 : flagchange( bold, arg[n] );

       { ***** NO FLAGS OVERSTRIKE ***** }
     118 : turnflagoff( overstrike );

       { ***** FLAGS OVERSTRIKE ***** }
     119 : flagchange( overstrike, arg[n] );

       { ***** NO FLAGS HYPHENATE ***** }        
     120 : turnflagoff( hyphenate );

       { ***** FLAGS HYPHENATE ***** }
     121 : flagchange( hyphenate, arg[n] );

       { ***** NO FLAGS CAPITALIZE ***** }
     122 : turnflagoff( capitalize );

       { ***** FLAGS CAPITALIZE ***** }
     123 : flagchange( capitalize, arg[n] );

       { ***** NO FLAGS END FOOTNOTE ***** }
     124 : turnflagoff( endfootnote );

       { ***** FLAGS END FOOTNOTE ***** }
     125 : flagchange( endfootnote, arg[n] );

       { ***** NO FLAGS COMMENT ***** }
     126 : turnflagoff( comment );

       { ***** FLAGS COMMENT ***** }
     127 : flagchange( comment, arg[n] );

       { ***** NO FLAGS SUBSTITUTE ***** }
     128 : turnflagoff( substitute );

       { ***** FLAGS SUBSTITUTE ***** }
     129 : flagchange( substitute, arg[n] );
         
       { ***** INDEX ***** }
     130 : begin
	     write(outfile,'\index{');
	     dumpthelist(outfile, nextinlist(dsrlist));
	     write(    log,'\index{');
	     dumpthelist(    log, nextinlist(dsrlist));
	     c(outfile)
           end
                                              
end; {case of tex index extracted}	


routineexit : nullstatement
end;
                                                                     


[GLOBAL] PROCEDURE putsecondarytexcommand(var outfile : text;
	                          var nextcommand : integer );
begin 

  if nextcommand = 40 {centering}      then  
  begin      
      if centering then
      begin
        centering := false;
        writeln(outfile,'\end{centering}');
        if startnofillagain then
        begin
	  startnofillagain := false;
	  beginnofill( outfile )
        end
      end
      else
      begin
	writeln(outfile,'% RNOTOTEX - end centering when centering not-active');	
	writeln(    log,'% RNOTOTEX - end centering when centering not-active')
      end
  end;
  if nextcommand = 44 {rightjustify}  then
  begin  
      if flushright then
      begin
        flushright := false;
        writeln(outfile,'\end{flushright}');
        if startnofillagain then
        begin
	  startnofillagain := false;
	  beginnofill( outfile )
        end
      end
      else
      begin
        writeln(outfile,'% RNOTOTEX - end flushright when not active');
        writeln(    log,'% RNOTOTEX - end flushright when not active')
      end
  end;

  nextcommand := indexofunknowntexcommand

end;





END.
