/* move all files to an other directory
	args: src_path = source directory ending with dirsep (NULL is current)
			files = string of the files to move
			dest_path = destination directory ending with dirsep
	returns: 0 = error
				1 = success */
int move_files(char* src_path, char* files, char* dest_path)
{
#ifdef __WIN32__
	struct _finddata_t dir_list;
#else
	struct ffblk dir_list;
#endif
	int find_file_handle;
	int find_error;
	char src_name[MAX_PATH];
	char dest_name[MAX_PATH];
	char* tmp_src_name;
	char* tmp_dest_name;

	tmp_src_name=src_name;
	tmp_dest_name=dest_name;
	if (!src_path) sprintf(src_name,"%s",files);
	else
	{
		tmp_src_name+=sprintf(src_name,"%s",src_path);
		sprintf(tmp_src_name,"%s",files);
	}
	tmp_dest_name+=sprintf(dest_name,"%s",dest_path);
#ifdef __WIN32__
	find_file_handle=_findfirst(src_path,&dir_list);
	if (find_file_handle<0)
#else
	find_file_handle=findfirst(src_path,&dir_list,FA_ARCH);
	if (find_file_handle)
#endif
	{/* not found */
		return 0;
	}
	else
	{
		while (1)
		{/* generate names */
			sprintf(tmp_src_name,"%s",dir_list.name);
			sprintf(tmp_dest_name,"%s",dir_list.name);
			if (runtex_data.print_actions)
				printf("\tMoving file %s to %s\n",tmp_src_name,dest_name);
		/* move file */
			rename(src_name,dest_name);
#ifdef __WIN32__
			find_error=_findnext(find_file_handle,&dir_list);
#else
			find_error=findnext(&dir_list);
#endif
			if (find_error) break;
		}
#ifdef __WIN32__
		_findclose(find_file_handle);
#endif
	}
	return 1;
}

/* delete all files that match expression */
int delete_files(char* path)
{
#ifdef __WIN32__
	struct _finddata_t dir_list;
#else
	struct ffblk dir_list;
#endif
	int find_file_handle;
	int find_error;

#ifdef __WIN32__
	find_file_handle=_findfirst(path,&dir_list);
	if (find_file_handle<0)
#else
	find_file_handle=findfirst(path,&dir_list,FA_ARCH);
	if (find_file_handle)
#endif
	{/* not found */
		return 0;
	}
	else
	{
		while (1)
		{/* delete it */
			unlink(dir_list.name);
#ifdef __WIN32__
			find_error=_findnext(find_file_handle,&dir_list);
#else
			find_error=findnext(&dir_list);
#endif
			if (find_error) break;
		}
#ifdef __WIN32__
		_findclose(find_file_handle);
#endif
	}
	return 1;
}

/* copy text file - no checks are made if the paths are identical or if
	there's enough space left on the drive dest resides on */
int copy_file_to(char* src, char* dest)
{
	FILE* src_file=NULL;
	FILE* dest_file=NULL;
	char* buffer=NULL;
	int file_size;

	do
	{
		src_file=fopen(src,"rt");
		if (!src_file) break;
		dest_file=fopen(dest,"wt");
		if (!dest_file) break;
		fseek(src_file,0,SEEK_END);
		file_size=ftell(src_file);
		fseek(src_file,0,SEEK_SET);
		new_string(buffer,file_size);
		if (!buffer) break;
		file_size=fread(buffer,1,file_size,src_file);
		fwrite(buffer,1,file_size,dest_file);
	} while (0);
	if (src_file)
	{
		fclose(src_file);
		if (dest_file)
		{
			fclose(dest_file);
			if (buffer)
			{/* all was allocated - success */
				free(buffer);
				return 1;
			}
		}
	}
	return 0;
}
/* creates a randomly named sub-directory and returns its name */
char* create_random_dir(char* path)
{
	char* temp_path;
	int temp_path_size, path_size;
	int i;
	char buffer[MAX_PATH];
	char* new_name;

	if (!path) return NULL;
	temp_path=path;
	i=0;
/* copy path into array (could've used memcpy/strlen but so what) */
	while (*temp_path)
	{
		buffer[i++]=*temp_path;
		temp_path++;
	}
/* add dir separator if not set */
	if (*(temp_path-1)!=NATIVE_DIRSEP) buffer[i++]=NATIVE_DIRSEP;
	temp_path_size=i;
	path_size=i+3;
	buffer[path_size]=0;
	srand(time(0));
	new_name=NULL;
	i=0;
/* have we tried 10 times already ? */
	while (i<10)
	{/* create name */
		buffer[temp_path_size]=rand()%26+0x61;
		buffer[temp_path_size+1]=rand()%26+0x61;
		buffer[temp_path_size+2]=rand()%26+0x61;
	/* dir exists ? */
		if (!mkdir(buffer))
		{/* no - copy array into string */
			new_name=(char*)malloc(path_size);
			if (new_name)
				memcpy(new_name,buffer,path_size);
		/* no mem - delete dir */
			else rmdir(buffer);
			break;
		}
		i++;
	}
	return new_name;
}
/* creates a randomly named sub-directory in the temp path
	and returns its name */
char* create_temp_dir(void)
{
	char* temp_path;

#ifdef __WIN32__
	char* native_fallback_path=".\\";
#else
	char* native_fallback_path="/usr/tmp/";
#endif

	temp_path=getenv("TEMP");
	if (!temp_path)
	{
		temp_path=getenv("TMP");
		if (!temp_path) temp_path=native_fallback_path;
	}
	return create_random_dir(temp_path);
}
/* set command line switches for program
	args: exe_type = 0 TeX or variant, 1 util
			file_type = enum value of exe_type */
static char** set_spawn_options(int exe_type, int file_type, char* file_name)
{
	char** exe_options;
	char* tmp_opt;
	char* program;

	if (!exe_type)
	{
		program=runtex_data.tex[file_type];
		tmp_opt=runtex_data.tex_opt[file_type];
	}
	else
	{
		program=runtex_data.utils[file_type];
		tmp_opt=runtex_data.utils_opt[file_type];
	}
	exe_options=create_spawn_options(program,tmp_opt,file_name);
	return exe_options;
}

/* spawns program on file with options
	args: exe_type = 0 TeX or variant, 1 util
			file_type = enum value of exe_type */
static int spawn_program(char** exe_options)
{
	int ret_val;

	if (runtex_data.print_actions)
		printf("Spawning %s\n",exe_options[0]);
/* spawn searching the path using an array for arguments and
	wait until it's finished; the first index of the array
	contains the program's name */
#ifdef __WIN32__
	ret_val=_spawnvp(_P_WAIT,exe_options[0],exe_options);
#else
	ret_val=spawnvp(P_WAIT,exe_options[0],exe_options);
#endif
/* program exited normally (0) - return 1, if 1 change to 0 */
	if (ret_val==EXIT_SUCCESS) return 1;
	return 0;
}

/* frees the char* array containing the command-line switches for a program */
static void free_spawn_options(char** exe_options, char* file_name)
{
	int index=0;

/* don't free [0] as this is an internal array entry and don't
	free last index with file_name either (local array or string in
	option struct) */
	while (exe_options[++index]!=file_name) free(exe_options[index]);
/* free char array */
	free(exe_options);
}

/* spawns program on file with options
	args: exe_type = 0 TeX or variant, 1 util
			file_type = enum value of exe_type */
int run_external_program(int exe_type, int file_type, char* file_name)
{
	char** exe_options;
	int ret_val;

	exe_options=set_spawn_options(exe_type,file_type,file_name);
	if (!exe_options) return 0;
	ret_val=spawn_program(exe_options);
/* before returning the error code free array */
	free_spawn_options(exe_options,file_name);
	return ret_val;
}
/* _spawnve( _P_WAIT, args[0], args, my_env); to set environment vars */
int run_xindy(char* tmp_job)
{
	char** xindy_env;
	char** exe_options;
	char* str;
	char buffer[1024];
	int tmp_int;
	int ret_val;
	char exe_name[MAX_PATH];

	if (runtex_data.print_actions) printf("Setup environment\n");
	new_array(char*,xindy_env,5);
	if (!xindy_env) return 0;
	tmp_int=sprintf(buffer,"%s=%s/%s.exe","rsx",runtex_data.utils[0],"rsx");
	new_string(str,tmp_int);
	ret_val=EXIT_FAILURE;
	exe_options=NULL;
	xindy_env[0]=str;
	xindy_env[1]=NULL;
	xindy_env[2]=NULL;
	while (1)
	{
		if (!str) break;
		memcpy(str,buffer,tmp_int+1);
		sprintf(buffer,"%s=%s/%s.exe","emx",runtex_data.utils[0],"emx");
		new_string(str,tmp_int);
		xindy_env[1]=str;
		if (!str) break;
		memcpy(str,buffer,tmp_int+1);
		tmp_int=sprintf(buffer,"XINDY_SEARCHPATH=.%c%smodules",NATIVE_PATHSEP,
			runtex_data.utils[0]);
		new_string(str,tmp_int);
		xindy_env[2]=str;
		if (!str) break;
		memcpy(str,buffer,tmp_int+1);
		xindy_env[3]="RSXOPT=-Re0";
		xindy_env[4]=NULL;
		if (runtex_data.index_type==2)
		{/* convert to xindy format first */
			if (runtex_data.print_actions)
				printf("Converting index to Xindy format\n");
			sprintf(buffer,"%s.sta < %s.idx > %s.raw",tmp_job,
				tmp_job,tmp_job);
#ifdef __WIN32__
			sprintf(exe_name,"%stex2xdy.exe",runtex_data.utils[0]);
#else
			sprintf(exe_name,"%stex2xdy",runtex_data.utils[0]);
#endif
			exe_options=create_spawn_options(exe_name,buffer,NULL);
			if (!exe_options) break;
		/* spawn with environment using an array for arguments and
			wait until it's finished; the first index of the array
			contains the program's name */
#ifdef __WIN32__
			tmp_int=_spawnve(_P_WAIT,exe_name,exe_options,xindy_env);
#else
			tmp_int=spawnve(P_WAIT,exe_name,exe_options,xindy_env);
#endif
		/* program failed (!=0) - error */
			if (tmp_int!=EXIT_SUCCESS) break;
			free_spawn_options(exe_options,NULL);
			sprintf(buffer,"< %s.sta > %s.xdy",tmp_job,tmp_job);
#ifdef __WIN32__
			sprintf(exe_name,"%smkidx.exe",runtex_data.utils[0]);
#else
			sprintf(exe_name,"%smkidx",runtex_data.utils[0]);
#endif
			exe_options=create_spawn_options(exe_name,buffer,NULL);
			if (!exe_options) break;
#ifdef __WIN32__
			tmp_int=_spawnve(_P_WAIT,exe_name,exe_options,xindy_env);
#else
			tmp_int=spawnve(P_WAIT,exe_name,exe_options,xindy_env);
#endif
		/* program failed (!=0) - error */
			if (tmp_int!=EXIT_SUCCESS) break;
			free_spawn_options(exe_options,NULL);
		}
		if (runtex_data.print_actions)
			printf("Processing index with Xindy\n");
		tmp_int=sprintf(buffer,"-q -M %sxindy.mem -o %s.ind ",
			runtex_data.utils[0],tmp_job);
	/* add switches and style file user wants when .raw was generated */
		if (runtex_data.index_type==3)
			tmp_int+=sprintf(buffer+tmp_int,"%s",runtex_data.utils_opt[0]);
	/* otherwise add style file created by convertion process
		it must be set in runtex.ini */
		else tmp_int+=sprintf(buffer+tmp_int,"%s.xdy",tmp_job);
		sprintf(buffer+tmp_int," %s.raw",tmp_job);
#ifdef __WIN32__
		sprintf(exe_name,"%sxindy.exe",runtex_data.utils[0]);
#else
		sprintf(exe_name,"%sxindy",runtex_data.utils[0]);
#endif
		exe_options=create_spawn_options(exe_name,buffer,NULL);
		if (!exe_options) break;
#ifdef __WIN32__
		ret_val=_spawnve(_P_WAIT,exe_name,exe_options,xindy_env);
#else
		ret_val=spawnve(P_WAIT,exe_name,exe_options,xindy_env);
#endif
		break;
	}
	if (exe_options) free_spawn_options(exe_options,NULL);
	if (xindy_env)
	{
		if (xindy_env[0])
		{
			free(xindy_env[0]);
			if (xindy_env[1])
			{
				free(xindy_env[1]);
				free_if(xindy_env[2]);
			}
		}
		free(xindy_env);
	}
/* program failed (!=0) - error */
	if (ret_val==EXIT_SUCCESS) return 1;
	return 0;
}
/* searches the \jobname.aux for "\citation{" the only sign to know
	if BibTeX needs to be run
	runtex_data.config_buffer will be freed at the end of the program */
int check_for_bib_entries(char* path, char* suffix_start)
{
	char* buffer;

	memcpy(suffix_start,"aux",4);
	open_text_file(path);
	if (!runtex_data.config_buffer) return 0;
	buffer=runtex_data.config_buffer;
	while (1)
	{/* did not find bibtex command but no error */
		if (!*buffer) break;
		if ((*buffer=='\\') &&
		(*(buffer+1)=='c') &&
		(*(buffer+2)=='i') &&
		(*(buffer+3)=='t') &&
		(*(buffer+4)=='a') &&
		(*(buffer+5)=='t') &&
		(*(buffer+6)=='i') &&
		(*(buffer+7)=='o') &&
		(*(buffer+8)=='n') &&
		(*(buffer+9)=='{'))
		{/* found a bibtex command - outta here */
			file_types[BIBLIOGRAPHY].found++;
			break;
		}
		while (1)
		{/* all lines in .aux end with return */
			if (*buffer=='\n')
			{/* start of next line */
				buffer++;
				break;
			}
			buffer++;
		}
	}
	free_pntr(runtex_data.config_buffer);
	return 1;
}
/* create coomand-line options for makeindex's glossary mode
	and run makeindex with them */
int run_glossary(char* buffer, char* tmp_buffer)
{
	int ret_val;
	int str_size;
	char glossary_buffer[1024];

	do
	{
		if (!runtex_data.utils_opt[_MAKE_GLOSSARY]) ret_val=0;
		else
		{
			ret_val=sprintf(glossary_buffer,"%s",
				runtex_data.utils_opt[_MAKE_GLOSSARY]);
			free(runtex_data.utils_opt[_MAKE_GLOSSARY]);
		}
		*(tmp_buffer-1)=0;
		sprintf(glossary_buffer+ret_val,"-s gglo.ist -o %s.gls",buffer);
		*(tmp_buffer-1)='.';
		str_size=strlen(glossary_buffer);
		new_string(runtex_data.utils_opt[_MAKE_GLOSSARY],str_size);
		if (!runtex_data.utils_opt[_MAKE_GLOSSARY])
			exit_on_error("No memory while trying to spawn utility.");
		memcpy(runtex_data.utils_opt[_MAKE_GLOSSARY],
			glossary_buffer,str_size+1);
		ret_val=run_external_program(1,_MAKE_GLOSSARY,buffer);
	} while (0);
	return ret_val;
}
/* searches for files of known types
	and executes the appropriate program (".mp"->metapost, ".mf"->metafont,
	".idx"->xindy, etc.) */
void process_document_related_files(char* path_name)
{
#ifdef __WIN32__
	struct _finddata_t dir_list;
#else
	struct ffblk dir_list;
#endif
	char buffer[MAX_PATH];
	char* tmp_buffer=NULL;
	char** exe_options;
	int find_file_handle;
	int find_error;
	int index;
	int util_index;
	int ret_val;
	int file_name_index;
	int add_tex_runs=0;
	FILE* tmp_file;

/* we have to guess the number of times or delete temporaries ? */
	if ((!runtex_data.tex_runs) || (!runtex_data.keep_temps))
	{/* yes - find them */
		index=0;
		tmp_buffer=buffer;
		tmp_buffer+=sprintf(buffer,"%s%s.",path_name,runtex_data.job_name);
		while (index<NUMBER_RUNTEX_FIRST_UTIL_SUFFIX)
		{/* not using memcpy as some suffixes have a * place holder */
			sprintf(tmp_buffer,"%s",file_types[index].suffix);
			if (runtex_data.print_actions)
				printf("Searching for file %s - ",buffer);
		/* Have to use findfirst because some suffixes are not fixed */
#ifdef __WIN32__
			find_file_handle=_findfirst(buffer,&dir_list);
			if (find_file_handle<0)
#else
			find_file_handle=findfirst(buffer,&dir_list,FA_ARCH);
			if (find_file_handle)
#endif
			{/* not found -  try next suffix */
				if (runtex_data.print_actions) printf("failed\n");
			}
			else
			{/* found - clean up, increase counter, go to next */
#ifdef __WIN32__
				_findclose(find_file_handle);
#endif
				if (runtex_data.print_actions) printf("found\n");
				add_tex_runs=1;
			/* don't delete temporaries - find the first file type that
				increases number of runs by one if there are more is of no
				interest as they wouldn't increase the number of runs either */
				if (runtex_data.keep_temps) break;
				file_types[index].found++;
			}
			index++;
		}
	}
/* utilities should be run or temporaries deleted ? */
	if ((runtex_data.exec_utils) || (!runtex_data.keep_temps))
	{/* yes - set up variables */
		index=NUMBER_RUNTEX_FIRST_UTIL_SUFFIX;
		util_index=0;
		if (!tmp_buffer)
		{
			tmp_buffer=buffer;
			tmp_buffer+=sprintf(buffer,"%s%s.",path_name,runtex_data.job_name);
		}
		for (; index<METAPOST_FILE; index++, util_index++)
		{/* don't try it if no util available */
			if (runtex_data.utils[util_index])
			{
				sprintf(tmp_buffer,"%s",file_types[index].suffix);
				if (runtex_data.print_actions)
					printf("Searching for file %s - ",buffer);
				if (index<BIBLIOGRAPHY)
				{
					tmp_file=fopen(buffer,"rt");
				/* ugly but necessary */
					ret_val=(int)tmp_file;
					if (tmp_file) fclose(tmp_file);
				}
				else
				{
					if (!check_for_bib_entries(buffer,tmp_buffer))
						exit_on_error("No memory while trying to spawn utility.");
					ret_val=file_types[index].found;
				}
				if (!ret_val)
				{/* not found -  try next suffix */
					if (runtex_data.print_actions) printf("failed\n");
				}
				else if (runtex_data.exec_utils)
				{/* found - do stuff */
					switch (util_index)
					{
						case _MAKE_INDEX:
							if (runtex_data.index_type>1)
							{/* special code if xindy is requested */
								*(tmp_buffer-1)=0;
								ret_val=run_xindy(buffer);
							/* add back the suffix delimiter */
								*(tmp_buffer-1)='.';
							}
							else
								ret_val=run_external_program(1,_MAKE_INDEX,buffer);
						break;
						case _MAKE_GLOSSARY:
						/* run makeindex as glossary utilitiy */
							ret_val=run_glossary(buffer,tmp_buffer);
						break;
						case _BIBTEX:
						/* bibtex needed - it only wants \jobname as argument */
							*(tmp_buffer-1)=0;
							ret_val=run_external_program(1,_BIBTEX,buffer);
						/* no adding suffix back as buffer gets overwritten */
						break;
					}
					if (!ret_val)
						exit_on_error("Spawned utility exited abnormally.");
				/* we set variable regardless since it doesn't hurt here */
					if (index<BIBLIOGRAPHY)
					{
						add_tex_runs=1;
						file_types[index].found++;
					}
					else add_tex_runs=2;
				}
			}
		}
		tmp_buffer=buffer;
		tmp_buffer+=sprintf(buffer,"%s*.", path_name);
		for (; index<NUMBER_RUNTEX_FILE_TYPES; index++, util_index++)
		{/* external utilities that may have any name+suffix */
		/* don't try it, if no util available */
			if (!runtex_data.utils[util_index]) continue;
			sprintf(tmp_buffer,"%s",file_types[index].suffix);
#ifdef __WIN32__
			find_file_handle=_findfirst(buffer,&dir_list);
			if (find_file_handle<0)
#else
			find_file_handle=findfirst(buffer,&dir_list,FA_ARCH);
			if (find_file_handle)
#endif
			{/* not found -  try next suffix */
				if (runtex_data.print_actions)
				{
					printf("Searching for files %s - ",buffer);
					printf("failed\n");
				}
			}
			else
			{
				file_types[index].found++;
			/* only set counter if we wouldn't overwrite a higher one */
				if (!add_tex_runs)
				{/* guess at times to run - do so */
/*					switch (util_index)
					{
						case _METAPOST:
						case _METAFONT:*/
							add_tex_runs=1;
/*						break;
					}*/
				}
			/* don't execute utils if we shouldn't */
				if (runtex_data.exec_utils)
				{
#ifdef __WIN32__
					_findclose(find_file_handle);
#endif
					continue;
				}
				exe_options=set_spawn_options(1,util_index,NULL);
				if (!exe_options) exit_on_error(
"No memory while trying to spawn utility.");
			/* so we can detect when spawning failed on first run */
				find_error=0;
				file_name_index=1;
			/* search for the index of the file name */
				while (exe_options[file_name_index]) file_name_index++;
				exe_options[file_name_index]=buffer;
				while (1)
				{/* (re-)set file name in command-line array */
					sprintf(buffer,"%s%s",path_name,dir_list.name);
					if (runtex_data.print_actions)
						printf("\tFound file %s\n",buffer);
					if (!spawn_program(exe_options)) break;
#ifdef __WIN32__
					find_error=_findnext(find_file_handle,&dir_list);
#else
					find_error=findnext(&dir_list);
#endif
					if (find_error) break;
				}
				free_spawn_options(exe_options,buffer);
#ifdef __WIN32__
				_findclose(find_file_handle);
#endif
				if (!find_error)
					exit_on_error("Spawned utility exited abnormally.");
			}
		}
	}
/* set our guess if we need to */
	if (!runtex_data.tex_runs) runtex_data.tex_runs=add_tex_runs;
}

int del_tmp_tex_file(char* buffer, char* suffix_start, char* suffix)
{
	memcpy(suffix_start,suffix,4);
	if (runtex_data.print_actions) printf("Deleting %s - ",buffer);
/* returns 0 on success, !=0 on failure */
	return unlink(buffer);
}

void delete_temporary_tex_files(char* path_name)
{
#ifdef __WIN32__
	struct _finddata_t dir_list;
#else
	struct ffblk dir_list;
#endif
	char buffer[MAX_PATH];
	char* tmp_buffer;
	int find_file_handle;
	int find_error;
	int index;
	int ret_val;

	index=0;
	tmp_buffer=buffer;
	tmp_buffer+=sprintf(buffer,"%s%s.",path_name,runtex_data.job_name);
	for (;index<NUMBER_RUNTEX_FIRST_UTIL_SUFFIX; index++)
	{
		if (!file_types[index].found) continue;
	/* create file name and delete file - no memcpy since
		some suffixes are not fixed */
		sprintf(tmp_buffer,"%s",file_types[index].suffix);
		if (runtex_data.print_actions)
			printf("Deleting %s - ",buffer);
	/* Have to use findfirst because some suffixes are not fixed */
#ifdef __WIN32__
		find_file_handle=_findfirst(buffer,&dir_list);
		if (find_file_handle<0)
#else
		find_file_handle=findfirst(buffer,&dir_list,FA_ARCH);
		if (find_file_handle)
#endif
		{/* not found -  try next suffix */
			if (runtex_data.print_actions) printf("failed\n");
		}
		else
		{
			while (1)
			{/* create file names */
				sprintf(buffer,"%s%s",path_name,dir_list.name);
				if (runtex_data.print_actions)
					printf("\tFound file %s\n",buffer);
			/* not delete - error */
				if ((ret_val=unlink(buffer))) break;
#ifdef __WIN32__
				find_error=_findnext(find_file_handle,&dir_list);
#else
				find_error=findnext(&dir_list);
#endif
				if (find_error) break;
			}
#ifdef __WIN32__
			_findclose(find_file_handle);
#endif
			if (!ret_val)
			{/* deletes were successful - refresh jobname in buffer */
				sprintf(buffer,"%s%s.",path_name,runtex_data.job_name);
			}
			else exit_on_error("Failed to delete %s.",buffer);
		}
	}
	if (file_types[index].found)
	{/* there's an index file ? */
		do
		{/* this is always there - copy NULL too */
			memcpy(tmp_buffer,"ind",4);
			if (runtex_data.print_actions)
				printf("Deleting %s - ",buffer);
			ret_val=unlink(buffer);
			if (ret_val) break;
			switch (runtex_data.index_type)
			{/* makeindex */
				case 1:
					ret_val=del_tmp_tex_file(buffer,tmp_buffer,
						file_types[index].suffix);
					if (ret_val) break;
					ret_val=del_tmp_tex_file(buffer,tmp_buffer,"ilg");
				break;
			/* convert to xindy and run xindy */
				case 2:
					ret_val=del_tmp_tex_file(buffer,tmp_buffer,
						file_types[index].suffix);
					if (ret_val) break;
					ret_val=del_tmp_tex_file(buffer,tmp_buffer,"sta");
					if (ret_val) break;
					ret_val=del_tmp_tex_file(buffer,tmp_buffer,"raw");
					if (ret_val) break;
				/* fall through */
			/* xindy */
				case 3:
					ret_val=del_tmp_tex_file(buffer,tmp_buffer,"xdy");
				break;
			}
		} while (0);
		if (ret_val) exit_on_error("Failed to delete %s.",buffer);
	}
	index++;
	if (file_types[index].found)
	{/* glossaries are makeindex only */
		do
		{
			ret_val=del_tmp_tex_file(buffer,tmp_buffer,"glo");
			if (ret_val) break;
			ret_val=del_tmp_tex_file(buffer,tmp_buffer,"gls");
			if (ret_val) break;
			ret_val=del_tmp_tex_file(buffer,tmp_buffer,"ilg");
		} while (0);
		if (ret_val) exit_on_error("Failed to delete %s.",buffer);
	}
	index++;
	if (file_types[index].found)
	{/* BibTeX */
		do
		{
			ret_val=del_tmp_tex_file(buffer,tmp_buffer,"blg");
			if (ret_val) break;
			ret_val=del_tmp_tex_file(buffer,tmp_buffer,"bbl");
		} while (0);
		if (ret_val) exit_on_error("Failed to delete %s.",buffer);
	}
	do
	{/* delete TeX temps */
		ret_val=del_tmp_tex_file(buffer,tmp_buffer,"log");
		if (ret_val) break;
		tmp_buffer=buffer;
/* there could be several .aux files */
		tmp_buffer+=sprintf(buffer,"%s*.aux",path_name);
		if (runtex_data.print_actions)
			printf("Deleting %s - ",buffer);
#ifdef __WIN32__
		find_file_handle=_findfirst(buffer,&dir_list);
		if (find_file_handle<0)
#else
		find_file_handle=findfirst(buffer,&dir_list,FA_ARCH);
		if (find_file_handle)
#endif
		{/* not found -  try next suffix */
			if (runtex_data.print_actions) printf("failed\n");
			return;
		}
		else
		{
			while (1)
			{/* create file names */
				sprintf(buffer,"%s%s",path_name,dir_list.name);
				if (runtex_data.print_actions)
					printf("\tFound file %s\n",buffer);
			/* not delete - error */
				if ((ret_val=unlink(buffer))) break;
#ifdef __WIN32__
				find_error=_findnext(find_file_handle,&dir_list);
#else
				find_error=findnext(&dir_list);
#endif
				if (find_error) break;
			}
#ifdef __WIN32__
			_findclose(find_file_handle);
#endif
		/* all deletes were successful */
			if (!ret_val) return;
		}
	} while (0);
	exit_on_error("Failed to delete %s.",buffer);
}
