/*
 * Decompiled with CFR 0.152.
 */
import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class JSpellChecker
extends Applet {
    private boolean initialized = false;
    protected SpellCheckEvent event;
    protected SpellChecker checker;
    private StringWordTokenizer tokens;
    private JSpellCheckListener listener;
    private static final int IGNORE_ALL_CAPS_WORD = 2;
    private static final int IGNORE_CAPPED_WORD = 4;
    private static final int IGNORE_MIXED_CASE = 8;
    private static final int IGNORE_MIXED_DIGITS = 16;
    private static final int REPORT_DOUBLED_WORD = 64;
    private static final int IGNORE_DOMAIN_NAMES = 65536;
    private static Hashtable configmap = new Hashtable();

    public void init() {
        JSpellChecker.log(this.hashCode() + ": JSpellChecker.init");
        String string = this.getParameter("dictionary");
        this.checker = new SpellChecker();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ;:");
        while (stringTokenizer.hasMoreElements()) {
            InputStream inputStream = this.getClass().getResourceAsStream(stringTokenizer.nextToken());
            try {
                this.checker.addDictionary(new SpellDictionaryHashMap(new InputStreamReader(inputStream)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.initialized = true;
    }

    public void setText(String string) {
        JSpellChecker.log(this.hashCode() + ": JSpellChecker.setText(" + string + ")");
        if (!this.initialized) {
            throw new IllegalStateException("Spellchecker is loading.");
        }
        this.checker.removeSpellCheckListener(this.listener);
        this.tokens = new StringWordTokenizer(string);
        this.listener = new JSpellCheckListener(this.tokens);
        this.checker.addSpellCheckListener(this.listener);
        this.checker.reset();
    }

    public void setOptions(int n) {
        Configuration configuration = this.checker.getConfiguration();
        for (int i = 1; i <= 131072; i <<= 1) {
            String string = (String)configmap.get(new Integer(i));
            if (string == null) continue;
            configuration.setBoolean(string, (n & i) > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean check() {
        if (!this.listener.isAlive()) {
            this.listener.start();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.listener.done();
        }
        JSpellCheckListener jSpellCheckListener = this.listener;
        synchronized (jSpellCheckListener) {
            this.listener.notifyAll();
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.listener.done();
    }

    private String getSuggestionList(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Word word = (Word)iterator.next();
            string = string + word.getWord() + "|";
        }
        return string;
    }

    public String getSuggestions() {
        return this.getSuggestionList(this.event.getSuggestions());
    }

    public String getSuggestions(String string) {
        return this.getSuggestionList(this.checker.getSuggestions(string, 0));
    }

    public String getMisspelledWord() {
        if (this.event != null) {
            return this.event.getInvalidWord();
        }
        return null;
    }

    public int getCursorPosition() {
        if (this.event != null) {
            return this.event.getWordContextPosition();
        }
        return 0;
    }

    public void changeWord(String string, boolean bl) {
        if (this.event != null) {
            if (string == null) {
                string = "";
            }
            this.event.replaceWord(string, bl);
        }
    }

    public void ignoreWord(boolean bl) {
        if (this.event != null) {
            this.event.ignoreWord(bl);
        }
    }

    protected static void log(String string) {
        System.out.println(string);
    }

    static {
        configmap.put(new Integer(16), "SPELL_IGNOREDIGITWORDS");
        configmap.put(new Integer(65536), "SPELL_IGNOREINTERNETADDRESS");
        configmap.put(new Integer(8), "SPELL_IGNOREMIXEDCASE");
        configmap.put(new Integer(64), "SPELL_IGNOREMULTIPLEWORDS");
        configmap.put(new Integer(4), "SPELL_IGNORESENTENCECAPTILIZATION");
        configmap.put(new Integer(2), "SPELL_IGNOREUPPERCASE");
    }

    private class JSpellCheckListener
    extends Thread
    implements SpellCheckListener {
        private boolean done;
        private StringWordTokenizer tokens;

        private JSpellCheckListener(StringWordTokenizer stringWordTokenizer) {
            JSpellChecker.log(this.hashCode() + ": JSpellCheckListener.init");
            this.tokens = stringWordTokenizer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void spellingError(SpellCheckEvent spellCheckEvent) {
            JSpellChecker.log(this.hashCode() + ": JSpellCheckListener.spellingError");
            JSpellChecker.this.event = spellCheckEvent;
            JSpellChecker jSpellChecker = JSpellChecker.this;
            synchronized (jSpellChecker) {
                JSpellChecker.this.notifyAll();
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public boolean done() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            JSpellChecker.log(this.hashCode() + ": JSpellCheckListener.run");
            this.done = false;
            JSpellChecker.this.checker.checkSpelling(this.tokens);
            this.done = true;
            JSpellChecker jSpellChecker = JSpellChecker.this;
            synchronized (jSpellChecker) {
                JSpellChecker.this.notifyAll();
            }
        }
    }
}

