/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.texparser;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.texlipse.model.ReferenceEntry;
import net.sourceforge.texlipse.model.TexCommandEntry;
import net.sourceforge.texlipse.texparser.LatexLexer;
import net.sourceforge.texlipse.texparser.TexParser;
import net.sourceforge.texlipse.texparser.lexer.LexerException;
import net.sourceforge.texlipse.texparser.node.EOF;
import net.sourceforge.texlipse.texparser.node.TArgument;
import net.sourceforge.texlipse.texparser.node.TCbib;
import net.sourceforge.texlipse.texparser.node.TCbibstyle;
import net.sourceforge.texlipse.texparser.node.TClabel;
import net.sourceforge.texlipse.texparser.node.TCnew;
import net.sourceforge.texlipse.texparser.node.TCommentline;
import net.sourceforge.texlipse.texparser.node.TCpackage;
import net.sourceforge.texlipse.texparser.node.TCpindex;
import net.sourceforge.texlipse.texparser.node.TOptargument;
import net.sourceforge.texlipse.texparser.node.TStar;
import net.sourceforge.texlipse.texparser.node.TWhitespace;
import net.sourceforge.texlipse.texparser.node.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatexRefExtractingParser {
    private ArrayList<ReferenceEntry> labels;
    private ArrayList<TexCommandEntry> commands;
    private List<String> bibs;
    private String bibstyle;
    private boolean biblatexMode;
    private String biblatexBackend;
    private boolean index;
    private boolean fatalErrors = false;
    private String preamble;

    private void extractPreamble(String input) {
        this.preamble = TexParser.extractLaTeXPreamble(input);
    }

    private void initializeDatastructs() {
        this.labels = new ArrayList(100);
        this.commands = new ArrayList();
        this.bibs = new ArrayList<String>();
        this.biblatexMode = false;
        this.biblatexBackend = null;
        this.index = false;
    }

    private static String findBiblatexBackend(String options) {
        int beIdx = options.indexOf("backend=");
        if (beIdx > 0) {
            int startIdx = beIdx + 8;
            int endIdx = options.indexOf(44, startIdx);
            if (endIdx > startIdx) {
                return options.substring(startIdx, endIdx).trim();
            }
            if (endIdx == -1) {
                return options.substring(startIdx).trim();
            }
            return null;
        }
        return null;
    }

    public LatexRefExtractingParser() {
        this.initializeDatastructs();
    }

    public void parse(String input) throws IOException {
        this.extractPreamble(input);
        LatexLexer lexer = new LatexLexer(new PushbackReader(new StringReader(input), 4096));
        boolean expectArg = false;
        boolean expectArg2 = false;
        Token prevToken = null;
        String packageOptions = null;
        TexCommandEntry currentCommand = null;
        int argCount = 0;
        try {
            Token t = lexer.next();
            while (!(t instanceof EOF)) {
                if (expectArg) {
                    if (t instanceof TArgument) {
                        if (prevToken instanceof TClabel) {
                            ReferenceEntry l = new ReferenceEntry(t.getText());
                            l.setPosition(t.getPos(), t.getText().length());
                            l.startLine = t.getLine();
                            l.setLabelInfo(input);
                            this.labels.add(l);
                        } else if (prevToken instanceof TCbib) {
                            String[] sBibs;
                            String[] stringArray = sBibs = t.getText().split(",");
                            int n = sBibs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String bib = stringArray[n2];
                                this.bibs.add(bib.trim());
                                ++n2;
                            }
                        } else if (prevToken instanceof TCbibstyle) {
                            this.bibstyle = t.getText();
                        } else if (prevToken instanceof TCnew) {
                            currentCommand = new TexCommandEntry(t.getText().substring(1), "", 0);
                            currentCommand.startLine = t.getLine();
                            expectArg2 = true;
                        } else if (prevToken instanceof TCpackage && t.getText().equals("biblatex")) {
                            this.biblatexMode = true;
                            if (packageOptions != null) {
                                this.biblatexBackend = LatexRefExtractingParser.findBiblatexBackend(packageOptions);
                                packageOptions = null;
                            }
                        }
                        prevToken = null;
                        expectArg = false;
                    } else if (t instanceof TOptargument) {
                        if (prevToken instanceof TCpackage) {
                            packageOptions = t.getText();
                        }
                    } else if (!(t instanceof TWhitespace || t instanceof TStar || t instanceof TCommentline)) {
                        prevToken = null;
                        expectArg = false;
                    }
                } else if (expectArg2) {
                    if (t instanceof TArgument) {
                        currentCommand.info = t.getText();
                        this.commands.add(currentCommand);
                        argCount = 0;
                        expectArg2 = false;
                    } else if (t instanceof TOptargument) {
                        if (argCount == 0) {
                            try {
                                currentCommand.arguments = Integer.parseInt(t.getText());
                            }
                            catch (NumberFormatException numberFormatException) {
                                expectArg2 = false;
                            }
                        }
                        ++argCount;
                    } else if (!(t instanceof TWhitespace) && !(t instanceof TCommentline)) {
                        argCount = 0;
                        expectArg2 = false;
                    }
                } else if (t instanceof TClabel || t instanceof TCbib || t instanceof TCbibstyle || t instanceof TCnew || t instanceof TCpackage) {
                    prevToken = t;
                    expectArg = true;
                } else if (t instanceof TCpindex) {
                    this.index = true;
                }
                t = lexer.next();
            }
        }
        catch (LexerException lexerException) {
            this.fatalErrors = true;
        }
    }

    public String[] getBibs() {
        return this.bibs.toArray(new String[0]);
    }

    public String getBibstyle() {
        return this.bibstyle;
    }

    public boolean isBiblatexMode() {
        return this.biblatexMode;
    }

    public String getBiblatexBackend() {
        return this.biblatexBackend;
    }

    public boolean isIndex() {
        return this.index;
    }

    public ArrayList<ReferenceEntry> getLabels() {
        return this.labels;
    }

    public ArrayList<TexCommandEntry> getCommands() {
        return this.commands;
    }

    public String getPreamble() {
        return this.preamble;
    }

    public boolean isFatalErrors() {
        return this.fatalErrors;
    }
}

