# Voreinstellungsmen fr Logfiles/Protokolldateien   
#
# Copyright (C) 2000  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc lv  {} {

proc lvanzeige {s1} {
  global vv Wl logtext logform logback logxterm logoptions main_file lsuff
  writescr0 $Wl.d.tt "$s1\n\n$logtext\n\n $vv(lv2)  $logform$logback\n" \
	" $vv(lv7)  $logxterm\n $vv(lv3)  $logoptions\n" \
	" $vv(lv4)  [fileName $main_file]$lsuff\n"
}

proc lvfsel {s} {
  global Wl vv lvfsep logtext logxterm logform logoptions logback lvfsel_v lsuff
  global lvssel_v lvssel_v1
  set logtext [getvalue $s 0 $lvfsep]; set logxterm   [getvalue $s 1 $lvfsep]
  set logform [getvalue $s 2 $lvfsep]; set logoptions [getvalue $s 3 $lvfsep]
  if {($logform=="tla")&&($lsuff!=".log")} {set lsuff ".log"; set lvssel_v $lvssel_v1}
  progback logform logback;  logedit;  lvanzeige "$vv(lv5)"
  knoepfe; set lvfsel_v "$s"
}

proc lvssel {s} {
  global Wl vv main_file lsuff lvssel_v lvssel_v1 logform
  set i [string range $s 0 [expr [string first " " $s]-1]]
  set i [string range $i [string last "." $i] end]
  if {($i!=".log")&&($logform=="tla")} {
    set lvssel_v $lvssel_v1; set t "$vv(lv8) $main_file.log"
  } else {
    set lsuff $i; set t "$vv(lv6) [fileName $main_file]$lsuff\n"; set lvssel_v "$s"
  }
  writescr0 $Wl.d.tt $t; knoepfe
}

proc logedit {} {
  global logform logxterm logback logoptions logtext edxterm editor edback edoptions
  if {$logform=="\$editor"} {
    set logxterm $edxterm; set logform $editor; set logback $edback; set logoptions $edoptions
    set logtext ""
  }
}

proc lvWlae {} {global Wl; destros $Wl; knoepfe; unlock_list}

global vv Wl dir main_file logform logtext logback lsuff lvfsep lvfsel_v lvssel_v lvssel_v1


if {$main_file==""} {writescr0 .d.tt "***** $vv(ea1)\n";  unlock_list; mybell 2; return}


toplevel_init $Wl "$vv(lvvor)" 0 0;  set tyh 20;  set dir [pwd]


# Bereich a fuer erste Buttons

insertTopButtons $Wl lv_h lvWlae
button $Wl.a.g -text "$vv(ag)" -command \
	{vstr_logfile; progback logform logback; logedit; lvanzeige "$vv(ausg1)"; knoepfe}
Bind3HF $Wl.a.g lv_grund $Wl.d.tt
pack configure $Wl.a.g -side left -padx 3 -pady 3


# Bereich bv fuer eigene Einstellungen

frame  $Wl.bv; pack configure $Wl.bv -pady 13 -anchor w
label  $Wl.bv.dv -text "$vv(bvdv)" -width 23 -anchor w
Bind3HF $Wl.bv.dv z_voreinst1 $Wl.d.tt
button $Wl.bv.va -text "$vv(bvva)" -command {lvanzeige "$vv(aus0)"}
Bind3HF $Wl.bv.va z_voreinst1 $Wl.d.tt
pack configure $Wl.bv.dv $Wl.bv.va -side left


# Bereich c fuer Wechsel
frame $Wl.c; pack configure $Wl.c -anchor w
set he 12

# Bereich c1 fuer Wechsel Darstellungsart
frame $Wl.c.1; pack configure $Wl.c.1 -side left -anchor nw -fill x
set lvfsep [getsep logform.vst]
CreateLSBox $Wl.c.1 $vv(lvc1fl) top 40 $he 2 lv_logform $Wl.d.tt \
	$lvfsep [vst2list logform.vst 1 $lvfsep "$logtext" lvfsel_v] lvfsel "" lvWlae

# Bereich c2 fuer Wechsel Protokolldatei
frame $Wl.c.2; pack configure $Wl.c.2 -side left -anchor nw
set dateiliste [lsort [glob -nocomplain -- *]]
set f [open_vst logsuffix.vst]
set liste ""; set lvssel_v ""
if [info exists lvssel_v1] {unset lvssel_v1}
while {[getscl $f e]>0} {
  TestPut 4 "<$e> <$liste>"
  set suff [string trim [string range $e 0 [string first " " $e]]]
  if {[string first [fileName $main_file]$suff $dateiliste]>=0} {set l "$e ($vv(ex))"} \
  else {set l "$e ($vv(nex))"}
  lappend liste $l
  if ![info exists lvssel_v1] {set lvssel_v1 $l}
  if {$lsuff==[getvalue $e 0 " "]} {set lvssel_v "$l"}
}
close $f
set t "$vv(lvc2dl) `[fileName $main_file]':"
CreateLSBox $Wl.c.2 $t top 50 $he 2 lv_filesel $Wl.d.tt "" $liste lvssel "" lvWlae


InsertTextFrame $Wl $tyh "" "" ""
}
