# installation menu for xtem_TeXMenu
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Bremen University
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University
#
##############################################################################################

set copyright "Copyright 1996  G.Lamprecht, W.Lotz, R.Weibezahn; LRW/IWD, Bremen University"
set email     "e-mail: weibezahn@iwd.uni-bremen.de"
set www       "WWW:    http://www.iwd.uni-bremen.de/xtem/xtem_texmenu.html"
set testPut 0; # 0: no testoutput at all; 1: testoutput according to bell_level 0 (much output) | 1 | ... | 4 (no putput)
set bell_level 0
set RequestActive 0
if [info exists env(PATH)] {set whichcheck "yes"} else {set whichcheck "no"}

set INSTPATH        "[lindex $argv  0]"
set BINPATH         "[lindex $argv  1]"
set MANPATH         "[lindex $argv  2]"
set WISHCALL        "[lindex $argv  3]"
set TCLCALL         "[lindex $argv  4]"
set XTERMCALL       "[lindex $argv  5]"
set XTEMVERSION     "[lindex $argv  6]"
set LANGUAGES       "[lindex $argv  7]"
set DEFAULTLANGUAGE "[lindex $argv  8]"
set XiMaxBoxWidth   "[lindex $argv  9]"

puts stdout "xtem_TeXMenu installation menu starts with parameters:"
puts stdout "   INSTPATH        : \"$INSTPATH\""
puts stdout "   BINPATH         : \"$BINPATH\""
puts stdout "   MANPATH         : \"$MANPATH\""
puts stdout "   WISHCALL        : \"$WISHCALL\""
puts stdout "   TCLCALL         : \"$TCLCALL\""
puts stdout "   XTERMCALL       : \"$XTERMCALL\""
puts stdout "   XTEMVERSION     : \"$XTEMVERSION\""
puts stdout "   LANGUAGES       : \"$LANGUAGES\""
puts stdout "   DEFAULTLANGUAGE : \"$DEFAULTLANGUAGE\""
puts stdout "   XiMaxBoxWidth   : \"$XiMaxBoxWidth\""
puts stdout "   \[pwd\]           : \"[pwd]\""
puts stdout ""


if	{[info commands set]==""}	{set errt "is not a Tcl/Tk/TclX-shell"} \
elseif	{[info commands pack]==""}	{set errt "is a Tcl-shell but not a Tcl/Tk/TclX-Shell"} \
elseif	{[info commands infox]==""}	{set errt "is a Tcl/Tk-shell but not a Tcl/Tk/TclX-Shell"} \
else					{set errt ""}
if {$errt!=""} {puts "\n***** Error: Variable WISHCALL in file xteminstall\n$errt (see `Installation Guide')\n"; exit}


set stt ""; set mousebutts 3; set bindkeysenab 0
source ut.tcl; source xV.tcl; set XiInstallationRuns 1

# now set array vv with texts for this xtem release
set f [open "help_$DEFAULTLANGUAGE/button.texts" r]
while {[gets $f z]>=0} {
	set z "[string trim $z] "; set p [string first " " $z]
	set vv([string range $z 0 [expr $p-1]]) [string trim [string range $z $p end]]
}
close $f

if {"$INSTPATH"=="$BINPATH"} {puts stdout "\n***** Error: BINPATH cannot be set to $INSTPATH\n"; mybell 4; exit}

proc XiProtokoll {text} {puts stdout "$text"; flush stdout; if [winfo exists .d.tt] {writescr .d.tt "$text\n"}}
proc XiProtokollEnd2 {text} {global XiProtEndText2; XiProtokoll "$text"; set XiProtEndText2 "${XiProtEndText2}$text\n"}
proc XiProtokollEnd4 {text} {global XiProtEndText4; XiProtokoll "$text"; set XiProtEndText4 "${XiProtEndText4}$text\n"}

set NEWV "$XTEMVERSION"; set NEW "xtem-$NEWV"

set Wvsts  ".xteminstall_vsts";  # main menu
set Wenews ".xteminstall_enews"; # edit local news files
set Wevst  ".xteminstall_evst";  # edit vst file: all buttons
set Wevstb ".xteminstall_evstb"; # edit vst file (all the file in one text widget)
set Wevstl ".xteminstall_evstl"; # edit vst file (one entry, splitted into parameters) 
set Wevsta ".xteminstall_evsta"; # append a parameter to a vst file (if variable # of parameters)
set Wevstd ".xteminstall_evstd"; # delete a parameter from a vst file (if variable # of parameters)

set XiVstPBDLw ""

set XV(AAsteriks) "********************************************************************************"
set XV(anever)    "String which never should occur normally!"
set XV(anoact)    "the selected entry is not an active one ---"
set XV(anoact)     "$XV(anoact) select an active entry or `make_active' or `copy_to_active' first!"
set XV(anocopy)   "the selected entry cannot be copied!"
set XV(anodelete) "this entry cannot be deleted!"
set XV(anoentry)  "no entry selected --- select entry first!"
set XV(anoinact)  "the selected entry is not a comment --- select an entry from the comment list!"
set XV(anomove)   "the selected entry cannot be moved!"
set XV(anomovedo) "the selected entry cannot be moved downwards within this list any more!"
set XV(anomoveup) "the selected entry cannot be moved upwards within this list any more!"
set XV(MkCmdNCol1) "New column generated for Tcl version"
set XV(MkCmdNCol2) "complete all lines (starting with the 2nd line) according to your system!"
set XV(Xeebabrt)  "abort"
set XV(Xeebends)  "end"
set XV(Xeebnext)  "down"
set XV(Xeebprev)  "up"
set XV(Xeebpdel)  "delete_parameter"
set XV(Xeebpadd)  "add_parameter"
set XV(Xeetabrt)  "abort this window"
set XV(Xeetends)  "ends this window (saving changes done in this window!)"
set XV(Xeetnext)  "switch to the next entry in the entry list (saving changes done in this window!)"
set XV(Xeetprev)  "switch to the previous entry  in the entry list (saving changes done in this window!)"
set XV(Xeetpdel)  "after clicking this button you can specify the parameter to be deleted (from each entry)"
set XV(Xeetpadd)  "after clicking this button you can specify a new parameter to be added (to each entry)"
set XV(XSettVButtons) "1 2 3 4 5 6 7 8 9 10 11 12"
set XV(XSettVBut1)  "edit_all_entries XiSettVBEditBuff  {edit all entries in a text edit widget} {}"
set XV(XSettVBut2)  "append_new_entry XiSettVBAppdNewE  {create a new active entry and edit this entry} {}"
set XV(XSettVBut3)  "copy_to_active   XiSettVBCopyAct   \
	{copy the selected inactive entry to the active entries (Shift modifier for successive copies)} \
							{selected entry is copied}"
set XV(XSettVBut4)  "copy_to_inactive XiSettVBCopyInact \
	{copy the selected active entry to the comment lines (Shift modifier for successive copies)} \
							{selected entry is copied}"
set XV(XSettVBut5)  "edit_one_entry   XiSettVBEditEntry {edit the selected active entry} {}"
set XV(XSettVBut6)  "delete_entry     XiSettVBDeltEntry {delete selected entry (Shift modifier for successive delete)} \
							{selected entry is deleted}"
set XV(XSettVBut7)  "move_to_active   XiSettVBMakeActiv \
	{move the selected comment line to the active entries (Shift modifier for successive moves)} \
							{selected entry is moved to active entries}"
set XV(XSettVBut8)  "move_to_inactive XiSettVBMakeInact \
	{move the selected active entry to the comment lines (Shift modifier for successive moves)} \
							{selected entry is moved to comments}"
set XV(XSettVBut9)  "copy&edit_entry  XiSettVBCpEdEntry {copy the selected active entry and edit the copy} {}"
set XV(XSettVBut10) "move_to_default  XiSettVBMoveDeflt {move the selected entry to default position} \
							{moved to default position}"
set XV(XSettVBut11) "move_1_up        XiSettVBMove1Up   {move the selected entry 1 line up} \
							{selected entry moved up}"
set XV(XSettVBut12) "move_1_down      XiSettVBMove1Down {move the selected entry 1 line down} \
							{selected entry moved down}"
set XV(XSettVBut13) "$XV(Xeebpdel)    XiSettVBParDel    {$XV(Xeetpdel)} {}"
set XV(XSettVBut14) "$XV(Xeebpadd)    XiSettVBParAdd    {$XV(Xeetpadd)} {}"
set XV(XSettVComgerman)  "*** ab hier \"Kommentar\" (Leerzeile beendet den ausgewerteten Teil der Datei!)"
set XV(XSettVComenglish) "*** the preceding empty line ends the setting file, the following is \"comment\""
set XiVstLO 10; # Vst-List-Offset for the following specifications in XV(XSettVF...)
# [lindex (XV(XSettVF...)  0] : file has separator (1) or not (0)
# [lindex (XV(XSettVF...)  1] : criteria line (1) or no criteria line (0)
# [lindex (XV(XSettVF...)  2] : number of parameters (without user added parameters, see printing.vst)
# [lindex (XV(XSettVF...)  3] : user may specify new parameters. eg. printing.vst (1) or not (0)
# [lindex (XV(XSettVF...)  4] : width for entry/text widgets in vst-entry-change window
# [lindex (XV(XSettVF...)  5] : width for labels in vst-entry-change window
# [lindex (XV(XSettVF...)  6] : position for label relative to entry/text widgets in vst-entry-change window
# [lindex (XV(XSettVF...)  7] : current number of parameters (will be set by xi.tcl, procedure XiSettEditVst)
# [lindex (XV(XSettVF...)  8] : if != "" : minimum width for parameter p0 if of no file separator
# [lindex (XV(XSettVF...)  9] : 
# [lindex (XV(XSettVF...) 10] : list:  p0 | {p0 [p1 [p2 p3]]}
#                                   p0: parameter_name (_ if unused, e.g. printing.vst)
#                                   p1: =1 if_parameter_must_be_nonempty; blank or 0 otherwise
#                                   p2: blank if no "suboptions", otherwise 
#                                       number of lines for text edit widget for this parameter (see printing.vst)
set XV(XSettVFbibtex.vst)      "1 0  2 0 45 30 top  {} {} {} {bitext 1} {bibtex 1} bioptions"
set XV(XSettVFcleanup.vst)     "1 0  1 0 10 30 top  {} {} {} {aufsuff 1} {auftoggle 1}"
set XV(XSettVFeditor.vst)      "1 0  3 0 50 30 top  {} {} {} {edtext 1} edxterm {editor 1} edoptions"
set XV(XSettVFhyphen.vst)      "1 0  4 0 30 20 top  {} {} {} {hyphentext 1} {texposthyph 1} hyphenprog hyphenopts"
set XV(XSettVFhyphen.vst)      "$XV(XSettVFhyphen.vst) hyphenchk"
set XV(XSettVFindex.vst)       "1 0  2 0 55 30 top  {} {} {} {intext 1} index inoptions"
set XV(XSettVFinstall.vst)     "0 0  1 0 60 30 top  {} 20 {} variable_name variable_value"
set XV(XSettVFletters.vst)     "1 0  0 0 50 30 top  {} {} {} "
set XV(XSettVFloganalyze.vst)  "1 0  2 0 24 30 top  {} {} {} {texlogatext 1} {texloganalyze 1} texlogopts"
set XV(XSettVFlogform.vst)     "1 0  3 0 45 30 top  {} {} {} {logtext 1} logterm {logform 1} logoptions"
set XV(XSettVFlogsuffix.vst)   "0 0  1 0 45 30 top  {}  6 {} lsuff text_describing_the_logfile"
set XV(XSettVFmkcommand.vst)   "1 0  0 1 60 30 top  {} {} {} {text 1}"
set XV(XSettVFpreview.vst)     "1 0  4 0 52 30 top  {} {} {} {prtext 1} {preview 1} {prsuffix 1} proptions {prvformat 1}"
set XV(XSettVFprinting.vst)    "1 1 11 1 60 15 left {} {} {} {text 1} {printer 1} {emulation 1} {prtdriver 1} {prtsuf 1}"
set XV(XSettVFprinting.vst) "$XV(XSettVFprinting.vst) prtoptions {lpcmd 1} lpopt _ _ _ {prformat 1 4}"
set XV(XSettVFprt_dvi2xyz.vst) "1 0  7 0 85 30 top  {} {} {} {prmtext 1} prmrelabs {prmsel 1} _"
set XV(XSettVFprt_dvi2xyz.vst) "$XV(XSettVFprt_dvi2xyz.vst) prtcmd(1) prtcmd(2) prtcmd(3) prtcmd(4)"
set XV(XSettVFspellcheck.vst)  "1 0  5 0 80 30 top  {} {} {} {sptext 1} {spcmd 1} splang spcorr spselect spoptions"
set XV(XSettVFsuffix.vst)      "0 0  0 0 20 30 top  {}  6 {} esuff"
set XV(XSettVFsyntax.vst)      "1 0  2 0 55 30 top  {} {} {} {sytext 1} {syntax 1} syoptions"
set XV(XSettVFtexfmt.vst)      "1 0  9 0 50 30 top  {} {} {} {text 1} {texfmt 1} quickenable quickverbatim quickprereq"
set XV(XSettVFtexfmt.vst)   "$XV(XSettVFtexfmt.vst) quickpreform quicksuffix quickpreamble quickendpre quickenddoc"
set XV(XSettVFtexmax.vst)      "0 0  0 0 10 30 top  {} {} {} texmax";# obsolete; only for backward compatibility!
set XV(XSettVFtexsiz.vst)      "1 0  1 0 12 30 top  {} {} {} {texmtext 1} texmem"
set XV(XSettVFtexsuffix.vst)   "0 0  0 0 10 30 top  {}  6 {} texsuffix"
set XV(XSettVFutility.vst)     "1 0  7 0 50 30 top  {} {} {} {text 1} {command 1} options file_requested default_suffix"
set XV(XSettVFutility.vst)  "$XV(XSettVFutility.vst)  suffix_list cd_dir (no)backup"


set alink1    "Symbolic links are not available at this Tcl installation; xteminstall thus "
set alink2    "cannot run. Sorry, but you have to do the installation manually, see Installation Guide!"
if {[info commands link]==""} {XiProtokoll "$alink1\n$alink2\n"; exit}; # link command available?


setTclVersions
if {$tclversion<7.4} {puts stdout "This version of xtem needs a newer Tcl version!"; exit}

#----- common procs      ----------------------------------------------------------------------

proc XiEnabModVst {args} {
 set enabModVst 1
 foreach f $args {
   if {(![file exists $f])||(![file isdir $f])} {set enabModVst 0}
   if {([file exists $f])&&([file type $f]=="link")&&([file tail [file readlink $f]]=="$f.LRW")} {set enabModVst 0}
   TestPut 4 "<$args><$f><$enabModVst>"
 }
   return $enabModVst
}

proc Languages {} {# Languages <-- all Languages defines in LANGUAGES. but without synonyms!
 global LANGUAGES LAnguages
 if ![info exists LAnguages] {
   set lstr "$LANGUAGES"; set LAnguages ""
   while {[lindex $lstr 0]!=""} {set LAnguages "$LAnguages [lindex [lindex $lstr 0] 0]"; set lstr [lrange $lstr 1 end]}
   TestPut 4 "LAnguages=<$LAnguages>"
 }
 return "$LAnguages"
}

#----- main menu        ----------------------------------------------------------------------

wm iconname . "xteminstall";  wm title . "xteminstall: [pwd] (version: $NEWV)"
wm minsize . 300 50; wm geometry . 1000x500
TestPut 3 "********************** Start main procedure!"


# top section buttons (end, install, settings)

frame .a; pack .a -fill x
button .a.ende -text "end" -command {destroy .}
label .a.dummy -width 5
button .a.inst -text "install xtem" -width 20 -command {XiInstall};  # "install" section
button .a.vsts -text "change settings" -width 20 -command {XiSettings}; #  modify "settings"
pack .a.ende .a.dummy .a.inst .a.vsts -side left -padx 5 -pady 5
if {[XiEnabModVst locals_$DEFAULTLANGUAGE]} {.a.vsts configure -state normal} else {.a.vsts configure -state disabled}

set textxscroll 1; set Wx  .xtemx; InsertTextFrame "" 25 "" "" ""


#----- installation proc's -------------------------------------------------------------------

proc XiGetVersion {dir} {
 TestPut 3 ""

 if {[file exists $dir/xV.tcl]||[file exists $dir/xtem.tcl]} {
   if [file exists $dir/xV.tcl] {set file xV.tcl; #version>=5.01} else {set file xtem.tcl; #version<=5.00}
   set ret "old"
   set f [open $dir/$file]
   for {set i 1} {$i<=40} {incr i} {getscl $f z
		set e [string trim $z];                set p [string first " " $e];set w1 "$e"
     if {$p>0} {set w1 [string range $e 0 [expr $p-1]]
		set e [string trim [string range $e $p end]]; set p [string first " " $e]; set w2 "$e"}
     if {$p>0} {set w2 [string range $e 0 [expr $p-1]]
		set e [string trim [string range $e $p end]]; set p [string first " " $e]; set w3 "$e"}
     if {$p>0} {set w3 [string range $e 0 [expr $p-1]]}
     if {($w1=="set")&&($w2=="version")&&([string index $w3 0]=={"})} {
       if {[string first ";" $e]>0} {set e [string range $e 0 [expr [string first ";" $e]-1]]}
       set ret [lindex $e 0]
     }
   }
   close $f
   return $ret
 }
  
}

proc XiChmod {mode names} {
 TestPut 2 ""
 XiProtokoll "\t chmod $mode $names"
 foreach n $names {if [file exists $n] {chmod $mode $n} else {chmod $mode "[glob -- $n]"} }
 update
}

proc XiFillString {string length} {# fills string up to lenght with trailing blanks
 TestPut 2 ""
 while {[string length $string]<$length} {set string "$string "}; return "$string"
}

proc XiNotInstalledText {} \
 {return " <--- this file couldn't be installed\n(no write permission); restart xteminstall once more,  or do manually:"}

proc xiVstCallsWhich {} {

 proc xiVstCalls {file par} {
   global XiVstActive XiVstSep XiCurLanguage
   set ret ""
   XiVst2Lists $file "" new
   TestPut 4 "<locals_$XiCurLanguage/$file><$XiVstSep><$par>\n\t\t\t<$XiVstActive>"
   for {set e 0} {$e<[llength $XiVstActive]} {incr e} \
	{lappend ret "\{[getvalue [lindex $XiVstActive $e] $par $XiVstSep]\} $file $e $par"}
   return $ret
 }

 proc xiTclCalls {cmd} {
   set ret ""
   TestPut 4 "<[pwd]><[glob prt_dvi*.tcl]>\t\t<$cmd>"
   SigChldB; set gres [catch "exec grep -n $cmd [glob prt_dvi*.tcl]" grest]; SigChldU
   if {($gres==0)&&($grest!="")} {
     set list [split "$grest" \n]
     foreach le $list {
       set le [split [string trimright "$le" \\] :]
       set file [lindex "$le" 0]; set ln [lindex "$le" 1]
       set t [string trim [string trim [lrange "$le" 2 end] \{\}]]
       if {[string first \# $t]!=0} {lappend ret "$cmd $file $ln"}
     }
   }
   return $ret
 }

 proc xiInstCalls {var} {
   global XiCurLanguage
   set ret ""
   TestPut 4 "<[pwd]><locals_$XiCurLanguage/install.vst>\t\t<$var>"
   set f [open locals_$XiCurLanguage/install.vst]; set l 0
   while {[getscl $f e]>0} {
     incr l
     if {([string compare [lindex $e 0] "$var"]==0)&&([string compare [lindex $e 1] ""]!=0)} \
	{set ret "\{[lindex $e 1] install.vst $l/$var 1\}"}
   }
   close $f
   return $ret
 }

 global INSTPATH NEW XiProtEndText2 LANGUAGES XiCurLanguage language

 if ![info exists  XiProtEndText2] {set XiProtEndText2 ""}

 XiProtokoll "\n\nCheck whether the programs callable via the setting files are installed or not:"
 XiProtokoll "   (in directories \t\"$INSTPATH/$NEW/\",\n \t\t\t\"$INSTPATH/$NEW/locals_*/\")\n"

 set InstalledProgs ""
 set NotInstalledProgs ""
 set textnf "program not found, yet can be called via"
 set pln ""; set pln "$pln [xiTclCalls dvidvi]"; set pln "$pln [xiTclCalls dvips]"
 TestPut 3 " pln=<$pln>"
 for {set n 0} {$n<[llength $pln]} {incr n} {
   set program "[string trimright [lindex [lindex $pln $n] 0] &]"
   set file  "[lindex [lindex $pln $n] 1]";  set line "(line [lindex [lindex $pln $n] 2])"
   set not_installed [catch "which $program" m1]
   if {$program!=""} {
     if $not_installed {
       XiProtokoll "[XiFillString $program 20] : $textnf  $file $line"
       if {[lsearch $NotInstalledProgs $program]<0} {lappend NotInstalledProgs $program}
     } else {
       if {[lsearch $InstalledProgs $program]<0} {lappend InstalledProgs $program}
     }
   }
 }
 TestPut 3 "\n\n*****2\n<<$InstalledProgs>>\n\n<<$NotInstalledProgs>>\n\n"
 XiProtokoll     ""
 foreach XiCurLanguage [Languages] {
   set language $XiCurLanguage; # needed for proc "open_vst"
   set ProgramList(quickprevstd)    "[xiInstCalls quickprevstd]"
   set ProgramList(editor)          "[xiVstCalls editor.vst 2]"
   set ProgramList(editorxterm)     "[xiVstCalls editor.vst 1]"
   set ProgramList(texfmt)          "[xiVstCalls texfmt.vst 1]"
   set ProgramList(hyphenprog)      "[xiVstCalls hyphen.vst 2]"
   set ProgramList(previewer)       "[xiVstCalls preview.vst 1]"
   set ProgramList(printingdriver)  "[xiVstCalls printing.vst 3]"
   set ProgramList(printinglp)      "[xiVstCalls printing.vst 6]"
   set ProgramList(spellcheck)      "[xiVstCalls spellcheck.vst 1]"
   set ProgramList(syntax)          "[xiVstCalls syntax.vst 1]"
   set ProgramList(index)           "[xiVstCalls index.vst 1]"
   set ProgramList(bibtex)          "[xiVstCalls bibtex.vst 1]"
   set ProgramList(logform)         "[xiVstCalls logform.vst 2]"
   set ProgramList(utility)         "[xiVstCalls utility.vst 1]"
   set ProgramList(prt_dvips4)      "[xiVstCalls prt_dvips.vst 4]"
   set ProgramList(prt_dvips5)      "[xiVstCalls prt_dvips.vst 5]"
   set ProgramList(prt_dvips6)      "[xiVstCalls prt_dvips.vst 6]"
   set ProgramList(prt_dvips7)      "[xiVstCalls prt_dvips.vst 7]"
   set ProgramList(prt_dvijep4)     "[xiVstCalls prt_dvijep.vst 4]"
   set ProgramList(prt_dvijep5)     "[xiVstCalls prt_dvijep.vst 5]"
   set ProgramList(prt_dvijep6)     "[xiVstCalls prt_dvijep.vst 6]"
   set ProgramList(prt_dvijep7)     "[xiVstCalls prt_dvijep.vst 7]"
   set ProgramList(prt_dvilj4)      "[xiVstCalls prt_dvilj.vst 4]"
   set ProgramList(prt_dvilj5)      "[xiVstCalls prt_dvilj.vst 5]"
   set ProgramList(prt_dvilj6)      "[xiVstCalls prt_dvilj.vst 6]"
   set ProgramList(prt_dvilj7)      "[xiVstCalls prt_dvilj.vst 7]"
   foreach pln [lsort [array names ProgramList]] {
     TestPut 3 " pln=<$pln>  <$ProgramList($pln)>"
     for {set n 0} {$n<[llength $ProgramList($pln)]} {incr n} {
       set program "[string trimright [lindex [lindex [lindex $ProgramList($pln) $n] 0] 0] &]"
       set file  "locals_$language/[lindex [lindex $ProgramList($pln) $n] 1]"
       set lpar "(entry [lindex [lindex $ProgramList($pln) $n] 2],"
       set lpar "$lpar parameter [lindex [lindex $ProgramList($pln) $n] 3])"
       if {($pln=="logform")&&($program=="tla")} {
	 set lookfor 1; set not_installed 0
       } elseif {($pln=="logform")&&($program=="\$editor")} {
	 set lookfor 0
       } else {
	 set lookfor 1; set not_installed [catch "which $program" m1]
       }
       if {$lookfor&&($program!="")} {
	 if $not_installed {
	   XiProtokoll "[XiFillString $program 20] : $textnf  $file $lpar"
	   if {[lsearch $NotInstalledProgs $program]<0} {lappend NotInstalledProgs $program}
	 } else {
	   if {[lsearch $InstalledProgs $program]<0} {lappend InstalledProgs $program}
	 }
       }
     }
     TestPut 3 "\n\n*****4\n<<$InstalledProgs>>\n\n<<$NotInstalledProgs>>\n\n"
   }
   update
   XiProtokoll     ""
 }
 TestPut 3 "\n\n*****5\n<<$InstalledProgs>>\n\n<<$NotInstalledProgs>>\n\n"
 if {$InstalledProgs!=""} {
   set InstalledProgs [lsort $InstalledProgs]
   XiProtokoll "Programs checked and found:"; set nf "\t"
   for {set n 0} {$n<[llength $InstalledProgs]} {incr n 5} {
     set nf "$nf[XiFillString [lindex $InstalledProgs       $n]     12] "
     set nf "$nf[XiFillString [lindex $InstalledProgs [expr $n+1]]  12] "
     set nf "$nf[XiFillString [lindex $InstalledProgs [expr $n+2]]  12] "
     set nf "$nf[XiFillString [lindex $InstalledProgs [expr $n+3]]  12] "
     set nf "$nf[XiFillString [lindex $InstalledProgs [expr $n+4]]  12] "
     set nf "$nf\n\t"
   }
   XiProtokoll "$nf"
 }
 if {$NotInstalledProgs!=""} {
   set NotInstalledProgs [lsort $NotInstalledProgs]
   set pt "\n  The following programs could not be found (`which ...'),\n"
   set pt "${pt}  yet they are callable via the setting files:"
   for {set n 0} {$n<[llength $NotInstalledProgs]} {incr n 5} {
     set pt "${pt}\n\t"
     set pt "$pt[XiFillString [lindex $NotInstalledProgs       $n]     12] "
     set pt "$pt[XiFillString [lindex $NotInstalledProgs [expr $n+1]]  12] "
     set pt "$pt[XiFillString [lindex $NotInstalledProgs [expr $n+2]]  12] "
     set pt "$pt[XiFillString [lindex $NotInstalledProgs [expr $n+3]]  12] "
     set pt "$pt[XiFillString [lindex $NotInstalledProgs [expr $n+4]]  12] "
   }
   set pt "${pt}\nreasons may be:"
   set pt "${pt}\n - program installed, yet cannot be found by `which' currently (PATH variable?)"
   set pt "${pt}\n - program installed with other command name (e.g. `tar' <---> `gtar'),"
   set pt "${pt}\n   install symbolic link or modify setting file concerned"
   set pt "${pt}\n - program not availabe: modify setting file concerned"
   set pt "${pt}\n  (for details see display above and `Installation Guide')"
   set XiProtEndText2 "${XiProtEndText2}$pt"
 }
}

#----- installation        -------------------------------------------------------------------

proc XiInstall {} {

 global XV NEWV NEW XTEMV XTEM OLDV OLD INSTPATH BINPATH MANPATH WISHCALL TCLCALL XTERMCALL 
 global LANGUAGES DEFAULTLANGUAGE env whichcheck tclversion mkcommand MkcmdTclVColNr XiVstVersion
 global XiVstActive XiVstInactive XiCurLanguage XiVstHasSep xtem_path language XiProtEndText4 XiProtEndText2 XiVstSep
 TestPut 3 ""

 set skipRest 0
 set XiProtEndText4 ""; set XiProtEndText2 ""

 foreach b ".a.ende .a.inst .a.vsts" {$b configure -state disabled}; update

 XiProtokoll "$XV(AAsteriks)\nInstallation starts now ...\n"

 chmod u+w $INSTPATH/xtem-$NEWV

 # look for $INSTPATH/xtem
 # if $INSTPATH/xtem exists, it is only allowed to be directory or link; if it's a file ---> exit!
 if [file isfile $INSTPATH/xtem] {XiProtokoll "Error - this should be a directory, but is a file: $INSTPATH/xtem"; exit}

 if [file isdirectory $INSTPATH/xtem] {
   if {[file type $INSTPATH/xtem]=="link"} {set XLINK 1} else {set XLINK 0}
   set XTEMV [XiGetVersion $INSTPATH/xtem]; set XTEM "xtem"
 } else {
   set XTEMV "";			    set XTEM ""
 }

 if {$XTEM==""} {				# $INSTPATH/xtem didn't exist up to now, a link to NEW is to be created

   unlink -nocomplain $INSTPATH/xtem; link -sym $INSTPATH/xtem-$NEWV $INSTPATH/xtem
   set XTEMV "$NEWV";   set XTEM "xtem-$NEWV"
   set OLDV  "";        set OLD  ""

 } else {					# $INSTPATH/xtem exists

   if {$XTEMV==""} {					# exit if version is not found

     XiProtokoll "\nError - couldn't find xtem version in the start lines of: $INSTPATH/$XTEM/xtem.tcl"
     exit

   }

   if {"$NEWV"!="$XTEMV"} {				# XTEMV has to become OLDV

     set OLDV  "$XTEMV";  set OLD  "xtem-$OLDV"
     if {$XLINK} {
	unlink -nocomplain $INSTPATH/xtem
     } else {
	if [file exists $INSTPATH/$OLD] {SigChldB; exec rm -rf $INSTPATH/$OLD; SigChldU}
	frename $INSTPATH/$XTEM $INSTPATH/$OLD
     }
     link -sym $INSTPATH/$NEW $INSTPATH/xtem
     set XTEMV "$NEWV";   set XTEM "xtem"

   } else {						# no OLD version

     set OLDV  "";	  set OLD  ""

   }

 }
 update
 set xtem_path "$INSTPATH/$XTEM"


 # xtem shell-script creation

 if {[file exists xtem]&&[file exists xtemInstalled]} {
   XiProtokollEnd2 "\nShell script \"xtem\" was not generated as file \"xtemInstalled\" exists."
 } else {
   set f [open "xtem" w]
   puts $f {#!/bin/sh}
   puts $f {}
   puts $f {# generated by xteminstall}
   puts $f {}
   puts $f {# If you need to change this file (e.g. adding environment settings etc.),}
   puts $f {# you can prevent xteminstall from overwriting this file}
   puts $f {# at further calls of xteminstall: }
   puts $f {# just create a file "xtemInstalled" in this directory, eg with Unix command:}
   puts $f {#}
   puts $f {#      touch xtemInstalled}
   puts $f {}
   puts $f {#####  command to call wishx (must include Tcl, Tk and TclX)}
   puts $f "wishcall=\"$WISHCALL\""
   puts $f {}
   puts $f {#####  command to call tcl (pure Tcl, without Tk)}
   puts $f "tclcall=\"$TCLCALL\""
   puts $f {}
   puts $f {#####  path in which xtem is installed:}
   puts $f {#####  can be set by the environment variable XTEMPATH; }
   puts $f {#####  if XTEMPATH doesn't exist, it will be set to the following default value:}
   puts $f ": \$\{XTEMPATH=\$\{XTEMPATH-$INSTPATH/xtem\}\}"
   puts $f "#####  (i.e. files      $INSTPATH/xtem/*.tcl     will be found)"
   puts $f {}
   puts $f {#####  one of the following language defining lines must be made active! }
   puts $f {#defaultlanguage="german"}
   puts $f {#defaultlanguage="english"}
   puts $f "defaultlanguage=\"$DEFAULTLANGUAGE\""
   puts $f {}
   puts $f {if [ ! -d "$XTEMPATH" ]}
   puts $f {then}
   puts $f {  echo "error at xtem call:  XTEMPATH=$XTEMPATH   doesn't exist"}
   puts $f {  echo "probably your installation is incomplete, see: xtem Installation Guide)"}
   puts $f {  exit}
   puts $f {fi}
   puts $f {}
   puts $f {if [ "$defaultlanguage" = "" ]}
   puts $f {then}
   puts $f {  defaultlanguage="english"}
   puts $f {  echo "installation incomplete: default language is not specified;  set to $defaultlanguage"}
   puts $f {  echo "please modify file (shell script) \"$0\""}
   puts $f {fi}
   puts $f {}
   puts $f {language=$defaultlanguage}
   puts $f {}
   puts $f {if [ "$1 " = "-l " ] ;# Blanks inserted for Linux}
   puts $f {then language="$2"; shift}
   puts $f {  if [ "$1" = "" ]}
   puts $f {  then}
   puts $f {    echo "syntax:  `basename $0` [ -l language ] [ filename[.tex] ]"}
   puts $f {  else}
   puts $f {    shift}
   puts $f {  fi}
   puts $f {fi}
   puts $f {}
   set languages "$LANGUAGES"; set supported ""; set sep ""
   while {[lindex $languages 0]!=""} {
     set langstring [lindex $languages 0]; set languages [lrange $languages 1 end]
     set language [lindex $langstring 0];  set synonyms [lrange $langstring 1 end]
     set supported "$supported$sep $language";   set sep ","
     while {[lindex $synonyms 0]!=""} {
       puts $f "if \[ \"\$language\" = \"[lindex $synonyms 0]\" \]; then language=\"$language\"; fi"
       set supported "$supported | [lindex $synonyms 0]"
       set synonyms [lrange $synonyms 1 end]
     }
   }
   puts $f "if \[ \\"
   set a "  "
   foreach i [Languages] {puts $f "     $a \"\$language\" != \"$i\" \\";   set a "-a"}
   puts $f {   ]}
   puts $f {then}
   puts $f {  echo "Warning: language \"$language\" not implemented; we use \"$defaultlanguage\" instead"}
   puts $f "  echo \"         supported languages are:  $supported\""
   puts $f {  language=$defaultlanguage}
   puts $f {fi}
   puts $f {}
   puts $f {exec $wishcall -f $XTEMPATH/xtem.tcl -n xtem $wishcall $tclcall $XTEMPATH $language $*}
   puts $f {####}
   puts $f {}
   close $f
   chmod a+rx xtem
 }

 XiProtokoll "\nInstallation parameters:"
 XiProtokoll "  Directory for installation of xtem_TeXMenu:  $INSTPATH"
 XiProtokoll "  Directory for executeables and shell scripts:  $BINPATH"
 XiProtokoll "  Command to call wishx (Tcl, Tk and TclX):  $WISHCALL"
 XiProtokoll "  Command to call tcl (pure Tcl without Tk):  $TCLCALL"
 XiProtokoll "  Defaultlanguage:  $DEFAULTLANGUAGE"
 XiProtokoll "  Language(s):"
 set languages "$LANGUAGES"
 while {[lindex $languages 0]!=""} {
   set langstring [lindex $languages 0]; set languages [lrange $languages 1 end]
   set language [lindex $langstring 0];  set synonyms [lrange $langstring 1 end]
   if {$synonyms==""} {XiProtokoll "    $language"} else {XiProtokoll "    $language  (synonym(s)): $synonyms)"}
 }
 update

 # installation of shell script  xtem ---> $BINPATH

 SigChldB; set cmpres [catch "exec cmp $BINPATH/xtem xtem" cmpmes]; SigChldU
 if {[file exists "$BINPATH/xtem"]&&($cmpmes=="")} {# is up to date
   XiProtokoll "\nIs up to date: \"xtem\" (Shell script)"
 } else {# must be updated
   if [file writable $BINPATH] {# update can be done
     XiProtokoll "\nInstallation of:  $BINPATH/xtem  (Shell script)"
     unlink -nocomplain $BINPATH/xtem; link -sym $INSTPATH/xtem/xtem $BINPATH/xtem
   } else {# needs update, but cannot be updated!
     XiProtokollEnd4 "\n$BINPATH/xtem [XiNotInstalledText]"
     XiProtokollEnd4 "  rm $BINPATH/xtem\n  ln -s $INSTPATH/xtem/xtem $BINPATH/xtem" ; XiProtokoll ""
   }
 }
 update

 # installation of program changecode ---> $BINPATH

 if [file exists "changecode"] {
   SigChldB; set cmpres [catch "exec cmp $BINPATH/changecode changecode" cmpmes]; SigChldU
   if {[file exists "$BINPATH/changecode"]&&($cmpmes=="")} {# changecode is up to date
     XiProtokoll "\nIs up to date: \"changecode\""
   } else {# changecode must be updated
     if [file writable $BINPATH] {# update can be done
       XiProtokoll "\nInstallation of:  $BINPATH/changecode"
       unlink -nocomplain $BINPATH/changecode; link -sym $INSTPATH/xtem/changecode $BINPATH/changecode
     } else {# needs update, but cannot be updated!
       XiProtokollEnd4 "\n$BINPATH/changecode [XiNotInstalledText]"
       XiProtokollEnd4 "  rm $BINPATH/changecode\n  ln -s $INSTPATH/xtem/changecode $BINPATH/changecode"
       XiProtokoll ""
     }
   }
 } else {# file changecode not found
   XiProtokollEnd4 "\nFile not found: \"changecode\""; XiProtokoll ""
 }
 update

 # installation of program hyphen_show ---> $BINPATH

 if [file exists "hyphen_show"] {
   SigChldB; set cmpres [catch "exec cmp $BINPATH/hyphen_show hyphen_show" cmpmes]; SigChldU
   if {[file exists "$BINPATH/hyphen_show"]&&($cmpmes=="")} {# hyphen_show is up to date
     XiProtokoll "\nIs up to date: \"hyphen_show\""
   } else {# hyphen_show must be updated
     if [file writable $BINPATH] {# update can be done
       XiProtokoll "\nInstallation of:  $BINPATH/hyphen_show"
       unlink -nocomplain $BINPATH/hyphen_show; link -sym $INSTPATH/xtem/hyphen_show $BINPATH/hyphen_show
     } else {# needs update, but cannot be updated!
       XiProtokollEnd4 "\n$BINPATH/hyphen_show [XiNotInstalledText]"
       XiProtokollEnd4 "  rm $BINPATH/hyphen_show\n  ln -s $INSTPATH/xtem/hyphen_show $BINPATH/hyphen_show"
       XiProtokoll ""
     }
   }
 } else {# file hyphen_show not found
   XiProtokollEnd4 "\nFile not found: \"hyphen_show\""; XiProtokoll ""
 }
 update


 # man-page installation  xtem.1 ---> $MANPATH

 SigChldB; set cmpres [catch "exec cmp $MANPATH/xtem.1 xtem.1" cmpmes]; SigChldU
 if {[file exists "$MANPATH/xtem.1"]&&($cmpmes=="")} {# is up to date
   XiProtokoll "\nIs up to date: \"xtem.1\" (Manual page)"
 } else {# must be updated
   if [file writable $MANPATH] {# update can be done
     XiProtokoll "\nInstallation of:  $MANPATH/xtem.1 (Manual page)"
     unlink -nocomplain $MANPATH/xtem.1; link -sym $INSTPATH/xtem/xtem.1 $MANPATH/xtem.1
   } else {# needs update, but cannot be updated!
     XiProtokollEnd4 "\n$MANPATH/xtem.1 [XiNotInstalledText]"
     XiProtokollEnd4 "  rm $MANPATH/xtem.1\n  ln -s $INSTPATH/xtem/xtem.1 $MANPATH/xtem.1"; XiProtokoll ""
   }
 }
 update


 # man-page installation  hyphen_show.1 ---> $MANPATH

 SigChldB; set cmpres [catch "exec cmp $MANPATH/hyphen_show.1 hyphen_show.1" cmpmes]; SigChldU
 if {[file exists "$MANPATH/hyphen_show.1"]&&($cmpmes=="")} {# is up to date
   XiProtokoll "\nIs up to date: \"hyphen_show.1\" (Manual page)"
 } else {# must be updated
   if [file writable $MANPATH] {# update can be done
     XiProtokoll "\nInstallation of:  $MANPATH/hyphen_show.1 (Manual page)"
     unlink -nocomplain $MANPATH/hyphen_show.1; link -sym $INSTPATH/xtem/hyphen_show.1 $MANPATH/hyphen_show.1
   } else {# needs update, but cannot be updated!
     XiProtokollEnd4 "\n$MANPATH/hyphen_show.1 [XiNotInstalledText]"
     XiProtokollEnd4 "  rm $MANPATH/hyphen_show.1\n  ln -s $INSTPATH/xtem/hyphen_show.1 $MANPATH/hyphen_show.1"
     XiProtokoll ""
   }
 }
 update


 # installation of the setting files

 XiProtokoll "\nPresetting files ($INSTPATH/xtem_locals_*/*.vst):"
 foreach language [Languages] {
   set f locals_$language; if {[file exists $f]&&[file type $f]=="directory"} {set skipRest 1
     XiProtokollEnd4 "`$INSTPATH/$XTEM/locals_$language' is directory;"
     XiProtokollEnd4 "should not exist (xteminstall will then create this link!)"
     XiProtokollEnd4 "or should be link to `$INSTPATH/xtem_locals_$language'."
     XiProtokollEnd4 "(Your tar command probably unresolved this link!?)"
     XiProtokollEnd4 "Remove directory `locals_$language' e.g. with command"
     XiProtokollEnd4 "       rm -rf locals_$language"
     XiProtokollEnd4 ""
   }
   set f $INSTPATH/xtem_locals_$language; if {[file exists $f]&&![file writable $f]} {set skipRest 1
     XiProtokollEnd4 "`$f' exists and is not writeable;"
     XiProtokollEnd4 "please modify write permission/restart xteminstall with write permission"
     XiProtokollEnd4 ""
   }

   if {$skipRest==0} {
     set cpFrom ""; set todir "$INSTPATH/xtem_locals_$language"
     if {[file exists $todir]} {                          # already exist's

       if {[file isdirectory $todir]} {                   #              and is directory
         chmod a+rx $todir
         XiProtokoll "\talready existing file is still used:  $todir"
       } else {                                           #              and is no directory
         XiProtokoll "\n  $todir \t exists and is file;"
         XiProtokoll "\t\tshouldn't exist or should be directory --- installation aborted!"
         exit
       }

     } else {                                             # doesn't exist: to be created

       mkdir $todir;  chmod a+rx $todir
       if {$OLDV!=""} {set cpFrom "$INSTPATH/$OLD/locals_$language"} else {set cpFrom "$INSTPATH/$NEW/locals_$language"}
       if {([file type $cpFrom]=="link")&&(![file exists [file readlink $cpFrom]])} \
	     {set cpFrom "$INSTPATH/$NEW/locals_$language.LRW"}
       set res [catch  "glob -- $cpFrom/*.vst" files]
       if {[catch  "glob -- $cpFrom/*.vst" files]} \
	     {set cpFrom "$INSTPATH/$NEW/locals_$language.LRW"; set files [glob -- $cpFrom/*.vst]}
       SigChldB; foreach f $files {exec cp $f $todir/.}; SigChldU
       set files [glob -- $todir/*.vst];   foreach f $files {chmod a+r $f}
       XiProtokoll "\tis created:  $todir"

     }
     if {$cpFrom!=""} {XiProtokoll "\t(files copied from: $cpFrom)"}; set cpFrom ""
     cd locals_$language.LRW; set files "[glob -- *.vst]"; cd ..
     foreach f $files {
	if ![file exists $todir/$f] {
	  set cpFrom "locals_$language.LRW/$f"
	  SigChldB; exec cp $cpFrom $todir/.; SigChldU
	  chmod a+r $todir/$f
	} else {
	  if ![file writable $todir/$f] {XiProtokollEnd2 "\n  File `$todir/$f' is not writeable!"; XiProtokoll ""}
	}
	if {$cpFrom!=""} {XiProtokoll "\tfile copied from: $cpFrom"}; set cpFrom ""
     }
     if {![file exists locals_$language]} {
	link -sym $INSTPATH/xtem_locals_$language locals_$language
     } elseif {[file type locals_$language]=="link"} {
	unlink -nocomplain locals_$language
	if {[file exists locals_$language]} {exec rm -rf locals_$language}
	if {[file exists locals_$language]&&($tclversion>7.5)} {file delete -force locals_$language}
	if {![file exists locals_$language]} {link -sym $todir locals_$language}
     }

     set file locals_$language/texfmt.vst;  # test whether texfmt.vst should be updated or not
     XiProtokoll "\nChecking file $file"
     set f [open $file]; Xigetscl0 $f e; set s [string index [string trim $e] 0]; Xigetscl0 $f e
     if {[getvalue $e 2 $s]==""} {
	XiProtokollEnd2 "\n  You are recommended to update file `$file'"
	XiProtokollEnd2 "  in order to use the `quick&dirty' facilities; for details see `Installation Guide'"
	XiProtokoll ""
     } else {XiProtokoll "  OK: Quick&Dirty is installed"}

     set file locals_$language/printing.vst;  # test whether printing.vst should be adapted from lp to lpr
     XiProtokoll "\nChecking file $file"
     set f [open $file]; Xigetscl0 $f e; set s [string index [string trim $e] 0]; Xigetscl0 $f e
     if {[string index [string trim $e] 0]=="$s"} {Xigetscl0 $f e}
     set p [getvalue $e 6 $s]
     if {[catch "which $p" m]!=0} {
       XiProtokollEnd2 "\n  File `$file' has default printer: `$p'"
       XiProtokollEnd2 "  This printer (command) is not found on this system."
       XiProtokollEnd2 "  Please check this file; for details see `Installation Guide'"
       XiProtokoll ""
     } elseif {([catch "which lp" m]==0)&&([catch "which lpr" m]==0)} {
       if {[file exists /etc/printcap]&&("$p"=="lpr")} {
	 XiProtokoll "  File `$file' has default printer: `$p'; on your system both `lp' and `lpr' exist,"
	 XiProtokoll "  yet line printer (command) `$p' seems to be OK!"     
	 XiProtokoll "  If necessary modify file `$file'; for details see `Installation Guide'"
       } else {
	 XiProtokollEnd2 "\n  File `$file' has default printer: `$p'; on your system both `lp' and `lpr' exist."
	 XiProtokollEnd2 "  If necessary modify file `$file'; for details see `Installation Guide'"
	 XiProtokoll ""
       }
     } else {XiProtokoll "  OK: line printer (command) `$p' is found"}

     set file locals_$language/prt_dvips.vst;  # test whether prt_dvips.vst should be updated or not
     XiProtokoll "\nChecking file $file"
     set f [open $file]; Xigetscl0 $f e; set s [string index [string trim $e] 0]
     set allempty 1; while {[Xigetscl0 $f e]>=0} {if {[string trim [getvalue $e 4 $s]]!=""} {set allempty 0}}
     if {$allempty} {
	XiProtokollEnd2 "\n  You are recommended to update file `$file'"
	XiProtokollEnd2 "  in order to use the `prtcmd' facilities; for details see `Installation Guide'"
	XiProtokoll ""
     } else {XiProtokoll "  OK: locals_$language/prt_dvips.vst does use parameters >=4 "}

     set file locals_$language/mkcommand.vst
     # test whether mkcommand.vst has column for this Tcl version or not
     XiProtokoll "\nChecking file $file"
     if [info exists MkcmdTclVColNr] {unset MkcmdTclVColNr}; set mkcmdcol [MkcmdTclVCol no-exit]
     if {$mkcmdcol==0} {
	XiProtokollEnd2 "\n  File `locals_$language/mkcommand.vst' has no column for Tcl version $tclversion"
	XiProtokollEnd2 "  It is necessary to update this file (e.g. by copying it from"
	XiProtokollEnd2 "  locals_$language.LRW/mkcommand.vst); for details see `Installation Guide'"
	XiProtokoll ""
     } else {XiProtokoll "  OK: has entries for executing commands with Tcl version $tclversion"}
     # test whether mkcommand.vst must be updated or not
     vstr_exec no-exit
     if {"$mkcommand"=="mkcommand.9"} {
	XiProtokollEnd2 "\n  File `$file' needs customization;"
	XiProtokollEnd2 "  remove \"... mkcommand.9 ...\" etc., for details see `Installation Guide'"
	XiProtokoll ""
     }

   }
 }
 update


 # installation of the "local.news"

 if {$skipRest==0} {
   XiProtokoll "\nLocal News ($INSTPATH/xtem_locals_*/local.news):"
   foreach file "local.news xtemstart.news" {
     foreach language [Languages] {
       if ![file exists $INSTPATH/xtem_locals_$language/$file] {
	 if [file exists $INSTPATH/$OLD/locals_$language/$file] {set cpFrom "$INSTPATH/$OLD/locals_$language/$file"} \
	 else {set cpFrom "locals_$language.LRW/$file"}
	  set cpTo "$INSTPATH/xtem_locals_$language/$file"
	  SigChldB; exec cp $cpFrom $cpTo; SigChldU;  chmod a+r $cpTo
	  XiProtokoll "\tfile copied from:  $INSTPATH/xtem/$cpFrom"
       } else {
	 XiProtokoll "\talready existing file is still used:  $INSTPATH/xtem_locals_$language/$file"
       }
     }
   }
   update
 }


 # check (and modify if necessary) variable "xtermcall" in install.vst

 if {$skipRest==0} {
   XiProtokoll "\nVariable xtermcall is checked (and modified if necessary) in $INSTPATH/xtem_locals_*/install.vst:"
   foreach language [Languages] {
     set todir "$INSTPATH/xtem_locals_$language"; set xtem_path "$INSTPATH/$NEW"; set XiVstHasSep 0
     if {![file exists $todir/install.vst]} {
	XiProtokoll "\n\tFile not found: $todir/install.vst\n"; mybell 4
     } else {
	set XiCurLanguage $language; set modified 0; set ln 0; XiVst2Lists install.vst "" new
	foreach l $XiVstActive {
	  if {("z[lindex $l 0]"=="zxtermcall")&&("z[lrange $l 1 end]"!="z$XTERMCALL")} {
	    set XiVstActive [linsert [lreplace $XiVstActive $ln $ln "#$l"] [expr $ln+1] "xtermcall          $XTERMCALL"]
	    set modified 1; incr ln; #incr ln important at this place (if more than one xtermcall line!)
	  }
	  incr ln
	}
	if {$modified==1} {XiSaveVstfile install.vst 1}
     }
   }
   update
 }


 # check file hyphen.vst (copy new version if necessary)

 if {$skipRest==0} {
   XiProtokoll "\nFile hyphen.vst is checked (copied from original if necessary) in $INSTPATH/xtem_locals_*/hyphen.vst:"
   foreach language [Languages] {
     set todir "$INSTPATH/xtem_locals_$language"; set xtem_path "$INSTPATH/$NEW"; set XiVstHasSep 1
     if {![file exists $todir/hyphen.vst]} {
	XiProtokoll "\n\tFile not found: $todir/hyphen.vst\n"; mybell 4
     } else {
	set XiCurLanguage $language; set ln 0; XiVst2Lists hyphen.vst "" new
	if {$XiVstVersion>=6.01} {set newFormOfVst 1} else {set newFormOfVst 0}
	foreach l $XiVstActive {
	  if {("[getvalue $l 3 $XiVstSep]"!="")||("[getvalue $l 4 $XiVstSep]"!="")} {set newFormOfVst 1}
	}
	if {$newFormOfVst==0} {
	  SigChldB; exec cp $INSTPATH/$NEW/locals_$language.LRW/hyphen.vst $todir/hyphen.vst; SigChldU
	  XiProtokoll "\n\tFile updated: $todir/hyphen.vst\n"; mybell 4
	}
     }
   }
   update
 }

 # delete existing language-dependent directories for languages not included in LANGUAGES
 #
 # at the moment no real delete, but creation of a list of commands to delete them

 if {$skipRest==0} {
   foreach langex "[glob -- help_*]" {
     set lgex [string range $langex 5 end];  set unused 1
     foreach language [Languages] {if {$lgex=="$language"} {set unused 0}}
     if {$unused} {
	XiProtokoll "\n$lgex :\tlanguage-dependent files are unused (~ 1 MB disk space/language!),"
	XiProtokoll "\t\tyou can use the following command to delete these files:"
	XiProtokoll "\t\t  rm -rf $INSTPATH/$NEW/*_$lgex "
     }
   }
   update
 }


 # chmod's

 if {$skipRest==0} {
   XiProtokoll "\n\nSetting acces modes:\n"
   set mod "a+r";  set names "$INSTPATH/$NEW                     "; XiChmod $mod "$names"
   set mod "a+r";  set names "$INSTPATH/$NEW/*                   "; XiChmod $mod "$names"
   set mod "a+r";  set names "$INSTPATH/$NEW/*/*                 "; XiChmod $mod "$names"
   set mod "a+r";  set names "$INSTPATH/$NEW/*/*/*               "; XiChmod $mod "$names"
   set mod "a+rx"; set names "$INSTPATH/$NEW                     "; XiChmod $mod "$names"
   set mod "a+rx"; set names "$INSTPATH/$NEW/xtem                "; XiChmod $mod "$names"
   set mod "a+rx"; set names "$INSTPATH/$NEW/xtem.tcl            "; XiChmod $mod "$names"
   set mod "a+rx"; set names "$INSTPATH/$NEW/xtem_*              "; XiChmod $mod "$names"
   set mod "a+rx"; set names "$INSTPATH/$NEW/locals_*            "; XiChmod $mod "$names"
   set mod "a-w";  set names "$INSTPATH/$NEW/locals_*.LRW/*      "; XiChmod $mod "$names"
   set mod "a+rx"; set names "$INSTPATH/$NEW/help_*              "; XiChmod $mod "$names"
   set mod "a+rx"; set names "$INSTPATH/$NEW/help_*/latex        "; XiChmod $mod "$names"
   set mod "a+rx"; set names "$INSTPATH/$NEW/help_*/miscellaneous"; XiChmod $mod "$names"
 }


 # all programs accessable?

 if {$skipRest==0} {
   if {$whichcheck=="yes"} {xiVstCallsWhich}
 }


 # test for gunzip | xdvi

 if {$skipRest==0} {
   if {$whichcheck=="yes"} {
     set liste "gunzip xdvi"; set NoneInstalled 1; foreach p $liste {if {[catch "which $p"]==0} {set NoneInstalled 0}}
     if {$NoneInstalled} {
	XiProtokoll "\n$XV(AAsteriks)\nNone of the following programs is installed: $liste"
	XiProtokoll "Sorry, you can't display the bitmaps to the (La)TeX syntax examples, see Installation Guide!"
	XiProtokoll "$XV(AAsteriks)\n"
     }
   }
 }

 #puts stdout "**** fehlt noch bei Installation: Installation weiterer Sprachen vorber.        "; #####@@@@@
 #puts stdout "**** fehlt noch bei Installation: welche Buttons im Hauptmenu erzeugen?         "; #####@@@@@
 #puts stdout "**** fehlt noch bei Installation: alte help-files Vorrang vor neuen?            "; #####@@@@@
 #puts stdout "**** fehlt noch bei Installation: character set translation (umlaute)           "; #####@@@@@
 #puts stdout "**** fehlt noch bei Installation: Bitmap-Dateien: *.gz oder *.xbm lschen!      "; #####@@@@@

puts stdout "\n<<<$XiProtEndText2>>>\n<<<$XiProtEndText4>>>\n"
 if {$XiProtEndText2!=""} {XiProtokoll "\n$XiProtEndText2"}
 if {$XiProtEndText4!=""} {
   mybell 4
   XiProtokoll "\n\n$XV(AAsteriks)\n$XV(AAsteriks)"
   XiProtokoll "\n$XiProtEndText4"
   XiProtokoll "Installation procedure ended incompletely (see preceding messages)!"
   XiProtokoll "Restart xteminstall after execution of the command(s) given ahead."
   XiProtokoll "$XV(AAsteriks)\n$XV(AAsteriks)"
 } else {
   XiProtokoll "\nInstallation procedure ended correctly.\nYou can now test and modify the setting files!"
   .a.inst configure -state normal
   if {[XiEnabModVst locals_$DEFAULTLANGUAGE]} {.a.vsts configure -state normal} {.a.vsts configure -state disabled}
 }
 set XiProtEndText4 ""; set XiProtEndText2 ""
 .a.ende configure -state normal; update idletasks
}


#---------------------------------------------------------------------------------------------

#----- setting file select menu proc's -------------------------------------------------------

proc XiFilesLangSuffix {suffix} {
 global XV Wvsts INSTPATH NEW email
 TestPut 2 ""

 set files ""
 foreach language [Languages] {
   if {![file exists $INSTPATH/$NEW/locals_$language]} {
     XiProtokoll "$INSTPATH/$NEW/locals_$language : directory not found;\nclick at \"install xtem\" first."
     XiProtokoll "If this error then repeats: $email\n"
     mybell 4
     return "$XV(anever)"
   }
   set list [glob -- $INSTPATH/$NEW/locals_$language/*$suffix]
   foreach name $list {
    set name [string range $name [expr [string last "/" $name]+1] [expr [string length $name]-[string length $suffix]-1]]
     set isin 0; foreach f $files {if {$name=="$f"} {set isin 1}}; if !$isin {set files "$files $name"}
   }
 }
 return "[lsort $files]"
}

proc XiCreateFileEditButtons {W Files Suffix Text} {
 TestPut 2 ""
 frame $W.dummy -height 7; pack $W.dummy
 label $W.label -text "$Text:"; pack $W.label -pady 3 -anchor nw
 set line 1
 while {$Files!=""} {
   frame $W.frame$line; pack $W.frame$line -anchor nw
   for {set n 1} {$n<=4} {incr n} {
     set fn [lindex $Files 0]; set Files [lrange $Files 1 end]
     button $W.frame$line.$fn -width 15 -text "$fn$Suffix" -anchor w -command "XiSettEditNV $fn $Suffix"
     pack $W.frame$line.$fn -side left
     if {$Files==""} {break}
   }
   incr line
 } 
}

proc XiSettEditNV {f s} {TestPut 2 ""; if {$s==".news"} {XiSettEditNews $f} else {XiSettEditVst $f}}

proc XiActivateFileEditButtons {W Files Suffix ActivateCase} {
 global XV INSTPATH NEW XiCurLanguage
 TestPut 2 ""
 set line 1
 while {$Files!=""} {
   for {set n 1} {$n<=4} {incr n} {
     set fn [lindex $Files 0]; set Files [lrange $Files 1 end]
     if     {$ActivateCase==0} {$W.frame$line.$fn configure -state disabled} \
     elseif [file exists $INSTPATH/$NEW/locals_$XiCurLanguage/$fn$Suffix] {$W.frame$line.$fn configure -state normal} \
     else                      {$W.frame$line.$fn configure -state disabled}
     if {$Files==""} {break}
   }
   incr line
 } 
}

proc XiLangButton {language} {
 global Wvsts XV INSTPATH NEW XiNewsfiles XiVstfiles
 TestPut 2 ""
 if {[file type "$INSTPATH/$NEW/locals_$language"]=="link"} \
      {set t1 "Directory: is link -->"; set t2 "[file readlink $INSTPATH/$NEW/locals_$language]"} \
 else {set t1 "Directory:";             set t2 "$INSTPATH/$NEW/locals_$language"}
 ConfigText $Wvsts.a.dirs.text "$t1"; ConfigText $Wvsts.a.dirs.disp "$t2"
 XiActivateFileEditButtons $Wvsts.b "$XiNewsfiles" .news 1
 XiActivateFileEditButtons $Wvsts.c "$XiVstfiles"  .vst  1
}

#----- setting file select menu        -------------------------------------------------------

proc XiSettings {} {

 global XV Wvsts INSTPATH DEFAULTLANGUAGE NEW XiCurLanguage XiNewsfiles XiVstfiles
 TestPut 3 "**********************"

 XiProtokoll "$XV(AAsteriks)\nModification of the setting files ...\n"

 set XiNewsfiles [XiFilesLangSuffix .news];  set XiVstfiles [XiFilesLangSuffix .vst]
 if {($XiNewsfiles=="$XV(anever)")||($XiVstfiles=="$XV(anever)")} {return}


 foreach b ".a.ende .a.inst .a.vsts" {$b configure -state disabled}; update idletasks

 toplevel_init $Wvsts "Modification of Settings" 0 0

 foreach frame "a b c" {frame $Wvsts.$frame -borderwidth 1 -relief raised; pack $Wvsts.$frame -fill x -ipady 3}

 # frame a: end button, languagage selecton and directory display
 button $Wvsts.a.ende -text "end" -command {
   destroy $Wvsts; raise .
   if {($whichcheck=="yes")&&[info exists xtem_path]} {xiVstCallsWhich}
   foreach b ".a.ende .a.inst .a.vsts" {$b configure -state normal}; update idletasks
 }
 label $Wvsts.a.dum1 -width 2; pack $Wvsts.a.ende $Wvsts.a.dum1 -side left
 set XiCurLanguage $DEFAULTLANGUAGE
 frame $Wvsts.a.lang -height 300; pack $Wvsts.a.lang -side left
 label $Wvsts.a.lang.label -text "Language selection:"; pack $Wvsts.a.lang.label
 foreach l [Languages] {
   radiobutton $Wvsts.a.lang.$l -variable XiCurLanguage -value $l -width 14 -text $l -anchor w -command "XiLangButton $l"
   pack $Wvsts.a.lang.$l -anchor w
 }
 label $Wvsts.a.dum2 -width 2;    pack $Wvsts.a.dum2 -side left
 frame $Wvsts.a.dirs -height 300; pack $Wvsts.a.dirs -side left
 if {[file type "$INSTPATH/$NEW/locals_$XiCurLanguage"]=="link"} \
      {set t1 "Directory: is link -->"; set t2 "[file readlink $INSTPATH/$NEW/locals_$XiCurLanguage]"} \
 else {set t1 "Directory:";             set t2 "$INSTPATH/$NEW/locals_$XiCurLanguage"}
 label $Wvsts.a.dirs.text -text "$t1"; pack $Wvsts.a.dirs.text -anchor w
 label $Wvsts.a.dirs.disp -text "$t2"; pack $Wvsts.a.dirs.disp -anchor w

 # frame b: news file buttons
 XiCreateFileEditButtons $Wvsts.b $XiNewsfiles .news "News Files"
 XiActivateFileEditButtons $Wvsts.b $XiNewsfiles .news 1

 # frame c: setting file buttons
 XiCreateFileEditButtons $Wvsts.c $XiVstfiles .vst "Setting Files"
 XiActivateFileEditButtons $Wvsts.c $XiVstfiles .vst 1
}

#---------------------------------------------------------------------------------------------

#----- setting file edit menus proc's --------------------------------------------------------

proc XiSaveNewsfile {W FileSuffix} {
 global XV INSTPATH NEW XiCurLanguage
 TestPut 2 ""
 set file $INSTPATH/$NEW/locals_$XiCurLanguage/$FileSuffix
 set f [open $file w]
 set lc [$W.b.t get "end -1c" end]
 if {($lc=="\n")} {puts -nonewline $f [$W.b.t get 1.0 "end-1c"]} \
 else             {puts -nonewline $f [$W.b.t get 1.0 end]}
 flush $f;  close $f
 XiProtokoll "\tsave file \"$file\""
}

proc XiSaveVstfile {FileSuffix protocol} {
 global XV INSTPATH NEW XiCurLanguage XiVstActive XiVstInactive XiVstHasSep XiVstFL
 TestPut 2 ""
 set file $INSTPATH/$NEW/locals_$XiCurLanguage/$FileSuffix
 set f [open $file w]
 if {$XiVstHasSep} {puts $f "$XiVstFL"}
 if {$XiVstHasSep} {set pnl " \\\n"} else {set pnl ""}
 foreach l $XiVstActive {puts $f "$l$pnl"}
 puts $f "\n$XV(XSettVCom$XiCurLanguage)\n"
 foreach l $XiVstInactive {puts $f "$l$pnl"}
 flush $f;  close $f
 if $protocol {XiProtokoll "\tsave file \"$file\""}
}

proc XiSaveFile {W File Suffix} {
 TestPut 2 ""
 if {$Suffix==".news"} {XiSaveNewsfile $W $File$Suffix} {XiSaveVstfile $File$Suffix 1}
}

proc XiDestroyESBut {W File Suffix logtext} {
 global Wvsts XiNewsfiles XiVstfiles
 TestPut 2 ""
 if {$File!=""} {if {$Suffix==".news"} {XiSaveNewsfile $W $File$Suffix} else {XiSaveVstfile $File$Suffix 1}}
 XiProtokoll "$logtext"
 destroy $W; raise $Wvsts
 XiActivateFileEditButtons $Wvsts.b $XiNewsfiles .news 1; XiActivateFileEditButtons $Wvsts.c $XiVstfiles .vst 1
 $Wvsts.a.ende configure -state normal; update idletasks
}

proc XiCreateESButtons {W File Suffix} {
 global XV
 TestPut 2 "<$W><$File><$Suffix>"
 if [info exists XV(XSettVF$File$Suffix)] {TestPut 2 "$XV(XSettVF$File$Suffix)"}
 button $W.a.ends -text "end with file save" -command "XiDestroyESBut $W $File $Suffix \"end with file save\""
 pack $W.a.ends -side left
 set XV(aendq) ""
 button $W.a.save -text "save file" -command "XiSaveFile $W $File $Suffix"; pack $W.a.save -side left
 button $W.a.endq -text "exit without file save" -command "XiDestroyESBut $W \"\" $Suffix exit"
 pack $W.a.endq -side left
}

proc XiCreateLSBox {w text s wi he bw list com} {
# creates frame w.f and title for selection, creates selection box + scrollbar, width wi, height he;  fills with list
 global XiVstLastClick
 TestPut 2 ""

 frame $w.f; pack $w.f -anchor sw -padx 2 -pady 8 -fill x -expand yes
 if {$text!=""} {label $w.f.l -text $text; pack $w.f.l -side $s -anchor w}
 frame $w.f.f -relief raised -borderwidth $bw; pack $w.f.f -anchor sw -fill x -expand yes
 scrollbar $w.f.f.sb -command "$w.f.f.li yview"
 listbox $w.f.f.li -yscrollcommand "$w.f.f.sb set" -width $wi -height $he
 pack $w.f.f.sb -side right -fill y
 pack $w.f.f.li -side right -fill y -fill x -expand yes
 if {$list!=""} then {foreach e $list {$w.f.f.li insert end $e}}
 bind $w.f.f.li <Leave> Bend;  bind $w.f.f.li <Double-Button-1> Bend;  bind $w.f.f.li <Triple-Button-1> Bend
 bind $w.f.f.li <Button-1> "set XiVstLastClick \[Selektion %W %y\]; $com; Bend"
}

proc Xigetscl0 {foid e} {# like getscl, but blanks at begin-of-continuation-line deleted
 upvar 1 $e ein
 TestPut 1 ""
 set ret [gets $foid z];  set z [string trimright $z]
 set ein "$z"
 set lm1 [expr [string length $z]-1]
 while {($lm1>=0)&&([string last \\ $z]==$lm1)} { 
   set ein [string range $ein 0 [expr [string length $ein]-2]]
   set ret [gets $foid z];  set z [string trimright $z]
   set lm1 [expr [string length $z]-1]
   set ein "$ein[string trimleft $z]"
 }
 if {$ret>=0} {set ret [string length "$ein"]}
 TestPut 1 "<$ret>"
 return $ret
}

proc SetXiVstOriginalParameters {LRWfil} {# check for same parameters in first line, set XiVstOriginalParameters
 global XiVstOriginalParameters XiVstFL XiVstSep XV
 set f [open $LRWfil r]; Xigetscl0 $f flLRW; close $f
 regsub -all " " $flLRW "" sflLRW;				regsub -all "$XiVstSep" "$sflLRW" "" sflLRW; 
 regsub -all " " "$XiVstFL" "" sfl;				regsub -all "$XiVstSep" "$sfl"    "" sfl; 
 if {"$sfl"=="$sflLRW"} {set XiVstOriginalParameters 1} {set XiVstOriginalParameters 0}
 TestPut 2 "\n<$XiVstFL>\n\n<$sfl>\n<$sflLRW>\n<$XiVstOriginalParameters>"
}

proc XiVst2Lists {file tmp newadd} {# read vst-file, store as new lists in XiVstActive/Inactive or append to Inactive
 global XV XiCurLanguage XiVstActive XiVstInactive XiVstSep XiNoSepVstFiles XiVstHasSep XiVstFL XiVstDefLine XiVstParAnz
 global tclversion xtem_path language XiVstOriginalParameters INSTPATH NEW Wevst XiVstVersion
 TestPut 4 "<$file><$tmp><$newadd>"
 if [regexp {prt_.+\.vst$} $file] {set XV(XSettVF$file) $XV(XSettVFprt_dvi2xyz.vst)}
 set LRWfil $INSTPATH/$NEW/locals_$XiCurLanguage.LRW/$file
 set XiVstHasSep [lindex $XV(XSettVF$file) 0]
 if {$newadd=="new"} {set XiVstActive "";  set XiVstInactive ""; set XiVstFL ""; set XiVstSL ""}
 if {"$file"=="mkcommand.vst"} \
     {global MkcmdTclVColNr; if [info exists MkcmdTclVColNr] {unset MkcmdTclVColNr}; set mkcmdcol [MkcmdTclVCol no-exit]}
 if {$newadd=="new"} {
   if {$tmp=="tmp"} {set f [open_vst "${file}.tmp"]} else {set f [open_vst "$file"]}
   if $XiVstHasSep {
     Xigetscl0 $f e; set XiVstFL "$e"; set XiVstSep [string index [string trim $e] 0]
     if {([lindex $XV(XSettVF$file) 1]==0)&&("$file"!="mkcommand.vst")} \
	{set XiVstVersion [lindex [string range [string trim $e] 1 end] 0]}
   } else {set XiVstSep ""; set XiVstVersion ""}
   if $XiVstHasSep {TestPut 3 "1a<$XiVstSep><$XiVstVersion>  <$e>"}
 } elseif {$newadd=="add"} {
   set errt "File not found: `$LRWfil'; why did you delete this file?"
   if ![file exists $LRWfil] {$Wevst.e.t configure -text "$errt"; XiProtokoll "\n$errt\n"; mybell 4; return}
   lappend XiVstInactive "---------- appended from file $LRWfil: ----------"
   set f [open "$LRWfil" r];# Xigetscl0 $f e
   if $XiVstHasSep {Xigetscl0 $f e; set XiVstSepLRW [string index [string trim $e] 0]} {set XiVstSepLRW ""}
   if $XiVstHasSep {TestPut 1 "1b<$XiVstSep><$XiVstSepLRW>  <$e>"}
 }
 if {[lindex $XV(XSettVF$file) 3]==0} {# user cannot define parameters in this file
   set XiVstParAnz [lindex $XV(XSettVF$file) 2]
   set XiVstOriginalParameters 1
 } else {			       # user can define parameters in this file
   set XiVstParAnz [expr [llength [split $XiVstFL $XiVstSep]]-1]
   if {[lindex [split $XiVstFL $XiVstSep] $XiVstParAnz]==""} {incr XiVstParAnz -1}
   set liste [split $XiVstFL $XiVstSep]; set XiVstFL "[lindex $liste 0]"
   for {set n 1} {$n<=$XiVstParAnz} {incr n} \
	{regsub -all " " [string trim [lindex $liste $n]] "_" zz;  set XiVstFL "$XiVstFL$XiVstSep $zz "}
   if {$newadd=="new"} {SetXiVstOriginalParameters $LRWfil}
 }
 if {[lindex $XV(XSettVF$file) 1]==1} {# criteria line expected in this file
   Xigetscl0 $f e
   TestPut 1 "2<$e>"
   if {$newadd=="new"} {
     set XiVstSL "$e"
     if {[string trim [lindex [split $e $XiVstSep] 0]]!=""} {# no default criteria line (in printing.vst) found
       set XiVstSL "          "; set liste [split $XiVstFL $XiVstSep]
       for {set n 1} {$n<=$XiVstParAnz} {incr n} {
	 set XiVstSL "$XiVstSL$XiVstSep"
	 if {[string trim [lindex $liste $n]]!=""} {set XiVstSL "${XiVstSL} * "} \
	 else					   {set XiVstSL "${XiVstSL}[lindex $liste $n]"}
       }
       lappend XiVstActive $XiVstSL
     }
     lappend XiVstActive $e
   }
 }
 if {("$file"=="mkcommand.vst")&&($mkcmdcol==0)} {set XiVstFL "$XiVstFL $XiVstSep Tcl_$tclversion"; incr XiVstParAnz}
 set ln 0; set active 1
 while {[Xigetscl0 $f e]>=0} {incr ln
   TestPut 1 "3<$ln><$e>"
   set l [string length $e]; set p [string first "$XV(XSettVCom$XiCurLanguage)" $e]
   if {("$file"=="mkcommand.vst")&&($mkcmdcol==0)} {set e "$e $XiVstSep"; if {$ln==1} {set e "$e mkcommand.9"}}
   if     {($l> 0)&&($active)} {if {$newadd=="new"} {lappend XiVstActive $e} {lappend XiVstInactive $e}} \
   elseif {($l==0)&&($active)} {set active 0} \
   elseif {($l> 0)&&($p<0)}    {lappend XiVstInactive $e}
 }
 close $f
 set XV(XSettVF$file) [lreplace $XV(XSettVF$file) 7 7 $XiVstParAnz]
 set XiVstDefLine ""; for {set n 1} {$n<=$XiVstParAnz} {incr n} {set XiVstDefLine "$XiVstDefLine $XiVstSep"}
}

proc XiCopyOriToInactive {File} {
 global Wevst XiVstInactive
 TestPut 4 "<$File><[llength $XiVstInactive]>"
 set oldlength [llength $XiVstInactive]; XiVst2Lists $File.vst {} add; XiSettVHFill; $Wevst.c.f.f.li yview $oldlength
}

proc XiSettVHCritLine {} {# if item XiVstSelectedNr is criterion line in XiVstActive: return 1 (else 0)
 global XV XiSelectedFromActive XiVstSelectedNr XiSelectedVstFile
 TestPut 2 ""
 if {($XiSelectedFromActive==1)&&($XiVstSelectedNr<[lindex $XV(XSettVF$XiSelectedVstFile) 1])} {return 1} {return 0}
}

proc XiSettVHDel {deleteitemnumber} {# delete deleteitemnumber from XiVstActive/XiVstInactive acc.to XiSelectedFromActive
 global XV Wevst XiSelectedFromActive XiVstActive XiVstInactive
 TestPut 2 ""
 if {$deleteitemnumber==""} {return}
 if {$XiSelectedFromActive==1} {
   if {[string length [lindex $XiVstActive $deleteitemnumber]]==0} \
	{ConfigText $Wevst.e.t "you can't delete from an empty list!"; mybell 4; return}
   set XiVstActive   [lreplace "$XiVstActive"   $deleteitemnumber $deleteitemnumber]
 } else {
   if {[lindex $XiVstInactive $deleteitemnumber]==""} \
	{ConfigText $Wevst.e.t "you can't delete from an empty list!"; mybell 4; return}
   set XiVstInactive [lreplace "$XiVstInactive" $deleteitemnumber $deleteitemnumber]
 }
}

proc XiSettVHFill {} {# fill lists XiVstActive and XiVstInactive into their windows
 global Wevst XiVstActive XiVstInactive
 TestPut 2 ""
 $Wevst.b.f.f.li delete 0 end; foreach e $XiVstActive   {$Wevst.b.f.f.li insert end $e}
 $Wevst.c.f.f.li delete 0 end; foreach e $XiVstInactive {$Wevst.c.f.f.li insert end $e}
}

proc XiSettVHIns {liste nr item} {# insert item as element nr in liste (Active/Inactive)
 global XV Wevst XiVstActive XiVstInactive XiSelectedFromActive
 TestPut 2 ""
 if {$liste==""} {if {$XiSelectedFromActive==1} {set liste "Active"} else {set liste "Inactive"}}
 if     {$liste=="Active" }  {set XiVstActive   [linsert "$XiVstActive"   $nr "$item"]} \
 elseif {$liste=="Inactive"} {set XiVstInactive [linsert "$XiVstInactive" $nr "$item"]} \
 else                        {puts stdout "error in XiSettVHIns"; mybell 4}
}

proc XiSettVHSelClear {} {# clears seclection in both lists XiVstActive and XiVstInactive
 global Wevst XiSelectedFromActive XiVstSelectedNr XiVstLastClick
 TestPut 2 ""
 $Wevst.b.f.f.li selection clear 0 end; $Wevst.b.f.f.li selection clear 0 end
 set XiSelectedFromActive "";  set XiVstSelectedNr "";  set XiVstLastClick ""
}

proc XiSettVHParAddL {ltype liste} {# adds (appends) new parameter to each entry in liste
 global XV XiVstSep XiVstParAnz
 TestPut 2 ""
 set Liste ""
 foreach e $liste {
   set fl [split $e $XiVstSep];  set fll [llength $fl];  set e "[lindex $fl 0]"
   if {$XiVstParAnz<=$fll} {
     for {set n 1} {$n<$XiVstParAnz} {incr n} {set e "${e}${XiVstSep}[lindex $fl $n]"}
     set e "${e}${XiVstSep} "
     if {($ltype=="Active")&&[lindex $XV(XSettVFprinting.vst) 1]&&([string trim [lindex $fl 0]]=="")} {set e "${e}* "}
   }
   lappend Liste $e
 }
 return "$Liste"
}

proc XiSettVHParDelN {pardel liste} {# delete parameter pardel from each entry in liste
 global XV XiVstSep XiVstParAnz
 TestPut 2 ""
 set Liste ""
 foreach e $liste {
   set fl [split $e $XiVstSep];  set fll [llength $fl];  set e "[lindex $fl 0]"
   if {$pardel<$fll} {set fl [lreplace $fl [expr $pardel-1] $pardel [lindex $fl [expr $pardel-1]]]}
   for {set n 1} {$n<=$XiVstParAnz} {incr n} {if {$n<$fll} {set e "$e$XiVstSep[lindex $fl $n]"}}
   lappend Liste $e
 }
 return "$Liste"
}

proc XiSettVHParList {} {# sets and returns XiVstParAktEL: list of user definable parameters (e.g. in printing.vst)
 global XV XiVstSep XiVstParAnzMin XiVstParAktEL XiVstFL XiVstParAnz
 TestPut 2 ""
 set XiVstParAktEL "";  if {$XiVstParAnz<=$XiVstParAnzMin} {return ""}
 for {set i [expr $XiVstParAnzMin+1]} {$i<=$XiVstParAnz} {incr i} \
	 {lappend XiVstParAktEL "parameter $i :     [lindex [split $XiVstFL $XiVstSep] $i]"}
 return "$XiVstParAktEL"
}

proc XiSettVHSelItem {liste nr} {# marks item $nr in XiVstActive/Inactive ($liste), update XiVstLastClick
 global Wevst XiSelectedFromActive XiVstLastClick XiVstActive XiVstInactive XiVstSelectedNr
 TestPut 2 ""
 if {$liste==""} {if {$XiSelectedFromActive==1} {set liste "Active"} else {set liste "Inactive"}} 
 if {$liste=="Active"} {set w $Wevst.b.f.f.li; set lst $XiVstActive;   set XiSelectedFromActive 1}  \
 else                  {set w $Wevst.c.f.f.li; set lst $XiVstInactive; set XiSelectedFromActive 0}
 $w yview $nr
 $w selection set $nr
 set XiVstLastClick [lindex $lst $nr]; set XiVstSelectedNr $nr
}

proc XiSettVHSelLineActive   {} {
 global Wevstl XiSelectedFromActive
 TestPut 2 ""
 if [winfo exists $Wevstl] return; set XiSelectedFromActive 1; XiSettVHSelLine
}

proc XiSettVHSelLineInactive {} {
 global Wevstl XiSelectedFromActive
 TestPut 2 ""
 if [winfo exists $Wevstl] return; set XiSelectedFromActive 0; XiSettVHSelLine
}

proc XiSettVHSelLine {} {
 global XiVstLastClick XiSelectedFromActive XiVstActive XiVstInactive XiVstSelectedNr email
 TestPut 2 ""
 if {[string length "$XiVstLastClick"]==0} {return}
 if {$XiSelectedFromActive} {set liste $XiVstActive} else {set liste $XiVstInactive}
 set nr 0; foreach e $liste {if {([string first "$XiVstLastClick" [lindex $liste $nr]]>=0)} {break}; incr nr}
 set XiVstSelectedNr $nr
}

proc XiSettVHSelNext {incr CallIfLast args} {
 global XiSelectedFromActive XiVstSelectedNr XiVstActive XiVstInactive XiShift
 if {$XiSelectedFromActive}	 {set from Active;	set l [llength $XiVstActive]} \
 else				 {set from Inactive;	set l [llength $XiVstInactive]}
 set neueNr [expr $XiVstSelectedNr+$incr]
 TestPut 4 "<$CallIfLast><$args> <$from>  <$XiVstSelectedNr><$incr><$neueNr>  <$l>"
 if {($XiShift)&&($neueNr<$l)}  {XiSettVHSelItem $from $neueNr} else {eval $CallIfLast $args}
}


proc XiSettVBAppdNewE	{b} {# create (append) a new active entry and edit this entry
 global XV Wevst XiSelectedFromActive XiVstDefLine XiVstActive XiVstLastClick
 TestPut 2 ""
 set p [llength $XiVstActive];  XiSettVHIns Active $p "$XiVstDefLine"
 XiSettVHFill;  XiSettVHSelItem Active $p;  XiSettVHEditEntry $p
}

proc XiSettVBCopyAct	{b} {# copy item XiVstSelectedNr from list XiVstInactive to list XiVstActive
 global XV Wevst XiSelectedFromActive XiVstActive XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";   mybell 4; return}
 if {$XiSelectedFromActive==1}  {ConfigText $Wevst.e.t "$XV(anoinact)";   mybell 4; return}
 set p [llength $XiVstActive];  XiSettVHIns Active $p "$XiVstLastClick"
 XiSettVHFill;  XiSettVHSelNext 1 XiSettVHSelItem Active $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBCopyInact	{b} {# copy item XiVstSelectedNr from list XiVstActive to list XiVstInactive
 global XV Wevst XiSelectedFromActive XiVstInactive XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}
 if [XiSettVHCritLine]          {ConfigText $Wevst.e.t "$XV(anocopy)";   mybell 4; return}
 set p [llength $XiVstInactive];  XiSettVHIns Inactive $p "$XiVstLastClick"
 XiSettVHFill;  XiSettVHSelNext 1 XiSettVHSelItem Inactive $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBCpEdEntry	{b} {# copy the selected active entry XiVstLastClick/XiSelectedFromActive and edit the copy
 global XV Wevst XiSelectedFromActive XiVstSelectedNr XiVstLastClick XiVstActive
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}
 if [XiSettVHCritLine]          {ConfigText $Wevst.e.t "$XV(anocopy)";   mybell 4; return}
 set p [expr $XiVstSelectedNr+1];  XiSettVHIns "" $p "$XiVstLastClick";  XiSettVHFill;  XiSettVHSelItem Active $p
 XiSettVHEditEntry $p
}

proc XiSettVBDeltEntry	{b} {# delete item XiVstSelectedNr from list XiVstActive/Inactive acc.to XiSelectedFromActive
 global XV Wevst XiSelectedFromActive XiVstLastClick XiVstActive XiVstInactive XiVstSelectedNr
 TestPut 2 "<$XiSelectedFromActive><[XiSettVHCritLine]><$XiVstSelectedNr>"
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if [XiSettVHCritLine]          {ConfigText $Wevst.e.t "$XV(anodelete)"; mybell 4; return}
 if {$XiVstSelectedNr==""} {return}
 XiSettVHDel $XiVstSelectedNr;  XiSettVHFill;  XiSettVHSelNext 0 XiSettVHSelClear
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBEditEntry	{b} {# edit the selected active entry XiVstLastClick (XiVstSelectedNr/...)
 global XV Wevst XiSelectedFromActive XiVstSelectedNr
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}
 set p $XiVstSelectedNr;  XiSettVHSelItem Active $p;  XiSettVHEditEntry $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBMakeActiv	{b} {# move item XiVstSelectedNr from list XiVstInactive to list XiVstActive
 global XV Wevst XiSelectedFromActive XiVstActive XiVstSelectedNr XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==1}  {ConfigText $Wevst.e.t "$XV(anoinact)";  mybell 4; return}
 set p [llength $XiVstActive];  XiSettVHIns Active $p "$XiVstLastClick";  XiSettVHDel $XiVstSelectedNr
 XiSettVHFill;  XiSettVHSelNext 0 XiSettVHSelItem Active $p
 ConfigText  $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBMakeInact	{b} {# move item XiVstSelectedNr from list XiVstActive to list XiVstInactive
 global XV Wevst XiSelectedFromActive XiVstInactive XiVstSelectedNr XiSelectedVstFile XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}
 if [XiSettVHCritLine]          {ConfigText $Wevst.e.t "$XV(anomove)";   mybell 4; return}
 set p [llength $XiVstInactive];  XiSettVHIns Inactive $p "$XiVstLastClick"; XiSettVHDel $XiVstSelectedNr
 XiSettVHFill;  XiSettVHSelNext 0 XiSettVHSelItem Inactive $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBMove1Down	{b} {# move item XiVstSelectedNr 1 down in list XiVstActive/Inactive acc.to XiSelectedFromActive
 global XV Wevst XiSelectedFromActive XiSelectedVstFile XiVstSelectedNr XiVstActive XiVstInactive XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==1}       {set ll [llength $XiVstActive]} else {set ll [llength $XiVstInactive]}
 if {$XiSelectedFromActive==""}      {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiVstSelectedNr>=[expr $ll-1]} {ConfigText $Wevst.e.t "$XV(anomovedo)"; mybell 4; return}
 if {($XiSelectedFromActive==1)&&($XiVstSelectedNr<=[expr [lindex $XV(XSettVF$XiSelectedVstFile) 1]-1])} \
				     {ConfigText $Wevst.e.t "$XV(anomove)"; mybell 4; return}
 set p $XiVstSelectedNr; XiSettVHDel $p; incr p; XiSettVHIns "" $p "$XiVstLastClick"; XiSettVHFill; XiSettVHSelItem "" $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBMove1Up	{b} {# move item XiVstSelectedNr 1 up in list XiVstActive/Inactive acc.to XiSelectedFromActive
 global XV Wevst XiSelectedFromActive XiSelectedVstFile XiVstSelectedNr XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiVstSelectedNr<=0}       {ConfigText $Wevst.e.t "$XV(anomoveup)"; mybell 4; return}
 if {($XiSelectedFromActive==1)&&($XiVstSelectedNr<=[lindex $XV(XSettVF$XiSelectedVstFile) 1])} \
				{ConfigText $Wevst.e.t "$XV(anomoveup)"; mybell 4; return}
 set p $XiVstSelectedNr; XiSettVHDel $p; decr p; XiSettVHIns "" $p "$XiVstLastClick"; XiSettVHFill; XiSettVHSelItem "" $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBMoveDeflt	{b} {# moves selected item to the default position in list XiVstActive
 global XV Wevst XiSelectedFromActive XiVstSelectedNr XiSelectedVstFile XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}
 if {$XiVstSelectedNr<=[lindex $XV(XSettVF$XiSelectedVstFile) 1]} \
				{ConfigText $Wevst.e.t "$XV(anomoveup)"; mybell 4; return}
 XiSettVHDel $XiVstSelectedNr;  set XiVstSelectedNr [lindex $XV(XSettVF$XiSelectedVstFile) 1]
 XiSettVHIns "" $XiVstSelectedNr "$XiVstLastClick";  XiSettVHFill;  XiSettVHSelItem "" $XiVstSelectedNr
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiTBKT {w} \
  {if {"$w"!=""} {ConfigText $w "editing of the displayed file (positioning: mouse, home, end, pg-up, pg-down, cursor)"}}

proc XiTextBindKeys {w wt wl} {# key bindings for editing in text widgets wt (mouse grab)/w=toplevel
 TestPut 2 "<$w><$wt><$wl>"
   # tkTextButton1 and tkTextSelectTo from /usr/local/lib/tk4.0/text.tcl (tk/tclversion dependent?)  
   bindtags $wt {T1 Text $w all}
   bind T1 <Home>            "$wt mark set insert 0.0; $wt yview -pickplace insert;        XiTBKT \"$wl\"; break"
   bind T1 <End>             "$wt mark set insert end; $wt yview -pickplace insert;        XiTBKT \"$wl\"; break"
   bind T1 <Button-1>        "tkTextButton1 %W %x %y;                                      XiTBKT \"$wl\"; break"
   bind T1 <B1-Motion>       "set tkPriv(x) %x; set tkPriv(y) %y; tkTextSelectTo %W %x %y; XiTBKT \"$wl\"; break"
   bind T1 <ButtonRelease-2> {catch {%W insert insert [selection get -selection PRIMARY]};                 break}
   bind T1 <Delete>          "selection clear $wt"
   bind T1 <BackSpace>       "selection clear $wt"
}

proc XiEVBEASBut {save} {
 global Wevst Wevstb XiWevstButList XiSelectedVstFile INSTPATH NEW XiCurLanguage XiVstHasSep
 TestPut 3 ""
 if {$save=="save"} {
   set file $INSTPATH/$NEW/locals_$XiCurLanguage/${XiSelectedVstFile}.tmp
   set f [open $file w]
   set lc [$Wevstb.b.t get "end -1c" end]
   if {($lc=="\n")} {puts -nonewline $f [$Wevstb.b.t get 1.0 "end-1c"]} {puts -nonewline $f [$Wevstb.b.t get 1.0 end]}
   flush $f;  close $f
 }
 XiVst2Lists $XiSelectedVstFile tmp new; XiSettVHFill; # XiSelectedVstFile.tmp --> XiVstActive/Inactive & fill windows
 unlink $INSTPATH/$NEW/locals_$XiCurLanguage/${XiSelectedVstFile}.tmp
 XiSettVHDestroyRaiseUnlock $Wevstb
}

proc XiSettVHDestroyRaiseUnlock {destroy} {#destroys $destroy; then raises Wevst and unlocks/locks Buttons in it
 global Wevst Wevstb XiWevstButList
 TestPut 3 ""
 destroy $destroy;  raise $Wevst
 eval UnlockButtons $Wevst.a.ends $Wevst.a.save $Wevst.a.endq $Wevst.a.cLRW $XiWevstButList
 XiSettVHButLock
}

proc XiSettVHButLock {} {# locks some edit buttons in menu Wevst="Edit Setting File" (XiVstLockIfNoSep + ...)
 global Wevst XiVstHasSep XiVstLockIfNoSep XiVstOriginalParameters XiSelectedVstFile XiCurLanguage
 TestPut 3 "XiVstOriginalParameters=$XiVstOriginalParameters"
 if {$XiVstHasSep==0} {foreach b $XiVstLockIfNoSep {$b configure -state disabled}}
 if {$XiVstOriginalParameters==0} {
   $Wevst.a.cLRW configure -state disabled; bind $Wevst.a.cLRW <Button-1> ""
   set ft "locals_$XiCurLanguage.LRW/$XiSelectedVstFile ---> locals_$XiCurLanguage/$XiSelectedVstFile"
   bind $Wevst.a.cLRW <Enter> "ConfigText $Wevst.e.t \"different criteria; you can copy (by hand)  $ft\""
 }
}

proc XiSettVHLockButtons {} {# locks top buttons in menu Wevst="Edit Setting File" (XiVstLockIfNoSep + ...)
 global Wevst XiWevstButList
 TestPut 3 ""
 eval LockButtons $Wevst.a.ends $Wevst.a.save $Wevst.a.endq $Wevst.a.cLRW $XiWevstButList
}

proc XiEditVstEntryBabrt {} {TestPut 2 ""; XiEditVstEntryHexit}

proc XiEditVstEntryBends {} {TestPut 2 ""; if ![XiEditVstEntryHSave] return; XiEditVstEntryHexit}

proc XiEditVstEntryBnext {} {
 global XiVstSelectedNr XiSelectedFromActive  XiVstActive XiVstInactive
 TestPut 2 "$XiVstSelectedNr"
 if {$XiSelectedFromActive==1} {set ll [llength $XiVstActive]} else {set ll [llength $XiVstInactive]}; incr ll -1
 if {$XiVstSelectedNr==$ll} return
 if {($XiVstSelectedNr<0)||($XiVstSelectedNr>$ll)} {return}
 if ![XiEditVstEntryHSave] return
 if {$XiVstSelectedNr<$ll} {incr XiVstSelectedNr 1}; XiEditVstEntryHLoad $XiVstSelectedNr; XiEditVstEntryHPNLU
 if {$XiSelectedFromActive==1} {XiSettVHSelItem Active $XiVstSelectedNr} else {XiSettVHSelItem Inactive $XiVstSelectedNr}
}

proc XiEditVstEntryBprev {} {
 global XiVstSelectedNr XiSelectedFromActive XiVstActive XiVstInactive
 TestPut 2 "$XiVstSelectedNr"
 if {$XiVstSelectedNr==0} return
 if {$XiSelectedFromActive==1} {set ll [llength $XiVstActive]} else {set ll [llength $XiVstInactive]}; incr ll -1
 if {($XiVstSelectedNr<0)||($XiVstSelectedNr>$ll)} {return}
 if ![XiEditVstEntryHSave] return
 if {$XiVstSelectedNr>0} {incr XiVstSelectedNr -1}; XiEditVstEntryHLoad $XiVstSelectedNr; XiEditVstEntryHPNLU
 if {$XiSelectedFromActive==1} {XiSettVHSelItem Active $XiVstSelectedNr} else {XiSettVHSelItem Inactive $XiVstSelectedNr}
}

proc XiEditVstEntryHexit {} {
 global Wevst Wevstl XiWevstButList XiVstSelectedNr XiSelectedFromActive
 TestPut 2 ""
 XiSettVHDestroyRaiseUnlock $Wevstl
 if {$XiSelectedFromActive==1} {XiSettVHSelItem Active $XiVstSelectedNr} else {XiSettVHSelItem Inactive $XiVstSelectedNr}
}

proc XiEditVstEntryHPar {n} {#
 global XV Wevstl XiVstPar XiSelectedVstFile XiVstLO
 TestPut 2 "$n"
 set wt [lindex $XV(XSettVF$XiSelectedVstFile) 4]; set wl [lindex $XV(XSettVF$XiSelectedVstFile) 5]
 set s [lindex $XV(XSettVF$XiSelectedVstFile) 6];  if {$s=="left"} {set a e} else {set a w}
 frame $Wevstl.b.$n;  pack $Wevstl.b.$n -anchor w -fill both -expand yes
 label $Wevstl.b.$n.l -width $wl -anchor $a; pack $Wevstl.b.$n.l -side $s -anchor w
 if {[lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 2]==""} {
   entry $Wevstl.b.$n.e -textvariable XiVstPar($n) -width $wt -relief sunken
   pack $Wevstl.b.$n.e -side $s -anchor w -fill x -expand yes
 } else {
   scrollbar $Wevstl.b.$n.s -command "$Wevstl.b.$n.e yview"
   text $Wevstl.b.$n.e -yscrollcommand "$Wevstl.b.$n.s set" \
	-height [lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 2]
   pack $Wevstl.b.$n.s -side right -fill y
   pack $Wevstl.b.$n.e -side right -fill both -expand yes
   XiTextBindKeys $Wevstl $Wevstl.b.$n.e ""
 }
}

proc XiEditVstEntryHLoad {nr} {# loads entry nr from list XiVstActive/Inactive acc.to XiSelectedFromActive
 global XV Wevstl XiVstActive XiVstInactive XiSelectedFromActive XiSelectedVstFile XiVstSep XiVstPar XiVstParAnz XiVstLO
 TestPut 2 "$nr"
 if   {$XiSelectedFromActive==1} {set e [lindex "$XiVstActive"   $nr]} \
 else				 {set e [lindex "$XiVstInactive" $nr]}
 for {set n 0} {$n<=$XiVstParAnz} {incr n} {
   ConfigText $Wevstl.b.$n.l "[lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 0] : "
   if {$XiVstSep==""} {if {$n==0} {set XiVstPar(0) [lindex $e 0]} else {set XiVstPar($n) [lrange $e 1 end]}} \
   else {set XiVstPar($n) "[string trim [lindex [split $e $XiVstSep] $n]]"}
   if {[lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]]=="_"} \
	{if [winfo exists $Wevstl.b.$n] {destroy $Wevstl.b.$n}}
   if {[lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 2]!=""} {
     regsub -all "\},( )*" $XiVstPar($n) "\},\n" t
     $Wevstl.b.$n.e delete 0.0 end;  $Wevstl.b.$n.e insert end "$t";  $Wevstl.b.$n.e yview 0
   }
 }
 update
}

proc XiEditVstHSaveEmptyPar {parNr} {# empty parameter not allowd, give warning!
 global XV Wevst XiVstSelectedNr
 TestPut 2 ""
 set t "\t*** error: parameter $parNr in line [expr $XiVstSelectedNr+1] is empty!"
 XiProtokoll "\t$t";  ConfigText $Wevst.e.t "$t"
 mybell 4
}

proc XiEditVstEntryHSave {} {# saves current values in XiVstActive/XiVstInactive
 global XV Wevstl XiVstActive XiVstInactive XiSelectedFromActive XiSelectedVstFile XiVstSep XiVstHasSep XiVstLO
 global XiVstSelectedNr XiVstPar XiVstParAnz XiVstPBDL
 TestPut 2 ""
 set e ""
 for {set n 0} {$n<=$XiVstParAnz} {incr n} {
   if {$n>0} {set e "${e}$XiVstSep"}
   if {[lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]]!="_"} {
     if {[lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 2]==""} {set p "$XiVstPar($n)"} \
     else					{regsub -all "\n" [$Wevstl.b.$n.e get 1.0 end] " " p}
     if {$n==0} {
       for {set b [string length $p]} {$b<[lindex $XV(XSettVF$XiSelectedVstFile) 4]} {incr b} {
	 set p "$p "
	 set ml "[lindex $XV(XSettVF$XiSelectedVstFile) 8]"
	 if {($XiVstSep=="")&&($ml!="")&&([string length $p]>=$ml)} {break}
       }
       set e "${e}$p "
     } else {
       set e "${e} $p "
     }
   }
   if {($XiVstHasSep!="")&&([string first "$XiVstSep" $p]>=0)} \
	{ConfigText $Wevstl.c.t "Error: argument $n contains separator; please correct"; mybell 4; return 0}
   if {[string trim $p]==""} {
     set errempt 0
     if {([lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 1]=="1")} {set errempt 1}
     if {[lindex $XV(XSettVF$XiSelectedVstFile) 1]=="1"} {# special analyse for file containing criteria line!
       if {$XiVstSelectedNr==0} {# criteria line
	 if {![winfo exists $Wevstl.b.$n.e]} {set errempt 0}; foreach i $XiVstPBDL {if {$i==$n} {set errempt 0}}
       } else {# other line
	 if {$n>[lindex $XV(XSettVF$XiSelectedVstFile) 2]} {set errempt 1}
       }
     }
     if {$errempt} {XiEditVstHSaveEmptyPar [lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 0]}
   }
 }
 if {$XiSelectedFromActive==1} {set XiVstActive   [lreplace $XiVstActive  $XiVstSelectedNr $XiVstSelectedNr "$e"]} \
 else                          {set XiVstInactive [lreplace XiVstInactive $XiVstSelectedNr $XiVstSelectedNr "$e"]}
 XiSettVHFill
 return 1
}

proc XiEditVstEntryHPNLU {} {# lock/unlock the previous/next buttons
 global Wevstl XiVstActive XiVstInactive XiVstSelectedNr XiSelectedFromActive XiVstPBDL XiVstPBDLw
 TestPut 2 ""
 if {$XiSelectedFromActive==1} {set anz [llength "$XiVstActive"]} else {set anz [llength "$XiVstInactive"]}; incr anz -1
 $Wevstl.a.prev configure -state normal; $Wevstl.a.next configure -state normal
 if {$XiVstSelectedNr==0}    {$Wevstl.a.prev configure -state disabled}
 if {$XiVstSelectedNr>=$anz} {$Wevstl.a.next configure -state disabled}
 if {($XiVstSelectedNr==0)} {
   set XiVstPBDLw "";  foreach n $XiVstPBDL \
	{if [winfo exists $Wevstl.b.$n.e] {pack forget $Wevstl.b.$n.e; set XiVstPBDLw "$XiVstPBDLw $Wevstl.b.$n.e"}}
 }
 if {($XiVstSelectedNr==1)&&($XiVstPBDLw!="")} \
	{foreach w $XiVstPBDLw {pack $w -anchor w -fill both -expand yes}; set XiVstPBDLw ""}
 update
}

#----- setting file edit menus        --------------------------------------------------------

proc XiSettEditNews {File} {# edit File (.news-file) in a text edit widget
 global XV Wvsts Wenews XiNewsfiles XiVstfiles INSTPATH NEW XiCurLanguage
 TestPut 3 "**********************<$File>"

 XiActivateFileEditButtons $Wvsts.b $XiNewsfiles .news 0; XiActivateFileEditButtons $Wvsts.c $XiVstfiles .vst 0
 $Wvsts.a.ende configure -state disabled; update idletasks
 
 XiProtokoll "$XV(AAsteriks)\nEdit News File \"$File.news\"\n"

 toplevel_init $Wenews "Edit News File" 400 100

 foreach frame "a b c" {frame $Wenews.$frame -borderwidth 1 -relief raised; pack $Wenews.$frame -fill both -expand yes}

 # frame a: end and save buttons
 XiCreateESButtons $Wenews $File .news

 # frame b: file edit widget
 scrollbar $Wenews.b.s -command "$Wenews.b.t yview"
 text $Wenews.b.t -yscrollcommand "$Wenews.b.s set" -height 20 -width 80
 pack $Wenews.b.s -side right -fill y
 pack $Wenews.b.t -side right -fill both -expand yes
 XiTextBindKeys $Wenews $Wenews.b.t $Wenews.c.t
 set f [open $INSTPATH/$NEW/locals_$XiCurLanguage/$File.news r]
 $Wenews.b.t delete 0.0 end;  $Wenews.b.t insert end "[read $f]";  $Wenews.b.t yview 0
 close $f

 # frame c: Text
 label $Wenews.c.t -text "click first at edit field"; pack $Wenews.c.t -anchor w
}

proc XiSettEditVst {File} {
 global XV Wevst Wvsts INSTPATH NEW XiNewsfiles XiVstfiles xtem_path language XiCurLanguage XiVstSelButtons XiVstParAnz
 global XiVstActive XiVstInactive XiSelectedFromActive XiSelectedVstFile XiVstSelectedNr XiWevstButList XiVstFL
 global XiVstHasSep XiVstSep XiVstParAnzMin XiMaxBoxWidth XiVstLO tclversion XiVstLockIfNoSep XiVstVersion
 TestPut 3 "**********************<$File>"
 
 XiActivateFileEditButtons $Wvsts.b $XiNewsfiles .news 0; XiActivateFileEditButtons $Wvsts.c $XiVstfiles .vst 0
 $Wvsts.a.ende configure -state disabled; update

 XiProtokoll "$XV(AAsteriks)\nEdit Setting File \"...$XiCurLanguage/$File.vst\"\n"

 set XiVstVersion ""
 if [info exists XV(XSettVF$File.vst)] {TestPut 2 "P1: <$XV(XSettVF$File.vst)>"}
 set xtem_path "$INSTPATH/$NEW"; set language "$XiCurLanguage"
  XiVst2Lists $File.vst "" new; # File --> XiVstActive/Inactive
 if {([lindex $XV(XSettVF$File.vst) 3]==1)&&($XiVstParAnz>[lindex $XV(XSettVF$File.vst) 2])} {# update XV(XSettVFxxx.vst)
   set XiVstParAnzMin [lindex $XV(XSettVF$File.vst) 2]
   TestPut 1 "    <[expr [lindex $XV(XSettVF$File.vst) 2]+1]>...<$XiVstParAnz>"
   for {set n [expr [lindex $XV(XSettVF$File.vst) 2]+1]} {$n<=$XiVstParAnz} {incr n} {
    TestPut 1 "    <[llength $XV(XSettVF$File.vst)]><[expr $n+$XiVstLO]>"
    if {[llength $XV(XSettVF$File.vst)]<=[expr $n+$XiVstLO]} {
     lappend XV(XSettVF$File.vst) [string trim [lindex [split $XiVstFL $XiVstSep] $n]]
    } else {
     set p [expr $n+$XiVstLO]; set e [llength $XV(XSettVF$File.vst)]
     set XV(XSettVF$File.vst) [lreplace $XV(XSettVF$File.vst) $p $e [string trim [lindex [split $XiVstFL $XiVstSep] $n]]]
    }
   }
   set XV(XSettVF$File.vst) [lreplace $XV(XSettVF$File.vst) 7 7 $XiVstParAnz]
 }
 if [info exists XV(XSettVF$File.vst)] {TestPut 2 "P2: <$XV(XSettVF$File.vst)>"}

 if ![info exists XV(XSettVCom$XiCurLanguage)] {set XV(XSettVCom$XiCurLanguage) "$XV(XSettVComenglish)"}
 set XiSelectedFromActive "";  set XiSelectedVstFile "$File.vst";  set XiVstSelectedNr ""

 if $XiVstHasSep {set t "(Separator=\"$XiVstSep\""} else {set t "(Has no Separator"}
 if {$XiVstVersion!=""} {set t "$t / V.$XiVstVersion"}; set t "${t})"

 toplevel_init $Wevst "Edit Setting File: ...$XiCurLanguage/$File.vst $t" 500 400

 foreach w "a b c d e" {frame $Wevst.$w -borderwidth 1 -relief raised; pack $Wevst.$w -fill x}

 # frame a: end and save buttons
 XiCreateESButtons $Wevst $File .vst
 button $Wevst.a.cLRW -text "copy originals to inactive" -command "XiCopyOriToInactive $File"
 pack $Wevst.a.cLRW -side right
 bind $Wevst.a.cLRW <Enter> \
	{ConfigText $Wevst.e.t "copy (add) the authors original setting file entries to `inactive entries'"}
 bind $Wevst.a.cLRW <Leave> {ConfigText $Wevst.e.t ""}

 # frame b: setting file line selection menu: active entries
 XiCreateLSBox $Wevst.b "active entries:" top $XiMaxBoxWidth 10 2 $XiVstActive   XiSettVHSelLineActive

 # frame c: setting file line selection menu: inactive entries
 XiCreateLSBox $Wevst.c "inactive entries (=comment):" top $XiMaxBoxWidth  5 2 $XiVstInactive XiSettVHSelLineInactive

 # frame d: buttons
 set XiWevstButList ""; set XiVstLockIfNoSep ""
 set Buttons "$XV(XSettVButtons)"; if {[lindex $XV(XSettVF$XiSelectedVstFile) 3]==1} {set Buttons "$Buttons 13 14"}
 foreach bt $Buttons {
   if {[expr $bt%4]==1} {set line [expr $bt/4]; frame $Wevst.d.line$line; pack $Wevst.d.line$line -anchor nw}
   button $Wevst.d.line$line.$bt -width 16 -text "[lindex $XV(XSettVBut$bt) 0]" -anchor w
   pack $Wevst.d.line$line.$bt -side left
   bind $Wevst.d.line$line.$bt <Button-1>	"set XiShift 0; [lindex $XV(XSettVBut$bt) 1] $bt"
   bind $Wevst.d.line$line.$bt <Shift-Button-1>	"set XiShift 1; [lindex $XV(XSettVBut$bt) 1] $bt"
   bind $Wevst.d.line$line.$bt <Enter> "ConfigText $Wevst.e.t \"[lindex $XV(XSettVBut$bt) 2]\""
   bind $Wevst.d.line$line.$bt <Leave> {ConfigText $Wevst.e.t ""}
   set XiWevstButList "$XiWevstButList $Wevst.d.line$line.$bt"
   if {$bt==10} {set XiVstLockIfNoSep "$XiVstLockIfNoSep $Wevst.d.line$line.$bt"}
 }
 if {$XiVstHasSep==0} {foreach b $XiVstLockIfNoSep {bind $b <Button-1> ""}}
 XiSettVHButLock

 # frame e: Text
 label $Wevst.e.t -text ""; pack $Wevst.e.t -anchor w
 if {"$File"=="mkcommand"} {
   global MkcmdTclVColNr; if [info exists MkcmdTclVColNr] {unset MkcmdTclVColNr}; set mkcmdcol [MkcmdTclVCol no-exit]
   if {$mkcmdcol==0} {ConfigText $Wevst.e.t "$XV(MkCmdNCol1) $tclversion; $XV(MkCmdNCol2)"; mybell 4}
 }
}

proc XiSettVBEditBuff	{b} {# edit file XiSelectedVstFile (all entries) in a text edit widget
 global XV Wevstb XiSelectedVstFile INSTPATH NEW XiCurLanguage XiVstHasSep XiVstSep
 TestPut 3 "**********************<$b>"

 XiSettVHSelClear; XiSettVHLockButtons
 XiSaveVstfile ${XiSelectedVstFile}.tmp 0

 if $XiVstHasSep {set ts "(Separator=\"$XiVstSep\")"} else {set ts "(Has no Separator)"}
 toplevel_init $Wevstb "Edit Buffer: \"$XiSelectedVstFile\" $ts" 500 100

 foreach frame "a b c" {frame $Wevstb.$frame -borderwidth 1 -relief raised}
 pack $Wevstb.a -anchor w; pack $Wevstb.b -anchor w -fill both -expand yes; pack $Wevstb.c -anchor w -fill x

 # frame a: end and save buttons
 button $Wevstb.a.end -text "end"; pack $Wevstb.a.end -side left
 button $Wevstb.a.ext -text "abort"; pack $Wevstb.a.ext -side left
 bind $Wevstb.a.end <Button-1> "XiEVBEASBut   save; Bend"
 bind $Wevstb.a.ext <Button-1> "XiEVBEASBut nosave; Bend"
 bind $Wevstb.a.end <Enter> {ConfigText $Wevstb.c.t "end edit buffer window, using current contents of this window"}
 bind $Wevstb.a.ext <Enter> {ConfigText $Wevstb.c.t "exit edit buffer window, ignore all changes done in this window"}
 bind $Wevstb.a.end <Leave> {ConfigText $Wevstb.c.t ""}
 bind $Wevstb.a.ext <Leave> {ConfigText $Wevstb.c.t ""}
 
 # frame b: file edit widget
 scrollbar $Wevstb.b.s -command "$Wevstb.b.t yview"
 text $Wevstb.b.t -yscrollcommand "$Wevstb.b.s set" -height 20 -width 80
 pack $Wevstb.b.s -side right -fill y
 pack $Wevstb.b.t -side right -fill both -expand yes
 XiTextBindKeys $Wevstb $Wevstb.b.t $Wevstb.c.t
 set f [open $INSTPATH/$NEW/locals_$XiCurLanguage/${XiSelectedVstFile}.tmp r]
 $Wevstb.b.t delete 0.0 end;  $Wevstb.b.t insert end "[read $f]";  $Wevstb.b.t yview 0
 close $f

 # frame c: Text
 label $Wevstb.c.t -text "click first at edit field"; pack $Wevstb.c.t -anchor w
}

proc XiSettVHEditEntry {nr} {# edit item $nr from the active lists XiVstActive/Inactive according to XiSelectedFromActive
 global XV Wevst Wevstl XiSelectedFromActive XiWevstButList XiSelectedVstFile XiVstHasSep XiVstSep XiVstParAnz
 global XiVstPBDL XiVstPBDLw
 TestPut 3 "**********************<$nr>"

 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}

 XiSettVHLockButtons

 if $XiVstHasSep {set t "(Separator=\"$XiVstSep\")"} else {set t "(Has no Separator)"}

 toplevel_init $Wevstl "Edit an Entry in Setting File: \"$XiSelectedVstFile\" $t" 500 150

 foreach frame "a b c" {frame $Wevstl.$frame -borderwidth 1 -relief raised; pack $Wevstl.$frame -fill x -expand yes}

 # frame a: end, previous, next, abort, delete_parameter and add_parameter buttons
 set butlist "ends prev next abrt";# if {[lindex $XV(XSettVF$XiSelectedVstFile) 3]==1} {set butlist "$butlist pdel padd"}
 foreach b $butlist {
   button $Wevstl.a.$b -text $XV(Xeeb$b); if {($b=="pdel")||($b=="padd")} {set sd right} else {set sd left}
   pack $Wevstl.a.$b -side $sd
   bind $Wevstl.a.$b <Button-1> "XiEditVstEntryB$b; Bend"
   bind $Wevstl.a.$b <Enter> "ConfigText $Wevstl.c.t \"$XV(Xeet$b)\""
   bind $Wevstl.a.$b <Leave> "ConfigText $Wevstl.c.t \"\""
 }

 # frame b: item edit widget
 for {set n 0} {$n<=$XiVstParAnz} {incr n} {XiEditVstEntryHPar $n}
 set XiVstPBDLw ""; set XiVstPBDL ""; if {$XiSelectedVstFile=="printing.vst"} {set XiVstPBDL "0 4 5 6 7"}
 XiEditVstEntryHLoad $nr;  XiEditVstEntryHPNLU

 # frame c: Text
 label $Wevstl.c.t -text ""; pack $Wevstl.c.t -anchor w
}

proc XiSettVBParDel	{b} {# delete a paramter (to be specified in a window now generated) from each entry
 global XV Wevst Wevstd XiSelectedVstFile XiVstSep
 TestPut 3 "**********************<$b>"

 XiSettVHSelClear; ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"; XiSettVHLockButtons

 toplevel_init $Wevstd "Deleting a Parameter in File: \"$XiSelectedVstFile\" (Separator=\"$XiVstSep\")" 500 100

 foreach frame "a b c" {frame $Wevstd.$frame -borderwidth 1 -relief raised; pack $Wevstd.$frame -fill x -expand yes}

 # frame a: end button
 button $Wevstd.a.e -text "end"; pack $Wevstd.a.e -side left
 bind $Wevstd.a.e <Button-1> "XiSettVHDestroyRaiseUnlock $Wevstd; Bend"
 bind $Wevstd.a.e <Enter> "ConfigText $Wevstd.c.t {ends this window}"
 bind $Wevstd.a.e <Leave> "ConfigText $Wevstd.c.t {}"

 # frame b: select&delete parameter
 XiCreateLSBox $Wevstd.b "Clicking at parameter in this list will delete it form all entries!:" top 40 10 2 \
	[XiSettVHParList] XiSettVHParDel

 # frame c: Text
 label $Wevstd.c.t -text ""; pack $Wevstd.c.t -anchor w
}

proc XiSettVBParAdd	{b} {# add a parameter (to be specified in window now generated) to each entry
 global XV Wevst Wevsta XiSelectedVstFile XiVstSep XiVstParNew
 TestPut 3 "**********************<$b>"

 XiSettVHSelClear;  ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"; XiSettVHLockButtons

 toplevel_init $Wevsta "Adding a Parameter in File: \"$XiSelectedVstFile\" (Separator=\"$XiVstSep\")" 200 100

 foreach frame "a b c" {frame $Wevsta.$frame -borderwidth 1 -relief raised; pack $Wevsta.$frame -fill x -expand yes}

 # frame a: end button
 button $Wevsta.a.e -text "end"; pack $Wevsta.a.e -side left
 button $Wevsta.a.c -text "abort"; pack $Wevsta.a.c -side left
 bind $Wevsta.a.e <Button-1> "XiSettVHParAdd; Bend"
 bind $Wevsta.a.e <Enter> "ConfigText $Wevsta.c.t {ends this window with parameter creating}"
 bind $Wevsta.a.e <Leave> "ConfigText $Wevsta.c.t {}"
 bind $Wevsta.a.c <Button-1> "XiSettVHDestroyRaiseUnlock $Wevsta; Bend"
 bind $Wevsta.a.c <Enter> "ConfigText $Wevsta.c.t {aborts this window without parameter creating}"
 bind $Wevsta.a.c <Leave> "ConfigText $Wevsta.c.t {}"

 # frame b: add new parameter
 label $Wevsta.b.l -text "new parameter name:"; pack $Wevsta.b.l -anchor w
 entry $Wevsta.b.p -textvariable XiVstParNew -width 30 -relief sunken; pack $Wevsta.b.p -anchor w -fill x -expand yes
 bind $Wevsta.b.p <Return> "focus $Wevsta"
 set t "enter name of the new parameter, then `end' window"
 foreach win "l p" \
    {bind $Wevsta.b.$win <Enter> "ConfigText $Wevsta.c.t \"$t\"";bind $Wevsta.b.$win <Leave> "ConfigText $Wevsta.c.t {}"}
 set XiVstParNew ""

 # frame c: Text
 label $Wevsta.c.t -width 50 -anchor w; pack $Wevsta.c.t -anchor w
 focus $Wevsta.b.p
}

proc XiSettVHParDel {} {# deletes a user definable parameter (e.g. in printing.vst)
 global XV Wevstd XiSelectedVstFile XiVstSep XiVstParAnzMin XiVstParAktEL XiVstParAnz XiVstLastClick XiVstLO
 global XiVstFL XiVstActive XiVstInactive XiVstOriginalParameters
 TestPut 2 ""
 if {($XiVstLastClick=="")||([lindex $XV(XSettVF$XiSelectedVstFile) 7]<=$XiVstParAnzMin)} {return ""}
 incr XiVstParAnz -1;  set XV(XSettVF$XiSelectedVstFile) [lreplace $XV(XSettVF$XiSelectedVstFile) 7 7 $XiVstParAnz]
 set pardel [lindex $XiVstLastClick 1]
 set n [expr $pardel+$XiVstLO]; set XV(XSettVF$XiSelectedVstFile) \
     [lreplace $XV(XSettVF$XiSelectedVstFile) [expr $n-1] $n [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n-1]]]
 set fl [split $XiVstFL $XiVstSep];  set XiVstFL "[lindex $fl 0]"
 set fl [lreplace $fl [expr $pardel-1] $pardel [lindex $fl [expr $pardel-1]]]
 for {set n 1} {$n<=$XiVstParAnz} {incr n} {set XiVstFL "${XiVstFL}${XiVstSep}[lindex $fl $n]"}
 $Wevstd.b.f.f.li delete 0 end; foreach e [XiSettVHParList] {$Wevstd.b.f.f.li insert end $e}
 set XiVstActive   [XiSettVHParDelN $pardel $XiVstActive]
 set XiVstInactive [XiSettVHParDelN $pardel $XiVstInactive]
 XiSettVHFill
 set XiVstOriginalParameters 0
}

proc XiSettVHParAdd {} {
 global XV Wevsta XiVstFL XiVstParNew XiVstActive XiVstInactive XiSelectedVstFile XiVstSep XiVstParAnz XiVstLO
 global XiVstOriginalParameters
 TestPut 2 "$XiVstParNew"
 set XiVstParNew [string trim $XiVstParNew]
 if {$XiVstParNew==""} \
	{ConfigText $Wevsta.c.t "missing parameter name --- enter string into the entry window!"; mybell 4; return}
 regsub -all " " $XiVstParNew "_" XiVstParNew
 TestPut 2 "$XiVstParNew"
 incr XiVstParAnz 1;  set XV(XSettVF$XiSelectedVstFile) [lreplace $XV(XSettVF$XiSelectedVstFile) 7 7 $XiVstParAnz]
 if {[string first " " $XiVstParNew]>=0} \
	{ConfigText $Wevsta.c.t "parameter name cannot contain blanks!"; mybell 4; return}
 set XV(XSettVF$XiSelectedVstFile) [linsert $XV(XSettVF$XiSelectedVstFile) [expr $XiVstParAnz+$XiVstLO] $XiVstParNew]
 set fl [split $XiVstFL $XiVstSep];  set XiVstFL "[lindex $fl 0]"
 for {set n 1} {$n<$XiVstParAnz} {incr n} {set XiVstFL "${XiVstFL}${XiVstSep}[lindex $fl $n]"}
 set XiVstFL "${XiVstFL}${XiVstSep} $XiVstParNew "
 set XiVstActive   [XiSettVHParAddL Active   $XiVstActive]
 set XiVstInactive [XiSettVHParAddL Inactive $XiVstInactive]
 set XiVstParNew ""
 XiSettVHFill
 set XiVstOriginalParameters 0
 XiSettVHDestroyRaiseUnlock $Wevsta
}

#---------------------------------------------------------------------------------------------
