/*
 * This AREXX script simulates the UNIX-sh script of the same name.
 *
 * MakeMPX -- make an MPX file from the labels in a MetaPost source file,
 * using mpto and dvitomp (TeX) (sorry, troff not supported).
 * Based on Karl Berry's version which is based on John Hobby's original
 * (though there's not much of it left by now).
 * Public domain.
 *
 * Written by <andreas.scherer@pobox.com>, March 7, 1998.
 */

Options FailAt 21 /* Handle all error levels in this script */

MPX = "mpx" || Pragma( 'Id' ) /* Simulate `$$' = task number */
NL = '0a'x /* `new line' character */

VERSION = "0.64"

MAKEMPX = "MakeMPX"

/*
 * The following constructions simulate the macro expansion
 * facility of UNIX "sh".  Most useful should be to call
 *
 *    rxset TEX "tex --progname=latex"
 *
 * in case you want to use the LaTeX typesetter for your
 * labels in METAPOST graphics.  In addition to that you
 * could set up a file mptexpre.tex in the working directory
 * containing the necessary LaTeX preamble commands.  Or, if
 * you want to use a global file instead, issue the call
 *
 *    rxset MPTEXPRE "<your-filename-here>"
 *
 * in order that MPTEXPRE points to the relevant file.  This
 * file will be prepended to the intermediate (La)TeX output
 * produced below.
 */
DMP = GetClip( "DMP" );
If "" = DMP Then DMP = "dmp"
DVITOMP = GetClip( "DVITOMP" );
If "" = DVITOMP Then DVITOMP = "dvitomp"
MPTEXPRE = GetClip( "MPTEXPRE" );
If "" = MPTEXPRE Then MPTEXPRE = "mptexpre.tex"
MPTOTEX = GetClip( "MPTOTEX" );
If "" = MPTOTEX Then MPTOTEX = "mpto -tex"
MPTOTR = GetClip( "MPTOTR" );
If "" = MPTOTR Then MPTOTR = "mpto -troff"
NEWER = GetClip( "NEWER" );
If "" = NEWER Then NEWER = "newer"
TEX = GetClip( "TEX" );
If "" = TEX Then TEX = "tex"
TROFF = GetClip( "TROFF" );
If "" = TROFF Then TROFF = "Sorry, troff not available!"

/*
 * These names are documented in the MetaPost manual, so it's
 * unwise to change them.
 */
ERRLOG = "mpxerr.log" /* file for an error log if necessary */
TEXERR = "mpxerr.tex" /* file for erroneous TeX if any */
DVIERR = "mpxerr.dvi" /* troublesome dvi file if any */
TROFF_INERR = "mpxerr" /* file for erroneous troff input, if any */
TROFF_OUTERR = "mpxerr.t" /* file for troublesome troff output, if any */

USAGE = "Usage: rx "MAKEMPX" <mpfile> <mpxfile>." || NL
USAGE = USAGE || "If <mpxfile> is older than <mpfile>, translate the" || NL
USAGE = USAGE || "labels from the MetaPost input file <mpfile> to" || NL
USAGE = USAGE || "low-level commands in <mpxfile>, by running" || NL
USAGE = USAGE || "`"MPTOTEX",' `"TEX",' and `"DVITOMP".'" || NL || NL
USAGE = USAGE || "The current directory is used for writing temporary files." || NL
USAGE = USAGE || "Errors are left in `mpxerr.{tex,log,dvi}.'" || NL || NL
USAGE = USAGE || "If the file specified with 'rxset MPTEXPRE <string>'" || NL
USAGE = USAGE || "(mptexpre.tex by default) exists, it is prepended to the output" || NL
USAGE = USAGE || "in tex mode." || NL || NL
USAGE = USAGE || "Email bug reports to andreas.scherer@pobox.com."

MODE = "tex"
MPFILE = ""
MPXFILE = ""

Parse Arg PARAMETERS
Parse Value PARAMETERS With PARAMETER PARAMETERS

Do While "" ~= PARAMETER
  Select
    When "-help" = PARAMETER | "--help" = PARAMETER Then Do
      Say USAGE
      Exit 0
    End
    When "-version" = PARAMETER | "--version" = PARAMETER Then Do
      Say MAKEMPX VERSION "(AmiWeb2c 2.1)"
      Say "There is NO warranty.  This script is public domain."
      Say "Primary author: John Hobby; AmiWeb2c maintainer: A. Scherer."
      Exit 0
    End
    When "-troff" = PARAMETER | "--troff" = PARAMETER Then
      MODE = "troff"
    When "-tex" = PARAMETER | "--tex" = PARAMETER Then
      MODE = "tex"
    When "-" = SubStr(PARAMETER,1,1) Then Do
      Say MAKEMPX": "PARAMETER"? Try --help for more information."
      Exit 1
    End
    Otherwise Do
      If "" = MPFILE Then
        MPFILE = PARAMETER /* input file */
      Else If "" = MPXFILE Then
        MPXFILE = PARAMETER /* output file */
      Else Do
        Say MAKEMPX": Extra argument "PARAMETER"; use --help if you need it."
        Exit 1
      End
    End
  End
  Parse Value PARAMETERS With PARAMETER PARAMETERS
End

If "" = MPFILE | "" = MPXFILE Then Do
  Say MAKEMPX": Need exactly two file arguments. Try --help for more information."
  Exit 1
End

Address COMMAND "delete force quiet > NIL: "MPX".#?" ERRLOG TEXERR DVIERR

/*
 * If MPXFILE is up-to-date, do nothing.
 */
Address COMMAND NEWER MPFILE MPXFILE

If 0 = RC Then Do /* 0 = TRUE in UNIX */

  /*
   * Have to remake.
   * Step 0: Check typesetter mode for consistency.
   */
  Select
    When "tex" = MODE Then
      MPTO = MPTOTEX
    When "troff" = MODE Then
      MPTO = MPTOTR
    Otherwise Do
      Say MAKEMPX": Unknown typesetter "MODE"."
      Exit 1
    End
  End

  /*
   * Step 1: Extract typesetter source from MetaPost source.
   */
  Address COMMAND MPTO MPFILE "-E"ERRLOG" > "MPX".tex"

  If 0 ~= RC Then Do
    Say NL || "Command failed: "MPTO MPFILE
    Address COMMAND "type" ERRLOG
    Address COMMAND "delete force quiet "MPX".tex"
    Exit 1
  End

  /*
   * Step 2: Run typesetter.
   */
  If "tex" = MODE Then Do

    If Exists( MPTEXPRE ) Then Do
      /* Prepend user file. */
      Address COMMAND "type "MPTEXPRE MPX".tex > "MPX".tmp"
      Address COMMAND "copy "MPX".tmp" MPX".tex > NIL:"
      Address COMMAND "delete force quiet "MPX".tmp > NIL:"
    End

    Address COMMAND TEX "\batchmode \input "MPX".tex > NIL:"

    If 0 = RC Then Do
      WHATEVER_TO_MPX = DVITOMP
      INFILE = MPX".dvi"
      INERROR = DVIERR
    End
    Else Do
      Address COMMAND "copy "MPX".tex" TEXERR
      Address COMMAND "copy "MPX".log" ERRLOG
      Say NL || MAKEMPX": Command failed: "TEX TEXERR"; see "ERRLOG
      Address COMMAND "delete force quiet "MPX".#?"
      Exit 2
    End

  End
  Else If "troff" = MODE Then
    TROFF /* Volunteers should come forward and fill this gap. */

  /*
   * Step 3: Translate typesetter output to a MetaPost MPX.
   */
  Address COMMAND WHATEVER_TO_MPX INFILE MPXFILE ">" ERRLOG

  If 0 ~= RC Then Do /* Failure */
    Address Command "copy "INFILE INERROR
    Say NL || MAKEMPX": Command failed: "WHATEVER_TO_MPX INFILE MPXFILE
    Address Command "type" ERRLOG
    Address Command "delete force quiet "MPX".#?"
    # Better to remove MPXFILE if something went wrong rather than
    # leaving behind an unfinished or unusable version since NEWER
    # might think that all is fine if MPXFILE exists.
    Address Command "delete force quiet "MPXFILE
    Exit 3
  End

  Address Command "delete force quiet "MPX".#?" ERRLOG

End

Exit 0
