//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 27th September, 2014
//
//
package worker4math.hktex2;

import java.util.ArrayList;
import java.io.InputStream;
import java.io.IOException;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.os.Bundle;
import android.view.View;
import android.util.DisplayMetrics;
import android.util.SparseArray;

public class MainActivity extends Activity {

  Canvas canvas = new Canvas();
  public static SparseArray<Thread> thread = new SparseArray<Thread>();
  
  public static int contentViewTop=0;
  public static int contentViewBottom= 0;
  public static int height=0;
  public static int width=0;
  public static int tid=0;
  
  public int showpage=0;
  Boolean firstdraw=true;
  ArrayList<Typeface> tf = new ArrayList<Typeface>();
  
  Integer containerwidth=0;
  Integer containerheight=0;
  Boolean parsed=false;
  Boolean error=false;
  Boolean tablet=true;
  String errormessage="";
  InputStream bitmapstream=null;
  DocumentBitmap documentbitmap = new DocumentBitmap();
 
  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.activity_main);
  }
 
	public void launchRingDialog(View view) {
		final ProgressDialog ringProgressDialog = ProgressDialog.show(MainActivity.this, "Please wait ...",	"Start Parsing ...", true);
		ringProgressDialog.setCancelable(true);
		new Thread(new Runnable() {
			@Override
			public void run() {
				try {
			     	Parse parse = new Parse();
			        parse.parse();
				} catch (Exception e) {

				}
				ringProgressDialog.dismiss();
				finish();
			}
		}).start();
	}
  public class Parse{
  public void parse(){

  	Source content = new Source();
  	content.content();
  	Header header = new Header();
  	header.header();
  	Symbol symbol = new Symbol();
  	symbol.symbol();
    DisplayMetrics metrics = new DisplayMetrics();
    getWindowManager().getDefaultDisplay().getMetrics(metrics);

    int containerheight = metrics.heightPixels;
    int containerwidth = metrics.widthPixels;
		int iwidth=Math.max(containerwidth, containerheight);
		int iheight=Math.min(containerwidth, containerheight);
		
    if (iwidth < 900){tablet=false;Header.tablet=false;} else {tablet=true;Header.tablet=true;}
    if(tablet){
    	if (Header.tablet_orientation_landscape){
    		containerheight=iheight;
    		containerwidth=iwidth;
    	} else {
    		containerheight=iwidth;
    		containerwidth=iheight;
    	}
    	if (Header.tablet_twocolumns && containerwidth < Header.twocolumns_criteria){Header.tablet_twocolumns=false;}
    } else {
    	if (!Header.phone_orientation_portrait){
    		containerheight=iheight;
    		containerwidth=iwidth; 		
    	} else {
    		containerheight=iwidth;
    		containerwidth=iheight;   		
    	}
    	if (Header.phone_twocolumns && containerwidth < Header.twocolumns_criteria){Header.phone_twocolumns=false;}
    }
  	SuperBlock superblock = new SuperBlock();
  	Block block= new Block();	
  	ParagraphBlock paragraphblock = new ParagraphBlock();
	    
      
  	tf.add(Typeface.SERIF);
  	tf.add(Typeface.create(Typeface.SERIF,Typeface.ITALIC));
  	tf.add(Typeface.DEFAULT_BOLD);
  	tf.add(Typeface.MONOSPACE);	    	
  	tf.add(Typeface.createFromAsset(getAssets(),"fonts/asana-math.ttf"));   //   Math symbols
  	tf.add(Typeface.SERIF);   // For the moment, use serif instead
  	
  	documentbitmap.documentbitmap();
 
    for (int i=0;i<=DocumentBitmap.bitmapname.size()-1;i++){
    try {
        bitmapstream=getAssets().open("bitmap/"+DocumentBitmap.bitmapname.get(i));
        Bitmap bitmap = BitmapFactory.decodeStream(bitmapstream);
        float width=(float)bitmap.getWidth();
        DocumentBitmap.bitmapwidth.put(DocumentBitmap.bitmapname.get(i), width);
        float height=(float)bitmap.getHeight();
        DocumentBitmap.bitmapheight.put(DocumentBitmap.bitmapname.get(i), height);
        bitmap.recycle();
    } catch (IOException e) {
        e.printStackTrace();
    } }
    
    Runnable task = new Parsable(canvas, header, symbol, superblock, block, paragraphblock, containerwidth, containerheight, 0.0f, tf);
    Header.threadid.put(Thread.currentThread().getId(), 0);
    		
    Thread thread0 = new Thread(task);
    Thread thread1 = new Thread(task);
    Thread thread2 = new Thread(task);
    Thread thread3 = new Thread(task);
    Thread thread4 = new Thread(task);
    Thread thread5 = new Thread(task);
    Thread thread6 = new Thread(task);
    Thread thread7 = new Thread(task);
    Thread thread8 = new Thread(task);
    Thread thread9 = new Thread(task);
          
    thread0.setPriority(Thread.MAX_PRIORITY);
    thread1.setPriority(Thread.MAX_PRIORITY-1);
    thread2.setPriority(Thread.MAX_PRIORITY-2);
    thread3.setPriority(Thread.MAX_PRIORITY-3);
    thread4.setPriority(Thread.MAX_PRIORITY-4);
    thread5.setPriority(Thread.MAX_PRIORITY-5);
    thread6.setPriority(Thread.MAX_PRIORITY-6);
    thread7.setPriority(Thread.MAX_PRIORITY-7);
    thread8.setPriority(Thread.MAX_PRIORITY-8);
    thread9.setPriority(Thread.MAX_PRIORITY-9); 
 
    thread.put(0, thread0);
    thread.put(1, thread1);
    thread.put(2, thread2);
    thread.put(3, thread3);
    thread.put(4, thread4);
    thread.put(5, thread5);
    thread.put(6, thread6);
    thread.put(7, thread7);
    thread.put(8, thread8);
    thread.put(9, thread9);
          
    for(int i=0;i<=Header.nthread-1;i++){
    	thread.get(i).start();
    }
    try {

    	for(int i=0;i<=Header.nthread-1;i++){
    		thread.get(i).join();
    	}
    	for(int i=0;i<=Header.nthread-1;i++){
    		if (Parsable.error.indexOfKey(i)>=0){error=true;errormessage=Parsable.errormessage.get(i);}
    	}
    	if (error){     
    		if ((!tablet && Header.phone_orientation_portrait) || (tablet && !Header.tablet_orientation_landscape)){ 
    			Intent intent = new Intent(MainActivity.this,Displayportraiterror.class); 
    			startActivityForResult(intent, 0);  
    			finish();        			  
    		} else {   
    			Intent intent = new Intent(MainActivity.this,Displaylandscapeerror.class); 
    			startActivityForResult(intent, 0);  
    			finish(); 
    		}
    	} else {
    		if ((!tablet && Header.phone_orientation_portrait) || (tablet && !Header.tablet_orientation_landscape)){        				  
    			Intent intent = new Intent(MainActivity.this,Displayportrait.class); 
    			startActivityForResult(intent, 0);  
    			finish(); 
    		} else {       				  
    			Intent intent = new Intent(MainActivity.this,Displaylandscape.class); 
    			startActivityForResult(intent, 0);  
    			finish();
    		} 
    	}
    }catch (InterruptedException e){
    	e.printStackTrace();
    }
    return ;	      	    
  }  

} }