#include <sys/emx.h>
#include <errno.h>
#include <sys/doscalls.h>

int __filesys (const char *drive, char *name, size_t size)
{
    char *res;
    int ret;
    char drv = drive[0];

    if (size < 3) {
	errno = EINVAL;
	return -1;
    }

    if (drv >= 'a')
	drv -= 0x20;

    if (drv < 'A' || drv > 'Z' || drive[1] != ':' || drive[2] != 0) {
	errno = EINVAL;
	return -1;
    }

    drv -= ('A' - 1);
    ret = dos_ioctl_remotedrive(drv);
    if (ret == 1)
	res = "LAN";
    else
	res = "FAT";

    strcpy(name, res);
    return 0;
}
