/*
 * Decompiled with CFR 0.152.
 */
package nts.dvi;

import java.io.OutputStream;
import java.util.HashMap;
import nts.base.Dimen;
import nts.dvi.DviFormatWriter;
import nts.io.CharCode;
import nts.node.FontMetric;
import nts.node.TypeSetter;

public class DviTypeSetter
extends DviFormatWriter
implements TypeSetter {
    public static final DviTypeSetter NULL;
    protected static final int DVI_NUM = 25400000;
    protected static final int DVI_DEN = 473628672;
    protected static final int DIM_DEN = 65536;
    static final PendRule NULL_PEND_RULE;
    private FontInformator fontInf;
    private int currX = 0;
    private int currY = 0;
    private HashMap fontMap = new HashMap();
    private FontMetric currMetric = null;
    private FontInfo currInfo = null;
    private PendRule pendRule = null;
    private int dviX = 0;
    private int dviY = 0;
    private Level stack = null;
    private int maxH = 0;
    private int maxW = 0;

    private static int dim(Dimen x) {
        return x.toInt(65536);
    }

    public void moveLeft(Dimen x) {
        this.currX -= DviTypeSetter.dim(x);
        this.tryToSetPendRule();
    }

    public void moveRight(Dimen x) {
        this.currX += DviTypeSetter.dim(x);
        this.tryToSetPendRule();
    }

    public void moveUp(Dimen y) {
        this.currY -= DviTypeSetter.dim(y);
    }

    public void moveDown(Dimen y) {
        this.currY += DviTypeSetter.dim(y);
    }

    public void set(char ch, FontMetric metric) {
        Dimen w;
        this.syncHoriz();
        this.syncVert();
        if (!metric.equals(this.currMetric)) {
            FontInfo info = (FontInfo)this.fontMap.get(metric);
            if (info == null) {
                info = this.fontInf.getInfo(metric);
                this.fontMap.put(metric, info);
                this.defFont(info.getIdNumber(), info.getCheckSum(), DviTypeSetter.dim(info.getAtSize()), DviTypeSetter.dim(info.getDesignSize()), info.getDirName(), info.getFileName());
            }
            this.setFont(info.getIdNumber());
            this.currMetric = metric;
            this.currInfo = info;
        }
        if ((w = this.currInfo.getCharWidth(ch)) == null) {
            this.putChar(ch);
        } else {
            this.setChar(ch);
            this.dviX += DviTypeSetter.dim(w);
        }
    }

    public void set(CharCode code, FontMetric metric) {
        this.set(code.toChar(), metric);
    }

    private void putPendRule() {
        if (this.pendRule != null) {
            this.pendRule.put();
            this.pendRule = null;
        }
    }

    private void tryToSetPendRule() {
        if (this.pendRule != null && this.pendRule.canBeSet()) {
            this.pendRule.set();
            this.pendRule = null;
        }
    }

    public void setRule(Dimen h, Dimen w) {
        int height = DviTypeSetter.dim(h);
        int width = DviTypeSetter.dim(w);
        if (height > 0 && width > 0) {
            this.syncHoriz();
            this.syncVert();
            DviTypeSetter dviTypeSetter = this;
            if (dviTypeSetter == null) {
                throw null;
            }
            this.pendRule = dviTypeSetter.new PendRule(height, width);
        }
    }

    public void setSpecial(byte[] spec) {
        this.syncHoriz();
        this.syncVert();
        super.setSpecial(spec);
    }

    public TypeSetter.Mark mark() {
        DviTypeSetter dviTypeSetter = this;
        if (dviTypeSetter == null) {
            throw null;
        }
        return new TypeSetter.Mark(dviTypeSetter){
            private final int x;
            private final int y;
            private final /* synthetic */ DviTypeSetter this$0;

            public void move() {
                DviTypeSetter.access$2(this.this$0, this.x);
                DviTypeSetter.access$3(this.this$0, this.y);
            }

            public Dimen xDiff() {
                return Dimen.valueOf(DviTypeSetter.access$0(this.this$0) - this.x, 65536);
            }

            public Dimen yDiff() {
                return Dimen.valueOf(DviTypeSetter.access$1(this.this$0) - this.y, 65536);
            }
            {
                this.this$0 = this$0;
                this.x = DviTypeSetter.access$0(this.this$0);
                this.y = DviTypeSetter.access$1(this.this$0);
                this.constructor$0(this$0);
            }

            private final void constructor$0(DviTypeSetter dviTypeSetter) {
            }
        };
    }

    public void syncHoriz() {
        this.putPendRule();
        if (this.dviX != this.currX) {
            this.moveX(this.currX - this.dviX);
            this.dviX = this.currX;
        }
    }

    public void syncVert() {
        this.putPendRule();
        if (this.dviY != this.currY) {
            this.moveY(this.currY - this.dviY);
            this.dviY = this.currY;
        }
    }

    public void push() {
        this.putPendRule();
        super.push();
        this.stack = new Level(this.dviX, this.dviY, this.stack);
    }

    public void pop() {
        this.putPendRule();
        if (this.stack == null) {
            throw new RuntimeException("too many pops in DVI");
        }
        this.dviX = this.stack.x;
        this.dviY = this.stack.y;
        this.stack = this.stack.next;
        super.pop();
    }

    public void startPage(Dimen yOffset, Dimen xOffset, Dimen height, Dimen width, int[] nums) {
        int y = DviTypeSetter.dim(yOffset);
        int x = DviTypeSetter.dim(xOffset);
        int h = DviTypeSetter.dim(height) + y;
        int w = DviTypeSetter.dim(width) + x;
        if (this.maxH < h) {
            this.maxH = h;
        }
        if (this.maxW < w) {
            this.maxW = w;
        }
        this.currMetric = null;
        this.currInfo = null;
        this.dviY = 0;
        this.dviX = 0;
        this.stack = null;
        this.currX = x;
        this.currY = y;
        this.startPage(nums);
    }

    public void endPage() {
        this.putPendRule();
        super.endPage();
    }

    public void close() {
        this.putPendRule();
        this.close(this.maxH, this.maxW);
    }

    static /* synthetic */ int access$1(DviTypeSetter dviTypeSetter) {
        return dviTypeSetter.currY;
    }

    static /* synthetic */ void access$2(DviTypeSetter dviTypeSetter, int n) {
        dviTypeSetter.currX = n;
    }

    static /* synthetic */ void access$3(DviTypeSetter dviTypeSetter, int n) {
        dviTypeSetter.currY = n;
    }

    public DviTypeSetter(OutputStream out, FontInformator inf, int mag, byte[] comm, int size) {
        super(out, 25400000, 473628672, mag, comm, size);
        this.fontInf = inf;
    }

    public DviTypeSetter(OutputStream out, FontInformator inf, int mag, byte[] comm) {
        this(out, inf, mag, comm, 0);
    }

    private class PendRule {
        private final int height;
        private final int width;

        void put() {
            DviTypeSetter.this.putRule(this.height, this.width);
        }

        void set() {
            DviTypeSetter.this.setRule(this.height, this.width);
            DviTypeSetter dviTypeSetter = DviTypeSetter.this;
            dviTypeSetter.dviX = dviTypeSetter.dviX + this.width;
        }

        boolean canBeSet() {
            return DviTypeSetter.this.currX == DviTypeSetter.this.dviX + this.width;
        }

        PendRule(int h, int w) {
            this.height = h;
            this.width = w;
        }
    }

    private static class Level {
        static final Level NULL;
        final int x;
        final int y;
        final Level next;

        Level(int x, int y, Level next) {
            this.x = x;
            this.y = y;
            this.next = next;
        }
    }

    public static interface FontInfo {
        public static final FontInfo NULL;

        public int getIdNumber();

        public byte[] getDirName();

        public byte[] getFileName();

        public int getCheckSum();

        public Dimen getAtSize();

        public Dimen getDesignSize();

        public Dimen getCharWidth(char var1);
    }

    public static interface FontInformator {
        public FontInfo getInfo(FontMetric var1);
    }
}

