/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.latex3;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.latex3.L3StorageCommand;
import java.io.IOException;

public class ClistCommand
extends Command
implements L3StorageCommand {
    protected TeXObjectList content;

    public ClistCommand(String string) {
        super(string);
        this.content = new TeXObjectList();
    }

    public ClistCommand(String string, int n) {
        super(string);
        this.content = new TeXObjectList(n);
    }

    public ClistCommand(String string, ClistCommand clistCommand) {
        super(string);
        this.content = (TeXObjectList)clistCommand.content.clone();
    }

    public static ClistCommand createFromClist(TeXParser teXParser, String string, CsvList csvList) {
        ClistCommand clistCommand = new ClistCommand(string, csvList.capacity());
        for (int i = 0; i < csvList.size(); ++i) {
            TeXObject teXObject = (TeXObject)csvList.get(i);
            if (teXParser.isStack(teXObject) && teXObject.isEmpty()) continue;
            TeXObject teXObject2 = csvList.getValue(i, true);
            clistCommand.append(teXObject2);
        }
        return clistCommand;
    }

    @Override
    public Object clone() {
        ClistCommand clistCommand = new ClistCommand(this.getName(), this.content.capacity());
        for (TeXObject teXObject : this.content) {
            clistCommand.append((TeXObject)teXObject.clone());
        }
        return clistCommand;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        CsvList csvList = new CsvList();
        csvList.addAll(this.content);
        return csvList;
    }

    public void setContent(TeXObjectList teXObjectList) {
        this.content = teXObjectList;
    }

    @Override
    public TeXObjectList getContent() {
        return this.content;
    }

    @Override
    public void setQuantity(TeXParser teXParser, TeXObject teXObject) throws TeXSyntaxException {
        if (teXObject instanceof TeXObjectList) {
            this.content = (TeXObjectList)teXObject;
        } else {
            this.content = new TeXObjectList();
            this.content.add(teXObject);
        }
    }

    @Override
    public TeXObject getQuantity(TeXParser teXParser, TeXObjectList teXObjectList) throws TeXSyntaxException {
        return (TeXObject)this.content.clone();
    }

    @Override
    public void append(TeXObject teXObject) {
        this.content.add(teXObject);
    }

    @Override
    public void prepend(TeXObject teXObject) {
        this.content.add(0, teXObject);
    }

    public TeXObject set(int n, TeXObject teXObject) throws ArrayIndexOutOfBoundsException {
        return this.content.set(n, teXObject);
    }

    public TeXObject get(int n) {
        return (TeXObject)this.content.get(n);
    }

    public TeXObject item(int n) {
        if (this.content.size() > n) {
            return new TeXObjectList();
        }
        return (TeXObject)this.content.get(n - 1);
    }

    public int size() {
        return this.content.size();
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public void clear() {
        this.content.clear();
    }

    public TeXObject firstElement() {
        if (this.content.isEmpty()) {
            return new TeXCsRef("q_no_value");
        }
        return (TeXObject)this.content.firstElement();
    }

    public TeXObject lastElement() {
        if (this.content.isEmpty()) {
            return new TeXCsRef("q_no_value");
        }
        return (TeXObject)this.content.lastElement();
    }

    public TeXObject popFirst() {
        if (this.content.isEmpty()) {
            return new TeXCsRef("q_no_value");
        }
        return (TeXObject)this.content.remove(0);
    }

    public TeXObject popLast() {
        if (this.content.isEmpty()) {
            return new TeXCsRef("q_no_value");
        }
        return (TeXObject)this.content.remove(this.content.size() - 1);
    }
}

