---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, 
              bibliographie complète, citer toutes les références,
              lister toutes les références biblio
---

# Comment afficher toutes les entrées d'un fichier BIB ?

Le travail de BibTeX ou BibLaTeX consiste à sélectionner uniquement 
les entrées de votre base de données bibliographique (fichier BIB) 
citées dans votre document. Mais parfois, par exemple pour lire 
et corriger votre base de données, vous voulez faire le contraire : 
obtenir un document avec tout le contenu de la base.


## Avec les commandes de base

Vous pouvez alors utiliser la commande `\nocite` avec une étoile 
pour argument :

```{noedit}
\nocite{*}
```

Ainsi, toutes les références de chaque fichier BIB
listé dans votre déclaration de fichier bibliographie (avec `\bibliography` 
pour BibTeX ou `\addbibresource` avec BibLaTeX) seront affichées.
Voici un exemple avec BibTeX.

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{mabiblio.bib}
  @book{mittelbach_latex_2005,
    title = "{\LaTeX} Companion",
    author = "Mittelbach, Frank and Goossens, Michel and Braams, Johannes
              and Carlisle, David and Rowley, Chris and Detig, Christine
              and Schrod, Joachim",
    publisher = "Pearson Education",
    edition = "2\textsuperscript{e} édition",
    year = "2005"
  }
  @book{knuth_texbook_1986,
    author = "Knuth, Donald Ervin",
    title = "The {\TeX book}",
    publisher = "Addison-Wesley",
    year = "1986"
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Sans rentrer dans le détail des ouvrages, nous vous renvoyons 
à notre bibliographie pour plus d'information.
\nocite{*}
\bibliographystyle{plain-fr}
\bibliography{mabiblio}
\end{document}
```

Si le style bibliographique ne trie pas les entrées, celles-ci seront incluses
dans leur ordre d'apparition dans le fichier BIB. De cette façon,

- si `\nocite{*}` est placée au début du document, les entrées 
  de la bibliographie seront dans l'ordre du fichier BIB ;
- si cette commande est placée à la fin du document, les entrées 
  qui n'étaient pas citées par ailleurs sont ajoutées après les entrées citées
  dans le document.

Notez que LaTeX *ne produit pas* d'avertissement `Citation ... undefined` ou 
`There were undefined references` quand ils arrivent à cause de `\nocite{*}`. 
Si vous exécutez LaTeX et BibTeX manuellement, cela ne vous posera 
aucun souci mais cela risque d'empêcher des scripts automatiques de déterminer 
si une nouvelle exécution de LaTeX est nécessaire.


## Cas de bases volumineuses

:::{warning}
Ce qui suit a un caractère historique du fait de l'évolution des capacités de
mémoire des ordinateurs rendant ces solutions peu utiles.
:::

Avec une base de données bibliographique volumineuse, il peut arriver que 
BibTeX, utilisé avec `\nocite{*}`, sature la mémoire de la machine. 
Des extensions ont été développées pour contourner le problème :

- <ctanpkg:biblist> a été écrit pour être utilisé sous LaTeX 2.09 
  mais semble encore fonctionner ;
- <ctanpkg:listbib> est plus moderne.

Ces deux extensions fournissent leurs propres fichiers 
de style bibliographique BST, ce qui permet de restituer chaque entrée 
de la bibliographie sous forme d'entrées plus détaillées intégrant 
en particulier la
"[clé unique](/3_composition/annexes/bibliographie/donnees/construire_un_fichier_bibtex)".


:::{sources}
- [Listing all your BibTeX entries](faquk:FAQ-nocitestar)
- [Generate list of references from bib file](https://tex.stackexchange.com/q/482570),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::