---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              structures, indices, positionnement des indices, 
              positionnement des exposants, indices décalés, 
              alignement des indices
---

# Comment bien aligner les indices et exposants ?

Toutes choses étant égales par ailleurs, TeX s'efforcera de positionner
les [indices et les exposants](/4_domaines_specialises/mathematiques/structures/indices/start) 
à des endroits corrects. Malheureusement, il le fait séparément 
pour les indices et les exposants de chaque terme de l'équation. 
Voici un exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\Huge % De grands caractères pour bien voir
$ X^{1}_{2} X_{2} $
\end{document}
```

Ici, le second indice semble trop haut, puisque le premier a été légèrement
déplacé vers le bas pour éviter de toucher l'exposant.


## Avec des commandes de base

Vous pouvez éviter ce problème, au sein d'une équation, en utilisant 
la méthode suivante :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\Huge % De grands caractères pour bien voir
$ X^{1}_{2} X^{}_{2} $
\end{document}
```

Ici, l'exposant vide a pour effet nécessaire de "pousser l'indice vers le bas",
ce qui restaure l'alignement visuel des deux indices.

De façon plus poussée, la commande `\vphantom` définit une boîte invisible 
dont la hauteur est celle de son argument. Elle peut être utilisée pour aligner
des indices, comme dans l'exemple qui suit.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\Huge % De grands caractères pour bien voir
\[
  f_d = f_{\widehat{ef}} \mathrm{\ devient\ } f_{\vphantom{\widehat{ef}} d}
      = f_{\widehat{ef}}.
\]
\end{document}
```


## Avec l'extension <ctanpkg:subdepth>

Si la technique ci-dessus fonctionne, elle est fastidieuse et potentiellement
source d'erreurs. Ainsi, pour plus d'une ou deux équations dans un document,
il est conseillé d'utiliser l'extension <ctanpkg:subdepth>, qui force 
tous les indices à apparaître à leur position basse, indépendamment 
de la présence d'un exposant.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}
  \usepackage{subdepth}

\begin{document}
\Huge % De grands caractères pour bien voir
$ X^{1}_{2} X_{2} $
\end{document}
```

Il faut noter que cette extension ne fonctionne pas avec `lualatex`. 
Dans ce cas, il faudra utiliser la solution suivante. Elle n'est cependant
pas idéale car elle nécessite des tests d'ajustement. Le simple fait 
de changer la taille des caractères demanderait un ajustement des règlages 
effectués avec la commande `\Umathsubshiftdown`, commande qui sert 
au déplacement vers le bas pour les caractères en indice :

```
%!TEX engine=lualatex
\documentclass{article}
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\Huge % De grands caractères pour bien voir
Avant modification, $X_2 X_2^\dagger
X_2^+$ s'affiche ainsi hors ligne :
\[X_2 X_2^\dagger X_2^+\]

% Décalage vers le bas de 6pt pour les indices des mathématiques en ligne
\Umathsubshiftdown\textstyle=6pt
% Décalage vers le bas de 6pt pour les indices des mathématiques hors ligne
\Umathsubshiftdown\displaystyle=6pt

Après modification, $X_2 X_2^\dagger
X_2^+$ s'affiche ainsi hors ligne :
\[X_2 X_2^\dagger X_2^+\]
\end{document}
```

Ce type de réglage fait partie d'un ensemble plus conséquent de réglages 
des mathématiques possibles avec `lualatex`. L'article 
*[LuaTeX 0.65 et les mathématiques](http://www.numdam.org/item/CG_2010___54-55_101_0.pdf)* 
du *[numéro 54-55](http://www.numdam.org/issues/CG_2010___54-55/)* 
des *[Cahiers de Gutenberg](https://www.gutenberg-asso.fr/-Cahiers-GUTenberg-)*
liste ce type de commandes (en fin d'article).


:::{sources}
- [Even subscript height](faquk:FAQ-subheight)
- [Re : \[luatex\] sub and superscripts in Lua(La)TeX with tfm/otf](https://www.mail-archive.com/luatex@tug.org/msg05849.html)
:::