/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.RenderCondition;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u0000H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/github/ajalt/colormath/CMYK;", "Lcom/github/ajalt/colormath/Color;", "c", "", "m", "y", "k", "a", "", "(IIIIF)V", "getA", "()F", "alpha", "getAlpha", "getC", "()I", "getK", "getM", "getY", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toCMYK", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "colormath"})
public final class CMYK
implements Color {
    private final int c;
    private final int m;
    private final int y;
    private final int k;
    private final float a;

    @Override
    public float getAlpha() {
        return this.a;
    }

    @Override
    @NotNull
    public RGB toRGB() {
        double c = (double)this.c / 100.0;
        double m = (double)this.m / 100.0;
        double y = (double)this.y / 100.0;
        double k = (double)this.k / 100.0;
        double r = (double)255 * (1.0 - c) * (1.0 - k);
        double g = (double)255 * (1.0 - m) * (1.0 - k);
        double b = (double)255 * (1.0 - y) * (1.0 - k);
        return new RGB(MathKt.roundToInt(r), MathKt.roundToInt(g), MathKt.roundToInt(b), this.getAlpha());
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return this;
    }

    public final int getC() {
        return this.c;
    }

    public final int getM() {
        return this.m;
    }

    public final int getY() {
        return this.y;
    }

    public final int getK() {
        return this.k;
    }

    public final float getA() {
        return this.a;
    }

    public CMYK(int c, int m, int y, int k, float a) {
        this.c = c;
        this.m = m;
        this.y = y;
        this.k = k;
        this.a = a;
        int n = this.c;
        n = 0 <= n && 100 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "c must be in range [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.m;
        n = 0 <= n && 100 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "m must be in range [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.y;
        n = 0 <= n && 100 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl5 = false;
            String string = "y must be in range [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.k;
        n = 0 <= n && 100 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl6 = false;
            String string = "k must be in range [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        float f = this.a;
        boolean bl7 = f >= 0.0f && f <= 1.0f;
        bl = false;
        bl2 = false;
        if (!bl7) {
            boolean bl8 = false;
            String string = "a must be in range [0, 1] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ CMYK(int n, int n2, int n3, int n4, float f, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x10) != 0) {
            f = 1.0f;
        }
        this(n, n2, n3, n4, f);
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign, @NotNull RenderCondition renderAlpha) {
        Intrinsics.checkNotNullParameter((Object)renderAlpha, "renderAlpha");
        return Color.DefaultImpls.toHex(this, withNumberSign, renderAlpha);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return Color.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    public final int component1() {
        return this.c;
    }

    public final int component2() {
        return this.m;
    }

    public final int component3() {
        return this.y;
    }

    public final int component4() {
        return this.k;
    }

    public final float component5() {
        return this.a;
    }

    @NotNull
    public final CMYK copy(int c, int m, int y, int k, float a) {
        return new CMYK(c, m, y, k, a);
    }

    public static /* synthetic */ CMYK copy$default(CMYK cMYK, int n, int n2, int n3, int n4, float f, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = cMYK.c;
        }
        if ((n5 & 2) != 0) {
            n2 = cMYK.m;
        }
        if ((n5 & 4) != 0) {
            n3 = cMYK.y;
        }
        if ((n5 & 8) != 0) {
            n4 = cMYK.k;
        }
        if ((n5 & 0x10) != 0) {
            f = cMYK.a;
        }
        return cMYK.copy(n, n2, n3, n4, f);
    }

    @NotNull
    public String toString() {
        return "CMYK(c=" + this.c + ", m=" + this.m + ", y=" + this.y + ", k=" + this.k + ", a=" + this.a + ")";
    }

    public int hashCode() {
        return (((Integer.hashCode(this.c) * 31 + Integer.hashCode(this.m)) * 31 + Integer.hashCode(this.y)) * 31 + Integer.hashCode(this.k)) * 31 + Float.hashCode(this.a);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CMYK)) break block3;
                CMYK cMYK = (CMYK)object;
                if (this.c != cMYK.c || this.m != cMYK.m || this.y != cMYK.y || this.k != cMYK.k || Float.compare(this.a, cMYK.a) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

