/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.EventTranslatorVararg;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DisruptorUtil;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.async.RingBufferLogEventHandler4;
import org.apache.logging.log4j.core.async.RingBufferLogEventTranslator;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.core.util.Log4jThread;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.message.Message;

class AsyncLoggerDisruptor
extends AbstractLifeCycle {
    private static final int SLEEP_MILLIS_BETWEEN_DRAIN_ATTEMPTS = 50;
    private static final int MAX_DRAIN_ATTEMPTS_BEFORE_SHUTDOWN = 200;
    private final Object queueFullEnqueueLock = new Object();
    private volatile Disruptor<RingBufferLogEvent> disruptor;
    private String contextName;
    private final Supplier<AsyncWaitStrategyFactory> waitStrategyFactorySupplier;
    private boolean useThreadLocalTranslator = true;
    private long backgroundThreadId;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;
    private int ringBufferSize;
    private WaitStrategy waitStrategy;

    private static EventHandler<RingBufferLogEvent> createEventHandler() {
        if (DisruptorUtil.DISRUPTOR_MAJOR_VERSION == 3) {
            try {
                return (EventHandler)Class.forName("org.apache.logging.log4j.core.async.RingBufferLogEventHandler").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (LinkageError | ReflectiveOperationException e) {
                LOGGER.warn("Failed to create event handler for LMAX Disruptor 3.x, trying version 4.x.", e);
            }
        }
        return new RingBufferLogEventHandler4();
    }

    AsyncLoggerDisruptor(String contextName, Supplier<AsyncWaitStrategyFactory> waitStrategyFactorySupplier) {
        this.contextName = contextName;
        this.waitStrategyFactorySupplier = Objects.requireNonNull(waitStrategyFactorySupplier, "waitStrategyFactorySupplier");
    }

    WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String name) {
        this.contextName = name;
    }

    Disruptor<RingBufferLogEvent> getDisruptor() {
        return this.disruptor;
    }

    @Override
    public synchronized void start() {
        if (this.disruptor != null) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor not starting new disruptor for this context, using existing object.", (Object)this.contextName);
            return;
        }
        if (this.isStarting()) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor is already starting.", (Object)this.contextName);
            return;
        }
        this.setStarting();
        LOGGER.trace("[{}] AsyncLoggerDisruptor creating new disruptor for this context.", (Object)this.contextName);
        this.ringBufferSize = DisruptorUtil.calculateRingBufferSize("AsyncLogger.RingBufferSize");
        AsyncWaitStrategyFactory factory = this.waitStrategyFactorySupplier.get();
        this.waitStrategy = DisruptorUtil.createWaitStrategy("AsyncLogger.WaitStrategy", factory);
        Log4jThreadFactory threadFactory = new Log4jThreadFactory("AsyncLogger[" + this.contextName + "]", true, 5){

            @Override
            public Thread newThread(Runnable r) {
                Thread result2 = super.newThread(r);
                AsyncLoggerDisruptor.this.backgroundThreadId = result2.getId();
                return result2;
            }
        };
        this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
        this.disruptor = new Disruptor((EventFactory)RingBufferLogEvent.FACTORY, this.ringBufferSize, (ThreadFactory)threadFactory, ProducerType.MULTI, this.waitStrategy);
        ExceptionHandler<RingBufferLogEvent> errorHandler2 = DisruptorUtil.getAsyncLoggerExceptionHandler();
        this.disruptor.setDefaultExceptionHandler(errorHandler2);
        EventHandler<RingBufferLogEvent> handler2 = AsyncLoggerDisruptor.createEventHandler();
        this.disruptor.handleEventsWith(new EventHandler[]{handler2});
        LOGGER.debug("[{}] Starting AsyncLogger disruptor for this context with ringbufferSize={}, waitStrategy={}, exceptionHandler={}...", (Object)this.contextName, (Object)this.disruptor.getRingBuffer().getBufferSize(), (Object)this.waitStrategy.getClass().getSimpleName(), (Object)errorHandler2);
        this.disruptor.start();
        LOGGER.trace("[{}] AsyncLoggers use a {} translator", (Object)this.contextName, (Object)(this.useThreadLocalTranslator ? "threadlocal" : "vararg"));
        super.start();
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        Disruptor<RingBufferLogEvent> temp = this.getDisruptor();
        if (temp == null) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor: disruptor for this context already shut down.", (Object)this.contextName);
            return true;
        }
        this.setStopping();
        LOGGER.debug("[{}] AsyncLoggerDisruptor: shutting down disruptor for this context.", (Object)this.contextName);
        this.disruptor = null;
        for (int i = 0; AsyncLoggerDisruptor.hasBacklog(temp) && i < 200; ++i) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            temp.shutdown(timeout, timeUnit);
        }
        catch (TimeoutException e) {
            LOGGER.warn("[{}] AsyncLoggerDisruptor: shutdown timed out after {} {}", (Object)this.contextName, (Object)timeout, (Object)timeUnit);
            temp.halt();
        }
        LOGGER.trace("[{}] AsyncLoggerDisruptor: disruptor has been shut down.", (Object)this.contextName);
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncLoggerDisruptor: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy));
        }
        this.setStopped();
        return true;
    }

    private static boolean hasBacklog(Disruptor<?> theDisruptor) {
        RingBuffer ringBuffer = theDisruptor.getRingBuffer();
        return !ringBuffer.hasAvailableCapacity(ringBuffer.getBufferSize());
    }

    public RingBufferAdmin createRingBufferAdmin(String jmxContextName) {
        RingBuffer ring = this.disruptor == null ? null : this.disruptor.getRingBuffer();
        return RingBufferAdmin.forAsyncLogger(ring, jmxContextName);
    }

    EventRoute getEventRoute(Level logLevel) {
        int remainingCapacity = this.remainingDisruptorCapacity();
        if (remainingCapacity < 0) {
            return EventRoute.DISCARD;
        }
        return this.asyncQueueFullPolicy.getRoute(this.backgroundThreadId, logLevel);
    }

    private int remainingDisruptorCapacity() {
        Disruptor<RingBufferLogEvent> temp = this.disruptor;
        if (this.hasLog4jBeenShutDown(temp)) {
            return -1;
        }
        return (int)temp.getRingBuffer().remainingCapacity();
    }

    private boolean hasLog4jBeenShutDown(Disruptor<RingBufferLogEvent> aDisruptor) {
        if (aDisruptor == null) {
            LOGGER.warn("Ignoring log event after log4j was shut down");
            return true;
        }
        return false;
    }

    boolean tryPublish(RingBufferLogEventTranslator translator) {
        try {
            return this.disruptor.getRingBuffer().tryPublishEvent((EventTranslator)translator);
        }
        catch (NullPointerException npe) {
            this.logWarningOnNpeFromDisruptorPublish(translator);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueLogMessageWhenQueueFull(RingBufferLogEventTranslator translator) {
        block6: {
            try {
                if (this.synchronizeEnqueueWhenQueueFull()) {
                    Object object = this.queueFullEnqueueLock;
                    synchronized (object) {
                        this.disruptor.publishEvent((EventTranslator)translator);
                        break block6;
                    }
                }
                this.disruptor.publishEvent((EventTranslator)translator);
            }
            catch (NullPointerException npe) {
                this.logWarningOnNpeFromDisruptorPublish(translator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueLogMessageWhenQueueFull(EventTranslatorVararg<RingBufferLogEvent> translator, AsyncLogger asyncLogger, StackTraceElement location, String fqcn, Level level, Marker marker, Message msg, Throwable thrown) {
        block6: {
            try {
                if (this.synchronizeEnqueueWhenQueueFull()) {
                    Object object = this.queueFullEnqueueLock;
                    synchronized (object) {
                        this.disruptor.getRingBuffer().publishEvent(translator, new Object[]{asyncLogger, location, fqcn, level, marker, msg, thrown});
                        break block6;
                    }
                }
                this.disruptor.getRingBuffer().publishEvent(translator, new Object[]{asyncLogger, location, fqcn, level, marker, msg, thrown});
            }
            catch (NullPointerException npe) {
                this.logWarningOnNpeFromDisruptorPublish(level, fqcn, msg, thrown);
            }
        }
    }

    private boolean synchronizeEnqueueWhenQueueFull() {
        return DisruptorUtil.ASYNC_LOGGER_SYNCHRONIZE_ENQUEUE_WHEN_QUEUE_FULL && this.backgroundThreadId != Thread.currentThread().getId() && !(Thread.currentThread() instanceof Log4jThread);
    }

    private void logWarningOnNpeFromDisruptorPublish(RingBufferLogEventTranslator translator) {
        this.logWarningOnNpeFromDisruptorPublish(translator.level, translator.loggerName, translator.message, translator.thrown);
    }

    private void logWarningOnNpeFromDisruptorPublish(Level level, String fqcn, Message msg, Throwable thrown) {
        LOGGER.warn("[{}] Ignoring log event after log4j was shut down: {} [{}] {}{}", (Object)this.contextName, (Object)level, (Object)fqcn, (Object)msg.getFormattedMessage(), thrown == null ? "" : Throwables.toStringList(thrown));
    }

    public boolean isUseThreadLocals() {
        return this.useThreadLocalTranslator;
    }

    public void setUseThreadLocals(boolean allow) {
        this.useThreadLocalTranslator = allow;
        LOGGER.trace("[{}] AsyncLoggers have been modified to use a {} translator", (Object)this.contextName, (Object)(this.useThreadLocalTranslator ? "threadlocal" : "vararg"));
    }
}

