/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

public class SetTextFont
extends OperatorProcessor {
    private static final Log LOG = LogFactory.getLog(SetTextFont.class);

    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        if (arguments.size() >= 2) {
            COSBase base0 = arguments.get(0);
            COSBase base1 = arguments.get(1);
            if (!(base0 instanceof COSName)) {
                return;
            }
            if (!(base1 instanceof COSNumber)) {
                return;
            }
            COSName fontName = (COSName)base0;
            float fontSize = ((COSNumber)base1).floatValue();
            this.context.getGraphicsState().getTextState().setFontSize(fontSize);
            PDFont font = this.context.getFonts().get(fontName.getName());
            if (font == null) {
                LOG.error((Object)("Could not find font(" + fontName + ") in map=" + this.context.getFonts() + ", creating default font"));
                font = PDFontFactory.createDefaultFont();
            }
            this.context.getGraphicsState().getTextState().setFont(font);
        }
    }
}

