#ifndef _CID_BASEFONT_H_
#define _CID_BASEFONT_H_

/* PDF object xxx is treated as yyy in this file */
#define NAME char *
#define INT double
#define ARRAY char *
#define STRING char *
#define DICTIONARY char *

/* CID font embedding is not supported yet, so related stuff are omitted */
typedef struct {
  NAME fontname; /* PostScript Font Name, required */
  NAME subtype; /* Subtype, CIDType0 or CIDType2, required */
  int cc_name; /* Charcter Collection, required */
  INT ascent; /* Ascent, required */
  INT capheight; /* CapHeight, required */
  INT descent; /* Descent, required */
  INT flags; /* Flags, required */
  INT dw; /* DW (Default Width), optional */
  ARRAY w; /* W (Width array), optional */
  ARRAY dw2; /* DW2 (for vertical writing mode), optional */
  ARRAY w2; /* W2 (for vertical writing mode), optional */
  ARRAY bbox; /* FontBBox, required */ 
  INT italic; /* ItalicAngle, required */
  INT stemv; /* StemV, required */
  INT avgw;  /* AvgWidth, optional */
  INT leading; /* Leading, optional */
  INT maxw; /* MaxWidth, optional */
  INT missw; /* MissingWidth, optional */
  INT stemh; /* StemH, optional */
  INT xheight; /* XHeight, optional */
  STRING charset; /* Charset, optional */
  DICTIONARY style; /* Style, optional */
} cid_info;

/* - Use of Style -
   cited from PDF Reference Manual v. 1.1

     The Style dictionary contains a set of key-value pairs that define
     style attribute and value for the font. Currently only the Panose
     key is defined. The value of the Panose key is the 12-byte string
     containing the Family Class ID, Family SubClass ID, and 10 bytes for
     the Panose classification number for the font. For additional details
     on the Panose number see the TrueType 1.0 Font Files specification
     from Microsoft.

    ---
    Usage:

     /Style << /Panose (12-byte string) >> 

    Note:
     Acrobat Reader uses those numbers when substituting missing font.

  - Obtaining Family Class ID, Fimily SubClass ID,
                       and Panose Classification Number -

    TrueType: see OS/2 table
    (TrueType font for MacOS may not have OS/2 table)
*/

/* - Subtypes -
   CIDFontType0 - PostScript Type1 glyph data
   CIDFontType2 - TrueType glyph data
*/
#define TYPE0 "CIDFontType0"
#define TRUETYPE "CIDFontType2"

/* Please correct me */
/*
  PDF core font for Japanese:
   HeiseiMin-W3-Acro, HeiseiKakuGo-W5-Acro
  PostScript "standard" font for Japanese:
   Ryumin-Light, GothicBBB-Medium
*/

/* Should not use 0 to represent undefined INT values ... Please correct me */
#define CID_LAST_BASEFONT 4
const cid_info cid_basefont[CID_LAST_BASEFONT] = {
  {
    "HeiseiKakuGo-W5", /* FontName, required */
    TYPE0, /* Subtype, CIDFontType0 or CIDFontType2, required */
    CC_JAPANESE, /* Character Collection, required */
    752, /* Ascend, required */
    737, /* CapHeight, required */
    -221, /* Descend, required */
    SYMBOLIC, /* Font flags, required */
    0, /* DW, optioanl, zero starnds for undefined */
    NULL, /* W, optional */
    NULL, /* DW2, optional */
    NULL, /* W2, optional */
    "[-92 -250 1010 922]", /* FontBBox, required */
    0, /* ItalicAngle, required */
    114, /* StemV, required */
    0, /* AvgWidth, optional */
    0, /* Leading, optional */
    0, /* MaxWidth, optional */
    0, /* MissingWidth, optional */
    0, /* StemH, optional */
    553, /* XHeight, optional */
    NULL, /* CharSet, optional */
    NULL /* Style, optional */
  },
  {
    "HeiseiMin-W3",
    TYPE0,
    CC_JAPANESE,
    723,
    709,
    -241,
    SYMBOLIC+SERIF, /* 6, */
    0,
    NULL,
    NULL,
    NULL,
    "[-123 -257 1001 910]",
    0,
    69,
    0,
    0,
    0,
    0,
    0,
    450,
    NULL,
    NULL
  },
  {
    "Ryumin-Light",
    TYPE0,
    CC_JAPANESE,
    723,
    709,
    -241,
    SYMBOLIC+SERIF,
    1000,
    NULL,
    NULL,
    NULL,
    "[-170 -331 1024 903]",
    0,
    69,
    0,
    0,
    0,
    0,
    0,
    0,
    NULL,
    "<< /Panose <010502020300000000000000> >>"
  },
  {
    "GothicBBB-Medium",
    TYPE0,
    CC_JAPANESE,
    752,
    737,
    -271,
    SYMBOLIC,
    1000,
    NULL,
    NULL,
    NULL,
    "[-174 -268 1001 944]",
    0,
    99,
    0,
    0,
    0,
    0,
    0,
    0,
    NULL,
    "<< /Panose  <0801020b0500000000000000> >>"
  }
};

#endif /* _CID_BASEFONT_H_ */
